/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import se.datadosen.component.JBackgroundTextField;
import se.datadosen.component.TagAutoCompleter;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.Msg;

public class JAlbumTagsField
extends JBackgroundTextField {
    private int maxTags = 4;
    private JLabel warningIcon = new JLabel(Icons.getIcon("warning"));

    public JAlbumTagsField(int chars) {
        this(chars, 3);
    }

    public JAlbumTagsField(int chars, int maxTags) {
        super(chars);
        this.init();
    }

    public JLabel getWarningIcon() {
        return this.warningIcon;
    }

    private void init() {
        this.warningIcon.setToolTipText(Msg.get("edit.tooManyAlbumTags", this.maxTags));
        this.warningIcon.setVisible(this.getTagCount() > this.maxTags);
        this.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                this.processChange();
            }

            public void removeUpdate(DocumentEvent e) {
                this.processChange();
            }

            public void changedUpdate(DocumentEvent e) {
                this.processChange();
            }

            void processChange() {
                JAlbumTagsField.this.warningIcon.setVisible(JAlbumTagsField.this.getTagCount() > JAlbumTagsField.this.maxTags);
            }
        });
        this.setBackgroundText(Msg.get("edit.albumTagsSample"));
        this.setToolTipText(Msg.get("edit.albumTagsToolTip"));
        TagAutoCompleter tagAutoCompleter = new TagAutoCompleter(this);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
    }

    public int getTagCount() {
        return this.getText().trim().split(",").length;
    }
}

