/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filterManager;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import net.jalbum.filterManager.FilterList;
import net.jalbum.filterManager.JAlbumImageFilter;
import se.datadosen.jalbum.ModifiesSize;

public class FilterRenderer {
    FilterList filterList;
    BufferedImage bi;
    BufferedImage biOut;
    BufferedImage prescaleCache;
    BufferedImage postscaleCache;
    private static int count = 0;

    public boolean hasFiltersInList() {
        return this.filterList != null && this.filterList.getFilters().size() > 0;
    }

    public BufferedImage renderImage(BufferedImage bi) {
        BufferedImage biOutClone = this.applyPrescaleFilters(bi);
        biOutClone = this.applyPostscaleFilters(biOutClone);
        return biOutClone;
    }

    protected boolean filterListHasPostscaleFilters() {
        for (int i = 0; i < this.filterList.getPosition(); ++i) {
            JAlbumImageFilter filter = this.filterList.getFilters().get(i);
            if (filter == null || !filter.isPostscale() || filter.isPrescale()) continue;
            return true;
        }
        return false;
    }

    protected boolean filterListHasPrescaleFilters() {
        for (int i = 0; i < this.filterList.getPosition(); ++i) {
            JAlbumImageFilter filter = this.filterList.getFilters().get(i);
            if (filter == null || !filter.isPrescale()) continue;
            return true;
        }
        return false;
    }

    public BufferedImage applyPrescaleFilters(BufferedImage bi) {
        this.prescaleCache = bi;
        if (!this.filterListHasPrescaleFilters()) {
            return bi;
        }
        BufferedImage biOutClone = this.cloneBufferedImage(bi);
        for (int i = 0; i < this.filterList.getPosition(); ++i) {
            JAlbumImageFilter filter = this.filterList.getFilters().get(i);
            if (filter == null || !filter.isPrescale()) continue;
            biOutClone = filter.renderImage(biOutClone);
        }
        this.prescaleCache = this.cloneBufferedImage(biOutClone);
        return biOutClone;
    }

    public BufferedImage applyPostscaleFilters(BufferedImage bi) {
        this.postscaleCache = bi;
        if (!this.filterListHasPostscaleFilters()) {
            return bi;
        }
        BufferedImage biOutClone = this.cloneBufferedImage(bi);
        this.postscaleCache = this.cloneBufferedImage(biOutClone);
        for (int i = 0; i < this.filterList.getPosition(); ++i) {
            JAlbumImageFilter filter = this.filterList.getFilters().get(i);
            if (filter == null || !filter.isPostscale() || filter.isPrescale()) continue;
            biOutClone = filter.renderImage(biOutClone);
        }
        return biOutClone;
    }

    public Dimension getPrescaleFilteredSize(Dimension dim) {
        for (int i = 0; i < this.filterList.getPosition(); ++i) {
            JAlbumImageFilter filter = this.filterList.getFilters().get(i);
            if (filter == null || !filter.isPrescale() || !(filter instanceof ModifiesSize)) continue;
            dim = ((ModifiesSize)((Object)filter)).getModifiedSize(dim, null);
        }
        return dim;
    }

    public Dimension getPostscaleFilteredSize(Dimension dim) {
        for (int i = 0; i < this.filterList.getPosition(); ++i) {
            JAlbumImageFilter filter = this.filterList.getFilters().get(i);
            if (filter == null || !filter.isPostscale() || filter.isPrescale() || !(filter instanceof ModifiesSize)) continue;
            dim = ((ModifiesSize)((Object)filter)).getModifiedSize(dim, null);
        }
        return dim;
    }

    public BufferedImage cloneBufferedImage(BufferedImage img) {
        ++count;
        int iw = img.getWidth();
        int ih = img.getHeight();
        return FilterRenderer.createBufferedImage(img, iw, ih);
    }

    private static BufferedImage createBufferedImage(BufferedImage img, int iw, int ih) {
        BufferedImage bi = new BufferedImage(iw, ih, img.getType());
        Graphics2D g = bi.createGraphics();
        g.drawImage((Image)img, 0, 0, null);
        g.dispose();
        img.flush();
        return bi;
    }

    public FilterList getFilterList() {
        return this.filterList;
    }

    public void setFilterList(FilterList filterList) {
        this.filterList = filterList;
    }
}

