/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters.components;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import javax.swing.event.ChangeEvent;
import net.jalbum.filters.components.ExtendedSlider;

public class GammaSlider
extends ExtendedSlider {
    private static final int PRECISION = 100;
    private static final long serialVersionUID = -2122782364313322527L;
    protected double resultingGamma;
    protected final double gamma = 0.301029996;

    public GammaSlider() {
        super(0, -100, 100, 0);
    }

    public GammaSlider(int orientation) {
        super(orientation, -100, 100, 0);
        this.slider.setValue(-1);
        this.slider.setValue(0);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.textfield) {
            this.readTextfieldValue();
        } else {
            super.actionPerformed(e);
        }
    }

    private void readTextfieldValue() {
        try {
            double value = Double.parseDouble(this.textfield.getText());
            if (value < 0.0) {
                value = 0.0;
            } else if (value > 10.0) {
                value = 10.0;
            }
            this.resultingGamma = value;
            this.slider.setValue((int)Math.pow(Math.pow(200.0, 3.321928091179325) * this.resultingGamma / 10.0, 0.301029996) - 100);
            this.textfield.setText(Double.toString((double)((int)(value * 100.0)) / 100.0));
        }
        catch (Exception ex) {
            this.textfield.setText(Double.toString((double)((int)(this.resultingGamma * 100.0)) / 100.0));
        }
    }

    public void stateChanged(ChangeEvent arg0) {
        if (arg0.getSource() == this.slider) {
            this.resultingGamma = 10.0 * Math.pow(this.slider.getValue() + 100, 3.321928091179325) / Math.pow(200.0, 3.321928091179325);
            this.textfield.setText(Double.toString((double)((int)(this.resultingGamma * 100.0)) / 100.0));
            this.postActionEvent();
        }
    }

    public void reset() {
        this.slider.setValue(0);
    }

    public double getResultingGamma() {
        return this.resultingGamma;
    }

    public void setResultingGamma(double value) {
        this.resultingGamma = value;
    }

    public int getValue() {
        return (int)this.resultingGamma;
    }

    public void setValue(int value) {
        this.resultingGamma = value;
    }

    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.textfield) {
            this.readTextfieldValue();
        }
    }
}

