/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.iptc;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.iptc.IptcDirectory;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.GregorianCalendar;

public class IptcReader
implements MetadataReader {
    private final byte[] _data;

    public IptcReader(File jpegFile) throws JpegProcessingException {
        this(new JpegSegmentReader(jpegFile).readSegment((byte)-19));
    }

    public IptcReader(InputStream is) throws JpegProcessingException {
        this(new JpegSegmentReader(is).readSegment((byte)-19));
    }

    public IptcReader(byte[] data) {
        this._data = data;
    }

    public Metadata extract() {
        return this.extract(new Metadata());
    }

    public Metadata extract(Metadata metadata) {
        int offset;
        if (this._data == null) {
            return metadata;
        }
        Directory directory = metadata.getDirectory(IptcDirectory.class);
        try {
            for (offset = 0; offset < this._data.length - 1 && this.get32Bits(offset) != 7170; ++offset) {
            }
        }
        catch (MetadataException e) {
            directory.addError("Couldn't find start of Iptc data (invalid segment)");
            return metadata;
        }
        while (offset < this._data.length && this._data[offset] == 28 && offset + 5 < this._data.length) {
            int tagByteCount;
            byte tagType;
            byte directoryType;
            ++offset;
            try {
                directoryType = this._data[offset++];
                tagType = this._data[offset++];
                tagByteCount = this.get32Bits(offset);
            }
            catch (MetadataException e) {
                directory.addError("Iptc data segment ended mid-way through tag descriptor");
                return metadata;
            }
            if ((offset += 2) + tagByteCount > this._data.length) {
                directory.addError("data for tag extends beyond end of iptc segment");
                break;
            }
            this.processTag(directory, directoryType, tagType, offset, tagByteCount);
            offset += tagByteCount;
        }
        return metadata;
    }

    private int get32Bits(int offset) throws MetadataException {
        if (offset >= this._data.length) {
            throw new MetadataException("Attempt to read bytes from outside Iptc data buffer");
        }
        return (this._data[offset] & 0xFF) << 8 | this._data[offset + 1] & 0xFF;
    }

    private void processTag(Directory directory, int directoryType, int tagType, int offset, int tagByteCount) {
        String str;
        int tagIdentifier = tagType | directoryType << 8;
        switch (tagIdentifier) {
            case 512: {
                short shortValue = (short)(this._data[offset] << 8 | this._data[offset + 1]);
                directory.setInt(tagIdentifier, shortValue);
                return;
            }
            case 522: {
                directory.setInt(tagIdentifier, this._data[offset]);
                return;
            }
            case 542: 
            case 567: {
                if (tagByteCount < 8) break;
                String dateStr = new String(this._data, offset, tagByteCount);
                try {
                    int year = Integer.parseInt(dateStr.substring(0, 4));
                    int month = Integer.parseInt(dateStr.substring(4, 6)) - 1;
                    int day = Integer.parseInt(dateStr.substring(6, 8));
                    Date date = new GregorianCalendar(year, month, day).getTime();
                    directory.setDate(tagIdentifier, date);
                    return;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        if (tagByteCount < 1) {
            str = "";
        } else {
            try {
                str = new String(this._data, offset, tagByteCount, System.getProperty("file.encoding"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (directory.containsTag(tagIdentifier)) {
            String[] newStrings;
            String[] oldStrings;
            try {
                oldStrings = directory.getStringArray(tagIdentifier);
            }
            catch (MetadataException e) {
                oldStrings = null;
            }
            if (oldStrings == null) {
                newStrings = new String[1];
            } else {
                newStrings = new String[oldStrings.length + 1];
                for (int i = 0; i < oldStrings.length; ++i) {
                    newStrings[i] = oldStrings[i];
                }
            }
            newStrings[newStrings.length - 1] = str;
            directory.setStringArray(tagIdentifier, newStrings);
        } else {
            directory.setString(tagIdentifier, str);
        }
    }
}

