/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.debug.Logger;
import com.incors.plaf.alloy.AlloyLookAndFeel;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import net.jalbum.slideshow.SlideShowFactory;
import se.datadosen.component.ComponentUtilities;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JCollapsiblePanel;
import se.datadosen.component.JNotification;
import se.datadosen.component.JSmartDialog;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JPrefsPanel_language_actionAdapter;
import se.datadosen.jalbum.JPrefsPanel_lookAndFeel_actionAdapter;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.Item;
import se.datadosen.util.JComponentHolder;
import se.datadosen.util.LanguageMapper;
import se.datadosen.util.PropertyBinder;
import se.datadosen.util.annotations.Bound;
import se.datadosen.util.annotations.TabTitle;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.Title;
import se.datadosen.util.annotations.ToolTipText;

public class JPreferencesWindow
extends JSmartDialog
implements JComponentHolder {
    JAlbumFrame parent;
    JTabbedPane tabs = new JTabbedPane();
    @Text(value="ui.~")
    @ToolTipText(value="ui.~ToolTip")
    JCheckBox debugMode = new JCheckBox();
    @Text(value="ui.~")
    @ToolTipText(value="ui.~ToolTip")
    JCheckBox checkForUpdates = new JCheckBox();
    @Text(value="prefs.~")
    JCheckBox closeProgressDialog = new JCheckBox();
    @Text
    JCheckBox useLayoutHints = new JCheckBox();
    @Text(value="ui.~")
    @ToolTipText(value="ui.~ToolTip")
    JCheckBox restorePreviousSettings = new JCheckBox();
    @Text(value="prefs.~")
    JCheckBox writeXmp = new JCheckBox();
    JComboBox language = new JComboBox<Object>(JPreferencesWindow.fillLanguages());
    JComboBox lookAndFeel = new JComboBox<Object>(JPreferencesWindow.fillLookAndFeels());
    @TabTitle(value="ui.mainPanel")
    ControlPanel general = new ControlPanel();
    @TabTitle(value="ui.albumMenu")
    ControlPanel album = new ControlPanel();
    @TabTitle(value="ui.~Title")
    ControlPanel publishing = new ControlPanel();
    @Title(value="prefs.~Border")
    ControlPanel skins = new ControlPanel();
    @Title(value="prefs.imageEditingBorder")
    ControlPanel editing = new ControlPanel();
    @Title(value="prefs.~Border")
    ControlPanel guides = new ControlPanel();
    @Text(value="prefs.~")
    JCheckBox showWarnings = new JCheckBox();
    @Title(value="prefs.~Border")
    ControlPanel multipleProcessors = new ControlPanel();
    @Text(value="prefs.nThreadsLabel")
    JLabel cpuCoresLabel = new JLabel();
    JComboBox cpuCores = new JComboBox<Object>(JPreferencesWindow.fillCpuCores());
    @Text(value="prefs.myAlbumsLocation")
    JLabel myAlbumsLocationLabel = new JLabel();
    JTextField myAlbumsLocation = new JSmartTextField();
    @Text(value="prefs.illegalCharacters")
    @ToolTipText(value="prefs.illegalCharactersToolTip")
    JLabel illegalCharactersLabel = new JLabel();
    @ToolTipText(value="prefs.illegalCharactersToolTip")
    JTextField illegalCharacters = new JSmartTextField();
    @Text(value="prefs.language")
    JLabel languageLabel = new JLabel();
    @Text(value="prefs.lookAndFeel")
    JLabel lookAndFeelLabel = new JLabel();
    @Text(value="prefs.slideShow")
    JLabel slideShowLabel = new JLabel();
    @Text(value="prefs.~")
    JCheckBox cleanOutputFiles = new JCheckBox();
    @Text(value="prefs.~")
    @ToolTipText(value="prefs.~ToolTip")
    JCheckBox synchronizeOutputDirectory = new JCheckBox();
    @Text(value="prefs.~")
    JCheckBox cacheThumbnails = new JCheckBox();
    @Text(value="prefs.fileAddBehavior")
    JLabel fileAddBehaviorLabel = new JLabel();
    JComboBox fileAddBehavior = new JComboBox<Object>(new Object[]{Config.FileAddBehavior.COPY, Config.FileAddBehavior.LINK});
    @Text(value="prefs.~")
    @ToolTipText(value="prefs.~ToolTip")
    JCheckBox rememberCopiedFiles = new JCheckBox();
    @Text(value="prefs.~")
    JCheckBox thumbnailsInFileChooser = new JCheckBox();
    @Text(value="prefs.showPreviewInfoBar")
    JCheckBox showInfoBarInPreview = new JCheckBox();
    @Text(value="prefs.afterPublishingAction")
    JLabel afterPublishingLabel = new JLabel();
    JComboBox afterPublishing = new JComboBox<Object>(new Object[]{Config.AfterPublishBehavior.openPublishingSuccessfulPage, Config.AfterPublishBehavior.openPublishedAlbum, Config.AfterPublishBehavior.doNothing});
    @Text(value="ui.includeHiresImages")
    @ToolTipText(value="ui.hiResImagesToolTip")
    JCheckBox includeHiResImagesDefault = new JCheckBox();
    @Text(value="ui.~")
    @ToolTipText(value="ui.~ToolTip")
    JCheckBox includeLifeboatFile = new JCheckBox();
    public JToggleButton largeThumbnails = new JToggleButton("", true);
    JCheckBox expandedMainSettings = new JCheckBox();
    JCheckBox expandedFolderSettings = new JCheckBox();
    JTextField userName = new JTextField();
    JTextField password = new JTextField();
    JCheckBox rememberSignIn = new JCheckBox();
    JCheckBox doNotShowSigninAgain = new JCheckBox();
    JCheckBox backgroundSignInOnStart = new JCheckBox();
    @Title(value="ui.~")
    JCollapsiblePanel paranoia = new JCollapsiblePanel(new RiverLayout());
    @Text(value="prefs.~")
    @ToolTipText(value="prefs.~ToolTip")
    JCheckBox encryptManifest = new JCheckBox();
    @Text(value="prefs.manifestPassword")
    JLabel manifestPasswordLabel = new JLabel();
    JTextField manifestPassword = new JTextField(12);
    @Title(value="ui.advancedPanel")
    JCollapsiblePanel advancedPublishing = new JCollapsiblePanel(new RiverLayout());
    @Text(value="prefs.~")
    @ToolTipText(value="prefs.~ToolTip")
    JCheckBox zipstreaming = new JCheckBox();
    @Text(value="prefs.~")
    JCheckBox rememberWindowBounds = new JCheckBox();
    @Text(value="prefs.~")
    JCheckBox backupProjects = new JCheckBox();
    @Text(value="prefs.~")
    JCheckBox showTipOfTheDay = new JCheckBox();
    @Text(value="ui.restore")
    Action restoreIllegalCharacters = new AbstractAction(){

        public void actionPerformed(ActionEvent ae) {
            JPreferencesWindow.this.illegalCharacters.setText("#$%&*\"\\/:;?=|");
        }
    };
    @Bound
    Rectangle windowBounds = new Rectangle();

    public JPreferencesWindow(JAlbumFrame parent) {
        super((Frame)parent, false);
        this.parent = parent;
        try {
            this.jbInit();
            this.loadPreferences();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.expandedMainSettings.setSelected(true);
        this.rememberSignIn.setSelected(true);
        this.useLayoutHints.setSelected(true);
        this.restorePreviousSettings.setSelected(true);
        this.showWarnings.setSelected(true);
        this.cleanOutputFiles.setSelected(true);
        this.synchronizeOutputDirectory.setSelected(true);
        this.cacheThumbnails.setSelected(true);
        this.thumbnailsInFileChooser.setSelected(true);
        this.checkForUpdates.setSelected(true);
        this.zipstreaming.setSelected(true);
        this.includeLifeboatFile.setSelected(true);
        ComponentUtilities.whenSelectedEnable((AbstractButton)this.encryptManifest, this.manifestPasswordLabel, this.manifestPassword);
        this.cpuCores.setSelectedIndex(this.cpuCores.getItemCount() - 1);
        this.debugMode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.setProperty("log.level", JPreferencesWindow.this.debugMode.isSelected() ? "DEBUG" : "OFF");
                String logLevel = System.getProperty("log.level");
                if (logLevel == null || logLevel.equals("OFF")) {
                    Logger.setLevel((Level)Level.OFF);
                } else {
                    Logger.setLevel((Level)Level.getLevel((String)logLevel));
                }
            }
        });
        this.showTipOfTheDay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    JNotification.forgetAllShown();
                }
                catch (BackingStoreException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        AbstractAction okAction = new AbstractAction(Msg.get("ok")){

            public void actionPerformed(ActionEvent e) {
                JPreferencesWindow.this.setVisible(false);
                JPreferencesWindow.this.savePreferences();
            }
        };
        AbstractAction cancelAction = new AbstractAction(Msg.get("cancel")){

            public void actionPerformed(ActionEvent e) {
                JPreferencesWindow.this.setVisible(false);
                JPreferencesWindow.this.cancelPreferences();
            }
        };
        this.registerActions(okAction, cancelAction);
        this.language.addActionListener(new JPrefsPanel_language_actionAdapter(this));
        this.lookAndFeel.addActionListener(new JPrefsPanel_lookAndFeel_actionAdapter(this));
        Container c = this.getContentPane();
        c.setLayout(new RiverLayout());
        this.tabs.add(this.general);
        this.tabs.add(this.album);
        this.tabs.add(this.publishing);
        c.add("br hfill vfill", this.tabs);
        this.general.add("br", this.languageLabel);
        this.general.add("tab", this.language);
        this.general.add("br", this.lookAndFeelLabel);
        this.general.add("tab", this.lookAndFeel);
        this.general.add("br", this.cpuCoresLabel);
        this.general.add("tab", this.cpuCores);
        this.general.add("p", this.checkForUpdates);
        this.general.add("br", this.closeProgressDialog);
        this.general.add("br", this.showWarnings);
        this.general.add("br", this.debugMode);
        this.general.add("br", this.thumbnailsInFileChooser);
        this.general.add("br", this.showInfoBarInPreview);
        this.general.add("br", this.rememberWindowBounds);
        this.general.add("br", this.backupProjects);
        this.general.add("br", this.showTipOfTheDay);
        this.album.add("br", this.myAlbumsLocationLabel);
        this.album.add("tab hfill", this.myAlbumsLocation);
        this.album.add("br", this.illegalCharactersLabel);
        this.album.add("tab hfill", this.illegalCharacters);
        this.album.add(new JButton(this.restoreIllegalCharacters));
        if (Runtime.getRuntime().availableProcessors() < 2) {
            this.multipleProcessors.setEnabled(false);
        }
        this.album.add("br", this.cleanOutputFiles);
        this.album.add("br", this.synchronizeOutputDirectory);
        this.album.add("br", this.cacheThumbnails);
        this.album.add("br", this.fileAddBehaviorLabel);
        this.album.add(this.fileAddBehavior);
        this.album.add("br", this.rememberCopiedFiles);
        this.skins.add(this.useLayoutHints);
        this.skins.add("br", this.restorePreviousSettings);
        this.album.add("br hfill", this.skins);
        this.editing.add(this.writeXmp);
        this.album.add("br hfill", this.editing);
        this.publishing.add("br", this.afterPublishingLabel);
        this.publishing.add("tab", this.afterPublishing);
        this.publishing.add("br", this.includeHiResImagesDefault);
        this.publishing.add("br", this.includeLifeboatFile);
        this.advancedPublishing.getContentPanel().add(this.zipstreaming);
        this.publishing.add("br hfill", this.advancedPublishing);
        this.paranoia.getContentPanel().add(this.encryptManifest);
        this.paranoia.getContentPanel().add("br", this.manifestPasswordLabel);
        this.paranoia.getContentPanel().add("tab", this.manifestPassword);
        this.publishing.add("p hfill", this.paranoia);
        Msg.maintainTranslated(this);
    }

    public void loadPreferences() {
        if (JAlbumFrame.defaultProjectFile != null && JAlbumFrame.defaultProjectFile.exists()) {
            try {
                Properties props = IO.readPropertyFile(JAlbumFrame.defaultProjectFile);
                PropertyBinder.syncUI(props, this);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        BeanBinder.getProperties((Object)Config.getConfig(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void savePreferences() {
        FileOutputStream fos = null;
        try {
            try {
                Config config = Config.getConfig();
                Properties visiblePreferences = PropertyBinder.getProperties(this);
                BeanBinder.setProperties((Object)config, visiblePreferences);
                Properties allPreferences = BeanBinder.getProperties((Object)config, visiblePreferences);
                Properties defaults = new Properties();
                if (JAlbumFrame.defaultProjectFile.exists()) {
                    defaults = IO.readPropertyFile(JAlbumFrame.defaultProjectFile);
                }
                defaults.putAll((Map<?, ?>)allPreferences);
                fos = new FileOutputStream(JAlbumFrame.defaultProjectFile);
                defaults.store(fos, "JAlbum Project");
            }
            catch (Exception ex) {
                Debug.showErrorDialog(this, ex);
                this.parent.statusBar.setText(ex.getMessage());
                Object var7_8 = null;
                IO.close(fos);
                return;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            IO.close(fos);
            throw throwable;
        }
        IO.close(fos);
    }

    private void cancelPreferences() {
        try {
            Properties defaults = new Properties();
            if (JAlbumFrame.defaultProjectFile.exists()) {
                defaults = IO.readPropertyFile(JAlbumFrame.defaultProjectFile);
            }
            PropertyBinder.syncUI(defaults, this);
            BeanBinder.getProperties((Object)Config.getConfig(), this);
        }
        catch (Exception ex) {
            Debug.showErrorDialog(this, ex);
            this.parent.statusBar.setText(ex.getMessage());
        }
    }

    private static Object[] fillLanguages() {
        File dir = new File(Config.getConfig().progDir, "texts");
        File[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".properties");
            }
        });
        Object[] result = new Object[files.length + 1];
        for (int i = 0; i < files.length; ++i) {
            String name = files[i].getName();
            int underscoreIndex = name.indexOf(95);
            String iso2 = underscoreIndex == -1 ? "en" : name.substring(underscoreIndex + 1, name.lastIndexOf(46));
            result[i + 1] = new Item(iso2, LanguageMapper.getFullName(iso2));
        }
        Arrays.sort(result, 1, result.length - 1, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)((Item)o1).item).compareToIgnoreCase((String)((Item)o2).item);
            }
        });
        result[0] = new Item("default", Msg.get("prefs.systemDefault"));
        return result;
    }

    private static Object[] fillLookAndFeels() {
        UIManager.LookAndFeelInfo[] lafInfo = UIManager.getInstalledLookAndFeels();
        Object[] result = new Object[lafInfo.length + 2];
        result[0] = new Item(UIManager.getSystemLookAndFeelClassName(), Msg.get("prefs.systemDefault"));
        result[1] = new Item("com.incors.plaf.alloy.AlloyLookAndFeel", "Alloy");
        for (int i = 0; i < lafInfo.length; ++i) {
            result[i + 2] = new Item(lafInfo[i].getClassName(), lafInfo[i].getName());
        }
        return result;
    }

    private static Object[] fillSlideShow() {
        Object[] slideShowKeys = SlideShowFactory.getSlideShowKeys();
        return slideShowKeys;
    }

    private static Object[] fillCpuCores() {
        Object[] result = new Object[Runtime.getRuntime().availableProcessors()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new Integer(i + 1);
        }
        return result;
    }

    void language_actionPerformed(ActionEvent e) {
        Item lang = (Item)this.language.getSelectedItem();
        String newLang = (String)lang.value;
        Config config = Config.getConfig();
        if (!config.getLanguage().equals(newLang)) {
            config.setLanguage(newLang);
            this.parent.ui2Engine();
            Msg.setTexts();
            this.parent.setTexts();
            this.parent.engine2UI();
        }
    }

    void lookAndFeel_actionPerformed(ActionEvent e) {
        String laf = (String)((Item)this.lookAndFeel.getSelectedItem()).value;
        Config config = Config.getConfig();
        if (!config.getLookAndFeel().equals(laf)) {
            config.setLookAndFeel(laf);
            try {
                UIManager.setLookAndFeel(laf);
                AlloyLookAndFeel.updateAllUIs();
                this.pack();
                this.parent.validate();
            }
            catch (Exception ex) {
                this.parent.statusBar.setText(ex.toString());
            }
        }
    }
}

