/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import net.miginfocom.swing.MigLayout;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import se.datadosen.component.JCollapsiblePanel;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.JNotification;
import se.datadosen.component.JPopupButton;
import se.datadosen.component.JSiteButton;
import se.datadosen.component.JSmartComboBox;
import se.datadosen.component.JSmartSeparator;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.DirectoryFilter;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumBorders;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.SkinManager;
import se.datadosen.jalbum.SkinProperties;
import se.datadosen.jalbum.StyleFileFilter;
import se.datadosen.jalbum.event.AccountManagerListener;
import se.datadosen.jalbum.event.JAlbumEvent;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.Item;
import se.datadosen.util.JComponentHolder;
import se.datadosen.util.Platform;
import se.datadosen.util.PropertyBinder;
import se.datadosen.util.VersionNumber;

public class JMainSettingsPanel
extends JPanel
implements JComponentHolder {
    private JAlbumFrame parent;
    JLabel skinLabel = new JLabel();
    JLabel styleLabel = new JLabel();
    JComboBox skin = new JSmartComboBox();
    JComboBox style = new JSmartComboBox();
    JLinkLabel moreSkinsLink = new JLinkLabel();
    JSmartSeparator settingsSeparator = JAlbumBorders.createSeparator();
    private JRadioButton makeChanges = new JRadioButton();
    private JRadioButton makeAll = new JRadioButton();
    public ButtonGroup appendImages = new ButtonGroup(){
        {
            this.add(JMainSettingsPanel.this.makeChanges);
            this.add(JMainSettingsPanel.this.makeAll);
            JMainSettingsPanel.this.makeAll.setSelected(true);
            JMainSettingsPanel.this.makeChanges.setActionCommand("true");
            JMainSettingsPanel.this.makeAll.setActionCommand("false");
        }
    };
    private JCollapsiblePanel collapsiblePanel = new JCollapsiblePanel((LayoutManager)new MigLayout());
    private JPopupButton makeAlbumButton;
    private JButton viewAlbumButton;
    private JPopupButton publishButton;
    private MouseListener skinsScanner = new MouseAdapter(){

        public void mouseEntered(MouseEvent e) {
            JMainSettingsPanel.this.scanSkins();
        }
    };
    private PopupMenuListener skinPreviewer = new PopupMenuListener(){

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            JMainSettingsPanel.this.parent.setPreviewImage();
            ((JMainSettingsPanel)JMainSettingsPanel.this).parent.skinPreview.setVisible(true);
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            ((JMainSettingsPanel)JMainSettingsPanel.this).parent.skinPreview.setVisible(false);
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    };
    ActionListener skinSelectedActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            File onLoadScript;
            int answer;
            final String skin = JMainSettingsPanel.this.getSelectedSkin();
            ((JMainSettingsPanel)JMainSettingsPanel.this).parent.engine.setSkin(skin);
            JMainSettingsPanel.this.parent.fireSkinChanged(new JAlbumEvent(this));
            this.checkForSkinUpdate();
            JMainSettingsPanel.this.parent.setSkinUI(null);
            String selected = JMainSettingsPanel.this.getSelectedStyle();
            JMainSettingsPanel.this.style.removeActionListener(JMainSettingsPanel.this.styleSelectedActionListener);
            JMainSettingsPanel.this.style.removeAllItems();
            File skinDir = ((JMainSettingsPanel)JMainSettingsPanel.this).parent.cfg.chainedSkinsDir.getFile(skin);
            File slideTemplateFile = new File(skinDir, "slide.htt");
            ((JMainSettingsPanel)JMainSettingsPanel.this).parent.settingsWindow.slides.setEnabled(slideTemplateFile.exists() && slideTemplateFile.length() > 0L);
            JAlbumUtilities.fillCombo(JMainSettingsPanel.this.style, new File(skinDir, "styles"), (FileFilter)new StyleFileFilter());
            JMainSettingsPanel.this.style.setSelectedItem(selected);
            if (JMainSettingsPanel.this.style.getSelectedIndex() == -1 && JMainSettingsPanel.this.style.getItemCount() > 0) {
                JMainSettingsPanel.this.style.setSelectedIndex(0);
            }
            JMainSettingsPanel.this.style.addActionListener(JMainSettingsPanel.this.styleSelectedActionListener);
            JMainSettingsPanel.this.parent.loadHints();
            SkinProperties sp = ((JMainSettingsPanel)JMainSettingsPanel.this).parent.engine.getSkinProperties();
            String req = sp.getProperty("requiredJalbumVersion");
            VersionNumber current = new VersionNumber(AlbumBean.getInternalVersion());
            if (req != null && current.compareTo(new VersionNumber(req)) < 0 && (answer = JOptionPane.showConfirmDialog(JMainSettingsPanel.this.parent, Msg.get("ui.upgradeRecommended", skin, req), Msg.get("ui.upgradeRecommendedTitle"), 0, 2)) == 0) {
                try {
                    BrowserLauncher.openURL(JAlbumSite.getTrueInstance().getUpgradeUrl());
                    JMainSettingsPanel.this.parent.doExit();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if ((onLoadScript = new File(((JMainSettingsPanel)JMainSettingsPanel.this).parent.cfg.chainedSkinsDir.getFile(((JMainSettingsPanel)JMainSettingsPanel.this).parent.engine.getSkin()), "onload.bsh")).exists()) {
                new Thread("Skin onload thread"){
                    String statusMessage;
                    {
                        super(x0);
                        this.setDaemon(true);
                        this.statusMessage = Msg.get("ui.loadingSkinInfo", skin) + "...";
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = JAlbum.initializedOkMonitor;
                        synchronized (object) {
                            try {
                                ((JMainSettingsPanel)JMainSettingsPanel.this).parent.engine.initInterpreter();
                                ((JMainSettingsPanel)JMainSettingsPanel.this).parent.statusBar.pushText(this.statusMessage);
                                ((JMainSettingsPanel)JMainSettingsPanel.this).parent.progressSpinner.workStarted();
                                ((JMainSettingsPanel)JMainSettingsPanel.this).parent.actions.makeAction.setEnabled(false);
                                ((JMainSettingsPanel)JMainSettingsPanel.this).parent.actions.makeAllAction.setEnabled(false);
                                ((JMainSettingsPanel)JMainSettingsPanel.this).parent.actions.makeChangesAction.setEnabled(false);
                                JMainSettingsPanel.this.parent.executeScript(onLoadScript);
                                Object var3_2 = null;
                                ((JMainSettingsPanel)JMainSettingsPanel.this).parent.statusBar.popText(this.statusMessage);
                                ((JMainSettingsPanel)JMainSettingsPanel.this).parent.progressSpinner.workDone();
                                JMainSettingsPanel.this.parent.directorySelected();
                                JMainSettingsPanel.this.parent.markSkinAsClean();
                            }
                            catch (Throwable throwable) {
                                Object var3_3 = null;
                                ((JMainSettingsPanel)JMainSettingsPanel.this).parent.statusBar.popText(this.statusMessage);
                                ((JMainSettingsPanel)JMainSettingsPanel.this).parent.progressSpinner.workDone();
                                JMainSettingsPanel.this.parent.directorySelected();
                                JMainSettingsPanel.this.parent.markSkinAsClean();
                                throw throwable;
                            }
                        }
                    }
                }.start();
            }
        }

        private void checkForSkinUpdate() {
            new Thread("Skin update checker"){

                public void run() {
                    block7: {
                        try {
                            String iv = ((JMainSettingsPanel)JMainSettingsPanel.this).parent.engine.getSkinProperties().getProperty("version");
                            String skinInfoURL = JAlbumSite.getInstance().getSkinInfoUrl();
                            if (iv != null && skinInfoURL != null) {
                                VersionNumber installedVersion = new VersionNumber(iv);
                                String skinName = ((JMainSettingsPanel)JMainSettingsPanel.this).parent.engine.getSkin();
                                URL u = new URL(IO.combinePaths(skinInfoURL, IO.urlEncode(skinName)));
                                if (Config.getConfig().isDebugMode()) {
                                    System.out.println("Calling URL " + u);
                                }
                                URLConnection conn = u.openConnection();
                                conn.setConnectTimeout(5000);
                                InputStream is = conn.getInputStream();
                                InputSource input = new InputSource(is);
                                XPath xpath = XPathFactory.newInstance().newXPath();
                                Node skin = (Node)xpath.evaluate("/reply/skin", input, XPathConstants.NODE);
                                if (skin != null) {
                                    VersionNumber currentVersion;
                                    String version = xpath.evaluate("current-version", skin);
                                    String skinPage = xpath.evaluate("url", skin);
                                    String lu = xpath.evaluate("last-updated", skin);
                                    GregorianCalendar lastUpdated = new GregorianCalendar();
                                    lastUpdated.setTime(DateFormat.getDateInstance(3, new Locale("sv")).parse(lu));
                                    String formattedLastUpdated = DateFormat.getDateInstance(1).format(lastUpdated.getTime());
                                    is.close();
                                    if (version != null && (currentVersion = new VersionNumber(version)).compareTo(installedVersion) > 0) {
                                        JNotification n = new JNotification(Msg.get("ui.newSkinUpdate", skinName, currentVersion, formattedLastUpdated, skinPage, installedVersion), JNotification.Type.SKIN);
                                        n.setExpiration(15);
                                        n.setRememberDismissed(true);
                                        n.setCloseButtonToolTipText(Msg.get("ui.dontShowAgainForThisVersion"));
                                        if (!n.isDismissedBefore()) {
                                            JMainSettingsPanel.this.parent.showNotification(n);
                                        }
                                    }
                                }
                            }
                        }
                        catch (Exception ex) {
                            if (!Config.getConfig().isDebugMode()) break block7;
                            ex.printStackTrace(System.err);
                        }
                    }
                }
            }.start();
        }
    };
    ActionListener styleSelectedActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            JMainSettingsPanel.this.parent.setPreviewImage();
            Item item = (Item)JMainSettingsPanel.this.style.getSelectedItem();
            if (item != null) {
                this.styleChanged((String)item.item);
            }
            JMainSettingsPanel.this.parent.fireStyleChanged(new JAlbumEvent(JMainSettingsPanel.this.parent));
        }

        private void styleChanged(String styleName) {
            File skinDir = ((JMainSettingsPanel)JMainSettingsPanel.this).parent.cfg.chainedSkinsDir.getFile(((JMainSettingsPanel)JMainSettingsPanel.this).parent.engine.getSkin());
            File styleDir = new File(skinDir, "styles");
            File hintsFile = new File(styleDir, styleName + ".jap");
            if (hintsFile.exists() && ((JMainSettingsPanel)JMainSettingsPanel.this).parent.preferencesWindow.useLayoutHints.isSelected()) {
                try {
                    Properties styleHints = IO.readPropertyFile(hintsFile);
                    if (JMainSettingsPanel.this.parent.getSkinUI() != null) {
                        PropertyBinder.syncUI(JAlbumUtilities.getSkinVariables(styleHints), JMainSettingsPanel.this.parent.getSkinUI());
                    }
                    PropertyBinder.syncUI(JAlbumUtilities.getOrdinaryVariables(styleHints), ((JMainSettingsPanel)JMainSettingsPanel.this).parent.settingsWindow);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    };

    public JMainSettingsPanel(JAlbumFrame frame) {
        this.parent = frame;
        this.init();
    }

    public void reloadSkin() {
        this.skinSelectedActionListener.actionPerformed(null);
    }

    private boolean isValidDragDrop(int dropAction, DataFlavor[] flavors) {
        for (int i = 0; i < flavors.length; ++i) {
            DataFlavor dropFlavor = flavors[i];
            if (!dropFlavor.equals(DataFlavor.javaFileListFlavor)) continue;
            return true;
        }
        return false;
    }

    private void init() {
        this.scanSkins();
        if (!Platform.isMac()) {
            this.skin.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
            this.skin.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    JComboBox combo = (JComboBox)evt.getSource();
                    combo.hidePopup();
                }
            });
        }
        this.skin.getComponent(0).addMouseListener(this.skinsScanner);
        this.skin.addPopupMenuListener(this.skinPreviewer);
        this.style.addPopupMenuListener(this.skinPreviewer);
        DropTarget skinDropTarget = new DropTarget(){

            public void dragEnter(DropTargetDragEvent e) {
                if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    e.acceptDrag(1);
                } else {
                    e.rejectDrag();
                }
            }

            public void dragOver(DropTargetDragEvent e) {
                if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    e.acceptDrag(1);
                } else {
                    e.rejectDrag();
                }
            }

            public void dragExit(DropTargetEvent e) {
            }

            public void drop(DropTargetDropEvent e) {
                if (!e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    e.rejectDrop();
                    return;
                }
                e.acceptDrop(1);
                try {
                    List files = (List)e.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    e.dropComplete(true);
                    final File f = (File)files.get(0);
                    String name = f.getName().toLowerCase();
                    if (name.endsWith(".zip") || name.endsWith(".jaskin")) {
                        new Thread(){
                            {
                                this.setDaemon(true);
                            }

                            public void run() {
                                SkinManager sm = new SkinManager();
                                sm.installSkin(f);
                            }
                        }.start();
                    }
                }
                catch (Exception ex) {
                    e.dropComplete(false);
                    Debug.showErrorDialog(JMainSettingsPanel.this, ex);
                }
            }
        };
        this.skin.setDropTarget(skinDropTarget);
        final ListCellRenderer defaultRenderer = this.skin.getRenderer();
        this.skin.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component comp = defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (isSelected && !cellHasFocus) {
                    JMainSettingsPanel.this.parent.setPreviewImage((String)value, JMainSettingsPanel.this.getDefaultStyleForSkin(value.toString()));
                }
                if (value != null) {
                    Config cfg = Config.getConfig();
                    File skinDir = cfg.chainedSkinsDir.getFile(value.toString());
                    if (comp instanceof JLabel) {
                        JLabel label = (JLabel)comp;
                        if (skinDir.getParentFile().equals(cfg.chainedSkinsDir.getDirectory())) {
                            label.setFont(label.getFont().deriveFont(1));
                        }
                    }
                }
                return comp;
            }
        });
        this.style.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (isSelected && !cellHasFocus) {
                    JMainSettingsPanel.this.parent.setPreviewImage(JMainSettingsPanel.this.getSelectedSkin(), value.toString());
                }
                return defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        });
        this.style.setSelectedItem("Plain.css");
        this.setupPanel();
    }

    private static void setSmallerFont(JComponent comp) {
        Font f = comp.getFont();
        comp.setFont(f.deriveFont(f.getSize2D() - 1.0f));
    }

    private void updatePublishPopupMenu() {
        JPopupMenu menu = this.publishButton.getPopup();
        menu.removeAll();
        AccountManager manager = AccountManager.getInstance();
        ButtonGroup bg = new ButtonGroup();
        try {
            menu.add(this.parent.actions.showPublishWindowAction);
            menu.addSeparator();
            DefaultListModel accounts = manager.getAccounts();
            Enumeration e = accounts.elements();
            while (e.hasMoreElements()) {
                AccountProfile a = (AccountProfile)e.nextElement();
                JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(a.getName());
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        JAlbumContext.getInstance().getEngine().setAccountProfileName(e.getActionCommand());
                    }
                });
                bg.add(menuItem);
                menu.add(menuItem);
            }
            this.setSelectedAccountProfile();
        }
        catch (Exception ex) {
            Debug.showErrorDialog(this, ex);
        }
    }

    private void setSelectedAccountProfile() {
        if (JAlbumContext.getInstance().getEngine() == null) {
            return;
        }
        JPopupMenu menu = this.publishButton.getPopup();
        String selectedAccountProfile = JAlbumContext.getInstance().getEngine().getAccountProfileName();
        for (Component comp : menu.getComponents()) {
            JRadioButtonMenuItem item;
            if (!(comp instanceof JRadioButtonMenuItem) || !(item = (JRadioButtonMenuItem)comp).getText().equals(selectedAccountProfile)) continue;
            item.setSelected(true);
            return;
        }
        if (menu.getComponent(0) instanceof JRadioButtonMenuItem) {
            ((JRadioButtonMenuItem)menu.getComponent(0)).setSelected(true);
        }
    }

    private void setupPanel() {
        if (Platform.isMac()) {
            JMainSettingsPanel.setSmallerFont(this.skinLabel);
            JMainSettingsPanel.setSmallerFont(this.styleLabel);
            JMainSettingsPanel.setSmallerFont(this.skin);
            JMainSettingsPanel.setSmallerFont(this.style);
            JMainSettingsPanel.setSmallerFont(this.moreSkinsLink);
            JMainSettingsPanel.setSmallerFont(this.makeAll);
            JMainSettingsPanel.setSmallerFont(this.makeChanges);
        }
        this.makeAlbumButton = new JPopupButton(this.parent.actions.makeAction);
        this.makeAlbumButton.add(this.parent.actions.makeAllAction);
        this.makeAlbumButton.add(this.parent.actions.makeChangesAction);
        this.viewAlbumButton = new JButton(this.parent.actions.viewAlbumAction);
        this.publishButton = new JPopupButton(this.parent.actions.publishAction);
        ImageIcon makeAlbumIcon = Icons.getIcon("big.frog");
        ImageIcon viewAlbumIcon = Icons.getIcon("big.preview");
        ImageIcon publishIcon = Icons.getIcon("big.publish");
        this.updatePublishPopupMenu();
        AccountManager.getInstance().addAccountManagerListener(new AccountManagerListener(){

            public void accountListUpdated() {
                JMainSettingsPanel.this.updatePublishPopupMenu();
            }
        });
        JAlbumContext.getInstance().addPropertyChangeListener("engine", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JAlbumContext.getInstance().getEngine().addPropertyChangeListener("accountProfileName", new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        JMainSettingsPanel.this.setSelectedAccountProfile();
                    }
                });
            }
        });
        this.makeAlbumButton.setIcon(makeAlbumIcon);
        this.viewAlbumButton.setIcon(viewAlbumIcon);
        this.publishButton.setIcon(publishIcon);
        JPanel content = JMainSettingsPanel.createRiverPanel();
        content.setBorder(BorderFactory.createEmptyBorder(6, 6, 4, Platform.isMac() ? 3 : 6));
        content.add("hfill", this.settingsSeparator);
        content.add(JMainSettingsPanel.emptyArea(3));
        content.add("p", this.skin);
        JSiteButton skinSettingsButton = new JSiteButton(this.parent.actions.skinSettingsAction, false);
        skinSettingsButton.setBackground(skinSettingsButton.getBackground().darker());
        skinSettingsButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 3, 4));
        if (!Platform.isMac()) {
            content.add("tab", Box.createHorizontalStrut(4));
        }
        content.add(skinSettingsButton);
        content.add("br left", this.style);
        content.add("br", Box.createHorizontalStrut(4));
        content.add("center", this.moreSkinsLink);
        content.add(JMainSettingsPanel.emptyArea(5));
        content.add("br left hfill", new JSmartSeparator());
        this.skin.setPreferredSize(new Dimension(142, this.skin.getPreferredSize().height));
        this.style.setPreferredSize(this.skin.getPreferredSize());
        content.add("br hfill", this.makeAlbumButton);
        content.add("br hfill", this.publishButton);
        this.setLayout(new BorderLayout());
        this.add((Component)content, "Center");
    }

    private static JPanel createRiverPanel() {
        RiverLayout layout = new RiverLayout(0, Platform.isMac() ? 3 : 5);
        JPanel panel = new JPanel(layout);
        panel.setBorder(null);
        return panel;
    }

    private static Component emptyArea(int size) {
        return Box.createRigidArea(new Dimension(size, size));
    }

    void setTexts() {
        this.skin.setToolTipText(Msg.get("ui.skinToolTip"));
        this.style.setToolTipText(Msg.get("ui.styleToolTip"));
        this.skinLabel.setLabelFor(this.skin);
        this.skinLabel.setText(Msg.get("ui.skin"));
        this.styleLabel.setLabelFor(this.style);
        this.styleLabel.setText(Msg.get("ui.style"));
        this.moreSkinsLink.setText(Msg.get("ui.downloadSkins"));
        this.moreSkinsLink.setToolTipText(Msg.get("ui.downloadSkinsToolTip"));
        this.moreSkinsLink.setURL("http://jalbum.net/skins");
        this.collapsiblePanel.setTitle(Msg.get("ui.more"));
        this.settingsSeparator.setText(Msg.get("ui.skinAndStyle"));
        this.makeChanges.setText(Msg.get("ui.changes"));
        this.makeChanges.setToolTipText(Msg.get("ui.makeAlbumToolTip"));
        this.makeAll.setText(Msg.get("ui.all"));
        this.makeAll.setToolTipText(Msg.get("ui.rebuildAllToolTip"));
        this.makeAlbumButton.setText(Msg.get("ui.makeAlbum"));
    }

    public void scanSkins() {
        this.skin.removeActionListener(this.skinSelectedActionListener);
        Object selected = this.skin.getSelectedItem();
        this.skin.removeAllItems();
        JAlbumUtilities.fillCombo(this.skin, this.parent.cfg.chainedSkinsDir, (FileFilter)new DirectoryFilter());
        this.skin.setSelectedItem(selected);
        this.skin.addActionListener(this.skinSelectedActionListener);
        Object newSelected = this.skin.getSelectedItem();
        if (newSelected != null && !newSelected.equals(selected)) {
            this.skin.setSelectedItem(this.skin.getSelectedItem());
        }
    }

    private String getDefaultStyleForSkin(String skinName) {
        try {
            Config cfg = Config.getConfig();
            File skinDir = cfg.chainedSkinsDir.getFile(skinName);
            File stylesDir = new File(skinDir, "styles");
            Properties skinProps = IO.readPropertyFile(new File(skinDir, "hints.jap"));
            String style = skinProps.getProperty("style");
            if (style == null || !new File(stylesDir, style).exists()) {
                File[] styles = stylesDir.listFiles(new StyleFileFilter());
                if (styles != null && styles.length > 0) {
                    return styles[0].getName();
                }
                return "";
            }
            return style;
        }
        catch (IOException ex) {
            return "";
        }
    }

    String getSelectedSkin() {
        Object item = this.skin.getSelectedItem();
        if (item instanceof Item) {
            return (String)((Item)item).value;
        }
        return (String)item;
    }

    String getSelectedStyle() {
        Item item = (Item)this.style.getSelectedItem();
        if (item == null) {
            return null;
        }
        return (String)item.value;
    }

    boolean isMakeChanges() {
        return this.makeChanges.isSelected();
    }
}

