/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.ParseException;
import bsh.TargetError;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import se.datadosen.component.JSmartTextArea;
import se.datadosen.io.ConsoleStream;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.tags.ElementException;
import se.datadosen.util.Debug;
import se.datadosen.util.PrintSafeHashMap;
import se.datadosen.util.WindowUtilities;

public class JConsoleFrame
extends JFrame {
    JScrollPane jScrollPane1 = new JScrollPane();
    JTextArea console = new JSmartTextArea();
    JSplitPane jSplitPane1 = new JSplitPane();
    JScrollPane jScrollPane2 = new JScrollPane();
    JTextArea output = new JSmartTextArea();
    PrintStream stream = new PrintStream(new ConsoleStream(this.output), true);
    JAlbumFrame ui;
    Interpreter interpreter = new Interpreter();
    ClassLoader loader;

    public JConsoleFrame() {
        try {
            this.jbInit();
            this.loader = new URLClassLoader(new URL[]{Config.getConfig().pluginsDir.toURL()}, this.getClass().getClassLoader());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public JConsoleFrame(JAlbumFrame ui) {
        this.ui = ui;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        WindowUtilities.setApplicationModalExclusion(this);
        this.interpreter.setClassLoader(this.loader);
        NameSpace ns = this.interpreter.getNameSpace();
        ns.importPackage("se.datadosen.jalbum");
        ns.importPackage("se.datadosen.util");
        ns.importPackage("se.datadosen.component");
        ns.importPackage("net.miginfocom.swing");
        this.console.setText("");
        this.console.setTabSize(3);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        this.output.setColumns(100);
        this.output.setRows(20);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.add((Component)this.jScrollPane1, "top");
        this.jSplitPane1.add((Component)this.jScrollPane2, "bottom");
        this.jScrollPane2.getViewport().add((Component)this.output, null);
        this.jScrollPane1.getViewport().add((Component)this.console, null);
        AbstractAction evalExpression = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    String expr = JConsoleFrame.this.console.getSelectedText();
                    if (expr == null) {
                        expr = JConsoleFrame.this.console.getText();
                    }
                    JConsoleFrame.this.ui.ui2Engine();
                    System.out.println("==> " + JConsoleFrame.this.processExpression(expr));
                }
                catch (ElementException ex) {
                    Debug.showCopyableError(JConsoleFrame.this, ex, Msg.get("ui.scriptingError"));
                }
                catch (OperationAbortedException ex) {
                    JConsoleFrame.this.ui.statusBar.setText(Msg.get("ui.operationAborted"));
                }
                catch (Exception ex) {
                    Debug.showErrorDialog(JConsoleFrame.this, ex);
                }
            }
        };
        KeyStroke ctrlE = KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this.console.registerKeyboardAction(evalExpression, "evalExpression", ctrlE, 0);
        KeyStroke ctrlEnter = KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this.console.registerKeyboardAction(evalExpression, "evalExpression", ctrlEnter, 0);
        this.pack();
        this.jSplitPane1.setDividerLocation(100);
        this.setSize(new Dimension(640, 480));
    }

    public void setText(String text) {
        this.console.setText(text);
    }

    public String getText() {
        return this.console.getText();
    }

    public PrintStream getPrintStream() {
        return this.stream;
    }

    private Object processExpression(String expr) throws ElementException {
        PrintSafeHashMap vars = new PrintSafeHashMap();
        this.ui.engine.addGlobals(vars);
        Map userVariables = this.ui.engine.getUserVariables();
        if (userVariables != null) {
            vars.putAll(userVariables);
        }
        AlbumBean cfr_ignored_0 = this.ui.engine;
        AlbumBean.setVars(vars, this.interpreter);
        try {
            return this.interpreter.eval(expr);
        }
        catch (ParseException e) {
            throw new ElementException(e.getMessage() + "\n\nDetails:\n" + e.getErrorSourceFile());
        }
        catch (TargetError e) {
            Throwable t = e.getTarget();
            if (t instanceof OperationAbortedException) {
                throw (OperationAbortedException)t;
            }
            throw new ElementException("Exception caused by line " + e.getErrorLineNumber() + ": " + e.getTarget() + "\n\nDetails:\n" + e.getMessage());
        }
        catch (EvalError e) {
            throw new ElementException("Evaluation error on line " + e.getErrorLineNumber() + ":\n\nDetails:\n" + e.getMessage());
        }
    }
}

