/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import net.jalbum.filterManager.FilterList;
import net.jalbum.filterManager.FilterRenderer;
import net.jalbum.slideshow.SlideShow;
import net.jalbum.slideshow.SlideShowFactory;
import se.datadosen.component.AutoSelectingTreeCellEditor;
import se.datadosen.component.JGlassButton;
import se.datadosen.component.JNotification;
import se.datadosen.component.NonCollapsableJTree;
import se.datadosen.component.ToggleAction;
import se.datadosen.component.WordList;
import se.datadosen.explorer.ExplorerSelectionModel;
import se.datadosen.explorer.ExplorerTreeTransferHandler;
import se.datadosen.explorer.FileNameEditor;
import se.datadosen.explorer.ImageCache;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.explorer.JEditPanel;
import se.datadosen.explorer.JExplorerPanel;
import se.datadosen.explorer.JFilterBar;
import se.datadosen.explorer.JWelcomePanel;
import se.datadosen.explorer.TemporaryFileNameEditor;
import se.datadosen.explorer.event.SelectionListener;
import se.datadosen.explorer.event.StructureEvent;
import se.datadosen.explorer.event.StructureListener;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.AlbumSynchronizer;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.DeferredChooser;
import se.datadosen.jalbum.FileCopier;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumManager;
import se.datadosen.jalbum.JAlbumPlugin;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.PermissionException;
import se.datadosen.jalbum.RemoteFSTreeCellRenderer;
import se.datadosen.jalbum.TipOfTheDay;
import se.datadosen.jalbum.Tracer;
import se.datadosen.util.AliasAction;
import se.datadosen.util.Debug;
import se.datadosen.util.FileFilters;
import se.datadosen.util.IO;
import se.datadosen.util.Platform;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.ToolTipText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAlbumExplorer
extends JPanel
implements PropertyChangeListener {
    public static final int IMAGE_CACHE_SIZE = 10;
    static final KeyStroke backspace = KeyStroke.getKeyStroke(8, 0);
    static final KeyStroke cmdBackspace = KeyStroke.getKeyStroke(8, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    static final KeyStroke escape = KeyStroke.getKeyStroke(27, 0);
    static final KeyStroke f2 = KeyStroke.getKeyStroke(113, 0);
    static final KeyStroke f5 = KeyStroke.getKeyStroke(116, 0);
    static final KeyStroke delete = KeyStroke.getKeyStroke(127, 0);
    static final KeyStroke ctrlA = KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    static final KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
    static final KeyStroke altEnter = KeyStroke.getKeyStroke(10, 8);
    static final KeyStroke altGrEnter = KeyStroke.getKeyStroke(10, 2);
    static final KeyStroke ctrlShiftN = KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1);
    static final KeyStroke plus = KeyStroke.getKeyStroke('+');
    static final KeyStroke minus = KeyStroke.getKeyStroke('-');
    JAlbumFrame parent;
    AlbumObject rootFolder;
    AlbumObject currentFolder;
    ImageCache imageCache;
    MouseAdapter mouseOnComponentAdapter;
    private FocusListener componentFocusListener;
    private MouseMotionListener mouseMotionOnComponentListener;
    private MouseAdapter mouseOnTreeAdapter;
    private Point startingPoint;
    @Text(value="ui.up")
    public Action parentFolderAction;
    public Action refreshAction;
    @Text(value="edit.filterBar")
    public Action filterBarAction;
    @Text(value="edit.filterBar")
    public Action toggleFilterBarAction;
    public Action closeFilterBarAction;
    public Action largeThumbnailsAction;
    public Action hideExcludedAction;
    public Action slideShowAction;
    private Action renameAction;
    public Action repairLinkAction;
    public Action openAction;
    public Action showInFilesystemAction;
    public Action editModeAction;
    public Action explorerAction;
    @Text(value="ui.edit")
    public Action propertiesAction;
    @Text(value="ui.orderPhotobook", postfix="...")
    @ToolTipText(value="ui.photobookToolTip")
    public Action photobookAction;
    @Text(value="ui.photobook")
    public Action photobookAliasAction;
    private Action useAsFolderThumbnailAction;
    private Action convertLinkToCopyAction;
    public Action deleteAction;
    public Action saveCopyAsAction;
    public Action newFolderAction;
    public Action includeSelectedAction;
    public Action excludeSelectedAction;
    public ToggleAction includeOriginalAction;
    public Action rotateLeftAction;
    public Action rotateRightAction;
    public Action pasteAction;
    public Action selectAllAction;
    public Action copyFiltersAction;
    public Action pasteFiltersAction;
    public Action removeFiltersAction;
    public Action invertSelectionAction;
    @Text(value="ui.caption")
    public ToggleAction captionLabelTypeAction;
    @Text(value="ui.fileName")
    public ToggleAction fileNameLabelTypeAction;
    public ToggleAction orderByNameAction;
    public ToggleAction orderByDateAction;
    public ToggleAction orderByCameraDateAction;
    public ToggleAction orderByRatingAction;
    public ToggleAction customOrderingAction;
    public ToggleAction useJAlbumOrderingAction;
    public ToggleAction reverseOrderingAction;
    public ToggleAction foldersFirstAction;
    public ToggleAction orderFoldersByNameAction;
    public ToggleAction orderFoldersByDateAction;
    public ToggleAction reverseFolderOrderingAction;
    public Action shuffleAction;
    private JMenu imageFiltersMenu;
    private Action includeNodeAction;
    private Action excludeNodeAction;
    private Action deleteNodeAction;
    private Action renameNodeAction;
    @Text(value="ui.labelType")
    private JMenu labelTypeSubMenu;
    private JMenu orderingSubMenu;
    private JMenu folderOrderingSubMenu;
    private final JSplitPane splitPane;
    private final JScrollPane treeScrollPane;
    private final JScrollPane explorerScrollPane;
    final JTree tree;
    public final JAlbumManager albumManager;
    private final CardLayout viewMode;
    public JPanel viewPanel;
    public JPanel explorerCard;
    public JPanel leftPanel;
    public final WordList knownKeywords;
    JFilterBar filterBar;
    public JPanel albumsPanel;
    private JComponent notification;
    public JPanel rightPanel;
    private final JPanel welcomePanel;
    public JExplorerPanel explorer;
    public JEditPanel editor;
    JPopupMenu explorerPopup;
    JPopupMenu componentPopup;
    JPopupMenu brokenLinkPopup;
    JPopupMenu treeNodePopup;
    public JCheckBoxMenuItem hideExcludedMenuItem;
    JCheckBoxMenuItem filterBarMenuItem;
    public JCheckBoxMenuItem largeThumbnailsMenuItem;
    JCheckBoxMenuItem useAsFolderThumbnailMenuItem;
    private boolean explorerMode;
    private FilterList imageFilterClipboard;
    @Text(value="ui.edit")
    JButton glassEditButton;
    private PropertyChangeListener rootNameChangeListener;
    private PropertyChangeListener representingAlbumObjectListener;

    public JAlbumExplorer(JAlbumFrame parent) {
        JAlbumContext.getInstance().setExplorer(this);
        this.propertiesAction = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", altEnter);
            }

            public void actionPerformed(ActionEvent e) {
                JAlbumObject jao = JAlbumExplorer.this.explorer.selectionModel.getSingleSelected();
                if (jao != null) {
                    JAlbumExplorer.this.setEditView(jao.ao);
                } else {
                    JAlbumExplorer.this.setEditView(JAlbumExplorer.this.currentFolder);
                }
            }
        };
        this.photobookAction = new AbstractAction(){
            JAlbumPlugin photobookPlugin;
            {
                this.putValue("SmallIcon", Icons.getIcon("toolbar.photobook"));
            }

            public void setEnabled(boolean newValue) {
                super.setEnabled(newValue);
                if (this.enabled) {
                    this.putValue("ShortDescription", Msg.get("ui.photobookToolTip"));
                } else {
                    this.putValue("ShortDescription", Msg.get("ui.photobookDisabledToolTip"));
                }
            }

            public void actionPerformed(ActionEvent e) {
                Tracer.getInstance().trace("photo book dialog presented");
                try {
                    if (this.photobookPlugin == null) {
                        URLClassLoader cl = new URLClassLoader(new URL[]{new URL(JAlbumSite.getInstance().getUploaderCodeUrl())}, this.getClass().getClassLoader());
                        Class<?> clazz = cl.loadClass("net.jalbum.photobook.JPhotoBookPlugin");
                        this.photobookPlugin = (JAlbumPlugin)clazz.newInstance();
                    }
                    this.photobookPlugin.init(JAlbumExplorer.this.parent.context.getPluginContext());
                }
                catch (MalformedURLException ex) {
                    Debug.showStackTraceDialog(JAlbumExplorer.this.parent, ex);
                }
                catch (ClassNotFoundException ex) {
                    Exception ex2 = new Exception(Msg.get("ui.cantConnectError", "jalbum.net"));
                    Debug.showFriendlyErrorDialog(JAlbumExplorer.this.parent, ex2);
                }
                catch (InstantiationException ex) {
                    Debug.showStackTraceDialog(JAlbumExplorer.this.parent, ex);
                }
                catch (IllegalAccessException ex) {
                    Debug.showStackTraceDialog(JAlbumExplorer.this.parent, ex);
                }
            }
        };
        this.photobookAliasAction = new AliasAction(this.photobookAction);
        this.splitPane = new JSplitPane(1);
        this.treeScrollPane = new JScrollPane();
        this.explorerScrollPane = new JScrollPane();
        this.tree = new NonCollapsableJTree((TreeModel)null);
        this.viewMode = new CardLayout();
        this.viewPanel = new JPanel(this.viewMode);
        this.explorerCard = new JPanel(new BorderLayout());
        this.leftPanel = new JPanel(new BorderLayout());
        this.knownKeywords = new WordList();
        this.filterBar = new JFilterBar(this);
        this.albumsPanel = new JPanel(new BorderLayout());
        this.rightPanel = new JPanel(new BorderLayout());
        this.explorerPopup = new JPopupMenu();
        this.componentPopup = new JPopupMenu();
        this.brokenLinkPopup = new JPopupMenu();
        this.treeNodePopup = new JPopupMenu();
        this.glassEditButton = new JGlassButton(Icons.getIcon("small.edit"));
        this.rootNameChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent pce) {
                String newName = pce.getNewValue().toString();
                try {
                    JAlbumExplorer.this.parent.renameImageDirectory(newName);
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(JAlbumExplorer.this.parent, ex);
                }
            }
        };
        this.parent = parent;
        this.albumManager = new JAlbumManager(parent.context, this.tree);
        this.explorer = new JExplorerPanel(this);
        this.welcomePanel = new JWelcomePanel(this);
        this.editor = new JEditPanel(this);
        new ExplorerTreeTransferHandler(this.tree, this.albumManager.getAlbumRootComponent(), this);
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.enableEvents(64L);
        this.glassEditButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Container c;
                for (c = JAlbumExplorer.this.glassEditButton.getParent(); c != null && !(c instanceof JAlbumObject); c = c.getParent()) {
                }
                if (c != null) {
                    JAlbumObject jao = (JAlbumObject)c;
                    JAlbumExplorer.this.explorer.selectionModel.deselectAll();
                    jao.setSelected(true);
                    JAlbumExplorer.this.explorer.selectionModel.setFocusedObject(jao);
                    JAlbumExplorer.this.glassEditButton.setVisible(false);
                    JAlbumExplorer.this.explorer.context.editModeAction.actionPerformed(null);
                }
            }
        });
        this.glassEditButton.setVisible(false);
    }

    public JComponent setNotification(JComponent notification) {
        JComponent oldNotification = this.notification;
        if (this.notification != null) {
            this.albumsPanel.remove(this.notification);
        }
        this.notification = notification;
        if (notification != null) {
            this.albumsPanel.add((Component)notification, "South");
        }
        this.leftPanel.validate();
        return oldNotification;
    }

    public JComponent getNotification() {
        return this.notification;
    }

    private void go(int dir, ActionEvent e) {
        JAlbumObject focused = this.explorer.selectionModel.getFocusedObject();
        if (focused != null) {
            JAlbumObject jao = this.explorer.selectionModel.getNeighbourObject(focused, dir);
            MouseEvent me = new MouseEvent(jao, 0, e.getWhen(), e.getModifiers(), 0, 0, 1, false);
            this.explorer.scrollRectToVisible(jao.getBounds());
            this.mouseOnComponentAdapter.mousePressed(me);
        }
    }

    private void init() throws Exception {
        JAlbumExplorer contentPane = this;
        contentPane.setLayout(new BorderLayout());
        this.explorerScrollPane.setPreferredSize(new Dimension(420, 80));
        this.explorerScrollPane.getVerticalScrollBar().setUnitIncrement(70);
        if (Platform.isMac()) {
            this.explorerScrollPane.setVerticalScrollBarPolicy(22);
        }
        this.explorerScrollPane.setHorizontalScrollBarPolicy(31);
        this.explorer.addStructureListener(new StructureListener(){

            public void structureChanged(StructureEvent e) {
                JAlbumExplorer.this.syncModel();
                JAlbumExplorer.this.refreshCurrentNode();
                JAlbumExplorer.this.updateStatusBar();
                if (!TipOfTheDay.isShowingNotification()) {
                    TipOfTheDay.showInBackground(Msg.get("tip.updateChanges", Msg.get("ui.makeAlbum")));
                }
            }
        });
        InputMap im = this.explorerScrollPane.getInputMap(1);
        im.put(KeyStroke.getKeyStroke(38, 64), "unitScrollUp");
        im.put(KeyStroke.getKeyStroke(40, 64), "unitScrollDown");
        im.put(KeyStroke.getKeyStroke(37, 64), "unitScrollLeft");
        im.put(KeyStroke.getKeyStroke(39, 64), "unitScrollRight");
        ActionMap am = this.explorerScrollPane.getActionMap();
        am.put("unitScrollUp", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.go(1, e);
            }
        });
        am.put("unitScrollDown", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.go(2, e);
            }
        });
        am.put("unitScrollLeft", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.go(3, e);
            }
        });
        am.put("unitScrollRight", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.go(4, e);
            }
        });
        im.put(KeyStroke.getKeyStroke('0'), "unrated");
        im.put(KeyStroke.getKeyStroke('1'), "1rated");
        im.put(KeyStroke.getKeyStroke('2'), "2rated");
        im.put(KeyStroke.getKeyStroke('3'), "3rated");
        im.put(KeyStroke.getKeyStroke('4'), "4rated");
        im.put(KeyStroke.getKeyStroke('5'), "5rated");
        am.put("unrated", new RatingAction(0));
        am.put("1rated", new RatingAction(1));
        am.put("2rated", new RatingAction(2));
        am.put("3rated", new RatingAction(3));
        am.put("4rated", new RatingAction(4));
        am.put("5rated", new RatingAction(5));
        contentPane.add((Component)this.splitPane, "Center");
        this.treeScrollPane.getViewport().add(this.tree);
        JScrollPane sp = new JScrollPane(this.albumManager);
        sp.setBorder(null);
        sp.getVerticalScrollBar().setUnitIncrement(8);
        this.albumsPanel.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, Color.lightGray));
        this.albumsPanel.setBackground(SystemColor.text);
        this.albumsPanel.add((Component)sp, "Center");
        this.leftPanel.add((Component)this.albumsPanel, "Center");
        this.leftPanel.add((Component)this.parent.mainSettingsPanel, "South");
        Dimension panelDimension = new Dimension(this.parent.mainSettingsPanel.getPreferredSize().width, this.treeScrollPane.getHeight() + this.parent.mainSettingsPanel.getHeight());
        this.leftPanel.setMinimumSize(panelDimension);
        this.leftPanel.setPreferredSize(panelDimension);
        this.explorerScrollPane.setViewportView(this.explorer);
        this.explorer.setAutoscrolls(true);
        this.explorerCard.add((Component)this.explorerScrollPane, "Center");
        this.explorerCard.add((Component)this.filterBar, "South");
        this.filterBar.setVisible(false);
        this.viewPanel.add((Component)this.welcomePanel, "welcomePanel");
        this.viewPanel.add((Component)this.explorerCard, "explorerPanel");
        this.viewPanel.add((Component)this.editor, "editPanel");
        this.viewPanel.setFocusCycleRoot(true);
        this.explorerCard.setFocusCycleRoot(true);
        this.explorerMode = true;
        this.viewMode.show(this.viewPanel, "welcomePanel");
        this.rightPanel.add((Component)this.viewPanel, "Center");
        this.splitPane.add((Component)this.leftPanel, "left");
        this.splitPane.add((Component)this.rightPanel, "right");
        this.splitPane.setDividerSize(3);
        Color borderColor = new Color(165, 165, 165);
        this.filterBar.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, borderColor));
        this.treeScrollPane.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, borderColor));
        this.editor.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 0, borderColor));
        this.explorerScrollPane.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, borderColor));
        this.welcomePanel.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, borderColor));
        if (Platform.isMac()) {
            this.leftPanel.setBorder(null);
        } else {
            this.leftPanel.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 0));
            this.editor.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 0, borderColor));
        }
        this.tree.setBorder(BorderFactory.createEmptyBorder(1, Platform.isMac() ? 6 : 2, 1, 1));
        this.viewPanel.setBorder(null);
        contentPane.setBorder(null);
        this.splitPane.setBorder(null);
        this.copyFiltersAction = new AbstractAction(Msg.get("edit.copy")){

            public void actionPerformed(ActionEvent e) {
                JAlbumObject jao = JAlbumExplorer.this.explorer.selectionModel.getSingleSelected();
                if (jao == null || !jao.ao.isDisplayableImage()) {
                    return;
                }
                FilterList fl = (FilterList)jao.ao.getProperties().get("filterList");
                JAlbumExplorer.this.imageFilterClipboard = FilterList.clone(fl);
            }
        };
        this.pasteFiltersAction = new AbstractAction(Msg.get("edit.paste")){

            public void actionPerformed(ActionEvent e) {
                LinkedList<JAlbumObject> objects = JAlbumExplorer.this.explorer.selectionModel.getSelectedObjects();
                JAlbumExplorer.this.setCursor(Cursor.getPredefinedCursor(3));
                for (JAlbumObject jao : objects) {
                    if (!jao.ao.isDisplayableImage()) continue;
                    AlbumObjectProperties props = jao.ao.getProperties();
                    props.putHidden("filterList", JAlbumExplorer.this.imageFilterClipboard);
                    props.save();
                    try {
                        jao.ao.updateRepresentingIcon();
                    }
                    catch (IOException ex) {
                        JAlbumExplorer.this.setCursor(Cursor.getDefaultCursor());
                        Debug.showFriendlyErrorDialog(JAlbumExplorer.this, ex);
                    }
                }
                JAlbumExplorer.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        this.removeFiltersAction = new AbstractAction(Msg.get("remove")){

            public void actionPerformed(ActionEvent e) {
                LinkedList<JAlbumObject> objects = JAlbumExplorer.this.explorer.selectionModel.getSelectedObjects();
                JAlbumExplorer.this.setCursor(Cursor.getPredefinedCursor(3));
                for (JAlbumObject jao : objects) {
                    if (!jao.ao.isDisplayableImage()) continue;
                    AlbumObjectProperties props = jao.ao.getProperties();
                    props.remove("filterList");
                    props.save();
                    try {
                        jao.ao.updateRepresentingIcon();
                    }
                    catch (IOException ex) {
                        JAlbumExplorer.this.setCursor(Cursor.getDefaultCursor());
                        Debug.showFriendlyErrorDialog(JAlbumExplorer.this, ex);
                    }
                }
                JAlbumExplorer.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        this.pasteAction = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
                JAlbumExplorer.this.parent.addWindowFocusListener(new WindowAdapter(){

                    public void windowGainedFocus(WindowEvent e) {
                        JAlbumExplorer.this.handlePasteActionEnabling();
                    }
                });
            }

            public void actionPerformed(ActionEvent e) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable t = clipboard.getContents(JAlbumExplorer.this.explorer);
                try {
                    if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        List files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                        JAlbumExplorer.this.explorer.handleFileAdd(files);
                    }
                }
                catch (IOException ex) {
                    Debug.showStackTraceDialog(JAlbumExplorer.this, ex);
                    ex.printStackTrace();
                }
                catch (UnsupportedFlavorException ex) {
                    Debug.showStackTraceDialog(JAlbumExplorer.this, ex);
                    ex.printStackTrace();
                }
            }
        };
        this.parentFolderAction = new AbstractAction(){
            {
                this.putValue("SmallIcon", Icons.getIcon("toolbar.toParentFolder"));
                this.setEnabled(false);
            }

            public void actionPerformed(ActionEvent e) {
                if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() instanceof JTextComponent) {
                    return;
                }
                if (JAlbumExplorer.this.currentFolder != null && JAlbumExplorer.this.currentFolder.getParent() != null) {
                    JAlbumExplorer.this.tree.setSelectionPath(JAlbumExplorer.this.tree.getSelectionPath().getParentPath());
                }
            }
        };
        this.parentFolderAction.putValue("AcceleratorKey", backspace);
        this.renameAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JAlbumObject selected = JAlbumExplorer.this.explorer.selectionModel.getSingleSelected();
                if (selected != null) {
                    if (!(selected.editor instanceof FileNameEditor)) {
                        TemporaryFileNameEditor editor = new TemporaryFileNameEditor(selected);
                        editor.install();
                    }
                    selected.setEditing(true);
                }
            }
        };
        this.renameAction.putValue("AcceleratorKey", f2);
        this.refreshAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                File dir;
                File jalbumDir;
                File thumbsDir;
                if (e != null && (e.getModifiers() & 9) != 0 && (thumbsDir = new File(jalbumDir = new File(dir = JAlbumExplorer.this.currentFolder.getFile(), ".jalbum"), "thumbs")).exists()) {
                    System.out.println("Flushing thumbnail cache in " + thumbsDir);
                    for (File f : thumbsDir.listFiles()) {
                        f.delete();
                    }
                }
                JAlbumExplorer.this.rootFolder.invalidate();
                JAlbumExplorer.this.setRootFolder(JAlbumExplorer.this.rootFolder);
                JAlbumExplorer.this.selectNode(JAlbumExplorer.this.currentFolder);
                JAlbumExplorer.this.viewFolder(JAlbumExplorer.this.currentFolder);
            }
        };
        this.refreshAction.putValue("AcceleratorKey", f5);
        this.openAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.open(JAlbumExplorer.this.explorer.selectionModel.getFocusedObject());
            }
        };
        this.openAction.putValue("AcceleratorKey", enter);
        this.repairLinkAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.open(JAlbumExplorer.this.explorer.selectionModel.getFocusedObject());
            }
        };
        this.showInFilesystemAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LinkedList<JAlbumObject> list = JAlbumExplorer.this.explorer.selectionModel.getSelectedObjects();
                try {
                    for (JAlbumObject jao : list) {
                        File dest = jao.ao.getFile();
                        BrowserLauncher.showInFileSystem(dest);
                    }
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(JAlbumExplorer.this, (Throwable)ex);
                }
            }
        };
        this.editModeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.propertiesAction.actionPerformed(e);
            }

            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                JAlbumExplorer.this.explorerAction.setEnabled(enabled);
            }
        };
        this.explorerAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.setExplorerView();
            }
        };
        this.hideExcludedAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.applyFilters();
                JAlbumExplorer.this.updateStatusBar();
            }
        };
        this.closeFilterBarAction = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", escape);
            }

            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.filterBarAction.putValue("SwingSelectedKey", false);
                JAlbumExplorer.this.filterBarAction.actionPerformed(e);
            }
        };
        this.filterBarAction = new AbstractAction(){
            {
                this.putValue("SwingSelectedKey", false);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            }

            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.filterBar.setVisible((Boolean)this.getValue("SwingSelectedKey"));
                if (JAlbumExplorer.this.filterBar.isVisible()) {
                    JAlbumExplorer.this.filterBar.keywordsField.requestFocusInWindow();
                }
                JAlbumExplorer.this.applyFilters();
                JAlbumExplorer.this.updateStatusBar();
            }
        };
        this.toggleFilterBarAction = new AbstractAction(){
            {
                this.putValue("SmallIcon", Icons.getIcon("small.filter"));
            }

            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.filterBarAction.putValue("SwingSelectedKey", Boolean.FALSE.equals((Boolean)JAlbumExplorer.this.filterBarAction.getValue("SwingSelectedKey")));
                JAlbumExplorer.this.filterBarAction.actionPerformed(e);
            }
        };
        this.largeThumbnailsAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (JAlbumExplorer.this.largeThumbnailsMenuItem.isSelected()) {
                    JAlbumExplorer.this.explorer.setIconBounds(new Dimension(160, 160));
                } else {
                    JAlbumExplorer.this.parent.preferencesWindow.largeThumbnails.setSelected(false);
                    JAlbumExplorer.this.explorer.setIconBounds(new Dimension(96, 96));
                }
                JAlbumExplorer.this.parent.preferencesWindow.savePreferences();
                JAlbumExplorer.this.viewFolder(JAlbumExplorer.this.currentFolder);
            }
        };
        this.useAsFolderThumbnailAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JAlbumObject jao = JAlbumExplorer.this.explorer.selectionModel.getFocusedObject();
                if (JAlbumExplorer.this.useAsFolderThumbnailMenuItem.isSelected()) {
                    JAlbumExplorer.this.currentFolder.setRepresentingAlbumObject(jao.ao);
                } else {
                    JAlbumExplorer.this.currentFolder.setRepresentingAlbumObject(null);
                }
            }
        };
        this.convertLinkToCopyAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LinkedList list = JAlbumExplorer.this.getSelectJAlbumObjects();
                FileCopier fc = new FileCopier(JAlbumExplorer.this.parent);
                fc.setAllowDuplicates(true);
                ArrayList<File> files = new ArrayList<File>();
                for (JAlbumObject jao : list) {
                    File f = jao.ao.getFile();
                    if (!(f instanceof LinkFile) || !f.exists() || f.isDirectory()) continue;
                    files.add(jao.ao.getFile());
                }
                fc.copyFiles(files, JAlbumExplorer.this.currentFolder);
                JAlbumExplorer.this.currentFolder.invalidate();
                JAlbumExplorer.this.viewFolder(JAlbumExplorer.this.currentFolder);
            }
        };
        this.deleteAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                int answer;
                LinkedList<JAlbumObject> list = JAlbumExplorer.this.explorer.selectionModel.getSelectedObjects();
                if (list.size() == 0) {
                    return;
                }
                int physicalFilesOrFoldersSelected = 0;
                for (JAlbumObject jao : list) {
                    if (jao.ao.isLink()) continue;
                    ++physicalFilesOrFoldersSelected;
                }
                File myalbumsDir = new File(Config.getConfig().getMyAlbumsLocation());
                if (physicalFilesOrFoldersSelected > 0 && (answer = JOptionPane.showConfirmDialog(JAlbumExplorer.this, Msg.get("edit.deletePermanentlyInfo", physicalFilesOrFoldersSelected), Msg.get("edit.deleteFilesTitle"), 0, 2)) != 0) {
                    return;
                }
                try {
                    for (JAlbumObject jao : list) {
                        jao.ao.delete();
                        JAlbumExplorer.this.explorer.remove(jao);
                    }
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(JAlbumExplorer.this, (Throwable)ex);
                }
                catch (PermissionException ex) {
                    JOptionPane.showMessageDialog(JAlbumExplorer.this, ex.getMessage(), Msg.get("edit.deleteFilesTitle"), 0);
                }
                JAlbumExplorer.this.explorer.validate();
                JAlbumExplorer.this.explorer.repaint();
                JAlbumExplorer.this.refreshCurrentNode();
            }
        };
        this.deleteAction.putValue("AcceleratorKey", Platform.isMac() ? cmdBackspace : delete);
        this.saveCopyAsAction = new AbstractAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void actionPerformed(ActionEvent e) {
                JAlbumObject jao = JAlbumExplorer.this.explorer.selectionModel.getFocusedObject();
                DeferredChooser imageChooser = new DeferredChooser(JFileChooser.class);
                imageChooser.setDialogTitle(Msg.get("edit.saveCopyAs"));
                imageChooser.setSelectedFile(jao.ao.getFile());
                int returnVal = imageChooser.showSaveDialog(JAlbumExplorer.this);
                if (returnVal != 0) return;
                File newFile = imageChooser.getSelectedFile();
                boolean write = true;
                if (newFile.exists()) {
                    int response = JOptionPane.showConfirmDialog(JAlbumExplorer.this, Msg.get("edit.fileAlreadyExistsWarning", jao.ao.getFile().getName()), Msg.get("edit.saveCopyAs"), 0);
                    write = response == 0;
                }
                if (!write) return;
                JAlbumExplorer.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    try {
                        BufferedImage im = (BufferedImage)jao.ao.loadImage();
                        FilterRenderer filterRenderer = new FilterRenderer();
                        FilterList fl = (FilterList)jao.ao.getProperties().get("filterList");
                        if (fl != null) {
                            filterRenderer.setFilterList(fl);
                            if (filterRenderer.getFilterList().getPosition() > 0) {
                                im = filterRenderer.renderImage(im);
                            }
                        }
                        IIOMetadata meta = null;
                        try {
                            ImageInputStream iis = ImageIO.createImageInputStream(jao.ao.getFile());
                            Iterator<ImageReader> it = ImageIO.getImageReadersBySuffix(IO.extensionOf(jao.ao.getFile()));
                            if (it.hasNext()) {
                                ImageReader ir = it.next();
                                ir.setInput(iis);
                                meta = ir.getImageMetadata(ir.getMinIndex());
                            }
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                        FileFilters.saveJPEG(im, newFile, JAlbumExplorer.this.parent.engine, meta);
                    }
                    catch (IOException ex) {
                        Debug.showErrorDialog(JAlbumExplorer.this, (Throwable)ex);
                        Object var15_18 = null;
                        JAlbumExplorer.this.setCursor(Cursor.getDefaultCursor());
                        return;
                    }
                    Object var15_17 = null;
                }
                catch (Throwable throwable) {
                    Object var15_19 = null;
                    JAlbumExplorer.this.setCursor(Cursor.getDefaultCursor());
                    throw throwable;
                }
                JAlbumExplorer.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        this.newFolderAction = new AbstractAction(){
            {
                this.putValue("AcceleratorKey", ctrlShiftN);
            }

            public void actionPerformed(ActionEvent e) {
                try {
                    AlbumObject ao = JAlbumExplorer.this.currentFolder.createFolder(Msg.get("edit.newFolder"));
                    JAlbumObject jao = JAlbumExplorer.this.addJAO(ao);
                    JAlbumExplorer.this.explorer.validate();
                    JAlbumExplorer.this.explorer.repaint();
                    JAlbumExplorer.this.refreshCurrentNode();
                    JAlbumExplorer.this.explorer.scrollRectToVisible(jao.getBounds());
                    jao.setEditing(true);
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(JAlbumExplorer.this, (Throwable)ex);
                }
            }
        };
        this.includeSelectedAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LinkedList list = JAlbumExplorer.this.getSelectJAlbumObjects();
                for (JAlbumObject jao : list) {
                    jao.setIncluded(true);
                    JAlbumExplorer.this.applyFilter(jao);
                }
                JAlbumExplorer.this.syncModel();
                if (!JAlbumExplorer.this.explorerMode) {
                    try {
                        JAlbumExplorer.this.editor.updateImage(false);
                    }
                    catch (IOException ex) {
                        Debug.showErrorDialog(JAlbumExplorer.this, (Throwable)ex);
                    }
                } else {
                    JAlbumExplorer.this.tree.repaint();
                }
            }
        };
        this.includeSelectedAction.putValue("AcceleratorKey", plus);
        this.excludeSelectedAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LinkedList list = JAlbumExplorer.this.getSelectJAlbumObjects();
                JAlbumObject first = (JAlbumObject)list.get(0);
                boolean include = true;
                if (first != null && first.isIncluded()) {
                    include = false;
                }
                boolean hideExcluded = JAlbumExplorer.this.hideExcludedMenuItem.isSelected();
                AlbumSynchronizer sync = new AlbumSynchronizer(JAlbumExplorer.this.parent.engine);
                for (JAlbumObject jao : list) {
                    if (!include) {
                        sync.delete(sync.translate(jao.ao));
                    }
                    jao.setIncluded(include);
                    JAlbumExplorer.this.applyFilter(jao);
                    JAlbumExplorer.this.syncModel();
                }
                if (!JAlbumExplorer.this.explorerMode) {
                    try {
                        JAlbumExplorer.this.editor.updateImage(false);
                    }
                    catch (IOException ex) {
                        Debug.showErrorDialog(JAlbumExplorer.this, (Throwable)ex);
                    }
                } else {
                    JAlbumExplorer.this.tree.repaint();
                }
            }
        };
        this.excludeSelectedAction.putValue("AcceleratorKey", minus);
        this.registerKeyboardAction(this.excludeSelectedAction, minus, 1);
        this.includeOriginalAction = new ToggleAction(){

            public void actionPerformed(ActionEvent e) {
                AlbumSynchronizer sync = new AlbumSynchronizer(JAlbumExplorer.this.parent.engine);
                LinkedList list = JAlbumExplorer.this.getSelectJAlbumObjects();
                for (JAlbumObject jao : list) {
                    if (!jao.ao.isDisplayableImage()) continue;
                    AlbumObjectProperties props = jao.ao.getProperties();
                    props.put("includeOriginal", this.isSelected());
                    props.save();
                    sync.deleteOriginal(jao.ao);
                    jao.repaint();
                }
            }
        };
        this.rotateLeftAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.adjustOrientation(false);
            }
        };
        this.rotateRightAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.adjustOrientation(true);
            }
        };
        this.selectAllAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.explorer.selectionModel.selectAll();
            }
        };
        this.selectAllAction.putValue("AcceleratorKey", ctrlA);
        this.invertSelectionAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.explorer.selectionModel.invertSelection();
            }
        };
        this.slideShowAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.startSlideshow();
            }
        };
        this.captionLabelTypeAction = new ToggleAction(){

            public void actionPerformed(ActionEvent e) {
                Config.getConfig().setLabelType(Config.LabelType.caption);
                JAlbumExplorer.this.parent.preferencesWindow.savePreferences();
                JAlbumExplorer.this.currentFolder.invalidate();
                JAlbumExplorer.this.viewFolder(JAlbumExplorer.this.currentFolder);
            }
        };
        this.fileNameLabelTypeAction = new ToggleAction(){

            public void actionPerformed(ActionEvent e) {
                Config.getConfig().setLabelType(Config.LabelType.fileName);
                JAlbumExplorer.this.parent.preferencesWindow.savePreferences();
                JAlbumExplorer.this.currentFolder.invalidate();
                JAlbumExplorer.this.viewFolder(JAlbumExplorer.this.currentFolder);
            }
        };
        this.orderByNameAction = new ToggleAction(){

            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.setOrdering("name");
            }
        };
        this.orderByDateAction = new ToggleAction(){

            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.setOrdering("date");
            }
        };
        this.orderByCameraDateAction = new ToggleAction(){

            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.setOrdering("cameraDate");
            }
        };
        this.orderByRatingAction = new ToggleAction(){

            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.setOrdering("rating");
            }
        };
        this.customOrderingAction = new ToggleAction(){

            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.setOrdering("custom");
            }
        };
        this.useJAlbumOrderingAction = new ToggleAction(){

            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.setOrdering("jalbum");
            }
        };
        this.reverseOrderingAction = new ToggleAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    JAlbumExplorer.this.currentFolder.setReverseOrdering(this.isSelected());
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(JAlbumExplorer.this, (Throwable)ex);
                }
                JAlbumExplorer.this.currentFolder.invalidate();
                JAlbumExplorer.this.viewFolder(JAlbumExplorer.this.currentFolder);
                JAlbumExplorer.this.refreshCurrentNode();
            }
        };
        this.foldersFirstAction = new ToggleAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    JAlbumExplorer.this.currentFolder.setFoldersFirst(this.isSelected());
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(JAlbumExplorer.this, (Throwable)ex);
                }
                JAlbumExplorer.this.currentFolder.invalidate();
                JAlbumExplorer.this.viewFolder(JAlbumExplorer.this.currentFolder);
            }
        };
        this.orderFoldersByNameAction = new ToggleAction(){

            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.setFolderOrdering("name");
            }
        };
        this.orderFoldersByDateAction = new ToggleAction(){

            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.setFolderOrdering("date");
            }
        };
        this.reverseFolderOrderingAction = new ToggleAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    JAlbumExplorer.this.currentFolder.setReverseFolderOrdering(this.isSelected());
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(JAlbumExplorer.this, (Throwable)ex);
                }
                JAlbumExplorer.this.currentFolder.invalidate();
                JAlbumExplorer.this.viewFolder(JAlbumExplorer.this.currentFolder);
                JAlbumExplorer.this.refreshCurrentNode();
            }
        };
        this.shuffleAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Component[] comps = JAlbumExplorer.this.explorer.getComponents();
                Collections.shuffle(Arrays.asList(comps));
                JAlbumExplorer.this.explorer.removeAll();
                for (Component element : comps) {
                    JAlbumExplorer.this.explorer.add(element);
                }
                JAlbumExplorer.this.explorer.validate();
                JAlbumExplorer.this.explorer.repaint();
                JAlbumExplorer.this.syncModel();
                try {
                    JAlbumExplorer.this.currentFolder.setOrdering("custom");
                    JAlbumExplorer.this.customOrderingAction.setSelected(true);
                    JAlbumExplorer.this.handleDisablingOfOrderingMenus();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        this.includeNodeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.currentFolder.setIncluded(true);
                JAlbumExplorer.this.tree.repaint();
                try {
                    JAlbumExplorer.this.currentFolder.getParent().setChildren(JAlbumExplorer.this.currentFolder.getParent().getChildren());
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            }
        };
        this.excludeNodeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.currentFolder.setIncluded(false);
                JAlbumExplorer.this.tree.repaint();
                try {
                    JAlbumExplorer.this.currentFolder.getParent().setChildren(JAlbumExplorer.this.currentFolder.getParent().getChildren());
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            }
        };
        this.deleteNodeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    AlbumObject parent = JAlbumExplorer.this.currentFolder.getParent();
                    JAlbumExplorer.this.currentFolder.delete();
                    JAlbumExplorer.this.selectNode(parent);
                    JAlbumExplorer.this.refreshCurrentNode();
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(JAlbumExplorer.this, (Throwable)ex);
                }
                catch (PermissionException ex) {
                    JOptionPane.showMessageDialog(JAlbumExplorer.this, ex.getMessage(), Msg.get("edit.deleteFilesTitle"), 0);
                }
            }
        };
        this.renameNodeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JAlbumExplorer.this.tree.startEditingAtPath(JAlbumExplorer.this.tree.getLeadSelectionPath());
            }
        };
        this.explorer.registerKeyboardAction(this.selectAllAction, "selectAllAction", ctrlA, 2);
        this.explorer.getInputMap(1).put(backspace, "parentFolder");
        this.explorer.getActionMap().put("parentFolder", this.parentFolderAction);
        this.explorer.registerKeyboardAction(this.renameAction, "editNameAction", f2, 2);
        this.explorer.registerKeyboardAction(this.openAction, "openAction", enter, 1);
        this.explorer.registerKeyboardAction(this.propertiesAction, "propertiesAction", altEnter, 2);
        this.explorer.registerKeyboardAction(this.newFolderAction, "newFolderAction", ctrlShiftN, 2);
        this.explorer.registerKeyboardAction(this.propertiesAction, "propertiesAction", altGrEnter, 2);
        this.explorer.registerKeyboardAction(this.deleteAction, "deleteAction", Platform.isMac() ? cmdBackspace : delete, 2);
        this.explorer.registerKeyboardAction(this.closeFilterBarAction, "closeFilterBarAction", escape, 2);
        this.explorer.registerKeyboardAction(this.includeSelectedAction, "includeSelectedAction", plus, 2);
        this.explorer.registerKeyboardAction(this.excludeSelectedAction, "excludeSelectedAction", minus, 2);
        contentPane.registerKeyboardAction(this.refreshAction, "update", f5, 2);
        this.componentPopup.add(this.openAction);
        this.componentPopup.add(this.showInFilesystemAction);
        this.componentPopup.add(this.invertSelectionAction);
        this.componentPopup.add(this.slideShowAction);
        this.imageFiltersMenu = new JMenu(Msg.get("edit.filtersHeading"));
        this.imageFiltersMenu.add(this.copyFiltersAction);
        this.imageFiltersMenu.add(this.pasteFiltersAction);
        this.imageFiltersMenu.add(this.removeFiltersAction);
        this.componentPopup.addSeparator();
        this.componentPopup.add(this.imageFiltersMenu);
        this.componentPopup.addSeparator();
        this.componentPopup.add(this.rotateLeftAction);
        this.componentPopup.add(this.rotateRightAction);
        this.componentPopup.addSeparator();
        this.componentPopup.add(this.excludeSelectedAction);
        this.componentPopup.add(this.includeOriginalAction.createJCheckBoxMenuItem());
        this.componentPopup.addSeparator();
        this.useAsFolderThumbnailMenuItem = new JCheckBoxMenuItem(this.useAsFolderThumbnailAction);
        this.componentPopup.add(this.saveCopyAsAction);
        this.componentPopup.add(this.useAsFolderThumbnailMenuItem);
        this.componentPopup.add(this.convertLinkToCopyAction);
        this.componentPopup.add(this.deleteAction);
        this.componentPopup.add(this.renameAction);
        this.componentPopup.addSeparator();
        this.componentPopup.add(this.propertiesAction);
        this.brokenLinkPopup.add(this.repairLinkAction);
        this.brokenLinkPopup.add(this.invertSelectionAction);
        this.brokenLinkPopup.addSeparator();
        this.brokenLinkPopup.add(this.excludeSelectedAction);
        this.brokenLinkPopup.addSeparator();
        this.brokenLinkPopup.add(this.deleteAction);
        this.brokenLinkPopup.add(this.renameAction);
        this.explorerPopup.add(this.pasteAction);
        this.explorerPopup.add(this.selectAllAction);
        this.explorerPopup.add(this.slideShowAction);
        this.labelTypeSubMenu = new JMenu();
        this.populateLabelTypeSubMenu(this.labelTypeSubMenu);
        this.orderingSubMenu = new JMenu();
        this.folderOrderingSubMenu = new JMenu();
        this.populateOrderingSubMenu(this.orderingSubMenu);
        this.populateFolderOrderingSubMenu(this.folderOrderingSubMenu);
        this.explorerPopup.addSeparator();
        this.filterBarMenuItem = new JCheckBoxMenuItem(this.filterBarAction);
        this.largeThumbnailsMenuItem = new JCheckBoxMenuItem(this.largeThumbnailsAction);
        this.largeThumbnailsMenuItem.setModel(this.parent.preferencesWindow.largeThumbnails.getModel());
        this.explorerPopup.add(this.filterBarMenuItem);
        this.explorerPopup.add(this.largeThumbnailsMenuItem);
        this.explorerPopup.add(this.labelTypeSubMenu);
        this.hideExcludedMenuItem = new JCheckBoxMenuItem(this.hideExcludedAction);
        this.explorerPopup.add(this.hideExcludedMenuItem);
        this.explorerPopup.add(this.orderingSubMenu);
        this.explorerPopup.add(this.folderOrderingSubMenu);
        this.explorerPopup.add(this.newFolderAction);
        this.explorerPopup.add(this.refreshAction);
        this.explorerPopup.addSeparator();
        this.explorerPopup.add(this.propertiesAction);
        this.treeNodePopup.add(this.excludeNodeAction);
        this.treeNodePopup.add(this.includeNodeAction);
        this.treeNodePopup.add(this.deleteNodeAction);
        this.treeNodePopup.add(this.renameNodeAction);
        this.treeNodePopup.addSeparator();
        this.treeNodePopup.add(this.propertiesAction);
        Msg.maintainTranslated(this);
        this.setTexts();
        MouseAdapter mouseOnExplorerAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                JAlbumExplorer.this.startingPoint = e.getPoint();
                JAlbumExplorer.this.explorer.rubberband = new Rectangle(JAlbumExplorer.this.startingPoint);
                if (!JAlbumExplorer.isPortableControlDown(e) && !e.isShiftDown()) {
                    JAlbumExplorer.this.explorer.selectionModel.deselectAll();
                }
                JAlbumExplorer.this.handlePasteActionEnabling();
                JAlbumExplorer.this.maybeShowPopup(e, JAlbumExplorer.this.explorerPopup);
            }

            public void mouseReleased(MouseEvent e) {
                Component[] comps;
                JAlbumExplorer.this.explorer.rubberband = null;
                JAlbumExplorer.this.explorer.repaint();
                for (Component element : comps = JAlbumExplorer.this.explorer.getComponents()) {
                    JAlbumObject jao = (JAlbumObject)element;
                    jao.resetRubberbanded();
                }
                JAlbumExplorer.this.handlePasteActionEnabling();
                JAlbumExplorer.this.maybeShowPopup(e, JAlbumExplorer.this.explorerPopup);
            }
        };
        this.explorer.addMouseListener(mouseOnExplorerAdapter);
        MouseMotionAdapter mouseMotionOnExplorerAdapter = new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                JAlbumExplorer.points2rect(JAlbumExplorer.this.startingPoint, e.getPoint(), JAlbumExplorer.this.explorer.rubberband);
                JAlbumExplorer.this.explorer.scrollRectToVisible(new Rectangle(e.getPoint()));
                Component[] comps = JAlbumExplorer.this.explorer.getComponents();
                Rectangle cr = new Rectangle();
                for (Component element : comps) {
                    JAlbumObject jao = (JAlbumObject)element;
                    cr.x = jao.getX();
                    cr.y = jao.getY();
                    cr.width = jao.getWidth();
                    cr.height = jao.getHeight();
                    Rectangle intersection = JAlbumExplorer.this.explorer.rubberband.intersection(cr);
                    jao.setRubberbanded(intersection.width > cr.width / 4 && intersection.height > cr.height / 4);
                }
                JAlbumExplorer.this.explorer.repaint();
            }

            public void mouseMoved(MouseEvent e) {
                JAlbumExplorer.this.glassEditButton.setVisible(false);
            }
        };
        this.explorer.addMouseMotionListener(mouseMotionOnExplorerAdapter);
        this.mouseMotionOnComponentListener = new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
            }

            public void mouseMoved(MouseEvent e) {
                JAlbumObject jao = (JAlbumObject)e.getComponent();
                jao.attachEditButton(JAlbumExplorer.this.glassEditButton);
            }
        };
        this.mouseOnComponentAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                JAlbumObject jao = (JAlbumObject)e.getComponent();
                JAlbumExplorer.this.explorer.selectionModel.wasAlreadySelected = jao.isSelected();
                if (JAlbumExplorer.isPortableControlDown(e) && !e.isPopupTrigger()) {
                    jao.setSelected(!jao.isSelected());
                } else if (e.isShiftDown()) {
                    int clickedIndex = JAlbumExplorer.this.explorer.selectionModel.indexOf(jao);
                    JAlbumExplorer.this.explorer.selectionModel.deselectAll();
                    JAlbumExplorer.this.explorer.selectionModel.selectRange(JAlbumExplorer.this.explorer.selectionModel.lastClickedIndex, clickedIndex);
                } else {
                    if (!jao.isSelected()) {
                        JAlbumExplorer.this.explorer.selectionModel.deselectAll();
                    }
                    jao.setSelected(true);
                }
                JAlbumExplorer.this.explorer.selectionModel.setFocusedObject(jao);
                if (!e.isShiftDown()) {
                    JAlbumExplorer.this.explorer.selectionModel.lastClickedIndex = JAlbumExplorer.this.explorer.selectionModel.indexOf(jao);
                }
                JAlbumExplorer.this.maybeShowPopup(e, JAlbumExplorer.this.componentPopup);
            }

            public void mouseReleased(MouseEvent e) {
                JAlbumObject jao = (JAlbumObject)e.getComponent();
                if (!(JAlbumExplorer.this.maybeShowPopup(e, JAlbumExplorer.this.componentPopup) || JAlbumExplorer.isPortableControlDown(e) || e.isShiftDown())) {
                    Point p = e.getPoint();
                    if (jao.editor.getBounds().contains(p) && JAlbumExplorer.this.explorer.selectionModel.wasAlreadySelected) {
                        jao.setEditing(true);
                    }
                }
            }

            public void mouseClicked(MouseEvent e) {
                JAlbumObject jao = (JAlbumObject)e.getComponent();
                if (e.getClickCount() == 2 && !jao.editor.getBounds().contains(e.getPoint())) {
                    JAlbumExplorer.this.open(jao);
                }
            }

            public void mouseExited(MouseEvent e) {
                JAlbumObject jao = (JAlbumObject)e.getComponent();
                Point p = e.getPoint();
                p.translate(jao.getX(), jao.getY());
                if (!jao.getBounds().contains(p)) {
                    JAlbumExplorer.this.glassEditButton.setVisible(false);
                }
            }
        };
        this.mouseOnTreeAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                JAlbumExplorer.this.explorer.selectionModel.deselectAll();
                TreePath path = JAlbumExplorer.this.tree.getPathForLocation(e.getX(), e.getY());
                if (path != null) {
                    JAlbumExplorer.this.tree.expandPath(path);
                }
                if (e.getButton() != 1) {
                    JAlbumExplorer.this.tree.getSelectionModel().setSelectionPath(path);
                }
                if (e.isPopupTrigger() && JAlbumExplorer.this.tree.getPathForLocation(e.getX(), e.getY()) != null) {
                    JAlbumExplorer.this.treeNodePopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            public void mouseReleased(MouseEvent e) {
                TreePath tp = JAlbumExplorer.this.tree.getClosestPathForLocation(e.getX(), e.getY());
                if (tp != null) {
                    boolean rootSelected = tp.getPathCount() == 1;
                    JAlbumExplorer.this.includeNodeAction.setEnabled(!rootSelected);
                    JAlbumExplorer.this.excludeNodeAction.setEnabled(!rootSelected);
                    JAlbumExplorer.this.propertiesAction.setEnabled(JAlbumExplorer.this.tree.getSelectionCount() < 2);
                    JAlbumExplorer.this.editModeAction.setEnabled(JAlbumExplorer.this.tree.getSelectionCount() < 2);
                    JAlbumExplorer.this.deleteNodeAction.setEnabled(!rootSelected);
                    JAlbumExplorer.this.setExplorerView();
                    if (e.isPopupTrigger() && JAlbumExplorer.this.tree.getPathForLocation(e.getX(), e.getY()) != null) {
                        JAlbumExplorer.this.treeNodePopup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && JAlbumExplorer.this.tree.getPathForLocation(e.getX(), e.getY()) == null) {
                    JAlbumExplorer.this.parent.actions.settingsAction.actionPerformed(null);
                }
            }
        };
        this.componentFocusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                JAlbumObject jao = (JAlbumObject)e.getSource();
                if (jao == JAlbumExplorer.this.explorer.selectionModel.getFocusedObject()) {
                    return;
                }
                JAlbumExplorer.this.explorer.scrollRectToVisible(jao.getBounds());
                JAlbumObject selected = JAlbumExplorer.this.explorer.selectionModel.getSingleSelected();
                if (selected != jao) {
                    MouseEvent me = new MouseEvent(jao, -1, 0L, 0, 0, 0, 1, false);
                    JAlbumExplorer.this.mouseOnComponentAdapter.mousePressed(me);
                    if (JAlbumObject.tabCycling) {
                        jao.setEditing(true);
                        JAlbumObject.tabCycling = false;
                    }
                }
            }

            public void focusLost(FocusEvent e) {
                JAlbumObject jao = (JAlbumObject)e.getSource();
            }
        };
        DefaultTreeCellRenderer folderRenderer = new DefaultTreeCellRenderer(){
            private ImageIcon albumIcon = new ImageIcon(RemoteFSTreeCellRenderer.class.getResource("images/publish/book_blue.png"));
            {
                this.setBackgroundNonSelectionColor(JAlbumColor.albumHighlight);
            }

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JComponent renderer = (JComponent)super.getTreeCellRendererComponent(tree, value, selected, expanded, false, row, hasFocus);
                if (value instanceof FolderTreeNode) {
                    FolderTreeNode node = (FolderTreeNode)value;
                    AlbumObject ao = node.getAlbumObject();
                    if (ao.getName().length() == 0) {
                        return new JLabel();
                    }
                    if (node.isRoot()) {
                        this.setIcon(this.albumIcon);
                    }
                    do {
                        if (ao.isIncluded()) continue;
                        renderer.setForeground(SystemColor.textInactiveText);
                    } while ((ao = ao.getParent()) != null);
                }
                return renderer;
            }
        };
        this.tree.setCellRenderer(folderRenderer);
        AutoSelectingTreeCellEditor editor = new AutoSelectingTreeCellEditor(this.tree, folderRenderer);
        editor.rootEditable = true;
        this.tree.setCellEditor(editor);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                FolderTreeNode node = (FolderTreeNode)e.getPath().getLastPathComponent();
                AlbumObject ao = node.getAlbumObject();
                if (ao != JAlbumExplorer.this.currentFolder) {
                    JAlbumExplorer.this.viewFolder(ao);
                }
            }
        });
        this.tree.addMouseListener(this.mouseOnTreeAdapter);
        RenderThread rt = new RenderThread();
        rt.start();
        this.imageCache = new ImageCache(10, new Dimension(640, 480));
        this.editor.imagePanel.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                JAlbumExplorer.this.imageCache = new ImageCache(10, e.getComponent().getSize());
            }
        });
        this.explorer.selectionModel.addSelectionListener(new SelectionListener(){

            public void selectionChange(ExplorerSelectionModel model) {
                boolean selected = model.getSelectionCount() > 0;
                JAlbumExplorer.this.includeSelectedAction.setEnabled(selected);
                JAlbumExplorer.this.excludeSelectedAction.setEnabled(selected);
                JAlbumExplorer.this.deleteAction.setEnabled(selected);
                JAlbumObject jao = model.getSingleSelected();
                if (jao != null) {
                    JAlbumExplorer.this.updateRotateActions(jao.ao);
                    JAlbumExplorer.this.useAsFolderThumbnailAction.setEnabled(jao.ao.isDisplayableImage() || jao.ao.getRepresentingIconFile() != null);
                    JAlbumExplorer.this.imageFiltersMenu.setEnabled(!jao.ao.isFolder() && jao.ao.isDisplayableImage());
                    JAlbumExplorer.this.saveCopyAsAction.setEnabled(!jao.ao.isFolder() && jao.ao.isDisplayableImage());
                    JAlbumExplorer.this.copyFiltersAction.setEnabled(!jao.ao.isFolder() && jao.ao.isDisplayableImage());
                } else {
                    JAlbumExplorer.this.imageFiltersMenu.setEnabled(selected);
                    JAlbumExplorer.this.rotateLeftAction.setEnabled(selected);
                    JAlbumExplorer.this.rotateRightAction.setEnabled(selected);
                    JAlbumExplorer.this.useAsFolderThumbnailAction.setEnabled(false);
                    JAlbumExplorer.this.saveCopyAsAction.setEnabled(false);
                    JAlbumExplorer.this.copyFiltersAction.setEnabled(false);
                }
                JAlbumExplorer.this.editModeAction.setEnabled(model.getSelectionCount() <= 1);
                JAlbumExplorer.this.propertiesAction.setEnabled(model.getSelectionCount() <= 1);
                JAlbumExplorer.this.updateStatusBar(model);
            }
        });
    }

    void setTopBarActionsEnabled(boolean enabled) {
        this.rotateLeftAction.setEnabled(enabled);
        this.rotateRightAction.setEnabled(enabled);
        this.includeSelectedAction.setEnabled(enabled);
        this.excludeSelectedAction.setEnabled(enabled);
    }

    void updateStatusBar() {
        this.updateStatusBar(this.explorer.selectionModel);
    }

    void updateStatusBar(ExplorerSelectionModel selectionModel) {
        Component[] comps;
        int total = this.explorer.getComponentCount();
        int excluded = 0;
        int visible = 0;
        for (Component element : comps = this.explorer.getComponents()) {
            JAlbumObject jao = (JAlbumObject)element;
            if (!jao.ao.isIncluded()) {
                ++excluded;
            }
            if (!jao.isVisible()) continue;
            ++visible;
        }
        total -= excluded;
        int selected = selectionModel.getSelectedObjects().size();
        if (selected == 0) {
            String s = "" + visible + " " + Msg.get("ui.objects");
            if (excluded > 0) {
                s = s + " (" + excluded + " " + Msg.get("ui.excluded") + ")";
            }
            this.parent.statusBar.setText(s);
        } else {
            this.parent.statusBar.setText("" + selected + " " + Msg.get("ui.objectsSelected"));
        }
        if (visible == 0 && total > 0) {
            this.explorer.setBackgroundText(Msg.get("ui.noMatchingItems"));
        } else {
            this.explorer.setBackgroundText(null);
        }
    }

    private LinkedList<JAlbumObject> getSelectJAlbumObjects() {
        LinkedList<JAlbumObject> list;
        if (this.explorerMode) {
            list = this.explorer.selectionModel.getSelectedObjects();
        } else {
            list = new LinkedList();
            list.add(new JAlbumObject(this.editor.ao, this.explorer));
        }
        return list;
    }

    @Override
    public JPopupMenu getComponentPopupMenu() {
        return this.componentPopup;
    }

    JAlbumObject getJAlbumObject(AlbumObject ao) {
        Component[] comps;
        for (Component element : comps = this.explorer.getComponents()) {
            JAlbumObject jao = (JAlbumObject)element;
            if (!jao.ao.equals(ao)) continue;
            return jao;
        }
        return null;
    }

    void updateOrderingMenus() {
        if (this.currentFolder != null) {
            String ordering = this.currentFolder.getOrdering();
            if (ordering.equals("name")) {
                this.orderByNameAction.setSelected(true);
            } else if (ordering.equals("date")) {
                this.orderByDateAction.setSelected(true);
            } else if (ordering.equals("cameraDate")) {
                this.orderByCameraDateAction.setSelected(true);
            } else if (ordering.equals("rating")) {
                this.orderByRatingAction.setSelected(true);
            } else if (ordering.equals("custom")) {
                this.customOrderingAction.setSelected(true);
            } else if (ordering.equals("jalbum")) {
                this.useJAlbumOrderingAction.setSelected(true);
            }
            this.reverseOrderingAction.setSelected(this.currentFolder.isReverseOrdering());
            this.foldersFirstAction.setSelected(this.currentFolder.isFoldersFirst());
            String folderOrdering = this.currentFolder.getFolderOrdering();
            if (folderOrdering.equals("name")) {
                this.orderFoldersByNameAction.setSelected(true);
            } else if (folderOrdering.equals("date")) {
                this.orderFoldersByDateAction.setSelected(true);
            }
            this.reverseFolderOrderingAction.setSelected(this.currentFolder.isReverseFolderOrdering());
        }
    }

    void handleDisablingOfOrderingMenus() {
        boolean b = !this.customOrderingAction.isSelected() && !this.useJAlbumOrderingAction.isSelected();
        this.reverseOrderingAction.setEnabled(b);
        this.foldersFirstAction.setEnabled(b);
        boolean foldersFirst = this.foldersFirstAction.isSelected();
        this.orderFoldersByNameAction.setEnabled(b && foldersFirst);
        this.orderFoldersByDateAction.setEnabled(b && foldersFirst);
        this.reverseFolderOrderingAction.setEnabled(b && foldersFirst);
    }

    private void setOrdering(String ordering) {
        try {
            this.currentFolder.setOrdering(ordering);
        }
        catch (IOException ex) {
            Debug.showErrorDialog(this, (Throwable)ex);
        }
        this.currentFolder.invalidate();
        this.viewFolder(this.currentFolder);
        this.refreshCurrentNode();
    }

    private void setFolderOrdering(String folderOrdering) {
        try {
            this.currentFolder.setFolderOrdering(folderOrdering);
        }
        catch (IOException ex) {
            Debug.showErrorDialog(this, (Throwable)ex);
        }
        this.currentFolder.invalidate();
        this.viewFolder(this.currentFolder);
        this.refreshCurrentNode();
    }

    public void populateLabelTypeSubMenu(JMenu menu) {
        ButtonGroup bg = new ButtonGroup();
        JRadioButtonMenuItem item = this.fileNameLabelTypeAction.createJRadioButtonMenuItem();
        bg.add(item);
        menu.add(item);
        item = this.captionLabelTypeAction.createJRadioButtonMenuItem();
        bg.add(item);
        menu.add(item);
        if (Config.getConfig().getLabelType() == Config.LabelType.caption) {
            this.captionLabelTypeAction.setSelected(true);
        } else {
            this.fileNameLabelTypeAction.setSelected(true);
        }
    }

    public void populateOrderingSubMenu(JMenu menu) {
        ButtonGroup bg = new ButtonGroup();
        JRadioButtonMenuItem item = this.orderByNameAction.createJRadioButtonMenuItem();
        bg.add(item);
        menu.add(item);
        item = this.orderByDateAction.createJRadioButtonMenuItem();
        bg.add(item);
        menu.add(item);
        item = this.orderByCameraDateAction.createJRadioButtonMenuItem();
        bg.add(item);
        menu.add(item);
        item = this.orderByRatingAction.createJRadioButtonMenuItem();
        bg.add(item);
        menu.add(item);
        item = this.customOrderingAction.createJRadioButtonMenuItem();
        bg.add(item);
        menu.add(item);
        item = this.useJAlbumOrderingAction.createJRadioButtonMenuItem();
        bg.add(item);
        menu.add(item);
        menu.add(this.reverseOrderingAction.createJCheckBoxMenuItem());
        menu.add(this.shuffleAction);
    }

    public void populateFolderOrderingSubMenu(JMenu menu) {
        menu.add(this.foldersFirstAction.createJCheckBoxMenuItem());
        ButtonGroup bg = new ButtonGroup();
        JRadioButtonMenuItem item = this.orderFoldersByNameAction.createJRadioButtonMenuItem();
        bg.add(item);
        menu.add(item);
        item = this.orderFoldersByDateAction.createJRadioButtonMenuItem();
        bg.add(item);
        menu.add(item);
        menu.add(this.reverseFolderOrderingAction.createJCheckBoxMenuItem());
        this.handleDisablingOfOrderingMenus();
    }

    static boolean isPortableControlDown(MouseEvent e) {
        boolean ret = (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0;
        return ret;
    }

    public void setTexts() {
        this.pasteAction.putValue("Name", Msg.get("edit.paste"));
        this.useAsFolderThumbnailAction.putValue("Name", Msg.get("edit.folderThumbnail"));
        this.useAsFolderThumbnailAction.putValue("ShortDescription", Msg.get("edit.folderThumbnailToolTip"));
        this.convertLinkToCopyAction.putValue("Name", Msg.get("edit.convertLinkToCopy"));
        this.renameAction.putValue("Name", Msg.get("edit.renameFile"));
        this.newFolderAction.putValue("Name", Msg.get("edit.newFolder"));
        this.refreshAction.putValue("Name", Msg.get("edit.update"));
        this.openAction.putValue("Name", Msg.get("edit.open"));
        this.repairLinkAction.putValue("Name", Msg.get("edit.repairLink"));
        this.showInFilesystemAction.putValue("Name", Msg.get("edit.showInFilesystem"));
        this.editModeAction.putValue("Name", Msg.get("ui.editMode"));
        this.explorerAction.putValue("Name", Msg.get("ui.explorerMode"));
        this.hideExcludedAction.putValue("Name", Msg.get("edit.hideExcluded"));
        this.largeThumbnailsAction.putValue("Name", Msg.get("edit.largeThumbnails"));
        this.deleteAction.putValue("Name", Msg.get("edit.delete"));
        this.includeSelectedAction.putValue("Name", Msg.get("edit.include"));
        this.excludeSelectedAction.putValue("Name", Msg.get("edit.exclude"));
        this.excludeSelectedAction.putValue("ShortDescription", Msg.get("edit.excludeToolTip"));
        this.includeOriginalAction.putValue("Name", Msg.get("edit.includeOriginal"));
        this.rotateLeftAction.putValue("Name", Msg.get("edit.rotateLeftToolTip"));
        this.rotateLeftAction.putValue("ShortDescription", Msg.get("edit.rotateLeftToolTip"));
        this.rotateRightAction.putValue("Name", Msg.get("edit.rotateRightToolTip"));
        this.rotateRightAction.putValue("ShortDescription", Msg.get("edit.rotateRightToolTip"));
        this.selectAllAction.putValue("Name", Msg.get("edit.selectAll"));
        this.invertSelectionAction.putValue("Name", Msg.get("edit.invertSelection"));
        this.slideShowAction.putValue("Name", Msg.get("edit.runSlideshow"));
        this.orderByNameAction.putValue("Name", Msg.get("ui.nameOrdering"));
        this.orderByDateAction.putValue("Name", Msg.get("ui.dateOrdering"));
        this.orderByCameraDateAction.putValue("Name", Msg.get("edit.cameraDateOrdering"));
        this.orderByRatingAction.putValue("Name", Msg.get("edit.ratingOrdering"));
        this.customOrderingAction.putValue("Name", Msg.get("edit.customOrdering"));
        this.useJAlbumOrderingAction.putValue("Name", Msg.get("edit.jalbumOrdering"));
        this.reverseOrderingAction.putValue("Name", Msg.get("edit.reverseOrdering"));
        this.foldersFirstAction.putValue("Name", Msg.get("edit.foldersFirst"));
        this.orderFoldersByNameAction.putValue("Name", Msg.get("ui.nameOrdering"));
        this.orderFoldersByDateAction.putValue("Name", Msg.get("ui.dateOrdering"));
        this.reverseFolderOrderingAction.putValue("Name", Msg.get("edit.reverseOrdering"));
        this.shuffleAction.putValue("Name", Msg.get("edit.shuffleOrdering"));
        this.includeNodeAction.putValue("Name", Msg.get("edit.include"));
        this.excludeNodeAction.putValue("Name", Msg.get("edit.exclude"));
        this.deleteNodeAction.putValue("Name", Msg.get("edit.delete"));
        this.renameNodeAction.putValue("Name", Msg.get("edit.renameFile"));
        this.orderingSubMenu.setText(Msg.get("edit.orderBy"));
        this.folderOrderingSubMenu.setText(Msg.get("edit.orderFoldersBy"));
        this.saveCopyAsAction.putValue("Name", Msg.get("edit.saveCopyAs"));
    }

    private void adjustOrientation(boolean right) {
        this.imageCache.clear();
        if (this.explorerMode) {
            int errorCounter = 0;
            LinkedList<JAlbumObject> list = this.getSelectJAlbumObjects();
            for (JAlbumObject jao : list) {
                try {
                    if (right) {
                        jao.ao.rotateRight();
                        continue;
                    }
                    jao.ao.rotateLeft();
                }
                catch (IOException ex) {
                    if (++errorCounter != 1) continue;
                    Exception ex2 = new Exception(Msg.get("edit.rotateError"), ex);
                    Debug.showFriendlyErrorDialog(this, ex2);
                }
            }
        } else {
            try {
                if (right) {
                    this.editor.ao.rotateRight();
                } else {
                    this.editor.ao.rotateLeft();
                }
                this.imageCache.clear();
                this.editor.updateImage(false);
            }
            catch (IOException ex) {
                Exception ex2 = new Exception(Msg.get("edit.rotateError"), ex);
                Debug.showFriendlyErrorDialog(this, ex2);
            }
        }
    }

    private void repairAllBrokenLinks(AlbumObject folder, File newParent) throws IOException {
        List<AlbumObject> children = folder.getChildren();
        for (AlbumObject ao : children) {
            LinkFile link;
            File newTarget;
            if (ao.isLink() && !ao.getFile().exists() && (newTarget = new File(newParent, (link = (LinkFile)ao.getFile()).getTargetName())).exists()) {
                ao.repairLink(newTarget);
            }
            if (!ao.isFolder()) continue;
            this.repairAllBrokenLinks(ao, newParent);
        }
    }

    void open(JAlbumObject jao) {
        if (jao == null) {
            return;
        }
        if (!jao.ao.getFile().exists() && jao.ao.getFile() instanceof LinkFile) {
            LinkFile link;
            File closestFile = link = (LinkFile)jao.ao.getFile();
            while (!closestFile.exists() && closestFile.getParentFile() != null) {
                closestFile = closestFile.getParentFile();
            }
            JFileChooser chooser = new JFileChooser(closestFile);
            chooser.setSelectedFile(new File(link.getParentFile(), link.getTargetName()));
            chooser.setDialogTitle(Msg.get("edit.locateTargetFile", link.getTargetName()));
            int returnVal = chooser.showDialog(this, Msg.get("ok"));
            if (returnVal == 0) {
                try {
                    File targetFile = chooser.getSelectedFile();
                    if (targetFile.exists()) {
                        File f;
                        if (targetFile.isDirectory() && (f = new File(targetFile, link.getTargetName())).exists()) {
                            targetFile = f;
                        }
                    } else {
                        File f = new File(chooser.getCurrentDirectory(), link.getTargetName());
                        if (f.exists()) {
                            targetFile = f;
                        }
                    }
                    if (jao.ao.repairLink(targetFile)) {
                        this.repairAllBrokenLinks(this.currentFolder, targetFile.getParentFile());
                    }
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(this, (Throwable)ex);
                }
                this.viewFolder(this.currentFolder);
            }
        } else if (jao.ao.isFolder()) {
            this.selectNode(jao.ao);
        } else if (jao.ao.isDisplayableImage()) {
            this.setEditView(jao.ao);
        } else {
            try {
                BrowserLauncher.openLocal(jao.ao.getFile());
            }
            catch (IOException ex) {
                Debug.showErrorDialog(this, (Throwable)ex);
            }
        }
    }

    void refreshCurrentNode() {
        FolderTreeNode node = (FolderTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            this.selectNode(this.currentFolder);
            node = (FolderTreeNode)this.tree.getLastSelectedPathComponent();
        }
        this.refreshFrom(node);
        TreePath selTP = new TreePath(node.getPath());
        this.tree.setSelectionPath(selTP);
    }

    void refreshFrom(FolderTreeNode node) {
        node.invalidate();
        ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(node);
    }

    public void syncModel() {
        Component[] comps;
        LinkedList<AlbumObject> children = new LinkedList<AlbumObject>();
        for (Component element : comps = this.explorer.getComponents()) {
            JAlbumObject jao = (JAlbumObject)element;
            children.add(jao.ao);
        }
        try {
            if (this.currentFolder != null) {
                this.currentFolder.setChildren(children);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    private void selectNode(AlbumObject current) {
        FolderTreeNode rootNode = (FolderTreeNode)this.tree.getModel().getRoot();
        Enumeration<TreeNode> allChildren = rootNode.breadthFirstEnumeration();
        while (allChildren.hasMoreElements()) {
            FolderTreeNode child = (FolderTreeNode)allChildren.nextElement();
            AlbumObject ao = child.getAlbumObject();
            if (!ao.equals(current)) continue;
            TreeSelectionModel sm = this.tree.getSelectionModel();
            TreePath path = new TreePath(child.getPath());
            sm.setSelectionPath(path);
            this.tree.expandPath(path);
            break;
        }
    }

    public void startSlideshow() {
        LinkedList<AlbumObject> slides = new LinkedList<AlbumObject>();
        LinkedList<JAlbumObject> list = this.explorer.selectionModel.getSelectedObjects();
        AlbumObject start = null;
        if (list.size() <= 1) {
            if (list.size() == 1) {
                start = list.getFirst().ao;
            }
            for (Component c : this.explorer.getComponents()) {
                JAlbumObject jao = (JAlbumObject)c;
                if (!jao.isVisible() || jao.ao.isFolder()) continue;
                slides.addLast(jao.ao);
            }
        } else {
            for (JAlbumObject jao : list) {
                if (!jao.isVisible() || jao.ao.isFolder()) continue;
                slides.addLast(jao.ao);
            }
        }
        SlideShow slideShow = SlideShowFactory.createSlideShow(slides, start);
        slideShow.start();
    }

    public AlbumObject getRootFolder() {
        return this.rootFolder;
    }

    public AlbumObject getCurrentFolder() {
        return this.currentFolder;
    }

    public void setRootFolder(AlbumObject root) {
        if (this.rootFolder != null) {
            this.rootFolder.removePropertyChangeListener(this.rootNameChangeListener);
        }
        this.explorerMode = false;
        this.setExplorerView();
        root.addPropertyChangeListener("name", this.rootNameChangeListener);
        this.parent.settingsWindow.generalSettings.setAlbumObject(root);
        this.rootFolder = root;
        this.knownKeywords.clear();
        this.albumManager.setActiveAlbumProject(new AlbumProject(this.parent.projectChooser.getSelectedFile(), this.rootFolder));
        this.explorer.removeAll();
        FolderTreeNode rootNode = new FolderTreeNode(root);
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.tree.setModel(treeModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setEditable(true);
        treeModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent e) {
                FolderTreeNode node = (FolderTreeNode)JAlbumExplorer.this.tree.getLastSelectedPathComponent();
                String newName = node.getUserObject().toString().trim();
                node.setUserObject(newName);
                AlbumObject ao = node.getAlbumObject();
                if (ao.setName(newName)) {
                    JAlbumExplorer.this.refreshCurrentNode();
                    JAlbumExplorer.this.viewFolder(JAlbumExplorer.this.currentFolder);
                    if (node.isRoot()) {
                        try {
                            JAlbumExplorer.this.parent.renameImageDirectory(newName);
                        }
                        catch (IOException ex) {
                            Debug.showErrorDialog(JAlbumExplorer.this.parent, ex);
                        }
                    }
                }
            }

            public void treeNodesInserted(TreeModelEvent e) {
            }

            public void treeNodesRemoved(TreeModelEvent e) {
            }

            public void treeStructureChanged(TreeModelEvent e) {
            }
        });
    }

    public void setExplorerView() {
        if (this.rootFolder == null || this.rootFolder.getName().length() == 0) {
            this.viewMode.show(this.viewPanel, "welcomePanel");
            return;
        }
        if (this.explorerMode) {
            return;
        }
        this.explorerMode = true;
        this.viewMode.show(this.viewPanel, "explorerPanel");
        JToggleButton tb = (JToggleButton)this.explorerAction.getValue("toggleButton");
        if (tb != null) {
            tb.setSelected(true);
        }
        this.editor.cleanFilterListeners();
        AlbumObject lastEdited = this.editor.getAO();
        this.editor.setAO(null);
        this.updateStatusBar();
        JAlbumObject jao = this.getJAlbumObject(lastEdited);
        if (jao != null) {
            this.explorer.selectionModel.deselectAll();
            jao.setSelected(true);
            this.explorer.selectionModel.setFocusedObject(jao);
        }
        this.parent.setTitle();
    }

    void setEditView(final AlbumObject ao) {
        Tracer.getInstance().trace("open edit view");
        new Thread("Slowtask"){

            public void run() {
                JAlbumExplorer.this.setCursor(Cursor.getPredefinedCursor(3));
                JAlbumExplorer.this.parent.progressSpinner.workStarted();
                JAlbumExplorer.this.explorerMode = false;
                JAlbumExplorer.this.viewMode.show(JAlbumExplorer.this.viewPanel, "editPanel");
                JToggleButton tb = (JToggleButton)JAlbumExplorer.this.editModeAction.getValue("toggleButton");
                if (tb != null) {
                    tb.setSelected(true);
                }
                JAlbumExplorer.this.viewPanel.validate();
                JAlbumExplorer.this.editor.setAO(ao);
                JAlbumExplorer.this.editor.setFiltersViewMode();
                JAlbumExplorer.this.parent.setTitle();
                JAlbumExplorer.this.propertiesAction.setEnabled(false);
                JAlbumExplorer.this.setCursor(Cursor.getDefaultCursor());
                JAlbumExplorer.this.parent.progressSpinner.workDone();
                JAlbumExplorer.this.editor.requestFocusInWindow();
                TipOfTheDay.interruptPendingNotification();
                JNotification n = new JNotification(Msg.get("tip.editMode"));
                if (!n.isShownBefore()) {
                    n.setRememberShown(true);
                    n.setLastShown(System.currentTimeMillis());
                }
            }
        }.start();
    }

    public void selectRootFolderInTreeView() {
        this.selectNode(this.rootFolder);
    }

    private void setRating(int rating) {
        for (JAlbumObject jao : this.explorer.selectionModel.getSelectedObjects()) {
            jao.ao.setRating(rating);
        }
    }

    void applyFilter(JAlbumObject jao) {
        boolean hideExcluded = this.hideExcludedMenuItem.isSelected();
        jao.setVisible(!(hideExcluded && !jao.ao.isIncluded() || this.filterBar.isVisible() && !this.filterBar.accept(jao.ao)));
    }

    void applyFilters() {
        for (Component c : this.explorer.getComponents()) {
            this.applyFilter((JAlbumObject)c);
        }
    }

    public void viewFolder(AlbumObject folder) {
        JAlbumObject jao;
        boolean projectLoaded = folder != null && folder.getName().length() > 0;
        this.newFolderAction.setEnabled(projectLoaded);
        this.editModeAction.setEnabled(projectLoaded);
        this.propertiesAction.setEnabled(projectLoaded);
        this.filterBarAction.setEnabled(projectLoaded);
        this.toggleFilterBarAction.setEnabled(projectLoaded);
        this.photobookAction.setEnabled(projectLoaded);
        if (!projectLoaded) {
            this.viewMode.show(this.viewPanel, "welcomePanel");
            this.explorerMode = false;
            return;
        }
        this.parentFolderAction.setEnabled(folder != null && folder.getParent() != null);
        this.setExplorerView();
        this.explorer.removeAll();
        List<AlbumObject> content = folder.getChildren();
        if (content == null) {
            return;
        }
        boolean hideExcluded = this.hideExcludedMenuItem.isSelected();
        for (AlbumObject ao : content) {
            this.addJAO(hideExcluded, ao);
        }
        this.validate();
        this.repaint();
        AlbumObject previousFolder = this.currentFolder;
        this.currentFolder = folder;
        this.updateOrderingMenus();
        this.handleDisablingOfOrderingMenus();
        this.updateStatusBar();
        this.representingAlbumObjectListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JAlbumExplorer.this.explorer.repaint();
            }
        };
        this.currentFolder.addPropertyChangeListener("representingAlbumObject", this.representingAlbumObjectListener);
        if (this.explorer.getComponentCount() > 0 && (jao = this.getJAlbumObject(previousFolder)) != null && this.currentFolder.equals(previousFolder.getParent())) {
            jao.requestFocusInWindow();
        }
    }

    private JAlbumObject addJAO(AlbumObject ao) {
        boolean hideExcluded = this.hideExcludedMenuItem.isSelected();
        return this.addJAO(hideExcluded, ao);
    }

    private JAlbumObject addJAO(boolean hideExcluded, AlbumObject ao) {
        JAlbumObject jao = new JAlbumObject(ao, this.explorer);
        this.applyFilter(jao);
        this.prepareJAO(jao);
        this.explorer.add(jao);
        return jao;
    }

    void prepareJAO(JAlbumObject jao) {
        jao.addFocusListener(this.componentFocusListener);
        DragSource ds = DragSource.getDefaultDragSource();
        DragGestureRecognizer dgr = ds.createDefaultDragGestureRecognizer(jao, 3, this.explorer);
        jao.addMouseListener(this.mouseOnComponentAdapter);
        jao.addMouseMotionListener(this.mouseMotionOnComponentListener);
        jao.ao.addPropertyChangeListener("name", this);
    }

    void updateRotateActions(AlbumObject ao) {
        this.rotateLeftAction.setEnabled(!ao.isFolder() && ao.isDisplayableImage());
        this.rotateRightAction.setEnabled(!ao.isFolder() && ao.isDisplayableImage());
    }

    private static void points2rect(Point p1, Point p2, Rectangle r) {
        r.x = Math.min(p1.x, p2.x);
        r.y = Math.min(p1.y, p2.y);
        r.width = p2.x - p1.x;
        if (r.width < 0) {
            r.width = -r.width;
        }
        r.height = p2.y - p1.y;
        if (r.height < 0) {
            r.height = -r.height;
        }
    }

    private void handlePasteActionEnabling() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable t = clipboard.getContents(this.explorer);
        this.pasteAction.setEnabled(t.isDataFlavorSupported(DataFlavor.javaFileListFlavor));
    }

    private boolean maybeShowPopup(MouseEvent e, JPopupMenu popup) {
        if (popup == this.componentPopup) {
            JAlbumObject jao = (JAlbumObject)e.getComponent();
            if (!jao.ao.getFile().exists()) {
                popup = this.brokenLinkPopup;
            }
            this.includeOriginalAction.setEnabled(jao.ao.isDisplayableImage());
            Boolean includeOriginals = (Boolean)jao.ao.getProperties().get("includeOriginal");
            this.includeOriginalAction.setSelected(includeOriginals != null && includeOriginals != false);
            this.useAsFolderThumbnailMenuItem.setSelected(false);
            File rep = this.currentFolder.getRepresentingIconFile();
            if (rep != null && rep.equals(jao.ao.getFile())) {
                this.useAsFolderThumbnailMenuItem.setSelected(true);
            }
        }
        if (e.isPopupTrigger()) {
            popup.show(e.getComponent(), e.getX(), e.getY());
            return true;
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("name".equals(evt.getPropertyName())) {
            this.refreshCurrentNode();
        }
    }

    private class RatingAction
    extends AbstractAction {
        private int rating;

        public RatingAction(int rating) {
            this.rating = rating;
        }

        public void actionPerformed(ActionEvent e) {
            JAlbumExplorer.this.setRating(this.rating);
        }
    }

    class RenderThread
    extends Thread {
        private int nErrors;

        public RenderThread() {
            super("JAlbumExplorer.RenderThread");
            this.nErrors = 0;
            this.setDaemon(true);
        }

        public void run() {
            block6: while (true) {
                try {
                    block7: while (true) {
                        Component[] comps = JAlbumExplorer.this.explorer.getComponents();
                        Rectangle view = JAlbumExplorer.this.explorerScrollPane.getViewport().getViewRect();
                        for (int i = 0; i < comps.length; ++i) {
                            JAlbumObject jao = (JAlbumObject)comps[i];
                            if (!(jao != null & !jao.isRenderingDone()) || !view.intersects(jao.getBounds())) continue;
                            jao.renderIcon();
                            continue block7;
                        }
                        comps = null;
                        try {
                            Thread.sleep(200L);
                            continue block6;
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable t) {
                    if (++this.nErrors == 1) {
                        Debug.showErrorDialog(JAlbumExplorer.this, t);
                    }
                    System.err.println("Render thread reported error: " + t);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    continue;
                }
                break;
            }
        }
    }

    public class FolderTreeNode
    extends DefaultMutableTreeNode {
        boolean initialized;
        private final AlbumObject ao;

        public FolderTreeNode(AlbumObject ao) {
            super(ao.getName());
            this.ao = ao;
        }

        public boolean isLeaf() {
            return false;
        }

        public AlbumObject getAlbumObject() {
            return this.ao;
        }

        public int getChildCount() {
            if (!this.initialized) {
                this.initialized = true;
                this.initialize();
            }
            return super.getChildCount();
        }

        public void invalidate() {
            this.removeAllChildren();
            this.initialized = false;
        }

        void initialize() {
            List<AlbumObject> albumObjectChildren = this.ao.getChildren();
            if (albumObjectChildren == null) {
                return;
            }
            for (AlbumObject albumObject : albumObjectChildren) {
                if (!albumObject.isFolder()) continue;
                this.add(new FolderTreeNode(albumObject));
            }
            this.initialized = true;
        }
    }
}

