/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumBorders;
import se.datadosen.util.JComponentHolder;
import se.datadosen.util.Platform;

public class ControlPanel
extends JPanel
implements JComponentHolder {
    private boolean useExtraSpace = true;

    public ControlPanel() {
        super(new RiverLayout());
        this.setBorder(null);
        this.transparentize(this);
    }

    public ControlPanel(String title) {
        this();
        this.setTitle(title);
    }

    public void setTitle(String title) {
        this.setBorder(this.createControlPanelBorder(title));
    }

    private Border createControlPanelBorder(String title) {
        if (title.length() <= 0) {
            return null;
        }
        return JAlbumBorders.createTitledCurveBorder(title, this.useExtraSpace);
    }

    public void setEnabled(boolean enable) {
        Component[] comps;
        super.setEnabled(enable);
        for (Component comp : comps = this.getComponents()) {
            comp.setEnabled(enable);
            if (!(comp instanceof JScrollPane)) continue;
            ((JScrollPane)comp).getViewport().getView().setEnabled(enable);
        }
    }

    public void add(Component c, Object o) {
        this.transparentize(c);
        super.add(c, o);
    }

    public Component add(String s, Component c) {
        this.transparentize(c);
        return super.add(s, c);
    }

    public void add(Component c, Object o, int i) {
        this.transparentize(c);
        super.add(c, o, i);
    }

    public Component add(Component c, int i) {
        this.transparentize(c);
        return super.add(c, i);
    }

    public Component add(Component c) {
        this.transparentize(c);
        return super.add(c);
    }

    public void transparentize(Component c) {
        if (Platform.isMac() && JAlbum.isUsingSystemLAF()) {
            boolean isJComponent = c instanceof JComponent;
            boolean isTextComponent = c instanceof JTextComponent;
            if (isJComponent && !isTextComponent) {
                ((JComponent)c).setOpaque(false);
            }
        }
    }

    public void setUseExtraSpace(boolean extraSpace) {
        this.useExtraSpace = extraSpace;
    }
}

