/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.formats;

import java.util.Hashtable;

public final class Naming {
    static final Object[][] ExifTagNames;
    static final Object[][] CIFFPropsNames;
    public static String[] ExifTagTypes;
    static Hashtable tagnames;
    static Hashtable propnames;

    public static String getCIFFTypeName(int type) {
        switch (type & 0x3800) {
            case 0: {
                return "Byte";
            }
            case 2048: {
                return "ASCII";
            }
            case 4096: {
                return "Word";
            }
            case 6144: {
                return "Double word";
            }
            case 8192: {
                return "Byte2";
            }
            case 10240: {
                return "Heap1";
            }
            case 12288: {
                return "Heap2";
            }
        }
        return "Unknown";
    }

    public static String getTagName(Integer tag) {
        String result = (String)tagnames.get(tag);
        return result != null ? result : "0x" + Integer.toHexString(tag);
    }

    public static String getPropName(Integer tag) {
        String result = (String)propnames.get(tag);
        return result != null ? result : "0x" + Integer.toHexString(tag);
    }

    public static String getTypeName(int type) {
        return ExifTagTypes[type - 1];
    }

    static {
        int i;
        ExifTagNames = new Object[][]{{new Integer(254), "NewSubFileType"}, {new Integer(256), "ImageWidth"}, {new Integer(257), "ImageLength"}, {new Integer(258), "BitsPerSample"}, {new Integer(259), "Compression"}, {new Integer(262), "PhotometricInterpretation"}, {new Integer(266), "FillOrder"}, {new Integer(269), "DocumentName"}, {new Integer(270), "ImageDescription"}, {new Integer(271), "Make"}, {new Integer(272), "Model"}, {new Integer(273), "StripOffsets"}, {new Integer(274), "Orientation"}, {new Integer(277), "SamplesPerPixel"}, {new Integer(278), "RowsPerStrip"}, {new Integer(279), "StripByteCounts"}, {new Integer(282), "XResolution"}, {new Integer(283), "YResolution"}, {new Integer(284), "PlanarConfiguration"}, {new Integer(296), "ResolutionUnit"}, {new Integer(301), "TransferFunction"}, {new Integer(305), "Software"}, {new Integer(306), "DateTime"}, {new Integer(315), "Artist"}, {new Integer(318), "WhitePoint"}, {new Integer(319), "PrimaryChromaticities"}, {new Integer(330), "SubIFDs"}, {new Integer(347), "JPEGTables"}, {new Integer(342), "TransferRange"}, {new Integer(512), "JPEGProc"}, {new Integer(513), "JPEGInterchangeFormat"}, {new Integer(514), "JPEGInterchangeFormatLength"}, {new Integer(529), "YCbCrCoefficients"}, {new Integer(530), "YCbCrSubSampling"}, {new Integer(531), "YCbCrPositioning"}, {new Integer(532), "ReferenceBlackWhite"}, {new Integer(33421), "CFARepeatPatternDim"}, {new Integer(33422), "CFAPattern"}, {new Integer(33423), "BatteryLevel"}, {new Integer(33432), "Copyright"}, {new Integer(33434), "ExposureTime"}, {new Integer(33437), "FNumber"}, {new Integer(33723), "IPTC/NAA"}, {new Integer(34665), "ExifOffset"}, {new Integer(34675), "InterColorProfile"}, {new Integer(34850), "ExposureProgram"}, {new Integer(34852), "SpectralSensitivity"}, {new Integer(34853), "GPSInfo"}, {new Integer(34855), "ISOSpeedRatings"}, {new Integer(34856), "OECF"}, {new Integer(36864), "ExifVersion"}, {new Integer(36867), "DateTimeOriginal"}, {new Integer(36868), "DateTimeDigitized"}, {new Integer(37121), "ComponentsConfiguration"}, {new Integer(37122), "CompressedBitsPerPixel"}, {new Integer(37377), "ShutterSpeedValue"}, {new Integer(37378), "ApertureValue"}, {new Integer(37379), "BrightnessValue"}, {new Integer(37380), "ExposureBiasValue"}, {new Integer(37381), "MaxApertureValue"}, {new Integer(37382), "SubjectDistance"}, {new Integer(37383), "MeteringMode"}, {new Integer(37384), "LightSource"}, {new Integer(37385), "Flash"}, {new Integer(37386), "FocalLength"}, {new Integer(37500), "MakerNote"}, {new Integer(37510), "UserComment"}, {new Integer(37520), "SubSecTime"}, {new Integer(37521), "SubSecTimeOriginal"}, {new Integer(37522), "SubSecTimeDigitized"}, {new Integer(40960), "FlashPixVersion"}, {new Integer(40961), "ColorSpace"}, {new Integer(40962), "ExifImageWidth"}, {new Integer(40963), "ExifImageLength"}, {new Integer(40965), "InteroperabilityOffset"}, {new Integer(41483), "FlashEnergy"}, {new Integer(41484), "SpatialFrequencyResponse"}, {new Integer(41486), "FocalPlaneXResolution"}, {new Integer(41487), "FocalPlaneYResolution"}, {new Integer(41488), "FocalPlaneResolutionUnit"}, {new Integer(41492), "SubjectLocation"}, {new Integer(41493), "ExposureIndex"}, {new Integer(41495), "SensingMethod"}, {new Integer(41728), "FileSource"}, {new Integer(41729), "SceneType"}};
        CIFFPropsNames = new Object[][]{{new Integer(2053), "Description"}, {new Integer(2058), "ModelName"}, {new Integer(2059), "FirmwareVersion"}, {new Integer(2060), "ComponentVesrion"}, {new Integer(2061), "ROMOperationMode"}, {new Integer(2064), "OwnerName"}, {new Integer(2070), "ImageFilename"}, {new Integer(2071), "ThumbnailFilename"}, {new Integer(4106), "TargetImageType"}, {new Integer(4112), "ReleaseMethod"}, {new Integer(4113), "ReleaseTiming"}, {new Integer(4118), "ReleaseSetting"}, {new Integer(4124), "BodySensitivity"}, {new Integer(6147), "ImageFormat"}, {new Integer(6148), "RecordId"}, {new Integer(6150), "SelfTimerTime"}, {new Integer(6151), "TargetDistanceSetting"}, {new Integer(6155), "BodyId"}, {new Integer(6158), "CaptureTime"}, {new Integer(6160), "ImageSpec"}, {new Integer(6163), "EF"}, {new Integer(6164), "EV"}, {new Integer(6167), "SerialNumber"}, {new Integer(6168), "Exposure"}, {new Integer(10247), "CameraObject"}, {new Integer(12290), "ShootingRecord"}, {new Integer(12291), "MeasuredInfo"}, {new Integer(12292), "CameraSpecification"}};
        ExifTagTypes = new String[]{"B", "A", "S", "L", "R", "SB", "U", "SS", "SL", "SR"};
        tagnames = new Hashtable(ExifTagNames.length);
        for (i = 0; i < ExifTagNames.length; ++i) {
            tagnames.put(ExifTagNames[i][0], ExifTagNames[i][1]);
        }
        propnames = new Hashtable(CIFFPropsNames.length);
        for (i = 0; i < CIFFPropsNames.length; ++i) {
            propnames.put(CIFFPropsNames[i][0], CIFFPropsNames[i][1]);
        }
    }
}

