/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.slideshow;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;
import net.jalbum.slideshow.SlideShow;
import se.datadosen.explorer.ImageCache;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Flag;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumContext;

class BasicSlideShow
extends JFrame
implements SlideShow {
    BorderLayout borderLayout1 = new BorderLayout();
    List<AlbumObject> albumObjects;
    int currentIndex;
    Image previousImage;
    Image currentImage;
    Image nextImage;
    JLabel imageLabel = new JLabel();
    JPanel statusPanel = new JPanel(new FlowLayout(3));
    JLabel[] stars = new JLabel[5];
    JLabel flagLabel = new JLabel();
    Dimension screenSize = this.getGraphicsConfiguration().getBounds().getSize();
    ImageCache slideCache = new ImageCache(4, this.screenSize);
    private Player player;

    BasicSlideShow(List albumObjects, AlbumObject start) {
        super(JAlbumContext.getInstance().getFrame().getGraphicsConfiguration());
        try {
            this.albumObjects = albumObjects;
            this.jbInit();
            this.getGraphicsConfiguration().getDevice().setFullScreenWindow(this);
            for (int i = 0; i < albumObjects.size(); ++i) {
                AlbumObject ao = (AlbumObject)albumObjects.get(i);
                if (ao != start) continue;
                this.currentIndex = i;
                this.showImage(i);
                return;
            }
            this.showImage(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void showImage(int index) {
        try {
            if (this.player != null) {
                this.player.reset();
            }
            AlbumObject ao = this.albumObjects.get(index);
            ImageIcon icon = new ImageIcon(this.slideCache.getImage(ao));
            this.currentImage = icon.getImage();
            this.imageLabel.setIcon(icon);
            this.showRating(ao.getRating());
            this.showFlag(ao.getFlag());
            if (index < this.albumObjects.size() - 1) {
                this.slideCache.preload(this.albumObjects.get(index + 1));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    void forward() {
        if (this.currentIndex < this.albumObjects.size() - 1) {
            this.showImage(++this.currentIndex);
        } else {
            if (this.imageLabel.getIcon() == null) {
                this.quit();
            }
            this.imageLabel.setIcon(null);
            this.showRating(0);
            this.showFlag(Flag.NoFlag);
        }
    }

    void backward() {
        if (this.currentIndex > 0) {
            this.showImage(--this.currentIndex);
        }
    }

    void first() {
        this.currentIndex = 0;
        this.showImage(this.currentIndex);
    }

    void last() {
        this.currentIndex = this.albumObjects.size() - 1;
        this.showImage(this.currentIndex);
    }

    private void quit() {
        if (this.player != null) {
            this.player.interrupt();
            this.player = null;
        }
        this.getGraphicsConfiguration().getDevice().setFullScreenWindow(null);
        this.setVisible(false);
        this.slideCache.dispose();
        this.dispose();
    }

    private void togglePlay() {
        if (this.player != null) {
            this.player.interrupt();
            this.player = null;
        } else {
            this.player = new Player();
            this.player.start();
        }
    }

    void jbInit() throws Exception {
        this.setUndecorated(true);
        Container c = this.getContentPane();
        c.setBackground(Color.black);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 27: {
                        BasicSlideShow.this.quit();
                        break;
                    }
                    case 10: 
                    case 34: 
                    case 39: 
                    case 40: {
                        BasicSlideShow.this.forward();
                        break;
                    }
                    case 8: 
                    case 33: 
                    case 37: 
                    case 38: {
                        BasicSlideShow.this.backward();
                        break;
                    }
                    case 36: {
                        BasicSlideShow.this.first();
                        break;
                    }
                    case 35: {
                        BasicSlideShow.this.last();
                        break;
                    }
                    case 32: {
                        BasicSlideShow.this.togglePlay();
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: {
                        BasicSlideShow.this.setRating(e.getKeyChar() - 48);
                        break;
                    }
                    case 54: 
                    case 102: {
                        BasicSlideShow.this.setFlag(Flag.Select);
                        break;
                    }
                    case 55: 
                    case 103: {
                        BasicSlideShow.this.setFlag(Flag.Second);
                        break;
                    }
                    case 56: 
                    case 104: {
                        BasicSlideShow.this.setFlag(Flag.Review);
                        break;
                    }
                    case 57: 
                    case 105: {
                        BasicSlideShow.this.setFlag(Flag.Approved);
                        break;
                    }
                    case 72: {
                        BasicSlideShow.this.statusPanel.setVisible(!BasicSlideShow.this.statusPanel.isVisible());
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    BasicSlideShow.this.forward();
                } else if (e.getButton() == 3) {
                    BasicSlideShow.this.backward();
                }
            }
        });
        this.imageLabel.setAlignmentX(0.5f);
        this.imageLabel.setAlignmentY(0.5f);
        OverlayLayout ol = new OverlayLayout(c);
        c.setLayout(ol);
        this.statusPanel.setOpaque(false);
        for (int i = 0; i < this.stars.length; ++i) {
            this.stars[i] = new JLabel(Icons.getIcon("big.star"));
            this.statusPanel.add(this.stars[i]);
            this.stars[i].setVisible(false);
        }
        this.statusPanel.add(this.flagLabel);
        c.add(this.statusPanel);
        c.add(this.imageLabel);
        this.setSize(this.screenSize);
    }

    private void setRating(int rating) {
        AlbumObject ao = this.albumObjects.get(this.currentIndex);
        ao.setRating(rating);
        this.showRating(rating);
    }

    private void setFlag(Flag flag) {
        AlbumObject ao = this.albumObjects.get(this.currentIndex);
        ao.setFlag(flag);
        this.showFlag(flag);
    }

    private void showRating(int rating) {
        int i;
        for (i = 0; i < rating; ++i) {
            this.stars[i].setVisible(true);
        }
        for (i = rating; i < this.stars.length; ++i) {
            this.stars[i].setVisible(false);
        }
    }

    private void showFlag(Flag flag) {
        if (flag == Flag.NoFlag) {
            this.flagLabel.setVisible(false);
        } else {
            this.flagLabel.setIcon(flag.getIcon(48, false));
            this.flagLabel.setToolTipText(flag.toString());
            this.flagLabel.setVisible(true);
        }
    }

    public void start() {
        this.setVisible(true);
    }

    class Player
    extends Thread {
        private boolean resetFlag;

        public Player() {
            super("player");
            this.resetFlag = false;
            this.setDaemon(true);
        }

        public void reset() {
            this.resetFlag = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Player player = this;
            synchronized (player) {
                while (true) {
                    try {
                        while (true) {
                            this.wait(5000L);
                            if (BasicSlideShow.this.currentIndex >= BasicSlideShow.this.albumObjects.size() - 1) break;
                            BasicSlideShow.this.showImage(++BasicSlideShow.this.currentIndex);
                        }
                        BasicSlideShow.this.player = null;
                    }
                    catch (InterruptedException ex) {
                        if (!this.resetFlag) break;
                        this.resetFlag = false;
                        continue;
                    }
                    break;
                }
            }
            System.out.println("Player quitting");
        }
    }
}

