/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filterManager;

import java.awt.Cursor;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import net.jalbum.filterManager.FilterList;
import net.jalbum.filterManager.FilterManagerFriend;
import net.jalbum.filterManager.FilterManagerInterface;
import net.jalbum.filterManager.FilterManagerUI;
import net.jalbum.filterManager.FilterRenderer;
import net.jalbum.filterManager.JAlbumImageFilter;

public class FilterManager
extends FilterRenderer
implements FilterManagerInterface {
    FilterManagerFriend friend;
    FilterManagerUI filterManagerUI;
    JAlbumImageFilter newFilter;

    public FilterManager(FilterManagerFriend friend) {
        this.friend = friend;
        if (friend != null) {
            this.filterManagerUI = new FilterManagerUI(this);
        }
    }

    public BufferedImage setImage(BufferedImage bi, FilterList filterList) {
        if (filterList == null) {
            this.filterList = new FilterList();
            this.filterList.setVersionNumber(1);
        } else {
            this.filterList = filterList;
        }
        this.bi = this.cloneBufferedImage(bi);
        this.biOut = this.renderImage(this.bi, true);
        return this.biOut;
    }

    public void addFilter(JAlbumImageFilter filter) {
        BufferedImage filterInputImage;
        if (!filter.isPrescale() && !filter.isPostscale()) {
            return;
        }
        this.newFilter = filter;
        this.newFilter.init();
        this.newFilter.setFilterManager(this);
        if (this.newFilter.isPrescale() && this.filterListHasPostscaleFilters()) {
            filterInputImage = this.prescaleCache;
            this.filterManagerUI.indicatePreview(true);
        } else {
            filterInputImage = this.biOut;
            this.filterManagerUI.indicatePreview(false);
        }
        this.filterManagerUI.loadFilterInfoPanel(this.newFilter);
        this.newFilter.setPreviewImage(filterInputImage);
    }

    public void setGUIImage(BufferedImage bi) {
        this.friend.setImage(bi);
    }

    public BufferedImage renderImage(BufferedImage bi) {
        return this.renderImage(bi, false);
    }

    public BufferedImage renderImage(BufferedImage bi, boolean scaleImage) {
        BufferedImage biOutClone = this.applyPrescaleFilters(bi);
        if (scaleImage) {
            biOutClone = this.scaleImage(biOutClone);
        }
        biOutClone = this.applyPostscaleFilters(biOutClone);
        return biOutClone;
    }

    protected BufferedImage scaleImage(BufferedImage bi) {
        BufferedImage out = this.friend.scaleImage(bi);
        this.postscaleCache = this.cloneBufferedImage(out);
        return out;
    }

    public boolean isUndoPossible() {
        return this.filterList.getPosition() > 0;
    }

    public BufferedImage undo() {
        if (this.filterList.getPosition() > 0) {
            this.filterList.setPosition(this.filterList.getPosition() - 1);
            JAlbumImageFilter undoneFilter = this.filterList.getFilters().get(this.filterList.getPosition());
            if (undoneFilter.isPrescale()) {
                this.biOut = this.applyPrescaleFilters(this.bi);
                this.biOut = this.scaleImage(this.biOut);
                this.biOut = this.applyPostscaleFilters(this.biOut);
            } else if (undoneFilter.isPostscale() && !undoneFilter.isPrescale()) {
                this.biOut = this.applyPostscaleFilters(this.postscaleCache);
            }
        }
        return this.biOut;
    }

    public boolean isRedoPossible() {
        return this.filterList.getFilters().size() > this.filterList.getPosition();
    }

    public BufferedImage redo() {
        if (this.filterList.getFilters().size() > this.filterList.getPosition()) {
            this.filterList.setPosition(this.filterList.getPosition() + 1);
            JAlbumImageFilter redoneFilter = this.filterList.getFilters().get(this.filterList.getPosition() - 1);
            if (redoneFilter.isPrescale()) {
                this.biOut = redoneFilter.renderImage(this.cloneBufferedImage(this.prescaleCache));
                this.prescaleCache = this.cloneBufferedImage(this.biOut);
                this.biOut = this.scaleImage(this.biOut);
                this.biOut = this.applyPostscaleFilters(this.biOut);
            } else if (redoneFilter.isPostscale() && !redoneFilter.isPrescale()) {
                this.biOut = redoneFilter.renderImage(this.cloneBufferedImage(this.postscaleCache));
            }
        }
        return this.biOut;
    }

    protected BufferedImage renderPreview() {
        BufferedImage previewImage = this.cloneBufferedImage(this.bi);
        if (this.newFilter.isPrescale()) {
            previewImage = this.newFilter.renderImage(this.cloneBufferedImage(this.prescaleCache));
            previewImage = this.friend.scaleImage(previewImage);
            previewImage = this.applyPostscaleFilters(previewImage);
        } else {
            previewImage = this.newFilter.isPostscale() && !this.newFilter.isPrescale() ? this.newFilter.renderImage(this.cloneBufferedImage(this.biOut)) : this.biOut;
        }
        return previewImage;
    }

    public JPanel getFilterControls() {
        return this.newFilter.getControls();
    }

    public JPanel getFilterManagerControls() {
        return this.filterManagerUI;
    }

    public void setCursor(Cursor cursor) {
        this.friend.getImageComponent().setCursor(cursor);
    }

    public Cursor getCursor() {
        return this.friend.getImageComponent().getCursor();
    }

    protected void applyFilter() {
        if (this.filterList.getFilters().size() > this.filterList.getPosition()) {
            int listSize = this.filterList.getFilters().size();
            for (int i = this.filterList.getPosition(); i < listSize; ++i) {
                this.filterList.getFilters().remove(this.filterList.getPosition());
            }
        }
        this.filterList.getFilters().add(this.newFilter);
        this.filterList.setPosition(this.filterList.getPosition() + 1);
        if (this.newFilter.isPrescale()) {
            this.biOut = this.newFilter.renderImage(this.cloneBufferedImage(this.prescaleCache));
            this.prescaleCache = this.cloneBufferedImage(this.biOut);
            this.biOut = this.scaleImage(this.biOut);
            this.biOut = this.applyPostscaleFilters(this.biOut);
        } else if (this.newFilter.isPostscale() && !this.newFilter.isPrescale()) {
            this.biOut = this.newFilter.renderImage(this.cloneBufferedImage(this.biOut));
        }
        this.friend.filterMenuClosed(this.biOut, true);
    }

    public void cancel() {
        this.friend.filterMenuClosed(this.biOut, false);
    }

    public JAlbumImageFilter getNewFilter() {
        return this.newFilter;
    }
}

