// Adapted LM classes: extension of interp classes

#ifndef MF_MDIADAPTLM_H
#define MF_MDIADAPTLM_H

class mdiadaptlm:public interplm{

  int adaptlev;
  interplm* forelm;
  double zeta0;
  double oovscaling;

 public:

  mdiadaptlm(char* ngtfile,int depth=0,TABLETYPE tt=FULL);

  normcache *cache;
  
  double gis_step;

  double zeta(ngram ng,int size);
  
  int discount(ngram ng,int size,double& fstar,double& lambda,int cv=0);

  int bodiscount(ngram ng,int size,double& fstar,double& lambda,double& bo);

  int compute_backoff();

  double backunig(ngram ng);

  double foreunig(ngram ng);
  
  int adapt(char* ngtfile,int alev=1,double gis_step=0.4);
  
  int scalefact(char* ngtfile);
  
  double scalefact(ngram ng);
  
  double prob(ngram ng,int size);

  double prob2(ngram ng,int size,double & fstar);
  
  double txclprob(ngram ng,int size);

  int saveASR(char *filename,int backoff,char* subdictfile=NULL);
  int saveMT(char *filename,int backoff,char* subdictfile=NULL,int resolution=10000000,double decay=0.999900);
  int saveARPA(char *filename,int backoff=0,char* subdictfile=NULL);
  
  int netsize();

  ~mdiadaptlm(){delete cache;};

  double myround(double x){
    long int i=(long int)x;
    return (x-i)>0.500?i+1.0:(double)i;
  }
  
};



#endif






