/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PageResources;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfContents;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.SimpleBookmark;
import com.lowagie.text.pdf.StampContent;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

class PdfStamperImp
extends PdfWriter {
    RandomAccessFileOrArray file;
    PdfReader reader;
    IntHashtable myXref = new IntHashtable();
    HashMap pagesToContent = new HashMap();
    boolean closed = false;
    private boolean rotateContents = true;
    protected AcroFields acroFields;
    protected boolean flat = false;
    protected int[] namePtr = new int[]{0};
    protected boolean namedAsNames;
    protected List newBookmarks;
    protected HashSet partialFlattening = new HashSet();

    PdfStamperImp(PdfReader pdfReader, OutputStream outputStream, char c) throws DocumentException, IOException {
        super(new PdfDocument(), outputStream);
        if (pdfReader.isTampered()) {
            throw new DocumentException("The original document was reused. Read it again from file.");
        }
        pdfReader.setTampered(true);
        this.reader = pdfReader;
        this.file = pdfReader.getSafeFile();
        if (c == '\u0000') {
            super.setPdfVersion(pdfReader.getPdfVersion());
        } else {
            super.setPdfVersion(c);
        }
        super.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(HashMap hashMap) throws DocumentException, IOException {
        PdfObject pdfObject;
        Object object;
        Object object2;
        Object object3;
        if (this.closed) {
            return;
        }
        if (this.flat) {
            this.flatFields();
        }
        this.closed = true;
        this.addSharedObjectsToBody();
        this.setOutlines();
        PRIndirectReference pRIndirectReference = null;
        try {
            this.file.reOpen();
            this.alterContents();
            object3 = this.reader.xrefObj;
            boolean bl = true;
            pRIndirectReference = (PRIndirectReference)this.reader.trailer.get(PdfName.INFO);
            int n = -1;
            if (pRIndirectReference != null) {
                n = pRIndirectReference.getNumber();
            }
            for (int i = 1; i < ((PdfObject[])object3).length; ++i) {
                if (object3[i] == null || n == i) continue;
                this.addToBody(object3[i], this.getNewObjectNumber(this.reader, i, 0));
            }
        }
        finally {
            try {
                this.file.close();
            }
            catch (Exception exception) {}
        }
        object3 = null;
        PdfObject pdfObject2 = null;
        if (this.crypto != null) {
            PdfIndirectObject pdfIndirectObject = this.body.add(this.crypto.getEncryptionDictionary());
            object3 = pdfIndirectObject.getIndirectReference();
            pdfObject2 = this.crypto.getFileID();
        }
        PRIndirectReference pRIndirectReference2 = (PRIndirectReference)this.reader.trailer.get(PdfName.ROOT);
        PdfIndirectReference pdfIndirectReference = new PdfIndirectReference(0, this.getNewObjectNumber(this.reader, pRIndirectReference2.getNumber(), 0));
        PdfIndirectReference pdfIndirectReference2 = null;
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        if (pdfDictionary != null) {
            object2 = pdfDictionary.getKeys().iterator();
            while (object2.hasNext()) {
                object = (PdfName)object2.next();
                pdfObject = PdfReader.getPdfObject(pdfDictionary.get((PdfName)object));
                pdfDictionary2.put((PdfName)object, pdfObject);
            }
        }
        if (hashMap != null) {
            object2 = hashMap.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                pdfObject = new PdfName((String)object);
                String string = (String)hashMap.get(object);
                if (string == null) {
                    pdfDictionary2.remove((PdfName)pdfObject);
                    continue;
                }
                pdfDictionary2.put((PdfName)pdfObject, new PdfString(string, "UnicodeBig"));
            }
        }
        if (!pdfDictionary2.getKeys().isEmpty()) {
            pdfIndirectReference2 = this.addToBody(pdfDictionary2).getIndirectReference();
        }
        this.body.writeCrossReferenceTable(this.os);
        object2 = new PdfWriter.PdfTrailer(this.body.size(), this.body.offset(), pdfIndirectReference, pdfIndirectReference2, (PdfIndirectReference)object3, pdfObject2);
        ((PdfWriter.PdfTrailer)object2).toPdf(this, this.os);
        this.os.flush();
        if (this.isCloseStream()) {
            this.os.close();
        }
    }

    void applyRotation(int n, ByteBuffer byteBuffer) {
        if (!this.rotateContents) {
            return;
        }
        Rectangle rectangle = this.reader.getPageSizeWithRotation(n);
        int n2 = rectangle.getRotation();
        switch (n2) {
            case 90: {
                byteBuffer.append(PdfContents.ROTATE90);
                byteBuffer.append(rectangle.top());
                byteBuffer.append(' ').append('0').append(PdfContents.ROTATEFINAL);
                break;
            }
            case 180: {
                byteBuffer.append(PdfContents.ROTATE180);
                byteBuffer.append(rectangle.right());
                byteBuffer.append(' ');
                byteBuffer.append(rectangle.top());
                byteBuffer.append(PdfContents.ROTATEFINAL);
                break;
            }
            case 270: {
                byteBuffer.append(PdfContents.ROTATE270);
                byteBuffer.append('0').append(' ');
                byteBuffer.append(rectangle.right());
                byteBuffer.append(PdfContents.ROTATEFINAL);
            }
        }
    }

    void alterContents() throws IOException {
        Iterator iterator = this.pagesToContent.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            PageStamp pageStamp = (PageStamp)this.pagesToContent.get(n);
            ByteBuffer byteBuffer = new ByteBuffer();
            if (pageStamp.under != null) {
                byteBuffer.append(PdfContents.SAVESTATE);
                this.applyRotation(n, byteBuffer);
                byteBuffer.append(pageStamp.under.getInternalBuffer());
                byteBuffer.append(PdfContents.RESTORESTATE);
            }
            if (pageStamp.over != null) {
                byteBuffer.append(PdfContents.SAVESTATE);
            }
            byteBuffer.append(this.reader.getPageContent(n, this.file));
            if (pageStamp.over != null) {
                byteBuffer.append(' ');
                byteBuffer.append(PdfContents.RESTORESTATE);
                byteBuffer.append(PdfContents.SAVESTATE);
                this.applyRotation(n, byteBuffer);
                byteBuffer.append(pageStamp.over.getInternalBuffer());
                byteBuffer.append(PdfContents.RESTORESTATE);
            }
            this.reader.setPageContent(n, byteBuffer.toByteArray());
            this.alterResources(pageStamp);
        }
    }

    void alterResources(PageStamp pageStamp) {
        PdfDictionary pdfDictionary = this.reader.getPageN(pageStamp.pageNumber);
        pdfDictionary.put(PdfName.RESOURCES, pageStamp.pageResources.getResources());
    }

    protected int getNewObjectNumber(PdfReader pdfReader, int n, int n2) {
        if (this.currentPdfReaderInstance == null) {
            int n3 = this.myXref.get(n);
            if (n3 == 0) {
                n3 = this.getIndirectReferenceNumber();
                this.myXref.put(n, n3);
            }
            return n3;
        }
        return this.currentPdfReaderInstance.getNewObjectNumber(n, n2);
    }

    RandomAccessFileOrArray getReaderFile(PdfReader pdfReader) {
        if (this.currentPdfReaderInstance == null) {
            return this.file;
        }
        return this.currentPdfReaderInstance.getReaderFile();
    }

    PageStamp getPageStamp(int n) {
        Integer n2 = new Integer(n);
        PageStamp pageStamp = (PageStamp)this.pagesToContent.get(n2);
        if (pageStamp == null) {
            pageStamp = new PageStamp(this, this.reader, n);
            this.pagesToContent.put(n2, pageStamp);
        }
        return pageStamp;
    }

    PdfContentByte getUnderContent(int n) {
        if (n < 1 || n > this.reader.getNumberOfPages()) {
            return null;
        }
        PageStamp pageStamp = this.getPageStamp(n);
        if (pageStamp.under == null) {
            pageStamp.under = new StampContent(this, n);
        }
        return pageStamp.under;
    }

    PdfContentByte getOverContent(int n) {
        if (n < 1 || n > this.reader.getNumberOfPages()) {
            return null;
        }
        PageStamp pageStamp = this.getPageStamp(n);
        if (pageStamp.over == null) {
            pageStamp.over = new StampContent(this, n);
        }
        return pageStamp.over;
    }

    boolean isRotateContents() {
        return this.rotateContents;
    }

    void setRotateContents(boolean bl) {
        this.rotateContents = bl;
    }

    boolean isContentWritten() {
        return this.body.size() > 1;
    }

    AcroFields getAcroFields() {
        if (this.acroFields == null) {
            this.acroFields = new AcroFields(this.reader, this);
        }
        return this.acroFields;
    }

    void setFormFlattening(boolean bl) {
        this.flat = bl;
    }

    boolean partialFormFlattening(String string) {
        this.getAcroFields();
        if (!this.acroFields.getFields().containsKey(string)) {
            return false;
        }
        this.partialFlattening.add(string);
        return true;
    }

    void flatFields() {
        PdfObject pdfObject;
        Object object;
        Object object2;
        Object object3;
        this.getAcroFields();
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM));
        ArrayList arrayList = null;
        if (pdfDictionary != null && (object3 = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.FIELDS))) != null) {
            arrayList = ((PdfArray)object3).getArrayList();
        }
        object3 = this.acroFields.getFields();
        Iterator iterator = ((HashMap)object3).keySet().iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            if (!this.partialFlattening.isEmpty() && !this.partialFlattening.contains(object2)) continue;
            object = (AcroFields.Item)((HashMap)object3).get(object2);
            for (int i = 0; i < ((AcroFields.Item)object).merged.size(); ++i) {
                PdfDictionary pdfDictionary2;
                PdfArray pdfArray;
                PdfIndirectReference pdfIndirectReference;
                Object object4;
                PdfDictionary pdfDictionary3;
                PdfDictionary pdfDictionary4 = (PdfDictionary)((AcroFields.Item)object).merged.get(i);
                pdfObject = (PdfNumber)PdfReader.getPdfObject(pdfDictionary4.get(PdfName.F));
                int n = 0;
                if (pdfObject != null) {
                    n = ((PdfNumber)pdfObject).intValue();
                }
                if ((n & 4) == 0 || (n & 2) != 0 || (pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary4.get(PdfName.AP))) == null) continue;
                PdfObject pdfObject2 = pdfDictionary3.get(PdfName.N);
                PdfAppearance pdfAppearance = null;
                PdfObject pdfObject3 = PdfReader.getPdfObject(pdfObject2);
                if (pdfObject2 instanceof PdfIndirectReference && !pdfObject2.isIndirect()) {
                    pdfAppearance = new PdfAppearance((PdfIndirectReference)pdfObject2);
                } else if (pdfObject3 instanceof PdfStream) {
                    ((PdfDictionary)pdfObject3).put(PdfName.SUBTYPE, PdfName.FORM);
                    pdfAppearance = new PdfAppearance((PdfIndirectReference)pdfObject2);
                } else if (pdfObject3.isDictionary() && (object4 = (PdfName)PdfReader.getPdfObject(pdfDictionary4.get(PdfName.AS))) != null && (pdfIndirectReference = (PdfIndirectReference)((PdfDictionary)pdfObject3).get((PdfName)object4)) != null) {
                    pdfAppearance = new PdfAppearance(pdfIndirectReference);
                    if (pdfIndirectReference.isIndirect()) {
                        pdfObject3 = PdfReader.getPdfObject(pdfIndirectReference);
                        ((PdfDictionary)pdfObject3).put(PdfName.SUBTYPE, PdfName.FORM);
                    }
                }
                if (pdfAppearance == null) continue;
                object4 = PdfReader.getNormalizedRectangle((PdfArray)PdfReader.getPdfObject(pdfDictionary4.get(PdfName.RECT)));
                int n2 = (Integer)((AcroFields.Item)object).page.get(i);
                PdfContentByte pdfContentByte = this.getOverContent(n2);
                pdfContentByte.setLiteral("Q ");
                pdfContentByte.addTemplate(pdfAppearance, ((Rectangle)object4).left(), ((Rectangle)object4).bottom());
                pdfContentByte.setLiteral("q ");
                if (this.partialFlattening.isEmpty() || (pdfArray = (PdfArray)PdfReader.getPdfObject((pdfDictionary2 = this.reader.getPageN(n2)).get(PdfName.ANNOTS))) == null) continue;
                ArrayList arrayList2 = pdfArray.getArrayList();
                block2: for (int j = 0; j < arrayList2.size(); ++j) {
                    PdfObject pdfObject4;
                    PdfObject pdfObject5 = (PdfObject)arrayList2.get(j);
                    if (!pdfObject5.isIndirect() || !(pdfObject4 = (PdfObject)((AcroFields.Item)object).widget_refs.get(i)).isIndirect() || ((PRIndirectReference)pdfObject5).getNumber() != ((PRIndirectReference)pdfObject4).getNumber()) continue;
                    arrayList2.remove(j--);
                    PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject4;
                    while (true) {
                        PdfObject pdfObject6;
                        PdfDictionary pdfDictionary5 = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
                        PRIndirectReference pRIndirectReference2 = (PRIndirectReference)pdfDictionary5.get(PdfName.PARENT);
                        PdfReader.killIndirect(pRIndirectReference);
                        if (pRIndirectReference2 == null) {
                            for (int k = 0; k < arrayList.size(); ++k) {
                                pdfObject6 = (PdfObject)arrayList.get(k);
                                if (!pdfObject6.isIndirect() || ((PRIndirectReference)pdfObject6).getNumber() != pRIndirectReference.getNumber()) continue;
                                arrayList.remove(k);
                                --k;
                            }
                            continue block2;
                        }
                        PdfDictionary pdfDictionary6 = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference2);
                        pdfObject6 = (PdfArray)PdfReader.getPdfObject(pdfDictionary6.get(PdfName.KIDS));
                        ArrayList arrayList3 = ((PdfArray)pdfObject6).getArrayList();
                        for (int k = 0; k < arrayList3.size(); ++k) {
                            PdfObject pdfObject7 = (PdfObject)arrayList3.get(k);
                            if (!pdfObject7.isIndirect() || ((PRIndirectReference)pdfObject7).getNumber() != pRIndirectReference.getNumber()) continue;
                            arrayList3.remove(k);
                            --k;
                        }
                        if (!arrayList3.isEmpty()) continue block2;
                        pRIndirectReference = pRIndirectReference2;
                    }
                }
                if (arrayList2.size() != 0) continue;
                PdfReader.killIndirect(pdfDictionary2.get(PdfName.ANNOTS));
                pdfDictionary2.remove(PdfName.ANNOTS);
            }
        }
        if (this.partialFlattening.isEmpty()) {
            for (int i = 1; i <= this.reader.getNumberOfPages(); ++i) {
                object2 = this.reader.getPageN(i);
                object = (PdfArray)PdfReader.getPdfObject(((PdfDictionary)object2).get(PdfName.ANNOTS));
                if (object == null) continue;
                ArrayList arrayList4 = ((PdfArray)object).getArrayList();
                for (int j = 0; j < arrayList4.size(); ++j) {
                    pdfObject = (PdfDictionary)PdfReader.getPdfObject((PdfObject)arrayList4.get(j));
                    if (!PdfName.WIDGET.equals(((PdfDictionary)pdfObject).get(PdfName.SUBTYPE))) continue;
                    arrayList4.remove(j);
                    --j;
                }
                if (arrayList4.size() != 0) continue;
                PdfReader.killIndirect(((PdfDictionary)object2).get(PdfName.ANNOTS));
                ((PdfDictionary)object2).remove(PdfName.ANNOTS);
            }
            this.eliminateAcroformObjects();
        } else if (arrayList.isEmpty()) {
            this.reader.getCatalog().remove(PdfName.ACROFORM);
        }
    }

    void eliminateAcroformObjects() {
        PdfObject pdfObject = this.reader.getCatalog().get(PdfName.ACROFORM);
        if (pdfObject == null) {
            return;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pdfObject);
        PdfObject pdfObject2 = pdfDictionary.get(PdfName.FIELDS);
        if (pdfObject2 != null) {
            PdfDictionary pdfDictionary2 = new PdfDictionary();
            pdfDictionary2.put(PdfName.KIDS, pdfObject2);
            this.sweepKids(pdfDictionary2);
        }
        PdfReader.killIndirect(pdfObject);
        this.reader.getCatalog().remove(PdfName.ACROFORM);
    }

    void sweepKids(PdfObject pdfObject) {
        PdfObject pdfObject2 = PdfReader.killIndirect(pdfObject);
        if (!pdfObject2.isDictionary()) {
            return;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)pdfObject2;
        PdfArray pdfArray = (PdfArray)PdfReader.killIndirect(pdfDictionary.get(PdfName.KIDS));
        if (pdfArray == null) {
            return;
        }
        ArrayList arrayList = pdfArray.getArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.sweepKids((PdfObject)arrayList.get(i));
        }
    }

    public PdfIndirectReference getPageReference(int n) {
        PRIndirectReference pRIndirectReference = this.reader.getPageOrigRef(n);
        if (pRIndirectReference == null) {
            throw new IllegalArgumentException("Invalid page number " + n);
        }
        return pRIndirectReference;
    }

    public void addAnnotation(PdfAnnotation pdfAnnotation) {
        throw new RuntimeException("Unsupported in this context. Use PdfStamper.addAnnotation()");
    }

    void addAnnotation(PdfAnnotation pdfAnnotation, int n) {
        try {
            if (pdfAnnotation.isForm()) {
                throw new RuntimeException("Form fields not yet supported.");
            }
            PdfRectangle pdfRectangle = (PdfRectangle)pdfAnnotation.get(PdfName.RECT);
            int n2 = this.reader.getPageRotation(n);
            Rectangle rectangle = this.reader.getPageSizeWithRotation(n);
            switch (n2) {
                case 90: {
                    pdfAnnotation.put(PdfName.RECT, new PdfRectangle(rectangle.top() - pdfRectangle.bottom(), pdfRectangle.left(), rectangle.top() - pdfRectangle.top(), pdfRectangle.right()));
                    break;
                }
                case 180: {
                    pdfAnnotation.put(PdfName.RECT, new PdfRectangle(rectangle.right() - pdfRectangle.left(), rectangle.top() - pdfRectangle.bottom(), rectangle.right() - pdfRectangle.right(), rectangle.top() - pdfRectangle.top()));
                    break;
                }
                case 270: {
                    pdfAnnotation.put(PdfName.RECT, new PdfRectangle(pdfRectangle.bottom(), rectangle.right() - pdfRectangle.left(), pdfRectangle.top(), rectangle.right() - pdfRectangle.right()));
                }
            }
            PdfDictionary pdfDictionary = this.reader.getPageN(n);
            PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.ANNOTS));
            if (pdfArray == null) {
                pdfArray = new PdfArray();
                pdfDictionary.put(PdfName.ANNOTS, pdfArray);
            }
            PdfIndirectReference pdfIndirectReference = this.addToBody(pdfAnnotation).getIndirectReference();
            pdfArray.add(pdfIndirectReference);
            pdfAnnotation.put(PdfName.RECT, pdfRectangle);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    private void outlineTravel(PRIndirectReference pRIndirectReference) {
        while (pRIndirectReference != null) {
            PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
            PRIndirectReference pRIndirectReference2 = (PRIndirectReference)pdfDictionary.get(PdfName.FIRST);
            if (pRIndirectReference2 != null) {
                this.outlineTravel(pRIndirectReference2);
            }
            PdfReader.killIndirect(pdfDictionary.get(PdfName.DEST));
            PdfReader.killIndirect(pdfDictionary.get(PdfName.A));
            PdfReader.killIndirect(pRIndirectReference);
            pRIndirectReference = (PRIndirectReference)pdfDictionary.get(PdfName.NEXT);
        }
    }

    void deleteOutlines() {
        PdfDictionary pdfDictionary = this.reader.getCatalog();
        PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfDictionary.get(PdfName.OUTLINES);
        if (pRIndirectReference == null) {
            return;
        }
        this.outlineTravel(pRIndirectReference);
        PdfReader.killIndirect(pRIndirectReference);
        pdfDictionary.remove(PdfName.OUTLINES);
    }

    void setOutlines() throws IOException {
        if (this.newBookmarks == null) {
            return;
        }
        this.deleteOutlines();
        if (this.newBookmarks.size() == 0) {
            return;
        }
        this.namedAsNames = this.reader.getCatalog().get(PdfName.DESTS) != null;
        PdfDictionary pdfDictionary = new PdfDictionary();
        PdfIndirectReference pdfIndirectReference = this.getPdfIndirectReference();
        Object[] objectArray = SimpleBookmark.iterateOutlines(this, pdfIndirectReference, this.newBookmarks, this.namedAsNames);
        pdfDictionary.put(PdfName.FIRST, (PdfIndirectReference)objectArray[0]);
        pdfDictionary.put(PdfName.LAST, (PdfIndirectReference)objectArray[1]);
        pdfDictionary.put(PdfName.COUNT, new PdfNumber((Integer)objectArray[2]));
        this.addToBody((PdfObject)pdfDictionary, pdfIndirectReference);
        this.reader.getCatalog().put(PdfName.OUTLINES, pdfIndirectReference);
    }

    void setOutlines(List list) {
        this.newBookmarks = list;
    }

    class PageStamp {
        int pageNumber;
        StampContent under;
        StampContent over;
        PageResources pageResources;

        PageStamp(PdfStamperImp pdfStamperImp2, PdfReader pdfReader, int n) {
            this.pageNumber = n;
            this.pageResources = new PageResources();
            PdfDictionary pdfDictionary = pdfReader.getPageN(n);
            PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.RESOURCES));
            this.pageResources.setOriginalResources(pdfDictionary2, pdfStamperImp2.namePtr);
        }
    }
}

