/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode128;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class BarcodeEAN128
extends Barcode128 {
    public static HashMap ids;
    public static IntHashtable codesB;
    private String codeText = "";
    private StringBuffer bCode = new StringBuffer(50);
    private int checksum = 0;
    private int ponderation = 2;

    public BarcodeEAN128() {
        try {
            this.x = 0.8f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.textAlignment = 1;
            this.codeType = 10;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public Rectangle getBarcodeSize(float f) {
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.font != null) {
            f3 = this.baseline > 0.0f ? this.baseline - this.font.getFontDescriptor(3, this.size) : -this.baseline + this.size;
            String string = this.codeText;
            f2 = this.font.getWidthPoint(string, this.size);
        }
        float f4 = Math.max(f, f2);
        float f5 = this.barHeight + f3;
        return new Rectangle(f4, f5);
    }

    public byte[] getBarsEAN128(String string) {
        LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
        int n = string.length();
        if (n == 0) {
            linkedList.add(BARS[104]);
            this.bCode.append('\u00cc');
            linkedList.add(BARS[102]);
            this.bCode.append('\u00ca');
            return this.getBarsArray(linkedList);
        }
        int n2 = 0;
        linkedList.add(BARS[105]);
        this.bCode.append('\u00cd');
        linkedList.add(BARS[102]);
        this.bCode.append('\u00ca');
        this.checksum += 105;
        this.checksum += 102;
        String string2 = "";
        while (string2 != null) {
            string2 = this.getBloc(string, n2);
            if (string2 == null) continue;
            n2 += string2.length();
            this.bCode.append(string2);
            linkedList.add(this.getBarsCode(string2));
        }
        int n3 = this.checksum % 103;
        linkedList.add(BARS[n3]);
        this.bCode.append((char)n3);
        linkedList.add(BARS_STOP);
        this.bCode.append('\u0000');
        byte[] byArray = this.getBarsArray(linkedList);
        return byArray;
    }

    public Rectangle placeBarcode(PdfContentByte pdfContentByte, Color color, Color color2) {
        String string = this.code;
        float f = 0.0f;
        byte[] byArray = this.getBarsEAN128(this.code);
        if (this.font != null) {
            f = this.font.getWidthPoint(this.codeText, this.size);
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                f3 = this.barHeight - this.baseline;
            } else {
                f3 = -this.font.getFontDescriptor(3, this.size);
                f2 = f3 + this.baseline;
            }
        }
        boolean bl = true;
        float f4 = (float)(byArray.length / 6 * 11 + 2) * this.x;
        float f5 = 0.0f;
        float f6 = 0.0f;
        switch (this.textAlignment) {
            case 0: {
                break;
            }
            case 2: {
                if (f > f4) {
                    f5 = f - f4;
                    break;
                }
                f6 = f4 - f;
                break;
            }
            default: {
                if (f > f4) {
                    f5 = (f - f4) / 2.0f;
                    break;
                }
                f6 = (f4 - f) / 2.0f;
            }
        }
        if (color != null) {
            pdfContentByte.setColorFill(color);
        }
        for (int i = 0; i < byArray.length; ++i) {
            float f7 = (float)byArray[i] * this.x;
            if (bl) {
                pdfContentByte.rectangle(f5, f2, f7, this.barHeight);
            }
            bl = !bl;
            f5 += f7;
        }
        pdfContentByte.fill();
        if (this.font != null) {
            if (color2 != null) {
                pdfContentByte.setColorFill(color2);
            }
            pdfContentByte.beginText();
            pdfContentByte.setFontAndSize(this.font, this.size);
            pdfContentByte.setTextMatrix(f6, f3);
            pdfContentByte.showText(this.codeText);
            pdfContentByte.endText();
        }
        return this.getBarcodeSize(f4);
    }

    protected byte[] getBarsCode(String string) {
        try {
            int n;
            int n2;
            int n3 = 0;
            String string2 = string;
            boolean bl = string.endsWith("\u00ca");
            if (bl) {
                string2 = string.substring(0, string.length() - 1);
                ++n3;
            }
            int n4 = 0;
            if (string2.length() % 2 != 0) {
                n3 = n3 + (string2.length() + 1) / 2 + 2;
                n4 = string2.length() - 1;
            } else {
                n3 += string2.length() / 2;
                n4 = string2.length();
            }
            byte[] byArray = new byte[n3 * 6];
            int[] nArray = new int[2];
            int n5 = 0;
            for (int i = 0; i < n4 && string2 != null && !"".equals(string2); i += 2) {
                nArray[0] = Integer.parseInt("" + string2.charAt(0));
                nArray[1] = Integer.parseInt("" + string2.charAt(1));
                string2 = string2.substring(2);
                n2 = nArray[0] * 10 + nArray[1];
                byte[] byArray2 = BARS[n2];
                this.checksum += this.ponderation * n2;
                ++this.ponderation;
                for (n = 0; n < 6; ++n) {
                    byArray[n5] = BARS[n2][n];
                    ++n5;
                }
            }
            if (string2 != null && string2.length() > 0) {
                int n6;
                n2 = string2.charAt(0);
                this.checksum += this.ponderation * 100;
                ++this.ponderation;
                for (n6 = 0; n6 < 6; ++n6) {
                    byArray[n5] = BARS[100][n6];
                    ++n5;
                }
                n6 = codesB.get(n2);
                for (n = 0; n < 6; ++n) {
                    byArray[n5] = BARS[n6][n];
                    ++n5;
                }
                this.checksum += this.ponderation * n6;
                ++this.ponderation;
                this.checksum += this.ponderation * 99;
                ++this.ponderation;
                for (n = 0; n < 6; ++n) {
                    byArray[n5] = BARS[99][n];
                    ++n5;
                }
            }
            if (bl) {
                this.checksum += this.ponderation * 102;
                ++this.ponderation;
                for (n2 = 0; n2 < 6; ++n2) {
                    byArray[n5] = BARS[102][n2];
                    ++n5;
                }
            }
            return byArray;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    protected String getBloc(String string, int n) {
        Object object;
        Object object2 = null;
        String string2 = null;
        Iterator iterator = ids.keySet().iterator();
        String string3 = string.substring(n);
        if (string3 == null || "".equals(string3.trim())) {
            return string2;
        }
        while (object2 == null && iterator.hasNext()) {
            object = (String)iterator.next();
            if (!string3.startsWith((String)object)) continue;
            object2 = object;
            this.codeText = this.codeText + "(" + (String)object2 + ")";
        }
        object = (IdentifierEAN)ids.get(object2);
        if (object != null) {
            if (((IdentifierEAN)object).isVariable()) {
                int n2 = string3.indexOf(202);
                if (n2 > 0) {
                    string2 = string3.substring(0, n2 + 1);
                    this.codeText = object2 != null ? this.codeText + string2.substring(((String)object2).length(), n2) : this.codeText + string2.substring(0, n2);
                } else {
                    string2 = string3;
                    this.codeText = object2 != null ? this.codeText + string2.substring(((String)object2).length()) : this.codeText + string2;
                }
            } else {
                string2 = string.substring(n, n + ((IdentifierEAN)object).getSize());
                this.codeText = object2 != null ? this.codeText + string2.substring(((String)object2).length()) : this.codeText + string2;
            }
        }
        return string2;
    }

    private byte[] getBarsArray(LinkedList linkedList) {
        Iterator iterator = linkedList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            n += ((byte[])iterator.next()).length;
        }
        byte[] byArray = new byte[n];
        iterator = linkedList.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            byte[] byArray2 = (byte[])iterator.next();
            for (int i = 0; i < byArray2.length; ++i) {
                byArray[n2] = byArray2[i];
                ++n2;
            }
        }
        return byArray;
    }

    public Rectangle getBarcodeSize() {
        int n;
        String string;
        float f = 0.0f;
        float f2 = 0.0f;
        if (this.font != null) {
            f2 = this.baseline > 0.0f ? this.baseline - this.font.getFontDescriptor(3, this.size) : -this.baseline + this.size;
            string = this.code;
            if (this.codeType == 11) {
                n = this.code.indexOf(65535);
                string = n < 0 ? "" : this.code.substring(n + 1);
            }
            f = this.font.getWidthPoint(string, this.size);
        }
        string = this.codeType == 11 ? ((n = this.code.indexOf(65535)) >= 0 ? this.code.substring(0, n) : this.code) : 307 + this.code;
        n = string.length();
        float f3 = (float)((n + 2) * 11) * this.x + 2.0f * this.x;
        f3 = Math.max(f3, f);
        float f4 = this.barHeight + f2;
        return new Rectangle(f3, f4);
    }

    static {
        int n;
        codesB = new IntHashtable(100);
        ids = new HashMap(10000);
        ids.put("00", new IdentifierEAN("00", "n2+n18", 20, false));
        ids.put("01", new IdentifierEAN("01", "n2+n14", 16, false));
        ids.put("02", new IdentifierEAN("02", "n2+n14", 16, false));
        ids.put("10", new IdentifierEAN("10", "n2+an...20", -1, true));
        ids.put("11", new IdentifierEAN("11", "n2+n6", 8, false));
        ids.put("13", new IdentifierEAN("13", "n2+n6", 8, false));
        ids.put("15", new IdentifierEAN("15", "n2+n6", 8, false));
        ids.put("17", new IdentifierEAN("17", "n2+n6", 8, false));
        ids.put("20", new IdentifierEAN("20", "n2+n6", 8, false));
        ids.put("21", new IdentifierEAN("21", "n2+an...20", -1, true));
        ids.put("22", new IdentifierEAN("22", "n2+an...29", -1, true));
        ids.put("230", new IdentifierEAN("230", "n3+n...19", -1, true));
        ids.put("231", new IdentifierEAN("231", "n3+n...19", -1, true));
        ids.put("232", new IdentifierEAN("232", "n3+n...19", -1, true));
        ids.put("233", new IdentifierEAN("233", "n3+n...19", -1, true));
        ids.put("234", new IdentifierEAN("234", "n3+n...19", -1, true));
        ids.put("235", new IdentifierEAN("235", "n3+n...19", -1, true));
        ids.put("236", new IdentifierEAN("236", "n3+n...19", -1, true));
        ids.put("237", new IdentifierEAN("237", "n3+n...19", -1, true));
        ids.put("238", new IdentifierEAN("238", "n3+n...19", -1, true));
        ids.put("239", new IdentifierEAN("239", "n3+n...19", -1, true));
        ids.put("240", new IdentifierEAN("240", "n3+an...30", -1, true));
        ids.put("241", new IdentifierEAN("241", "n3+an...30", -1, true));
        ids.put("250", new IdentifierEAN("250", "n3+an...30", -1, true));
        ids.put("30", new IdentifierEAN("30", "n2+n...8", -1, true));
        for (n = 3100; n < 3700; ++n) {
            ids.put("" + n, new IdentifierEAN("" + n, "n2+n...8", -1, true));
        }
        ids.put("337", new IdentifierEAN("337", "n4+n6", 10, false));
        ids.put("37", new IdentifierEAN("37", "n2+n...8", -1, true));
        ids.put("400", new IdentifierEAN("400", "n3+an...30", -1, true));
        ids.put("401", new IdentifierEAN("401", "n3+an...30", -1, true));
        ids.put("402", new IdentifierEAN("402", "n3+n17", 20, false));
        ids.put("403", new IdentifierEAN("403", "n3+an...30", -1, true));
        ids.put("410", new IdentifierEAN("410", "n3+n13", 16, false));
        ids.put("411", new IdentifierEAN("411", "n3+n13", 16, false));
        ids.put("412", new IdentifierEAN("412", "n3+n13", 16, false));
        ids.put("413", new IdentifierEAN("413", "n3+n13", 16, false));
        ids.put("414", new IdentifierEAN("414", "n3+n13", 16, false));
        ids.put("420", new IdentifierEAN("420", "n3+an...9", -1, true));
        ids.put("421", new IdentifierEAN("421", "n3+n3+an...9", -1, true));
        ids.put("422", new IdentifierEAN("422", "n3+n3", 6, false));
        ids.put("8001", new IdentifierEAN("8001", "n4+n14", 18, false));
        ids.put("8002", new IdentifierEAN("8002", "n4+an...30", -1, true));
        ids.put("8003", new IdentifierEAN("8003", "n4+n14+an...16", -1, true));
        ids.put("8004", new IdentifierEAN("8004", "n4+an...30", -1, true));
        ids.put("8005", new IdentifierEAN("8005", "n4+n6", 10, false));
        ids.put("8006", new IdentifierEAN("8006", "n4+n14+n2+n2", 22, false));
        ids.put("8018", new IdentifierEAN("8018", "n4+n18", 22, false));
        ids.put("8100", new IdentifierEAN("8100", "n4+n1+n5", 10, false));
        ids.put("8101", new IdentifierEAN("8101", "n4+n1+n5+n4", 14, false));
        ids.put("8102", new IdentifierEAN("8102", "n4+n1+n1", 6, false));
        ids.put("90", new IdentifierEAN("90", "n2+an...30", -1, true));
        for (n = 91; n < 100; ++n) {
            ids.put("" + n, new IdentifierEAN("" + n, "n2+an...30", -1, true));
        }
        for (n = 0; n < 95; ++n) {
            codesB.put(n + 32, n);
        }
        for (n = 95; n < 196; ++n) {
            codesB.put(n - 95 + 195, n);
        }
    }

    public static class IdentifierEAN {
        private boolean variable;
        private String id;
        private String format;
        private int size;

        public IdentifierEAN(String string, String string2, int n, boolean bl) {
            this.id = string;
            this.format = string2;
            this.variable = bl;
            this.size = n;
        }

        public boolean isVariable() {
            return this.variable;
        }

        public void setVariable(boolean bl) {
            this.variable = bl;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String string) {
            this.id = string;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String string) {
            this.format = string;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int n) {
            this.size = n;
        }
    }
}

