/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.xbeans;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import serpro.ppgd.gui.xbeans.PPGDCheckBox;
import serpro.ppgd.gui.xbeans.PPGDRadioButton;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.PPGDFacade;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;

public class PPGDButtonGroup
extends ButtonGroup {
    private Alfa informacao;
    private String informacaoAssociada;
    private boolean associaComFacade = true;
    private Collection<AbstractButton> colRadios = new ArrayList<AbstractButton>();
    private Collection<AbstractButton> colCheckbox = new ArrayList<AbstractButton>();
    private boolean desabilitaAtualizaInterface = false;
    private boolean atualizandoInterface = false;

    public void add(final AbstractButton b) {
        if (b instanceof PPGDRadioButton) {
            super.add(b);
            this.colRadios.add(b);
        } else {
            ((PPGDCheckBox)b).addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (!PPGDButtonGroup.this.atualizandoInterface) {
                        PPGDButtonGroup.this.clicouCheckBox(b.getModel(), e.getStateChange() == 1);
                    }
                }
            });
            this.colCheckbox.add(b);
        }
        if (b instanceof PPGDRadioButton) {
            ((PPGDRadioButton)b).setPPGDButtonGroup(this);
        } else if (b instanceof PPGDCheckBox) {
            ((PPGDCheckBox)b).setPPGDButtonGroup(this);
        }
        this.atualizaInterface(b);
    }

    public void remove(AbstractButton b) {
        super.remove(b);
        this.colRadios.remove(b);
        this.colCheckbox.remove(b);
    }

    public void setSelected(ButtonModel m, boolean b) {
        this.selecionouRadioButton(m, b);
    }

    public void selecionouRadioButton(ButtonModel m, boolean selecionou) {
        super.setSelected(m, selecionou);
        this.desabilitaAtualizaInterface = true;
        String novoValor = null;
        for (AbstractButton btn : this.colRadios) {
            if (!btn.getModel().isSelected() || !m.isSelected()) continue;
            novoValor = ((PPGDRadioButton)btn).getValor();
            break;
        }
        if (this.informacao != null) {
            if (novoValor != null) {
                this.informacao.setConteudo(novoValor);
            } else {
                this.informacao.clear();
            }
        }
        this.desabilitaAtualizaInterface = false;
    }

    private void clicouCheckBox(ButtonModel m, boolean selecionou) {
        this.desabilitaAtualizaInterface = true;
        String novoValor = "";
        for (PPGDCheckBox pPGDCheckBox : this.colCheckbox) {
            if (!pPGDCheckBox.isSelected()) continue;
            novoValor = String.valueOf(novoValor) + "#" + pPGDCheckBox.getValor() + ";";
        }
        if (this.informacao != null) {
            this.informacao.setConteudo(novoValor);
        }
        this.desabilitaAtualizaInterface = false;
    }

    public void setInformacao(Alfa informacao) {
        this.informacao = informacao;
        informacao.addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                PPGDButtonGroup.this.mudouInformacao();
            }
        });
        this.mudouInformacao();
    }

    private void mudouInformacao() {
        for (AbstractButton btn : this.colCheckbox) {
            this.atualizaInterface(btn);
        }
        for (AbstractButton btn : this.colRadios) {
            this.atualizaInterface(btn);
        }
    }

    protected boolean atualizaInterface(AbstractButton btn) {
        if (!this.desabilitaAtualizaInterface) {
            this.atualizandoInterface = true;
            if (this.informacao != null) {
                if (btn instanceof PPGDRadioButton) {
                    PPGDRadioButton radioButton = (PPGDRadioButton)btn;
                    if (radioButton.getValor() != null && radioButton.getValor().equals(this.informacao.asString())) {
                        btn.setSelected(true);
                    }
                } else if (btn instanceof PPGDCheckBox) {
                    PPGDCheckBox checkBox = (PPGDCheckBox)btn;
                    String valorCheckBox = "#" + checkBox.getValor() + ";";
                    if (this.informacao.asString().indexOf(valorCheckBox) > -1) {
                        btn.setSelected(true);
                    } else {
                        btn.setSelected(false);
                    }
                }
            }
            this.atualizandoInterface = false;
        }
        return btn.isSelected();
    }

    public Alfa getInformacao() {
        return this.informacao;
    }

    public void setInformacaoAssociada(String informacaoAssociada) {
        this.informacaoAssociada = informacaoAssociada;
        if (this.isAssociaComFacade()) {
            this.associaInformacao(informacaoAssociada);
        }
    }

    private void associaInformacao(String aInfo) {
        try {
            PPGDFacade facade;
            String classeFacade = FabricaUtilitarios.getProperties().getProperty("aplicacao.classes.facade", "serpro.ppgd.repositorio.FacadeDefault");
            Class<?> classe = Class.forName(classeFacade);
            Method methGetInstancia = classe.getMethod("getInstancia", new Class[0]);
            Object objInfo = facade = (PPGDFacade)methGetInstancia.invoke(null, new Object[0]);
            StringTokenizer tokens = new StringTokenizer(aInfo, ".");
            while (tokens.hasMoreTokens()) {
                Class<?> clazz = objInfo.getClass();
                String nomeMetodo = tokens.nextToken();
                nomeMetodo = String.valueOf(nomeMetodo.substring(0, 1).toUpperCase()) + nomeMetodo.substring(1, nomeMetodo.length());
                Method mtd = clazz.getMethod("get" + nomeMetodo, new Class[0]);
                objInfo = mtd.invoke(objInfo, new Object[0]);
            }
            if (objInfo != null && objInfo instanceof Informacao) {
                this.setInformacao((Alfa)objInfo);
            } else {
                LogPPGD.erro((String)("O retorno de " + aInfo + " veio nulo. Este atributo existe mesmo?"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getInformacaoAssociada() {
        return this.informacaoAssociada;
    }

    public void setAssociaComFacade(boolean associadoAutomaticamente) {
        this.associaComFacade = associadoAutomaticamente;
    }

    public boolean isAssociaComFacade() {
        return this.associaComFacade;
    }
}

