/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.xbeans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import serpro.ppgd.gui.ConstantesGlobaisGUI;
import serpro.ppgd.gui.xbeans.JButtonMensagem;
import serpro.ppgd.gui.xbeans.JEditCampoTextoAbstract;
import serpro.ppgd.gui.xbeans.PainelBotao;
import serpro.ppgd.gui.xbeans.editors.PPGDFormattedTextField;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.UtilitariosString;

public class JEditValor
extends JEditCampoTextoAbstract {
    private static String maskara = "###.###.##0,00";
    protected JFormattedTextField componente;
    protected boolean aceitaNumerosNegativos = false;

    public JEditValor() {
        super((Informacao)new Valor());
    }

    public JEditValor(Informacao campo) {
        super(campo);
    }

    public boolean isAceitaNumerosNegativos() {
        return this.aceitaNumerosNegativos;
    }

    public void setAceitaNumerosNegativos(boolean aceitaNumerosNegativos) {
        this.aceitaNumerosNegativos = aceitaNumerosNegativos;
    }

    protected void informacaoModificada() {
        ((PPGDFormattedTextField)this.componente).setInformacao(this.getInformacao());
        this.implementacaoPropertyChange(null);
    }

    protected void buildComponente() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        if (this.componente == null) {
            this.componente = new PPGDFormattedTextField();
            this.componente.setHorizontalAlignment(11);
            this.componente.setFont(ConstantesGlobaisGUI.FONTE_9_NORMAL);
            this.componente.setHorizontalAlignment(4);
            this.componente.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            (this).JEditValor.this.componente.selectAll();
                        }
                    });
                }

                public void focusLost(FocusEvent e) {
                    if (e.getOppositeComponent() == null) {
                        return;
                    }
                    JEditValor.this.setIdentificacaoFoco(false);
                    if (!JEditValor.this.getInformacao().getListaValidadoresImpeditivos().isEmpty() && !JEditValor.this.verificaValidacoesImpeditivas(JEditValor.this.componente.getText())) {
                        return;
                    }
                    JEditValor.this.getInformacao().setConteudo(JEditValor.this.componente.getText());
                    JEditValor.this.componente.setText(JEditValor.this.getInformacao().getConteudoFormatado());
                    JEditValor.this.chamaValidacao();
                }
            });
            this.componente.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent ev) {
                    JEditValor.this.trataEventoKeyTyped(ev);
                }
            });
        }
        this.add((Component)this.getComponenteEditor(), "Center");
        JButtonMensagem btnMsg = this.getButtonMensagem();
        if (btnMsg != null) {
            this.add((Component)new PainelBotao(btnMsg), "East");
        }
    }

    protected void trataEventoKeyTyped(KeyEvent e) {
        boolean naoEhDigitoVirgulaPontoOuSinalNegativo;
        char ch;
        int tamanhoMaximo;
        boolean manipulacaoCursor;
        boolean bl = manipulacaoCursor = (e.getKeyChar() == '\t' || e.getKeyChar() == '\n' || e.getKeyChar() == '\b' || e.getKeyChar() == '\u007f' || e.getKeyChar() == '%' || e.getKeyChar() == '\'') && !String.valueOf(e.getKeyChar()).equals("%") && !String.valueOf(e.getKeyChar()).equals("'");
        if (manipulacaoCursor) {
            return;
        }
        String text = this.componente.getText();
        int tamanhoTextoAtual = UtilitariosString.retiraMascara((String)text).length();
        boolean fracaoGrande = false;
        Valor info = (Valor)this.getInformacao();
        int pos = text.indexOf(44);
        if (pos != -1) {
            tamanhoMaximo = info.getMaximoDigitosParteInteira() + info.getCasasDecimais();
            String s = text.substring(pos + 1);
            if (s.length() == info.getCasasDecimais() && this.componente.getCaretPosition() > pos && this.componente.getSelectedText() == null) {
                fracaoGrande = true;
            }
        } else {
            tamanhoMaximo = info.getMaximoDigitosParteInteira();
        }
        if (e.getKeyChar() == ',') {
            tamanhoMaximo = info.getMaximoDigitosParteInteira() + info.getCasasDecimais();
        }
        boolean eventosEhInclusao = (ch = e.getKeyChar()) != '\t' && ch != '\n' && ch != '\b' && ch != '\u007f' && ch != '%' && ch != '\'';
        boolean jaExisteUmSinalNeg = false;
        if (this.componente.getText().trim().indexOf("-") != -1) {
            jaExisteUmSinalNeg = true;
        }
        boolean jaExisteVirgula = false;
        if (this.componente.getText().trim().indexOf(",") != -1) {
            jaExisteVirgula = true;
        }
        boolean bl2 = naoEhDigitoVirgulaPontoOuSinalNegativo = !Character.isDigit(e.getKeyChar()) && e.getKeyChar() != '-' && e.getKeyChar() != '.' && e.getKeyChar() != ',' && e.getKeyChar() != ' ';
        if (tamanhoTextoAtual >= tamanhoMaximo && eventosEhInclusao && this.componente.getSelectedText() == null || e.getKeyChar() == '-' && !this.aceitaNumerosNegativos || Character.isLetter(e.getKeyChar()) || fracaoGrande || e.getKeyChar() == '-' && jaExisteUmSinalNeg || jaExisteUmSinalNeg && tamanhoTextoAtual + 1 >= tamanhoMaximo || e.getKeyChar() == '\'' || e.getKeyChar() == '\"' || String.valueOf(e.getKeyChar()).equals("\u00b4") || String.valueOf(e.getKeyChar()).equals("`") || String.valueOf(e.getKeyChar()).equals("^") || String.valueOf(e.getKeyChar()).equals("@") || String.valueOf(e.getKeyChar()).equals("~") || String.valueOf(e.getKeyChar()).equals("'") || String.valueOf(e.getKeyChar()).equals("%") || e.getKeyChar() == ',' && jaExisteVirgula || e.getKeyChar() == ',' && info.getCasasDecimais() == 0 || naoEhDigitoVirgulaPontoOuSinalNegativo) {
            e.setKeyChar('\uffff');
            e.consume();
            UIManager.getLookAndFeel().provideErrorFeedback(this.componente);
        }
    }

    public void implementacaoPropertyChange(PropertyChangeEvent evt) {
        this.componente.setText(this.getInformacao().getConteudoFormatado());
    }

    public JComponent getComponenteEditor() {
        return this.componente;
    }

    public JComponent getComponenteFoco() {
        return this.componente;
    }

    public void setAceitaFoco(boolean aAceita) {
        this.getComponenteEditor().setFocusable(aAceita);
    }

    public boolean isAceitaFoco() {
        return this.getComponenteEditor().isFocusable();
    }
}

