/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.xbeans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import serpro.ppgd.gui.editors.PPGDTextField;
import serpro.ppgd.gui.xbeans.JButtonMensagem;
import serpro.ppgd.gui.xbeans.JEditCampoTextoAbstract;
import serpro.ppgd.gui.xbeans.PainelBotao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Inteiro;

public class JEditNumero
extends JEditCampoTextoAbstract {
    private JTextField componente;

    public JEditNumero() {
        super((Informacao)new Inteiro());
    }

    public JEditNumero(Informacao campo) {
        super(campo);
    }

    protected void informacaoModificada() {
        ((PPGDTextField)this.componente).setInformacao(this.campo);
        this.implementacaoPropertyChange(null);
    }

    public void setarCampo() {
        String s = this.componente.getText();
        int limiteMax = ((Inteiro)this.getInformacao()).getLimiteMaximo();
        if (limiteMax != -1 && Integer.parseInt(s) > limiteMax) {
            s = "" + limiteMax;
        }
        this.getInformacao().setConteudo(s);
        this.chamaValidacao();
    }

    public JComponent getComponenteEditor() {
        return this.componente;
    }

    public void implementacaoPropertyChange(PropertyChangeEvent evt) {
        this.componente.setText(this.getInformacao().getConteudoFormatado());
        this.componente.setCaretPosition(0);
    }

    public JComponent getComponenteFoco() {
        return this.componente;
    }

    protected void buildComponente() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        if (this.componente == null) {
            this.componente = new PPGDTextField();
            this.componente.setColumns(6);
            this.componente.setHorizontalAlignment(4);
            this.componente.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (e.getOppositeComponent() == null) {
                        return;
                    }
                    JEditNumero.this.setIdentificacaoFoco(false);
                    if (!JEditNumero.this.getInformacao().getListaValidadoresImpeditivos().isEmpty() && !JEditNumero.this.verificaValidacoesImpeditivas(JEditNumero.this.componente.getText())) {
                        return;
                    }
                    JEditNumero.this.setarCampo();
                }

                public void focusGained(FocusEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JEditNumero.this.componente.selectAll();
                        }
                    });
                }
            });
            this.componente.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JEditNumero.this.setarCampo();
                }
            });
            this.componente.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    boolean ehCharValido;
                    char ch = e.getKeyChar();
                    boolean bl = ehCharValido = Character.isDigit(ch) || ch == '\t' || ch == '\n' || ch == '\b' || ch == '\u007f' || ch == '%' || ch == '\'';
                    if (!ehCharValido) {
                        e.setKeyChar('\uffff');
                        e.consume();
                        UIManager.getLookAndFeel().provideErrorFeedback(JEditNumero.this.componente);
                    }
                }
            });
        }
        this.add((Component)this.componente, "Center");
        JButtonMensagem btnMsg = this.getButtonMensagem();
        if (btnMsg != null) {
            this.add((Component)new PainelBotao(btnMsg), "East");
        }
    }
}

