/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.xbeans;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import serpro.ppgd.gui.xbeans.CustomComboBox;
import serpro.ppgd.gui.xbeans.JButtonMensagem;
import serpro.ppgd.gui.xbeans.JDialogEditCampoLeitor;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.gui.xbeans.MyCustomRenderer;
import serpro.ppgd.gui.xbeans.PainelBotao;
import serpro.ppgd.gui.xbeans.editors.PPGDComboBox;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JEditCodigo
extends JEditCampo
implements ActionListener,
KeyListener {
    JComboBox combo;
    Dimension[] tamCols;
    boolean[] colsVisiveisExpandidas;
    boolean[] colsVisiveis;
    private Border bordaColunas = BorderFactory.createMatteBorder(0, 0, 1, 1, Color.GRAY);
    private Border bordaVazia = BorderFactory.createEmptyBorder();

    public JEditCodigo() {
        super((Informacao)new Codigo("C\u00f3digo"));
        this.aplicaItens(((Codigo)this.campo).getColecaoElementoTabela());
        this.inicio();
    }

    public JEditCodigo(Informacao aCampo) {
        super(aCampo);
        this.inicio();
    }

    public JEditCodigo(Informacao aCampo, String idAjuda) {
        super(aCampo, idAjuda);
        this.inicio();
    }

    @Override
    protected boolean continuaValidacaoImpeditiva(Object proxConteudo) {
        return proxConteudo == null || !proxConteudo.equals(((Codigo)this.getInformacao()).getElementoTabela());
    }

    @Override
    protected void desfazModificacao() {
        int indice = ((Codigo)this.getInformacao()).getIndiceElementoTabela();
        this.combo.setSelectedIndex(indice);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JEditCodigo.this.combo.grabFocus();
            }
        });
    }

    private void inicio() {
        this.corrigeFocoJava6();
        this.setInformacao(this.getInformacao());
        this.combo.setKeySelectionManager(new KeySelectionCustomizado());
        this.combo.addActionListener(this);
        this.combo.addKeyListener(this);
        this.combo.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() == null || !JEditCodigo.this.isFocusLostAtivo()) {
                    return;
                }
                JEditCodigo.this.setIdentificacaoFoco(false);
                if (!JEditCodigo.this.getInformacao().getListaValidadoresImpeditivos().isEmpty()) {
                    ElementoTabela elemento = ((Codigo)JEditCodigo.this.getInformacao()).getElementoTabela(JEditCodigo.this.combo.getSelectedIndex());
                    if (!JEditCodigo.this.verificaValidacoesImpeditivas(elemento)) {
                        return;
                    }
                    JEditCodigo.this.setaCampo();
                }
                JEditCodigo.this.chamaValidacao();
            }
        });
        this.getInformacao().getObservadores().addPropertyChangeListener("ComboReiniciado", this);
    }

    private void corrigeFocoJava6() {
        String versaoJava = System.getProperty("java.version");
        if (!versaoJava.startsWith("1.6")) {
            return;
        }
        FocusTraversalPolicy ftp = new FocusTraversalPolicy(){

            public Component getComponentAfter(Container aContainer, Component aComponent) {
                return null;
            }

            public Component getComponentBefore(Container aContainer, Component aComponent) {
                return null;
            }

            public Component getFirstComponent(Container aContainer) {
                return JEditCodigo.this.combo;
            }

            public Component getLastComponent(Container aContainer) {
                return JEditCodigo.this.combo;
            }

            public Component getDefaultComponent(Container aContainer) {
                return JEditCodigo.this.combo;
            }
        };
        this.setFocusTraversalPolicy(ftp);
        try {
            Method m = this.getClass().getMethod("setFocusTraversalPolicyProvider", Boolean.TYPE);
            m.invoke((Object)this, Boolean.TRUE);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    protected void initColsVisiveis() {
        this.colsVisiveis = new boolean[30];
        this.colsVisiveisExpandidas = new boolean[30];
        int i = 0;
        while (i < this.colsVisiveis.length) {
            this.colsVisiveisExpandidas[i] = false;
            this.colsVisiveis[i] = false;
            ++i;
        }
        this.exibeColunaNaoExpandida(1);
        this.exibeColunaExpandida(1);
    }

    public void exibeColunaNaoExpandida(int aCol) {
        this.colsVisiveis[aCol] = true;
    }

    public void escondeColunaNaoExpandida(int aCol) {
        this.colsVisiveis[aCol] = false;
    }

    public void exibeColunaExpandida(int aCol) {
        this.colsVisiveisExpandidas[aCol] = true;
    }

    public void escondeColunaExpandida(int aCol) {
        this.colsVisiveisExpandidas[aCol] = false;
    }

    private void aplicaItens(List<ElementoTabela> elems) {
        if (elems != null) {
            this.calculaTamanhoMaxCols();
            this.combo.setModel(new DefaultComboBoxModel<Object>(elems.toArray()));
            this.combo.setSelectedItem(((Codigo)this.campo).getElementoTabela());
        }
    }

    @Override
    protected void buildComponente() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        if (this.combo == null) {
            this.combo = new CustomComboBox(this);
            this.combo.setRenderer(new MyCustomRenderer(this));
        }
        if (this.colsVisiveis == null || this.colsVisiveisExpandidas == null) {
            this.initColsVisiveis();
        }
        this.add((Component)this.combo, "Center");
        JButtonMensagem btnMsg = this.getButtonMensagem();
        if (btnMsg != null) {
            this.add((Component)new PainelBotao(btnMsg), "East");
        }
    }

    @Override
    protected void informacaoModificada() {
        this.aplicaItens(((Codigo)this.campo).getColecaoElementoTabela());
        ((PPGDComboBox)this.combo).setInformacao(this.campo);
    }

    @Override
    public void implementacaoPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() != null && evt.getPropertyName().equals("ComboReiniciado")) {
            this.setInformacao(this.getInformacao());
        }
        if (evt.getPropertyName() != null && evt.getPropertyName().equals(this.getInformacao().getNomeCampo())) {
            this.combo.setSelectedIndex(((Codigo)this.getInformacao()).getIndiceElementoTabela());
        }
    }

    @Override
    public JComponent getComponenteEditor() {
        return this.combo;
    }

    @Override
    public JComponent getComponenteFoco() {
        return this.combo;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.getInformacao().getListaValidadoresImpeditivos().isEmpty()) {
            return;
        }
        this.setaCampo();
    }

    public void setaCampo() {
        ElementoTabela elem = (ElementoTabela)this.combo.getSelectedItem();
        if (elem != null) {
            this.campo.setConteudo(elem.getConteudo(0));
        }
    }

    private void calculaTamanhoMaxCols() {
        Dimension tam;
        int i;
        ElementoTabela elem;
        Iterator it = ((Codigo)this.campo).getColecaoElementoTabela().iterator();
        if (it.hasNext()) {
            elem = (ElementoTabela)it.next();
            this.tamCols = new Dimension[elem.size()];
            i = 0;
            while (i < this.tamCols.length) {
                tam = new JLabel(elem.getConteudo(i)).getPreferredSize();
                if (this.tamCols[i] == null || this.tamCols[i].width < tam.width) {
                    this.tamCols[i] = tam;
                    this.tamCols[i].width += 5;
                }
                ++i;
            }
        }
        while (it.hasNext()) {
            elem = (ElementoTabela)it.next();
            i = 0;
            while (i < this.tamCols.length) {
                tam = new JLabel(elem.getConteudo(i)).getPreferredSize();
                if (this.tamCols[i] == null || this.tamCols[i].width < tam.width) {
                    this.tamCols[i] = tam;
                    this.tamCols[i].width += 5;
                }
                ++i;
            }
        }
    }

    @Override
    protected void readOnlyPropertyChange(boolean readOnly) {
        this.combo.setEnabled(!readOnly);
    }

    @Override
    protected void habilitadoPropertyChange(boolean habilitado) {
        this.combo.setEnabled(habilitado);
    }

    public Border getBordaColunas() {
        Border borda = null;
        int qtdColsVisiveis = 0;
        int i = 0;
        while (i < this.colsVisiveis.length) {
            if (this.colsVisiveis[i]) {
                ++qtdColsVisiveis;
            }
            ++i;
        }
        borda = qtdColsVisiveis > 1 ? this.bordaColunas : this.bordaVazia;
        return borda;
    }

    public void setBordaColunas(Border bordaColunas) {
        this.bordaColunas = bordaColunas;
    }

    @Override
    public void setEstiloFonte(int estilo) {
        Font f = this.combo.getFont();
        f = f.deriveFont(estilo);
        this.combo.setFont(f);
    }

    @Override
    public void setIncrementoTamanhoFonte(int incremento) {
        this.incrementoTamanhoFonte = incremento;
        Font f = this.combo.getFont();
        if (this.tamanhoOriginal == -1.0f) {
            this.tamanhoOriginal = f.getSize2D();
        }
        f = f.deriveFont(this.tamanhoOriginal + (float)incremento);
        this.combo.setFont(f);
    }

    @Override
    public int getIncrementoTamanhoFonte() {
        return this.incrementoTamanhoFonte;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        String acessivel;
        if (e.isControlDown() && e.getKeyCode() == 83 && Boolean.valueOf(acessivel = FabricaUtilitarios.getProperties().getProperty("aplicacao.acessivel.habilitado")).booleanValue()) {
            JDialogEditCampoLeitor dialog = new JDialogEditCampoLeitor(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), this);
            dialog.setVisible(false);
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    class KeySelectionCustomizado
    implements JComboBox.KeySelectionManager {
        long ultimaVez = 0L;
        String filtro = "";

        public int selectionForKey(char aKey, ComboBoxModel aModel) {
            int itemSelecionado = -1;
            int colunaFiltro = ((Codigo)JEditCodigo.this.getInformacao()).getColunaFiltro();
            if (colunaFiltro < 0) {
                LogPPGD.erro((String)"N\u00e3o foi especificada nenhuma coluna-filtro para o Combo!");
                LogPPGD.erro((String)"N\u00e3o ser\u00e1 poss\u00edvel fazer filtragem por teclado");
                LogPPGD.erro((String)"");
            } else {
                long atual = System.currentTimeMillis();
                long diferenca = atual - this.ultimaVez;
                if (diferenca < 500L) {
                    this.filtro = String.valueOf(this.filtro) + aKey;
                    itemSelecionado = this.tentaSelecionar(aModel);
                } else {
                    this.filtro = "";
                    this.filtro = String.valueOf(this.filtro) + aKey;
                    itemSelecionado = this.tentaSelecionar(aModel);
                }
                this.ultimaVez = atual;
                if (this.filtro.length() > 100) {
                    this.filtro = "";
                }
            }
            return itemSelecionado;
        }

        private synchronized int tentaSelecionar(ComboBoxModel aModel) {
            int total = aModel.getSize();
            int colunaFiltro = ((Codigo)JEditCodigo.this.getInformacao()).getColunaFiltro();
            int itemSelecionado = -1;
            String upperFiltro = this.filtro.toUpperCase();
            int i = 0;
            while (i < total) {
                ElementoTabela elem = (ElementoTabela)aModel.getElementAt(i);
                String item = UtilitariosString.removeAcentos((String)elem.getConteudo(colunaFiltro));
                if (item.toUpperCase().startsWith(upperFiltro)) {
                    itemSelecionado = i;
                    break;
                }
                ++i;
            }
            return itemSelecionado;
        }
    }
}

