/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.xbeans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import serpro.ppgd.gui.editors.PPGDTextField;
import serpro.ppgd.gui.xbeans.JButtonMensagem;
import serpro.ppgd.gui.xbeans.JEditCampoTextoAbstract;
import serpro.ppgd.gui.xbeans.PainelBotao;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;

public class JEditAlfa
extends JEditCampoTextoAbstract {
    private JTextField componente;
    private int maxChars = 100;

    public JEditAlfa() {
        super((Informacao)new Alfa("EditAlfa"));
    }

    public JEditAlfa(Informacao campo, int aMaxChars) {
        super(campo);
        this.setMaxChars(aMaxChars);
    }

    protected void informacaoModificada() {
        ((PPGDTextField)this.componente).setInformacao(this.campo);
        if (this.campo instanceof Alfa && ((Alfa)this.campo).getMaximoCaracteres() != 1) {
            this.setMaxChars(((Alfa)this.campo).getMaximoCaracteres());
        }
        this.implementacaoPropertyChange(null);
    }

    public void setarCampo() {
        String s = this.componente.getText();
        if (s.length() > this.getMaxChars()) {
            s = s.substring(0, this.getMaxChars());
        }
        this.getInformacao().setConteudo(s);
        this.chamaValidacao();
    }

    public JComponent getComponenteEditor() {
        return this.componente;
    }

    public void implementacaoPropertyChange(PropertyChangeEvent evt) {
        this.componente.setText(this.getInformacao().getConteudoFormatado());
        this.componente.setCaretPosition(0);
    }

    public JComponent getComponenteFoco() {
        return this.componente;
    }

    protected void buildComponente() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        if (this.componente == null) {
            this.componente = new PPGDTextField();
            this.componente.setColumns(10);
            this.componente.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (e.getOppositeComponent() == null) {
                        return;
                    }
                    JEditAlfa.this.setIdentificacaoFoco(false);
                    if (!JEditAlfa.this.getInformacao().getListaValidadoresImpeditivos().isEmpty() && !JEditAlfa.this.verificaValidacoesImpeditivas(JEditAlfa.this.componente.getText())) {
                        return;
                    }
                    JEditAlfa.this.setarCampo();
                }

                public void focusGained(FocusEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JEditAlfa.this.componente.selectAll();
                        }
                    });
                }
            });
            this.componente.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JEditAlfa.this.setarCampo();
                }
            });
            this.componente.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    int tamanhoTextoAtual;
                    boolean eventosEhInclusao;
                    char ch = e.getKeyChar();
                    boolean bl = eventosEhInclusao = ch != '\t' && ch != '\n' && ch != '\b' && ch != '\u007f' && ch != '%' && ch != '\'';
                    if (ch == '\'') {
                        eventosEhInclusao = true;
                    }
                    if ((tamanhoTextoAtual = JEditAlfa.this.componente.getText().length()) >= JEditAlfa.this.getMaxChars() && eventosEhInclusao && JEditAlfa.this.componente.getSelectedText() == null) {
                        e.setKeyChar('\uffff');
                        e.consume();
                        UIManager.getLookAndFeel().provideErrorFeedback(JEditAlfa.this.componente);
                    }
                }
            });
        }
        this.add((Component)this.componente, "Center");
        JButtonMensagem btnMsg = this.getButtonMensagem();
        if (btnMsg != null) {
            this.add((Component)new PainelBotao(btnMsg), "East");
        }
    }

    public void setMaxChars(int maxChars) {
        this.maxChars = maxChars;
    }

    public int getMaxChars() {
        if (this.getInformacao() instanceof Alfa && ((Alfa)this.getInformacao()).getMaximoCaracteres() > 1) {
            return ((Alfa)this.getInformacao()).getMaximoCaracteres();
        }
        return this.maxChars;
    }
}

