/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendpj;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendpj.ColecaoRendPJTitular;
import serpro.ppgd.irpf.rendpj.RendPJDependente;
import serpro.ppgd.negocio.ObjetoNegocio;

public class ColecaoRendPJDependente
extends ColecaoRendPJTitular {
    private WeakReference declaracaoRef = null;

    public ColecaoRendPJDependente(DeclaracaoIRPF declaracaoIRPF) {
        super(RendPJDependente.class.getName(), declaracaoIRPF.getIdentificadorDeclaracao());
        this.declaracaoRef = new WeakReference<DeclaracaoIRPF>(declaracaoIRPF);
        this.setFicha("Rendimentos Tribut\u00e1veis Recebidos de PJ pelos Dependentes");
    }

    @Override
    public ObjetoNegocio instanciaNovoObjeto() {
        DeclaracaoIRPF declaracaoIRPF = (DeclaracaoIRPF)((Object)this.declaracaoRef.get());
        return new RendPJDependente(declaracaoIRPF);
    }

    public boolean possuiDependenteComCPF(String string) {
        if ("".equals(string.trim())) {
            return false;
        }
        for (RendPJDependente rendPJDependente : this.recuperarLista()) {
            if (!rendPJDependente.getCpfDependente().asString().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void excluirDependentesComCPF(String string) {
        Iterator iterator = this.recuperarLista().iterator();
        while (iterator.hasNext()) {
            RendPJDependente rendPJDependente = (RendPJDependente)((Object)iterator.next());
            if (!rendPJDependente.getCpfDependente().asString().equals(string)) continue;
            iterator.remove();
        }
    }
}

