/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRCommonGraphicElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterNature;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.data.BooleanTextValue;
import net.sf.jasperreports.engine.export.data.DateTextValue;
import net.sf.jasperreports.engine.export.data.NumberTextValue;
import net.sf.jasperreports.engine.export.data.StringTextValue;
import net.sf.jasperreports.engine.export.data.TextValue;
import net.sf.jasperreports.engine.export.data.TextValueHandler;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import org.apache.commons.collections.ReferenceMap;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.hssf.util.Region;

public class JRXlsExporter
extends JRXlsAbstractExporter {
    private static Map hssfColorsCache = new ReferenceMap();
    protected Map loadedCellStyles = new HashMap();
    protected HSSFWorkbook workbook = null;
    protected HSSFSheet sheet = null;
    protected HSSFRow row = null;
    protected HSSFCell cell = null;
    protected HSSFCellStyle emptyCellStyle = null;
    protected short whiteIndex = new HSSFColor.WHITE().getIndex();
    protected short blackIndex = new HSSFColor.BLACK().getIndex();
    protected short backgroundMode = 1;
    protected HSSFDataFormat dataFormat = null;
    protected Map formatPatternsMap = null;
    protected ExporterNature nature = null;

    protected void setParameters() {
        super.setParameters();
        this.formatPatternsMap = (Map)this.getParameter(JRXlsExporterParameter.FORMAT_PATTERNS_MAP);
        this.nature = new JRXlsExporterNature(this.filter, this.isIgnoreGraphics);
    }

    protected void setBackground() {
        if (!this.isWhitePageBackground) {
            this.backgroundMode = 0;
        }
    }

    protected void openWorkbook(OutputStream os) {
        this.workbook = new HSSFWorkbook();
        this.emptyCellStyle = this.workbook.createCellStyle();
        this.emptyCellStyle.setFillForegroundColor(new HSSFColor.WHITE().getIndex());
        this.emptyCellStyle.setFillPattern(this.backgroundMode);
        this.dataFormat = this.workbook.createDataFormat();
    }

    protected void createSheet(String name) {
        this.sheet = this.workbook.createSheet(name);
    }

    protected void closeWorkbook(OutputStream os) throws JRException {
        try {
            this.workbook.write(os);
        }
        catch (IOException e) {
            throw new JRException("Error generating XLS report : " + this.jasperPrint.getName(), e);
        }
    }

    protected void setColumnWidth(int col, int width) {
        this.sheet.setColumnWidth((short)col, (short)width);
    }

    protected void setRowHeight(int rowIndex, int lastRowHeight) {
        this.row = this.sheet.getRow(rowIndex);
        if (this.row == null) {
            this.row = this.sheet.createRow(rowIndex);
        }
        this.row.setHeightInPoints((float)lastRowHeight);
    }

    protected void setCell(int colIndex, int rowIndex) {
        HSSFCell emptyCell = this.row.getCell((short)colIndex);
        if (emptyCell == null) {
            emptyCell = this.row.createCell((short)colIndex);
            emptyCell.setCellStyle(this.emptyCellStyle);
        }
    }

    protected void removeColumn(int colIndex) {
        this.sheet.setColumnHidden((short)colIndex, true);
    }

    protected void addBlankCell(JRExporterGridCell gridCell, int colIndex, int rowIndex) {
        this.cell = this.row.createCell((short)colIndex);
        short mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (gridCell.getCellBackcolor() != null) {
            mode = 1;
            backcolor = JRXlsExporter.getNearestColor(gridCell.getCellBackcolor()).getIndex();
        }
        short forecolor = this.blackIndex;
        if (gridCell.getForecolor() != null) {
            forecolor = JRXlsExporter.getNearestColor(gridCell.getForecolor()).getIndex();
        }
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, (short)1, (short)0, (short)0, this.getLoadedFont(this.getDefaultFont(), forecolor), gridCell);
        this.cell.setCellStyle(cellStyle);
    }

    protected void exportLine(JRPrintLine line, JRExporterGridCell gridCell, int colIndex, int rowIndex) {
        short forecolor = JRXlsExporter.getNearestColor(line.getLinePen().getLineColor()).getIndex();
        HSSFCellStyle cellStyle = this.getLoadedCellStyle((short)1, forecolor, (short)1, (short)0, (short)0, this.getLoadedFont(this.getDefaultFont(), forecolor), gridCell);
        this.createMergeRegion(gridCell, colIndex, rowIndex, cellStyle);
        this.cell = this.row.createCell((short)colIndex);
        this.cell.setCellStyle(cellStyle);
    }

    protected void exportRectangle(JRPrintGraphicElement element, JRExporterGridCell gridCell, int colIndex, int rowIndex) {
        short forecolor = JRXlsExporter.getNearestColor(element.getLinePen().getLineColor()).getIndex();
        short mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (gridCell.getCellBackcolor() != null) {
            mode = 1;
            backcolor = JRXlsExporter.getNearestColor(gridCell.getCellBackcolor()).getIndex();
        }
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, (short)1, (short)0, (short)0, this.getLoadedFont(this.getDefaultFont(), forecolor), gridCell);
        this.createMergeRegion(gridCell, colIndex, rowIndex, cellStyle);
        this.cell = this.row.createCell((short)colIndex);
        this.cell.setCellStyle(cellStyle);
    }

    protected void exportText(JRPrintText textElement, JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        JRStyledText styledText = this.getStyledText(textElement);
        if (styledText == null) {
            return;
        }
        short forecolor = JRXlsExporter.getNearestColor(textElement.getForecolor()).getIndex();
        JRXlsAbstractExporter.TextAlignHolder textAlignHolder = JRXlsExporter.getTextAlignHolder(textElement);
        short horizontalAlignment = this.getHorizontalAlignment(textAlignHolder);
        short verticalAlignment = this.getVerticalAlignment(textAlignHolder);
        short rotation = this.getRotation(textAlignHolder);
        short mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (gridCell.getCellBackcolor() != null) {
            mode = 1;
            backcolor = JRXlsExporter.getNearestColor(gridCell.getCellBackcolor()).getIndex();
        }
        StyleInfo baseStyle = new StyleInfo(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, this.getLoadedFont(textElement, forecolor), gridCell);
        this.createTextCell(textElement, gridCell, colIndex, rowIndex, styledText, baseStyle);
    }

    protected void createTextCell(JRPrintText textElement, final JRExporterGridCell gridCell, final int colIndex, final int rowIndex, JRStyledText styledText, final StyleInfo baseStyle) throws JRException {
        String textStr = styledText.getText();
        if (this.isDetectCellType) {
            TextValue value = this.getTextValue(textElement, textStr);
            value.handle(new TextValueHandler(){

                public void handle(StringTextValue textValue) {
                    HSSFCellStyle cellStyle = JRXlsExporter.this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
                    JRXlsExporter.this.setStringCellValue(textValue.getText());
                    JRXlsExporter.this.endCreateCell(cellStyle);
                }

                public void handle(NumberTextValue textValue) {
                    if (textValue.getPattern() != null) {
                        baseStyle.setDataFormat(JRXlsExporter.this.dataFormat.getFormat(this.getConvertedPattern(textValue.getPattern())));
                    }
                    HSSFCellStyle cellStyle = JRXlsExporter.this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
                    if (textValue.getValue() == null) {
                        JRXlsExporter.this.cell.setCellType(3);
                    } else {
                        JRXlsExporter.this.cell.setCellValue(textValue.getValue().doubleValue());
                    }
                    JRXlsExporter.this.endCreateCell(cellStyle);
                }

                public void handle(DateTextValue textValue) {
                    baseStyle.setDataFormat(JRXlsExporter.this.dataFormat.getFormat(this.getConvertedPattern(textValue.getPattern())));
                    HSSFCellStyle cellStyle = JRXlsExporter.this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
                    if (textValue.getValue() == null) {
                        JRXlsExporter.this.cell.setCellType(3);
                    } else {
                        JRXlsExporter.this.cell.setCellValue(textValue.getValue());
                    }
                    JRXlsExporter.this.endCreateCell(cellStyle);
                }

                public void handle(BooleanTextValue textValue) {
                    HSSFCellStyle cellStyle = JRXlsExporter.this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
                    if (textValue.getValue() == null) {
                        JRXlsExporter.this.cell.setCellType(3);
                    } else {
                        JRXlsExporter.this.cell.setCellValue(textValue.getValue().booleanValue());
                    }
                    JRXlsExporter.this.endCreateCell(cellStyle);
                }

                private String getConvertedPattern(String pattern) {
                    if (JRXlsExporter.this.formatPatternsMap != null && JRXlsExporter.this.formatPatternsMap.containsKey(pattern)) {
                        return (String)JRXlsExporter.this.formatPatternsMap.get(pattern);
                    }
                    return pattern;
                }
            });
        } else if (this.isAutoDetectCellType) {
            HSSFCellStyle cellStyle = this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
            try {
                this.cell.setCellValue(Double.parseDouble(textStr));
            }
            catch (NumberFormatException e) {
                this.setStringCellValue(textStr);
            }
            this.endCreateCell(cellStyle);
        } else {
            HSSFCellStyle cellStyle = this.initCreateCell(gridCell, colIndex, rowIndex, baseStyle);
            this.setStringCellValue(textStr);
            this.endCreateCell(cellStyle);
        }
    }

    protected HSSFCellStyle initCreateCell(JRExporterGridCell gridCell, int colIndex, int rowIndex, StyleInfo baseStyle) {
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(baseStyle);
        this.createMergeRegion(gridCell, colIndex, rowIndex, cellStyle);
        this.cell = this.row.createCell((short)colIndex);
        this.cell.setEncoding((short)1);
        return cellStyle;
    }

    protected void endCreateCell(HSSFCellStyle cellStyle) {
        this.cell.setCellStyle(cellStyle);
    }

    protected final void setStringCellValue(String textStr) {
        this.cell.setCellValue(JRStringUtil.replaceDosEOL(textStr));
    }

    protected void createMergeRegion(JRExporterGridCell gridCell, int colIndex, int rowIndex, HSSFCellStyle cellStyle) {
        if (gridCell.getColSpan() > 1 || gridCell.getRowSpan() > 1) {
            if (this.isCollapseRowSpan) {
                this.sheet.addMergedRegion(new Region(rowIndex, (short)colIndex, rowIndex, (short)(colIndex + gridCell.getColSpan() - 1)));
            } else {
                this.sheet.addMergedRegion(new Region(rowIndex, (short)colIndex, rowIndex + gridCell.getRowSpan() - 1, (short)(colIndex + gridCell.getColSpan() - 1)));
            }
            for (int i = 0; i < gridCell.getRowSpan(); ++i) {
                HSSFRow spanRow = this.sheet.getRow(rowIndex + i);
                if (spanRow == null) {
                    spanRow = this.sheet.createRow(rowIndex + i);
                }
                for (int j = 0; j < gridCell.getColSpan(); ++j) {
                    HSSFCell spanCell = spanRow.getCell((short)(colIndex + j));
                    if (spanCell == null) {
                        spanCell = spanRow.createCell((short)(colIndex + j));
                    }
                    spanCell.setCellStyle(cellStyle);
                }
            }
        }
    }

    private short getHorizontalAlignment(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.horizontalAlignment) {
            case 3: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 5;
            }
        }
        return 1;
    }

    private short getVerticalAlignment(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.verticalAlignment) {
            case 3: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 3;
            }
        }
        return 0;
    }

    private short getRotation(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.rotation) {
            case 1: {
                return 90;
            }
            case 2: {
                return -90;
            }
        }
        return 0;
    }

    protected static HSSFColor getNearestColor(Color awtColor) {
        HSSFColor color = (HSSFColor)hssfColorsCache.get(awtColor);
        if (color == null) {
            Set keys;
            Hashtable triplets = HSSFColor.getTripletHash();
            if (triplets != null && (keys = triplets.keySet()) != null && keys.size() > 0) {
                Object key = null;
                HSSFColor crtColor = null;
                short[] rgb = null;
                int diff = 0;
                int minDiff = 999;
                Iterator it = keys.iterator();
                while (it.hasNext()) {
                    key = it.next();
                    crtColor = (HSSFColor)triplets.get(key);
                    rgb = crtColor.getTriplet();
                    diff = Math.abs(rgb[0] - awtColor.getRed()) + Math.abs(rgb[1] - awtColor.getGreen()) + Math.abs(rgb[2] - awtColor.getBlue());
                    if (diff >= minDiff) continue;
                    minDiff = diff;
                    color = crtColor;
                }
            }
            hssfColorsCache.put(awtColor, color);
        }
        return color;
    }

    protected HSSFFont getLoadedFont(JRFont font, short forecolor) {
        HSSFFont cellFont = null;
        String fontName = font.getFontName();
        if (this.fontMap != null && this.fontMap.containsKey(fontName)) {
            fontName = (String)this.fontMap.get(fontName);
        }
        for (int i = 0; i < this.loadedFonts.size(); ++i) {
            HSSFFont cf = (HSSFFont)this.loadedFonts.get(i);
            short fontSize = (short)font.getFontSize();
            if (this.isFontSizeFixEnabled) {
                fontSize = (short)(fontSize - 1);
            }
            if (!cf.getFontName().equals(fontName) || cf.getColor() != forecolor || cf.getFontHeightInPoints() != fontSize || !(cf.getUnderline() == 1 ? font.isUnderline() : !font.isUnderline()) || cf.getStrikeout() != font.isStrikeThrough() || !(cf.getBoldweight() == 700 ? font.isBold() : !font.isBold()) || cf.getItalic() != font.isItalic()) continue;
            cellFont = cf;
            break;
        }
        if (cellFont == null) {
            cellFont = this.workbook.createFont();
            cellFont.setFontName(fontName);
            cellFont.setColor(forecolor);
            short fontSize = (short)font.getFontSize();
            if (this.isFontSizeFixEnabled) {
                fontSize = (short)(fontSize - 1);
            }
            cellFont.setFontHeightInPoints(fontSize);
            if (font.isUnderline()) {
                cellFont.setUnderline((byte)1);
            }
            if (font.isStrikeThrough()) {
                cellFont.setStrikeout(true);
            }
            if (font.isBold()) {
                cellFont.setBoldweight((short)700);
            }
            if (font.isItalic()) {
                cellFont.setItalic(true);
            }
            this.loadedFonts.add(cellFont);
        }
        return cellFont;
    }

    protected HSSFCellStyle getLoadedCellStyle(StyleInfo style) {
        HSSFCellStyle cellStyle = (HSSFCellStyle)this.loadedCellStyles.get(style);
        if (cellStyle == null) {
            cellStyle = this.workbook.createCellStyle();
            cellStyle.setFillForegroundColor(style.backcolor);
            cellStyle.setFillPattern(style.mode);
            cellStyle.setAlignment(style.horizontalAlignment);
            cellStyle.setVerticalAlignment(style.verticalAlignment);
            cellStyle.setRotation(style.rotation);
            cellStyle.setFont(style.font);
            cellStyle.setWrapText(true);
            if (style.hasDataFormat()) {
                cellStyle.setDataFormat(style.getDataFormat());
            }
            if (!this.isIgnoreCellBorder) {
                BoxStyle box = style.box;
                cellStyle.setBorderTop(box.topBorder);
                cellStyle.setTopBorderColor(box.topBorderColour);
                cellStyle.setBorderLeft(box.leftBorder);
                cellStyle.setLeftBorderColor(box.leftBorderColour);
                cellStyle.setBorderBottom(box.bottomBorder);
                cellStyle.setBottomBorderColor(box.bottomBorderColour);
                cellStyle.setBorderRight(box.rightBorder);
                cellStyle.setRightBorderColor(box.rightBorderColour);
            }
            this.loadedCellStyles.put(style, cellStyle);
        }
        return cellStyle;
    }

    protected HSSFCellStyle getLoadedCellStyle(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, JRExporterGridCell gridCell) {
        StyleInfo style = new StyleInfo(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, gridCell);
        return this.getLoadedCellStyle(style);
    }

    protected static short getBorder(JRPen pen) {
        float lineWidth = pen.getLineWidth().floatValue();
        if (lineWidth > 0.0f) {
            switch (pen.getLineStyle()) {
                case 1: {
                    return 3;
                }
            }
            if (lineWidth >= 2.0f) {
                return 5;
            }
            if (lineWidth >= 1.0f) {
                return 2;
            }
            if (lineWidth >= 0.5f) {
                return 1;
            }
            return 4;
        }
        return 0;
    }

    protected void exportImage(JRPrintImage image, JRExporterGridCell gridCell, int colIndex, int rowIndex, int emptyCols) {
    }

    protected void exportFrame(JRPrintFrame frame, JRExporterGridCell gridCell, int x, int y) {
        short mode = this.backgroundMode;
        short backcolor = this.whiteIndex;
        if (frame.getMode() == 1) {
            mode = 1;
            backcolor = JRXlsExporter.getNearestColor(frame.getBackcolor()).getIndex();
        }
        short forecolor = JRXlsExporter.getNearestColor(frame.getForecolor()).getIndex();
        HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, (short)1, (short)0, (short)0, this.getLoadedFont(this.getDefaultFont(), forecolor), gridCell);
        this.createMergeRegion(gridCell, x, y, cellStyle);
        this.cell = this.row.createCell((short)x);
        this.cell.setCellStyle(cellStyle);
    }

    protected ExporterNature getNature() {
        return this.nature;
    }

    protected static class StyleInfo {
        protected final short mode;
        protected final short backcolor;
        protected final short horizontalAlignment;
        protected final short verticalAlignment;
        protected final short rotation;
        protected final HSSFFont font;
        protected final BoxStyle box = new BoxStyle();
        private short dataFormat = (short)-1;
        private int hashCode;

        public StyleInfo(short mode, short backcolor, short horizontalAlignment, short verticalAlignment, short rotation, HSSFFont font, JRExporterGridCell gridCell) {
            JRPrintElement element;
            this.mode = mode;
            this.backcolor = backcolor;
            this.horizontalAlignment = horizontalAlignment;
            this.verticalAlignment = verticalAlignment;
            this.rotation = rotation;
            this.font = font;
            JRLineBox lineBox = gridCell.getBox();
            if (lineBox != null) {
                this.box.setBox(lineBox);
            }
            if ((element = gridCell.getElement()) instanceof JRCommonGraphicElement) {
                this.box.setPen(((JRCommonGraphicElement)((Object)element)).getLinePen());
            }
            this.hashCode = this.computeHash();
        }

        protected int computeHash() {
            int hash = this.mode;
            hash = 31 * hash + this.backcolor;
            hash = 31 * hash + this.horizontalAlignment;
            hash = 31 * hash + this.verticalAlignment;
            hash = 31 * hash + this.rotation;
            hash = 31 * hash + (this.font == null ? 0 : (int)this.font.getIndex());
            hash = 31 * hash + (this.box == null ? 0 : this.box.hashCode());
            hash = 31 * hash + this.dataFormat;
            return hash;
        }

        public void setDataFormat(short dataFormat) {
            this.dataFormat = dataFormat;
            this.hashCode = this.computeHash();
        }

        public boolean hasDataFormat() {
            return this.dataFormat != -1;
        }

        public short getDataFormat() {
            return this.dataFormat;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            StyleInfo s = (StyleInfo)o;
            return s.mode == this.mode && s.backcolor == this.backcolor && s.horizontalAlignment == this.horizontalAlignment && s.verticalAlignment == this.verticalAlignment && s.rotation == this.rotation && (s.font == null ? this.font == null : this.font != null && s.font.getIndex() == this.font.getIndex()) && (s.box == null ? this.box == null : this.box != null && s.box.equals(this.box)) && s.rotation == this.rotation;
        }

        public String toString() {
            return "(" + this.mode + "," + this.backcolor + "," + this.horizontalAlignment + "," + this.verticalAlignment + "," + this.rotation + "," + this.font + "," + this.box + "," + this.dataFormat + ")";
        }
    }

    protected static class BoxStyle {
        protected short topBorder;
        protected short bottomBorder;
        protected short leftBorder;
        protected short rightBorder;
        protected short topBorderColour;
        protected short bottomBorderColour;
        protected short leftBorderColour;
        protected short rightBorderColour;
        private int hash = this.computeHash();

        public void setBox(JRLineBox box) {
            this.topBorder = JRXlsExporter.getBorder(box.getTopPen());
            this.topBorderColour = JRXlsExporter.getNearestColor(box.getTopPen().getLineColor()).getIndex();
            this.bottomBorder = JRXlsExporter.getBorder(box.getBottomPen());
            this.bottomBorderColour = JRXlsExporter.getNearestColor(box.getBottomPen().getLineColor()).getIndex();
            this.leftBorder = JRXlsExporter.getBorder(box.getLeftPen());
            this.leftBorderColour = JRXlsExporter.getNearestColor(box.getLeftPen().getLineColor()).getIndex();
            this.rightBorder = JRXlsExporter.getBorder(box.getRightPen());
            this.rightBorderColour = JRXlsExporter.getNearestColor(box.getRightPen().getLineColor()).getIndex();
            this.hash = this.computeHash();
        }

        public void setPen(JRPen pen) {
            if (this.topBorder == 0 && this.leftBorder == 0 && this.bottomBorder == 0 && this.rightBorder == 0) {
                this.topBorder = JRXlsExporter.getBorder(pen);
                this.topBorderColour = JRXlsExporter.getNearestColor(pen.getLineColor()).getIndex();
                this.bottomBorder = this.topBorder;
                this.bottomBorderColour = this.topBorderColour;
                this.leftBorder = this.topBorder;
                this.leftBorderColour = this.topBorderColour;
                this.rightBorder = this.topBorder;
                this.rightBorderColour = this.topBorderColour;
            }
            this.hash = this.computeHash();
        }

        private int computeHash() {
            int hashCode = this.topBorder;
            hashCode = 31 * hashCode + this.topBorderColour;
            hashCode = 31 * hashCode + this.bottomBorder;
            hashCode = 31 * hashCode + this.bottomBorderColour;
            hashCode = 31 * hashCode + this.leftBorder;
            hashCode = 31 * hashCode + this.leftBorderColour;
            hashCode = 31 * hashCode + this.rightBorder;
            hashCode = 31 * hashCode + this.rightBorderColour;
            return hashCode;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            BoxStyle b = (BoxStyle)o;
            return b.topBorder == this.topBorder && b.topBorderColour == this.topBorderColour && b.bottomBorder == this.bottomBorder && b.bottomBorderColour == this.bottomBorderColour && b.leftBorder == this.leftBorder && b.leftBorderColour == this.leftBorderColour && b.rightBorder == this.rightBorder && b.rightBorderColour == this.rightBorderColour;
        }

        public String toString() {
            return "(" + this.topBorder + "/" + this.topBorderColour + "," + this.bottomBorder + "/" + this.bottomBorderColour + "," + this.leftBorder + "/" + this.leftBorderColour + "," + this.rightBorder + "/" + this.rightBorderColour + ")";
        }
    }
}

