/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.infraestrutura.treeview;

import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import serpro.ppgd.gui.UtilitariosGUI;
import serpro.ppgd.infraestrutura.acoes.AcaoMudaPainel;
import serpro.ppgd.infraestrutura.treeview.NoGenerico;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;

public class ArvoreGenerica
extends JTree {
    protected DefaultMutableTreeNode raizTree;
    protected Map<String, NoGenerico> vctNos;
    protected Map<String, NoGenerico> vctNosEscondidos;
    protected Map<String, String> vctListaOrdenadaDeRotulos = new Hashtable<String, String>();
    protected int TAM_MIN = 25;
    protected String nodoInicial = "";
    private boolean minimizado = false;
    private String labelRaiz;
    private int tamanhoMaximo = 0;
    private int tamanhoMinimo = 0;

    public ArvoreGenerica() {
        super(new NoGenerico("", null));
        this.vctNos = new Hashtable<String, NoGenerico>();
        this.vctNosEscondidos = new Hashtable<String, NoGenerico>();
        this.raizTree = (DefaultMutableTreeNode)this.getModel().getRoot();
        this.setToggleClickCount(1);
        this.getSelectionModel().setSelectionMode(1);
        this.setFocusable(false);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void setFonteDados(String pXml) {
        Document definicoes = FabricaUtilitarios.carregarDOM((String)pXml);
        Element raiz = definicoes.getDocumentElement();
        if (raiz.getNodeName().trim().equalsIgnoreCase("arvore")) {
            try {
                String labelRaiz = raiz.getAttribute("labelRaiz");
                String tamanhoMaximo = raiz.getAttribute("tamanhoMaximo");
                String tamanhoMinimo = raiz.getAttribute("tamanhoMinimo");
                String classeCellRenderer = raiz.getAttribute("cellRenderer");
                String classeTreeSelectionListener = raiz.getAttribute("treeSelectionListener");
                String iconeExpandido = raiz.getAttribute("iconeExpandido");
                String iconeContraido = raiz.getAttribute("iconeContraido");
                String cellEditor = raiz.getAttribute("cellEditor");
                String editable = raiz.getAttribute("editable");
                if (labelRaiz != null && labelRaiz.trim().length() > 0) {
                    ((NoGenerico)this.raizTree).setActionHabilitado(false);
                    ((NoGenerico)this.raizTree).setLabel(labelRaiz);
                    if (iconeExpandido.length() != 0) {
                        ((NoGenerico)this.raizTree).setIconeExpandido(iconeExpandido);
                    }
                    if (iconeContraido.length() != 0) {
                        ((NoGenerico)this.raizTree).setIconeContraido(iconeContraido);
                    }
                    this.raizTree.setUserObject(labelRaiz);
                } else {
                    super.setRootVisible(false);
                    this.putClientProperty("JTree.lineStyle", "None");
                    ((NoGenerico)this.raizTree).setActionHabilitado(false);
                    String iconeVazio = "imagens/ico_vazio.gif";
                    ((NoGenerico)this.raizTree).setIconeExpandido(iconeVazio);
                    ((NoGenerico)this.raizTree).setIconeContraido(iconeVazio);
                    this.raizTree.setUserObject(labelRaiz);
                }
                if (tamanhoMaximo != null && tamanhoMaximo.trim().length() > 0) {
                    this.setTamanhoMaximo(Integer.parseInt(tamanhoMaximo));
                }
                if (tamanhoMinimo != null && tamanhoMaximo.trim().length() > 0) {
                    this.setTamanhoMinimo(Integer.parseInt(tamanhoMinimo));
                }
                if (cellEditor != null && cellEditor.trim().length() > 0) {
                    try {
                        Class<?> classeCellEditor = Class.forName(cellEditor);
                        TreeCellEditor treeCellEditor = (TreeCellEditor)classeCellEditor.newInstance();
                        this.setCellEditor(treeCellEditor);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (editable != null && editable.trim().length() > 0) {
                    if (editable.toLowerCase().equals("true")) {
                        this.setEditable(true);
                    } else {
                        this.setEditable(false);
                    }
                }
                try {
                    Constructor<?> construtor;
                    Class<?> classe;
                    Class[] argumentosFormais = new Class[]{JTree.class};
                    Object[] argumentosReais = new Object[]{this};
                    if (classeCellRenderer.trim().length() != 0) {
                        classe = Class.forName(classeCellRenderer);
                        construtor = classe.getConstructor(argumentosFormais);
                        Object cellRenderer = construtor.newInstance(argumentosReais);
                        this.setCellRenderer((TreeCellRenderer)cellRenderer);
                    }
                    if (classeTreeSelectionListener.trim().length() != 0) {
                        classe = Class.forName(classeTreeSelectionListener);
                        construtor = classe.getConstructor(argumentosFormais);
                        Object treeSelectionListener = construtor.newInstance(argumentosReais);
                        this.addTreeSelectionListener((TreeSelectionListener)treeSelectionListener);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalArgumentException("Erro na instancia\u00e7\u00e3o do CellRenderer ou do TreeSelectionListener " + e.getMessage());
                }
                this.obtemNodos(raiz, null);
            }
            catch (Exception e) {
                LogPPGD.erro((String)("Erro no carregamento da \u00e1rvore a partir do XML:" + e.getMessage()));
                e.printStackTrace();
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        throw new IllegalArgumentException("Tag <arvore> n\u00e3o encontrada");
        ((DefaultTreeModel)this.getModel()).nodeStructureChanged((DefaultMutableTreeNode)this.getModel().getRoot());
    }

    private void obtemNodos(Element element, NoGenerico idLinkPai) throws Exception {
        if (element.hasChildNodes()) {
            NodeList filhos = element.getChildNodes();
            for (int i = 0; i < filhos.getLength(); ++i) {
                NoGenerico idLinkAtual;
                Element elementFilho;
                if (filhos.item(i).getNodeType() != 1 || !(elementFilho = (Element)filhos.item(i)).getNodeName().trim().equalsIgnoreCase("nodo")) continue;
                String labelNodo = elementFilho.getAttribute("label");
                String classAction = elementFilho.getAttribute("action");
                String actionCmd = elementFilho.getAttribute("actionCommand");
                String painelStr = elementFilho.getAttribute("painel");
                String iconeExpandido = elementFilho.getAttribute("iconeExpandido");
                String iconeContraido = elementFilho.getAttribute("iconeContraido");
                String selecionado = elementFilho.getAttribute("selecionado");
                String tooltip = elementFilho.getAttribute("tooltip");
                String habilitado = elementFilho.getAttribute("enable");
                String valNodoInicial = elementFilho.getAttribute("nodoInicial");
                if (labelNodo.length() == 0) {
                    labelNodo = "Node";
                }
                Action action = null;
                if (classAction.length() == 0) {
                    idLinkAtual = new NoGenerico();
                    idLinkAtual.setLabel(labelNodo);
                } else {
                    action = classAction.equals("AcaoMudaPainel") ? new AcaoMudaPainel(painelStr) : (Action)Class.forName(classAction).newInstance();
                    idLinkAtual = new NoGenerico(labelNodo, action);
                }
                if (actionCmd.length() > 0) {
                    idLinkAtual.setActionCommand(actionCmd);
                }
                if (iconeExpandido.length() != 0) {
                    idLinkAtual.setIconeExpandido(iconeExpandido);
                }
                if (iconeContraido.length() != 0) {
                    idLinkAtual.setIconeContraido(iconeContraido);
                }
                if (valNodoInicial.length() != 0 || this.nodoInicial.trim().length() == 0) {
                    this.nodoInicial = labelNodo;
                }
                if (tooltip.trim().length() != 0) {
                    idLinkAtual.setTooltip(tooltip);
                }
                if (habilitado.trim().length() != 0) {
                    idLinkAtual.setActionHabilitado(habilitado.trim().equalsIgnoreCase("true"));
                }
                this.add(idLinkPai, idLinkAtual);
                if (selecionado.trim().equalsIgnoreCase("sim")) {
                    this.selecionarNodo(idLinkAtual.toString());
                }
                this.obtemNodos(elementFilho, idLinkAtual);
            }
        }
    }

    public String getRotuloNodo(String pActionCommand) {
        if (this.vctListaOrdenadaDeRotulos.containsKey(pActionCommand)) {
            return this.vctListaOrdenadaDeRotulos.get(pActionCommand);
        }
        return "";
    }

    public void add(NoGenerico topicoPai, NoGenerico topico) {
        this.vctListaOrdenadaDeRotulos.put(topico.getActionCommand(), topico.getNome());
        if (topicoPai == null) {
            this.raizTree.add(topico);
        } else {
            DefaultMutableTreeNode nodoPai = this.vctNos.get(topicoPai.toString());
            if (nodoPai == null) {
                nodoPai = this.vctNosEscondidos.get(topicoPai.toString());
            }
            if (nodoPai == null) {
                nodoPai = this.raizTree;
            }
            nodoPai.add(topico);
        }
        this.vctNos.put(topico.toString(), topico);
        ((DefaultTreeModel)this.getModel()).nodeStructureChanged(this.raizTree);
    }

    public void add(NoGenerico link) {
        this.raizTree.add(link);
        this.vctNos.put(link.toString(), link);
    }

    public void selecionaNodoInicial() {
        this.selecionarNodo(this.nodoInicial);
    }

    @Override
    public void setSelectionPath(TreePath pTree) {
        DefaultMutableTreeNode nodo = (DefaultMutableTreeNode)pTree.getLastPathComponent();
        if (nodo.getLevel() == 1) {
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(this.raizTree);
        } else if (nodo.getLevel() == 2) {
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(nodo.getParent());
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(this.raizTree);
        } else if (nodo.getLevel() == 3) {
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(nodo.getParent());
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(nodo.getParent().getParent());
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(this.raizTree);
        } else if (nodo.getLevel() == 4) {
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(nodo.getParent());
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(nodo.getParent().getParent());
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(nodo.getParent().getParent().getParent());
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(this.raizTree);
        }
        super.setSelectionPath(pTree);
    }

    public void preparaNavegador(JTree pTree, DefaultMutableTreeNode pUltimoNodo) {
    }

    public DefaultMutableTreeNode getRaiz() {
        return this.raizTree;
    }

    public Map<String, NoGenerico> getVctNos() {
        return this.vctNos;
    }

    public void setRaiz(DefaultMutableTreeNode node) {
        this.raizTree = node;
    }

    public void minimiza() {
        this.minimizado = true;
        this.setExpandsSelectedPaths(false);
        UtilitariosGUI.setParametrosGUI((JComponent)this, (int)this.getSize().width, (int)this.getTamanhoMinimo());
        this.collapseRow(0);
    }

    public void maximiza() {
        this.minimizado = false;
        this.setExpandsSelectedPaths(true);
        UtilitariosGUI.setParametrosGUI((JComponent)this, (int)this.getSize().width, (int)this.getTamanhoMaximo());
        this.expandRow(0);
    }

    public void esconde() {
        UtilitariosGUI.setParametrosGUI((JComponent)this, (int)0, (int)0);
    }

    public boolean isMinimizado() {
        return this.minimizado;
    }

    public void setMinimizado(boolean minimizado) {
        this.minimizado = minimizado;
    }

    public void selecionarNodo(String pLabelNodo) {
        if (this.vctNos.containsKey(pLabelNodo)) {
            NoGenerico nodo = this.vctNos.get(pLabelNodo);
            this.setSelectionPath(this.encontrarObjetoNaTree(nodo));
        }
    }

    public void removerNodo(String pLabelNodo) {
        if (this.vctNos.containsKey(pLabelNodo)) {
            NoGenerico nodo = this.vctNos.get(pLabelNodo);
            this.vctNos.remove(nodo.toString());
            ((DefaultTreeModel)this.getModel()).removeNodeFromParent(nodo);
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(this.raizTree);
        }
    }

    public void setNodoEnabled(String pLabelNodo, boolean pOpt) {
        if (this.vctNos.containsKey(pLabelNodo)) {
            NoGenerico nodo = this.vctNos.get(pLabelNodo);
            nodo.setActionHabilitado(pOpt);
            this.repaint();
        }
    }

    private void escondeNodo(String pLabelNodo) {
        if (this.vctNos.containsKey(pLabelNodo)) {
            NoGenerico nodo = this.vctNos.remove(pLabelNodo);
            ((DefaultTreeModel)this.getModel()).removeNodeFromParent(nodo);
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(this.raizTree);
            this.vctNosEscondidos.put(nodo.toString(), nodo);
        }
    }

    private void mostraNodo(String pLabelNodo) {
        if (this.vctNosEscondidos.containsKey(pLabelNodo)) {
            NoGenerico nodo = this.vctNosEscondidos.remove(pLabelNodo);
            NoGenerico nodoPai = (NoGenerico)nodo.getParent();
            if (nodoPai == null) {
                nodoPai = (NoGenerico)nodo.getOldParent();
            }
            this.add(nodoPai, nodo);
        }
    }

    public void setNodoVisivel(String pLabelNodo, boolean pVisivel) {
        if (pVisivel) {
            this.mostraNodo(pLabelNodo);
        } else {
            this.escondeNodo(pLabelNodo);
        }
    }

    public void escondeTodosNodos() {
        for (NoGenerico no : this.vctNos.values()) {
            this.escondeNodo(no.toString());
        }
    }

    public TreePath encontrarObjetoNaTree(Object object) {
        Enumeration<TreeNode> nodes = ((DefaultMutableTreeNode)this.getModel().getRoot()).preorderEnumeration();
        while (nodes.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes.nextElement();
            if (node.getUserObject() != object) continue;
            return new TreePath(node.getPath());
        }
        return null;
    }

    public int getTamanhoMaximo() {
        return this.tamanhoMaximo;
    }

    public void setTamanhoMaximo(int tamanhoMaximo) {
        this.tamanhoMaximo = tamanhoMaximo;
    }

    public int getTamanhoMinimo() {
        return this.tamanhoMinimo;
    }

    public void setTamanhoMinimo(int tamanhoMinimo) {
        this.tamanhoMinimo = tamanhoMinimo;
    }

    public String getLabelRaiz() {
        return this.labelRaiz;
    }

    public void setLabelRaiz(String labelRaiz) {
        this.labelRaiz = labelRaiz;
        this.raizTree.setUserObject(labelRaiz);
    }

    public DefaultMutableTreeNode getRaizTree() {
        return this.raizTree;
    }

    public void setRaizTree(DefaultMutableTreeNode raizTree) {
        this.raizTree = raizTree;
    }

    public void setCellRenderer(Constructor<?> c) {
        Object[] arg = new Object[]{this};
        try {
            this.setCellRenderer((TreeCellRenderer)c.newInstance(arg));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTreeSelectionListener(Constructor<?> c) {
        Object[] arg = new Object[]{this};
        try {
            this.addTreeSelectionListener((TreeSelectionListener)c.newInstance(arg));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getNodoInicial() {
        return this.nodoInicial;
    }

    public void setNodoInicial(String nodoInicial) {
        this.nodoInicial = nodoInicial;
    }
}

