/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio.validadoresBasicos;

import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;

public class ValidadorComparacao
extends ValidadorDefault {
    public static final byte DEVE_SER_IGUAL = 0;
    public static final byte DEVE_SER_DIFERENTE = 1;
    public static final byte DEVE_SER_MENOR = -2;
    public static final byte DEVE_SER_MENOR_OU_IGUAL = -3;
    public static final byte DEVE_SER_MAIOR = 2;
    public static final byte DEVE_SER_MAIOR_OU_IGUAL = 3;
    private byte regraValidacao = 1;

    public ValidadorComparacao(byte severidade) {
        super(severidade);
    }

    public ValidadorComparacao(byte severidade, byte regra, Object parValidacao) {
        super(severidade);
        this.regraValidacao = regra;
        this.setParValidacao(parValidacao);
    }

    public void setRegraValidacao(byte regra) {
        this.regraValidacao = regra;
    }

    @Override
    public RetornoValidacao validarImplementado() {
        String msg = null;
        int r = this.getInformacao().asString().compareTo(this.getParValidacao().toString());
        String nomeParValidacao = this.getParValidacao() instanceof Informacao ? ((Informacao)this.getParValidacao()).getNomeCampo() : this.getParValidacao().toString();
        switch (this.regraValidacao) {
            case 0: {
                if (r == 0) break;
                msg = "\"" + this.getInformacao().getNomeCampo() + " \u00e9 diferente de " + "\"" + nomeParValidacao;
                break;
            }
            case 1: {
                if (r != 0) break;
                msg = "\"" + this.getInformacao().getNomeCampo() + " \u00e9 igual de " + "\"" + nomeParValidacao;
                break;
            }
            case -2: {
                if (r < 0) break;
                msg = "\"" + this.getInformacao().getNomeCampo() + " deve ser menor que " + "\"" + nomeParValidacao;
                break;
            }
            case -3: {
                if (r <= 0) break;
                msg = "\"" + this.getInformacao().getNomeCampo() + " deve ser menor ou igual que " + "\"" + nomeParValidacao;
                break;
            }
            case 2: {
                if (r > 0) break;
                msg = "\"" + this.getInformacao().getNomeCampo() + " deve ser maior que " + "\"" + nomeParValidacao;
                break;
            }
            case 3: {
                if (r >= 0) break;
                msg = "\"" + this.getInformacao().getNomeCampo() + " deve ser maior ou igual que " + "\"" + nomeParValidacao;
                break;
            }
            default: {
                throw new IllegalArgumentException("regra de valida\u00e7\u00e3o inv\u00e1lida: " + this.regraValidacao);
            }
        }
        if (msg != null) {
            return new RetornoValidacao(msg);
        }
        return null;
    }
}

