/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.negocio.IdDeclaracao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ListaPPGD;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.util.FabricaTratamentoErro;

public abstract class Colecao
extends ObjetoNegocio {
    private List<ObjetoNegocio> lista;
    protected Class<?> tipoItens = null;
    private int tamanho = 0;
    private PropertyChangeSupport observadoresLista = new PropertyChangeSupport(this);
    private boolean observadoresListaAtivos = true;
    public static final String OBJETO_INSERIDO = "ObjetoInserido";
    public static final String OBJETO_A_REMOVER = "ObjetoAremover";
    public static final String OBJETO_REMOVIDO = "ObjetoRemovido";

    public Colecao(IdDeclaracao idDeclaracao) {
        super(idDeclaracao);
        this.setTipoItens(null);
    }

    public Colecao() {
        this.setTipoItens(null);
    }

    public Colecao(IdDeclaracao idDeclaracao, String nomeClasse) {
        this(idDeclaracao);
        this.setTipoItens(nomeClasse);
    }

    public Colecao(String nomeClasse) {
        this.setTipoItens(nomeClasse);
    }

    public Colecao(IdDeclaracao idDeclaracao, String nomeClasse, int tamanho) {
        this(idDeclaracao, nomeClasse);
        this.tamanho = tamanho;
    }

    public Colecao(String nomeClasse, int tamanho) {
        this.tamanho = tamanho;
    }

    @Override
    public void clear() {
        super.clear();
        this.recuperarLista().clear();
    }

    @Override
    public void setValidadoresAtivos(boolean opcao) {
        super.setValidadoresAtivos(opcao);
        Iterator<ObjetoNegocio> itItems = this.recuperarLista().iterator();
        ObjetoNegocio obj = null;
        while (itItems.hasNext()) {
            obj = itItems.next();
            obj.setValidadoresAtivos(opcao);
        }
    }

    public void setTipoItens(String tipoItens) {
        try {
            this.tipoItens = tipoItens != null ? Class.forName(tipoItens) : null;
        }
        catch (ClassNotFoundException e) {
            FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico("A classe " + tipoItens + " especificada com item da cole\u00e7\u00e3o " + this.getClass().getName() + " n\u00e3o foi encontrada.");
        }
    }

    public List<ObjetoNegocio> recuperarLista() {
        if (this.lista == null) {
            this.lista = new ListaPPGD<ObjetoNegocio>(this);
        }
        return this.lista;
    }

    public void objetoInserido(Object o) {
    }

    public void objetoARemover(Object o) {
    }

    public void objetoRemovido(Object o) {
    }

    public int novoObjeto() {
        this.recuperarLista().add(this.instanciaNovoObjeto());
        return this.recuperarLista().size() - 1;
    }

    public ObjetoNegocio instanciaNovoObjeto() {
        Class<?> classe = this.getTipoItens();
        try {
            Object o = classe.newInstance();
            return (ObjetoNegocio)o;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void removeObjeto(int i) {
        this.recuperarLista().remove(i);
    }

    public Class<?> getTipoItens() {
        return this.tipoItens;
    }

    @Override
    public List<Pendencia> verificarPendencias(int numeroItem) {
        List<Pendencia> listaPendenciasColecao = super.verificarPendencias(-1);
        int i = 0;
        for (ObjetoNegocio objetoNegocio : this.recuperarLista()) {
            List<Pendencia> listaPendenciasObjeto = objetoNegocio.verificarPendencias(++i);
            listaPendenciasColecao.addAll(listaPendenciasObjeto);
        }
        return listaPendenciasColecao;
    }

    @Override
    public void setFicha(String entidade) {
        this.ficha = entidade;
        for (ObjetoNegocio objetoNegocio : this.recuperarLista()) {
            objetoNegocio.setFicha(entidade);
        }
        Iterator<Informacao> itAtributosColecao = this.recuperarListaCamposPendencia().iterator();
        Informacao info = null;
        while (itAtributosColecao.hasNext()) {
            info = itAtributosColecao.next();
            info.setFicha(entidade);
        }
    }

    public int getTamanho() {
        return this.tamanho;
    }

    public int recuperarNumeroObjetosNaoNulos() {
        Iterator<ObjetoNegocio> iterator = this.recuperarLista().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            ObjetoNegocio obj = iterator.next();
            if (obj.isVazio()) continue;
            ++i;
        }
        return i;
    }

    public void excluirRegistrosEmBranco() {
        List<ObjetoNegocio> list = this.recuperarLista();
        for (int i = list.size() - 1; i >= 0; --i) {
            ObjetoNegocio objetoNegocio = list.get(i);
            if (!objetoNegocio.isVazio()) continue;
            list.remove(i);
        }
    }

    @Override
    public boolean isVazio() {
        for (ObjetoNegocio obj : this.recuperarLista()) {
            if (obj.isVazio()) continue;
            return false;
        }
        boolean atributosDaColecaoVazios = super.isVazio();
        return atributosDaColecaoVazios;
    }

    @Override
    public void removeObservadoresAnonimosDesnecessarios(Class<?> pClasse) {
        super.removeObservadoresAnonimosDesnecessarios(pClasse);
        Iterator<ObjetoNegocio> itItems = this.recuperarLista().iterator();
        ObjetoNegocio proximo = null;
        while (itItems.hasNext()) {
            proximo = itItems.next();
            proximo.removeObservadoresAnonimosDesnecessarios(pClasse);
        }
    }

    @Override
    public void removeObservadores(Class<?>[] pClasse) {
        super.removeObservadores(pClasse);
        Iterator<ObjetoNegocio> itItems = this.recuperarLista().iterator();
        ObjetoNegocio proximo = null;
        while (itItems.hasNext()) {
            proximo = itItems.next();
            proximo.removeObservadores(pClasse);
        }
    }

    public PropertyChangeSupport getObservadoresLista() {
        return this.observadoresLista;
    }

    public void addObservador(Observador observador) {
        this.observadoresLista.addPropertyChangeListener(observador);
    }

    public void addObservador(String nomePropriedade, Observador observador) {
        this.observadoresLista.addPropertyChangeListener(nomePropriedade, observador);
    }

    public void removeObservador(Observador observador) {
        this.observadoresLista.removePropertyChangeListener(observador);
    }

    public void removeObservador(String nomePropriedade, Observador observador) {
        this.observadoresLista.removePropertyChangeListener(nomePropriedade, observador);
    }

    public boolean isObservadoresListaAtivos() {
        return this.observadoresListaAtivos;
    }

    public void setObservadoresAtivos(boolean observadoresAtivos) {
        this.observadoresListaAtivos = observadoresAtivos;
    }
}

