/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.tree;

import java.awt.Component;
import java.io.File;
import java.io.FileFilter;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import serpro.ppgd.gui.tree.PPGDFileTreeNode;

public class PPGDDirectoryTree
extends JTree
implements TreeSelectionListener {
    protected String status = "";
    protected String rootNode = null;
    protected ImageIcon openedFolderIcon = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("imagens/pastaAberta.png"));
    protected ImageIcon closedFolderIcon = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("imagens/pastaFechada.png"));
    protected boolean showFiles = true;
    protected boolean showHiddenFiles = false;
    protected FileFilter filter = new FileFilter(){

        public boolean accept(File file) {
            return false;
        }
    };

    public PPGDDirectoryTree(File pFile, boolean pShowFiles, boolean pShowHiddenFiles) {
        super(PPGDDirectoryTree.createPPGDTreeModel(pFile, pShowFiles, pShowHiddenFiles));
        this.showFiles = pShowFiles;
        this.setRootVisible(false);
        this.setToggleClickCount(1);
        this.addTreeSelectionListener(this);
        ((DefaultTreeCellRenderer)this.getCellRenderer()).setLeafIcon(null);
        ((DefaultTreeCellRenderer)this.getCellRenderer()).setIcon(this.closedFolderIcon);
        ((DefaultTreeCellRenderer)this.getCellRenderer()).setOpenIcon(this.openedFolderIcon);
        ((DefaultTreeCellRenderer)this.getCellRenderer()).setClosedIcon(this.closedFolderIcon);
        this.putClientProperty("JTree.lineStyle", "None");
        this.setCellRenderer(new DefaultTreeCellRenderer(){

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                PPGDFileTreeNode nodo = (PPGDFileTreeNode)value;
                if (nodo.getUserObject() == null) {
                    return new JLabel("");
                }
                File file = (File)nodo.getUserObject();
                if (leaf && PPGDDirectoryTree.this.showFiles) {
                    try {
                        this.setLeafIcon(FileSystemView.getFileSystemView().getSystemIcon(file));
                    }
                    catch (Exception exception) {}
                } else if (FileSystemView.getFileSystemView().isDrive(file)) {
                    this.setOpenIcon(FileSystemView.getFileSystemView().getSystemIcon(file));
                    this.setClosedIcon(FileSystemView.getFileSystemView().getSystemIcon(file));
                } else {
                    this.setOpenIcon(PPGDDirectoryTree.this.openedFolderIcon);
                    this.setClosedIcon(PPGDDirectoryTree.this.closedFolderIcon);
                }
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                return this;
            }
        });
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent e) {
            }

            public void treeExpanded(TreeExpansionEvent e) {
                try {
                    TreePath path = e.getPath();
                    PPGDFileTreeNode node = (PPGDFileTreeNode)path.getLastPathComponent();
                    if (!node.isExplored()) {
                        DefaultTreeModel model = (DefaultTreeModel)PPGDDirectoryTree.this.getModel();
                        PPGDDirectoryTree.this.status = "exploring ...";
                        node.explore(PPGDDirectoryTree.this.showFiles, PPGDDirectoryTree.this.showHiddenFiles);
                        model.nodeStructureChanged(node);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            static /* synthetic */ PPGDDirectoryTree access$0(3 var0) {
                return var0.PPGDDirectoryTree.this;
            }

            class UpdateStatus
            extends Thread {
                UpdateStatus() {
                }

                public void run() {
                    try {
                        Thread.currentThread();
                        Thread.sleep(450L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(new Runnable(this){
                        final /* synthetic */ UpdateStatus this$2;
                        {
                            this.this$2 = updateStatus;
                        }

                        public void run() {
                            3.access$0(UpdateStatus.access$0((UpdateStatus)this.this$2)).status = "";
                        }
                    });
                }

                static /* synthetic */ 3 access$0(UpdateStatus updateStatus) {
                    return updateStatus.this;
                }
            }
        });
    }

    public static DefaultTreeModel createPPGDTreeModel(File file, boolean pShowFiles, boolean pShowHiddenFiles) {
        PPGDFileTreeNode rootNode = new PPGDFileTreeNode(file);
        rootNode.explore(pShowFiles, pShowHiddenFiles);
        return new DefaultTreeModel(rootNode);
    }

    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        this.selected(node);
    }

    public void updateRoot(File pFile) {
        PPGDFileTreeNode rootNode = new PPGDFileTreeNode(pFile);
        rootNode.explore(this.showFiles, this.showHiddenFiles);
        ((DefaultTreeModel)this.getModel()).setRoot(rootNode);
    }

    public void clear() {
        ((DefaultMutableTreeNode)this.getModel().getRoot()).removeAllChildren();
        ((DefaultTreeModel)this.getModel()).nodeStructureChanged((DefaultMutableTreeNode)this.getModel().getRoot());
    }

    protected void selected(DefaultMutableTreeNode node) {
    }

    public static void main(String[] args) {
        PPGDDirectoryTree tree = new PPGDDirectoryTree(File.listRoots()[1], false, false);
        JDialog dlg = new JDialog(null);
        dlg.getContentPane().add(tree);
        dlg.pack();
        dlg.setDefaultCloseOperation(3);
        dlg.setVisible(true);
    }
}

