/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;
import serpro.ppgd.gui.EditCampo;
import serpro.ppgd.gui.editors.PPGDFormattedTextField;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.util.UtilitariosString;

public class EditMascara
extends EditCampo {
    protected boolean retornaConteudoAposTeclaEsc = true;
    private static Alfa vazio = new Alfa("EditMascara");
    protected JFormattedTextField componente;
    private MaskFormatter formatador;
    private boolean sobrescreve = false;
    private String mascara;

    public EditMascara() {
        super((Informacao)vazio);
    }

    public EditMascara(Informacao campo) {
        super(campo);
    }

    public EditMascara(Informacao campo, int tamanho) {
        super(campo, tamanho);
    }

    public void setMascara(String mascara) {
        try {
            this.mascara = mascara;
            if (this.formatador == null) {
                this.formatador = new MaskFormatter(this.mascara);
                this.componente.setFormatterFactory(new DefaultFormatterFactory(this.formatador));
            } else {
                this.formatador.setMask(mascara);
            }
            this.componente.setValue(null);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.implementacaoPropertyChange(null);
    }

    public void setCaracteresValidos(String caracteresValidos) {
        this.formatador.setValidCharacters(caracteresValidos);
    }

    public void setCaracteresInvalidos(String charsInvalidos) {
        this.formatador.setInvalidCharacters(charsInvalidos);
    }

    public void setInformacao(Informacao campo) {
        if (this.componente == null) {
            this.componente = new PPGDFormattedTextField();
            this.setMascara(UtilitariosString.expandeString((int)this.d[0].width, (String)"*"));
            this.componente.setHorizontalAlignment(0);
            this.componente.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    if (EditMascara.this.isSelecionaTextoOnFocusGained()) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                1.access$0(this.this$1).componente.selectAll();
                            }
                        });
                    }
                }

                public void focusLost(FocusEvent e) {
                    if (e.getOppositeComponent() == null) {
                        return;
                    }
                    EditMascara.this.setIdentificacaoFoco(false);
                    if (!EditMascara.this.getInformacao().getListaValidadoresImpeditivos().isEmpty() && !EditMascara.this.verificaValidacoesImpeditivas(EditMascara.this.componente.getText())) {
                        return;
                    }
                    EditMascara.this.setarCampo();
                    EditMascara.this.chamaValidacao();
                }

                static /* synthetic */ EditMascara access$0(1 var0) {
                    return var0.EditMascara.this;
                }
            });
            this.componente.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    EditMascara.this.trataEventoKeyTyped(e);
                }
            });
        }
        ((PPGDFormattedTextField)this.componente).setInformacao(this.getInformacao());
        this.setMascara(this.mascara);
        this.setTamanho(this.mascara.length());
        this.implementacaoPropertyChange(null);
    }

    public void removeTransfereFocoEnter() {
        this.componente.getInputMap().put(KeyStroke.getKeyStroke(10, 0, true), "Focus.nextComponent");
        this.componente.getActionMap().put("Focus.nextComponent", null);
    }

    public void implementacaoPropertyChange(PropertyChangeEvent evt) {
        String valorSemMascara = this.campo.asString();
        String valorComMascara = UtilitariosString.retornaComMascara((String)valorSemMascara, (String)this.getFormatador().getMask());
        if (valorSemMascara.trim().equals("")) {
            ((PPGDFormattedTextField)this.componente).setText(valorComMascara);
            ((PPGDFormattedTextField)this.componente).setValue(null);
        } else {
            ((PPGDFormattedTextField)this.componente).setText(valorComMascara);
        }
        this.componente.setCaretPosition(0);
    }

    public JComponent getComponenteEditor() {
        return this.componente;
    }

    protected void readOnlyPropertyChange(boolean readOnly) {
        if (readOnly) {
            this.componente.setEditable(false);
        } else {
            this.componente.setEditable(true);
        }
    }

    protected void habilitadoPropertyChange(boolean habilitado) {
        this.componente.setEnabled(habilitado);
        this.labelCampo.setEnabled(habilitado);
    }

    public void setarCampo() {
        String s = this.componente.getText();
        String valorSemMascara = UtilitariosString.retiraMascara((String)s, (String)this.formatador.getMask());
        if (s.length() > this.d[0].width) {
            s = s.substring(0, this.d[0].width);
        }
        this.getInformacao().setConteudo(valorSemMascara);
    }

    public String getConteudoComMascara() {
        String valorSemMascara = UtilitariosString.retiraMascara((String)this.getInformacao().getConteudoFormatado());
        return UtilitariosString.retornaComMascara((String)valorSemMascara, (String)this.formatador.getMask());
    }

    public JComponent getComponenteFoco() {
        return this.componente;
    }

    public boolean isSobrescreve() {
        return this.sobrescreve;
    }

    public void setSobrescreve(boolean sobrescreve) {
        this.sobrescreve = sobrescreve;
    }

    public MaskFormatter getFormatador() {
        return this.formatador;
    }

    public void setPerdeFocoComEnter(boolean aPerdeFocoComEnter) {
        this.isPerdeFocoComEnter = aPerdeFocoComEnter;
        if (this.isPerdeFocoComEnter()) {
            this.aplicaTransfereFocoEnter();
        } else {
            this.removeTransfereFocoEnter();
        }
    }

    public boolean isRetornaConteudoAposTeclaEsc() {
        return this.retornaConteudoAposTeclaEsc;
    }

    public void setRetornaConteudoAposTeclaEsc(boolean retornaConteudoAposTeclaEsc) {
        this.retornaConteudoAposTeclaEsc = retornaConteudoAposTeclaEsc;
    }

    public String getMascara() {
        return this.mascara;
    }

    protected void trataEventoKeyTyped(KeyEvent e) {
        boolean manipulacaoCursor;
        boolean bl = manipulacaoCursor = e.getKeyChar() == '\t' || e.getKeyChar() == '\n' || e.getKeyChar() == '\b' || e.getKeyChar() == '\u007f' || e.getKeyChar() == '%' || e.getKeyChar() == '\'';
        if (this.getFormatador().getValidCharacters() != null && this.getFormatador().getValidCharacters().indexOf(" ") == -1 && e.getKeyChar() == ' ') {
            e.setKeyChar('\uffff');
            e.consume();
            UIManager.getLookAndFeel().provideErrorFeedback(this.componente);
            return;
        }
        if (manipulacaoCursor) {
            return;
        }
        char ch = e.getKeyChar();
        boolean eventosEhInclusao = ch != '\t' && ch != '\n' && ch != '\b' && ch != '\u007f' && ch != '%' && ch != '\'';
        int tamanhoTextoAtual = this.componente.getText().trim().length();
        if (this.sobrescreve && this.componente.getCaret().getDot() <= this.d[0].width && eventosEhInclusao && tamanhoTextoAtual >= this.d[0].width && this.componente.getSelectedText() == null) {
            this.componente.select(this.componente.getCaret().getDot(), this.componente.getCaret().getDot() + 1);
        }
        if (tamanhoTextoAtual >= this.d[0].width && eventosEhInclusao && this.componente.getSelectedText() == null) {
            e.setKeyChar('\uffff');
            e.consume();
            UIManager.getLookAndFeel().provideErrorFeedback(this.componente);
        }
    }
}

