/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import serpro.ppgd.gui.ComboElementoSimples;
import serpro.ppgd.gui.ComboElementoTabela;
import serpro.ppgd.gui.EditAlfa;
import serpro.ppgd.gui.EditCampo;
import serpro.ppgd.gui.EditCodigoAntigo;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.util.LogPPGD;

public class EditComboElementoTabela
extends EditCampo {
    private static Codigo vazio = new Codigo("EditCombo");
    private ComboElementoTabela combo;
    private EditCodigoAntigo editCodigo;
    private EditAlfa editAlfa;
    private String lastCodigo;

    public EditComboElementoTabela() {
        super((Informacao)vazio);
    }

    public EditComboElementoTabela(Informacao campo, int tamanho, String idAjuda) {
        super(campo, tamanho, idAjuda);
    }

    private String getConteudoAtual(int coluna) {
        int i = this.combo.getSelectedIndex();
        if (i != -1) {
            List colecao = ((Codigo)this.getInformacao()).getColecaoElementoTabela();
            ElementoTabela elementoTabela = (ElementoTabela)colecao.get(i);
            return elementoTabela.getConteudo(coluna);
        }
        return "";
    }

    public void setInformacao(Informacao campo) {
        Vector colecao;
        this.campo = campo;
        boolean isSimples = ((Codigo)campo).isSimples();
        int colunaFiltro = ((Codigo)campo).getColunaFiltro();
        if (this.combo == null) {
            colecao = (Vector)((Codigo)this.getInformacao()).getColecaoElementoTabela();
            this.combo = isSimples ? new ComboElementoSimples(colecao, colunaFiltro) : new ComboElementoTabela(colecao, colunaFiltro);
            this.combo.setSizeCol(0, this.d[0].width);
            this.combo.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    EditComboElementoTabela.this.setarConteudoEditado();
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    EditComboElementoTabela.this.lastCodigo = EditComboElementoTabela.this.getInformacao().getConteudoFormatado();
                }

                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
            this.combo.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    EditComboElementoTabela.this.setIdentificacaoFoco(false);
                }
            });
            this.combo.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    super.keyReleased(e);
                    EditComboElementoTabela.this.setarConteudoEditado();
                    if (e.getKeyCode() == 27 && (EditComboElementoTabela.this.lastCodigo == null || EditComboElementoTabela.this.lastCodigo.length() == 0)) {
                        EditComboElementoTabela.this.combo.setSelectedIndex(-1);
                        EditComboElementoTabela.this.setObservadorAtivo(false);
                        if (EditComboElementoTabela.this.editAlfa != null) {
                            ((JTextField)EditComboElementoTabela.this.editAlfa.getComponenteEditor()).setText(EditComboElementoTabela.this.getConteudoAtual(1));
                            ((JTextField)EditComboElementoTabela.this.editAlfa.getComponenteEditor()).setCaretPosition(0);
                        }
                        EditComboElementoTabela.this.getInformacao().setConteudo(EditComboElementoTabela.this.getConteudoAtual(0));
                        EditComboElementoTabela.this.setObservadorAtivo(true);
                    }
                }
            });
        }
        if ((colecao = (Vector)((Codigo)this.getInformacao()).getColecaoElementoTabela()) != this.combo.getColecao()) {
            this.combo.setColecao(colecao);
        }
        this.combo.setSelectedIndex(((Codigo)campo).getIndiceElementoTabela());
        if (this.editAlfa != null) {
            ((JTextField)this.editAlfa.getComponenteEditor()).setText(this.getConteudoAtual(1));
            ((JTextField)this.editAlfa.getComponenteEditor()).setCaretPosition(0);
        }
    }

    private void setarConteudoEditado() {
        this.setObservadorAtivo(false);
        this.getInformacao().setConteudo(this.getConteudoAtual(0));
        if (this.editAlfa != null) {
            ((JTextField)this.editAlfa.getComponenteEditor()).setText(this.getConteudoAtual(1));
            ((JTextField)this.editAlfa.getComponenteEditor()).setCaretPosition(0);
        }
        this.chamaValidacao();
        this.setObservadorAtivo(true);
    }

    public void setEditAlfa(EditAlfa editAlfa) {
        this.editAlfa = editAlfa;
        ((JTextField)editAlfa.getComponenteEditor()).setText(this.getConteudoAtual(1));
        ((JTextField)editAlfa.getComponenteEditor()).setCaretPosition(0);
    }

    public void setEditCodigo(EditCodigoAntigo edit) {
        this.editCodigo = edit;
    }

    public JComponent getComponenteEditor() {
        return this.combo;
    }

    public void implementacaoPropertyChange(PropertyChangeEvent evt) {
        if (((Codigo)this.campo).isVazio() && this.editAlfa != null) {
            this.combo.setSelectedIndex(-1);
            ((JTextField)this.editAlfa.getComponenteEditor()).setText("");
            ((JTextField)this.editAlfa.getComponenteEditor()).setCaretPosition(0);
        } else if (((Codigo)this.campo).isVazio() && this.editAlfa == null) {
            this.combo.setSelectedIndex(-1);
        } else {
            try {
                if (this.combo.getItemCount() > ((Codigo)this.campo).getIndiceElementoTabela()) {
                    this.combo.setSelectedIndex(((Codigo)this.campo).getIndiceElementoTabela());
                    if (this.editAlfa != null) {
                        ((JTextField)this.editAlfa.getComponenteEditor()).setText(this.getConteudoAtual(1));
                        ((JTextField)this.editAlfa.getComponenteEditor()).setCaretPosition(0);
                    }
                }
            }
            catch (Exception e) {
                LogPPGD.erro((String)"---Erro no implementacao property change do combo----");
                e.printStackTrace();
                this.combo.setSelectedIndex(-1);
            }
        }
    }

    public void setReadOnly(boolean b) {
        this.getComponenteEditor().setEnabled(!b);
    }

    public JComponent getComponenteFoco() {
        return this.combo;
    }

    public void setIdentificacaoFoco(boolean status) {
        super.setIdentificacaoFoco(status);
        if (this.editCodigo != null) {
            this.editCodigo.setIdentificacaoFoco(status);
        }
    }

    public ComboElementoTabela getCombo() {
        return this.combo;
    }

    protected void readOnlyPropertyChange(boolean readOnly) {
    }

    protected void habilitadoPropertyChange(boolean habilitado) {
    }

    public void setPerdeFocoComEnter(boolean isPerdeFocoComEnter) {
    }
}

