/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class DialogoOcupado
extends JWindow {
    private boolean duracaoIndeterminada = true;
    private int min = 0;
    private int max = 100;
    private JLabel mensagem;
    private JProgressBar progress;

    public DialogoOcupado() {
        this.buildComponente("");
    }

    public DialogoOcupado(String msg) {
        this.buildComponente(msg);
    }

    public DialogoOcupado(int aMin, int aMax, String msg) {
        this.duracaoIndeterminada = false;
        this.min = aMin;
        this.max = aMax;
        this.buildComponente(msg);
    }

    private void buildComponente(String msg) {
        JPanel content = new JPanel();
        this.progress = new JProgressBar(this.min, this.max);
        this.progress.setIndeterminate(this.duracaoIndeterminada);
        this.mensagem = new JLabel(msg);
        content.setLayout(new BorderLayout());
        content.add((Component)this.progress, "Center");
        content.add((Component)this.mensagem, "South");
        content.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(6, 6, 6, 6)));
        this.setContentPane(content);
    }

    public void atualiza(final String novaMsg) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DialogoOcupado.this.mensagem.setText(novaMsg);
                    if (!DialogoOcupado.this.duracaoIndeterminada) {
                        DialogoOcupado.this.progress.setValue(DialogoOcupado.this.progress.getValue() + 1);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void atualiza() {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (!DialogoOcupado.this.duracaoIndeterminada) {
                        DialogoOcupado.this.progress.setValue(DialogoOcupado.this.progress.getValue() + 1);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void atualiza(final int valor, final String novaMsg) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DialogoOcupado.this.mensagem.setText(novaMsg);
                    DialogoOcupado.this.progress.setValue(valor);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void atualiza(final int valor) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DialogoOcupado.this.progress.setValue(valor);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void finaliza() {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DialogoOcupado.this.setVisible(false);
                    DialogoOcupado.this.dispose();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DialogoOcupado exibeDialogo() {
        DialogoOcupado dialogo = new DialogoOcupado();
        dialogo.pack();
        dialogo.setSize(250, 30);
        dialogo.setLocationRelativeTo(null);
        dialogo.setVisible(true);
        return dialogo;
    }

    public static DialogoOcupado exibeDialogo(String msg) {
        DialogoOcupado dialogo = new DialogoOcupado(msg);
        dialogo.pack();
        dialogo.setSize(250, 40);
        dialogo.setLocationRelativeTo(null);
        dialogo.setVisible(true);
        return dialogo;
    }

    public static DialogoOcupado exibeDialogo(int min, int max, String msg) {
        DialogoOcupado dialogo = new DialogoOcupado(min, max, msg);
        dialogo.pack();
        dialogo.setSize(250, 40);
        dialogo.setLocationRelativeTo(null);
        dialogo.setVisible(true);
        return dialogo;
    }

    public boolean isDuracaoIndeterminada() {
        return this.duracaoIndeterminada;
    }

    public String getMensagem() {
        return this.mensagem.getText();
    }

    public static void main(String[] args) {
        System.out.println("1");
        DialogoOcupado dialogo = DialogoOcupado.exibeDialogo("Aguarde...");
        System.out.println("2");
    }
}

