/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.codec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.w3c.tools.codec.Base64FormatException;

public class Base64Decoder {
    private static final int BUFFER_SIZE = 1024;
    public InputStream c = null;
    public OutputStream a = null;
    public boolean b = false;

    private void printHex(int n2) {
        int n3 = (n2 & 0xF0) >> 4;
        int n4 = n2 & 0xF;
        System.out.print(new Character((char)(n3 > 9 ? 65 + n3 - 10 : 48 + n3)).toString() + new Character((char)(n4 > 9 ? 65 + n4 - 10 : 48 + n4)).toString());
    }

    private void printHex(byte[] byArray, int n2, int n3) {
        while (n2 < n3) {
            this.printHex(byArray[n2++]);
            System.out.print(" ");
        }
        System.out.println("");
    }

    private void printHex(String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(this.getClass().getName() + "[printHex] Unable to convert" + "properly char to bytes");
        }
        this.printHex(byArray, 0, byArray.length);
    }

    private final int get1(byte[] byArray, int n2) {
        return (byArray[n2] & 0x3F) << 2 | (byArray[n2 + 1] & 0x30) >>> 4;
    }

    private final int get2(byte[] byArray, int n2) {
        return (byArray[n2 + 1] & 0xF) << 4 | (byArray[n2 + 2] & 0x3C) >>> 2;
    }

    private final int get3(byte[] byArray, int n2) {
        return (byArray[n2 + 2] & 3) << 6 | byArray[n2 + 3] & 0x3F;
    }

    private final int check(int n2) {
        if (n2 >= 65 && n2 <= 90) {
            return n2 - 65;
        }
        if (n2 >= 97 && n2 <= 122) {
            return n2 - 97 + 26;
        }
        if (n2 >= 48 && n2 <= 57) {
            return n2 - 48 + 52;
        }
        switch (n2) {
            case 61: {
                return 65;
            }
            case 43: {
                return 62;
            }
            case 47: {
                return 63;
            }
        }
        return -1;
    }

    public void process() throws IOException, Base64FormatException {
        byte[] byArray = new byte[1024];
        byte[] byArray2 = new byte[4];
        int n2 = -1;
        int n3 = 0;
        block0: while ((n2 = this.c.read(byArray)) > 0) {
            int n4 = 0;
            while (n4 < n2) {
                while (n3 < 4) {
                    int n5;
                    if (n4 >= n2) continue block0;
                    if ((n5 = this.check(byArray[n4++])) < 0) continue;
                    byArray2[n3++] = (byte)n5;
                }
                if (byArray2[2] == 65) {
                    this.a.write(this.get1(byArray2, 0));
                    return;
                }
                if (byArray2[3] == 65) {
                    this.a.write(this.get1(byArray2, 0));
                    this.a.write(this.get2(byArray2, 0));
                    return;
                }
                this.a.write(this.get1(byArray2, 0));
                this.a.write(this.get2(byArray2, 0));
                this.a.write(this.get3(byArray2, 0));
                n3 = 0;
            }
        }
        if (n3 != 0) {
            throw new Base64FormatException("Invalid length.");
        }
        this.a.flush();
    }

    public String processString() throws Base64FormatException {
        String string;
        if (!this.b) {
            throw new RuntimeException(this.getClass().getName() + "[processString]" + "invalid call (not a String)");
        }
        try {
            this.process();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            string = ((ByteArrayOutputStream)this.a).toString("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(this.getClass().getName() + "[processString] Unable to convert" + "properly char to bytes");
        }
        return string;
    }

    public Base64Decoder(String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(this.getClass().getName() + "[Constructor] Unable to convert" + "properly char to bytes");
        }
        this.b = true;
        this.c = new ByteArrayInputStream(byArray);
        this.a = new ByteArrayOutputStream();
    }

    public Base64Decoder(InputStream inputStream, OutputStream outputStream) {
        this.c = inputStream;
        this.a = outputStream;
        this.b = false;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 1) {
            try {
                Base64Decoder base64Decoder = new Base64Decoder(stringArray[0]);
                System.out.println("[" + base64Decoder.processString() + "]");
            }
            catch (Base64FormatException base64FormatException) {
                System.out.println("Invalid Base64 format !");
                System.exit(1);
            }
        } else if (stringArray.length == 2 && stringArray[0].equals("-f")) {
            try {
                FileInputStream fileInputStream = new FileInputStream(stringArray[1]);
                Base64Decoder base64Decoder = new Base64Decoder(fileInputStream, System.out);
                base64Decoder.process();
            }
            catch (Exception exception) {
                System.out.println("error: " + exception.getMessage());
                System.exit(1);
            }
        } else {
            System.out.println("Base64Decoder [strong] [-f file]");
        }
        System.exit(0);
    }
}

