/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import java.lang.reflect.Method;
import org.jdom.output.EscapeStrategy;

public class Format
implements Cloneable {
    private static final String CVS_ID = "@(#) $RCSfile: Format.java,v $ $Revision: 1.6 $ $Date: 2004/02/11 20:56:43 $ $Name: jdom_1_0_b10 $";
    private static final String STANDARD_INDENT = "  ";
    private static final String STANDARD_LINE_SEPARATOR = "\r\n";
    private static final String STANDARD_ENCODING = "UTF-8";
    public String h = null;
    public String b = "\r\n";
    public String f = "UTF-8";
    public boolean e = false;
    public boolean d = false;
    public boolean i = false;
    public TextMode a = TextMode.PRESERVE;
    public EscapeStrategy c = new DefaultEscapeStrategy(this, this.f);
    public static Class g;

    public static Format getRawFormat() {
        return new Format();
    }

    public static Format getPrettyFormat() {
        Format format = new Format();
        format.setIndent(STANDARD_INDENT);
        format.setTextMode(TextMode.TRIM);
        return format;
    }

    public static Format getCompactFormat() {
        Format format = new Format();
        format.setTextMode(TextMode.NORMALIZE);
        return format;
    }

    public Format setEscapeStrategy(EscapeStrategy escapeStrategy) {
        this.c = escapeStrategy;
        return this;
    }

    public EscapeStrategy getEscapeStrategy() {
        return this.c;
    }

    public Format setLineSeparator(String string) {
        this.b = string;
        return this;
    }

    public String getLineSeparator() {
        return this.b;
    }

    public Format setOmitEncoding(boolean bl2) {
        this.d = bl2;
        return this;
    }

    public boolean getOmitEncoding() {
        return this.d;
    }

    public Format setOmitDeclaration(boolean bl2) {
        this.e = bl2;
        return this;
    }

    public boolean getOmitDeclaration() {
        return this.e;
    }

    public Format setExpandEmptyElements(boolean bl2) {
        this.i = bl2;
        return this;
    }

    public boolean getExpandEmptyElements() {
        return this.i;
    }

    public Format setTextMode(TextMode textMode) {
        this.a = textMode;
        return this;
    }

    public TextMode getTextMode() {
        return this.a;
    }

    public Format setIndent(String string) {
        if ("".equals(string)) {
            string = null;
        }
        this.h = string;
        return this;
    }

    public String getIndent() {
        return this.h;
    }

    public Format setEncoding(String string) {
        this.f = string;
        this.c = new DefaultEscapeStrategy(this, string);
        return this;
    }

    public String getEncoding() {
        return this.f;
    }

    public Object clone() {
        Format format = null;
        try {
            format = (Format)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return format;
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class TextMode {
        public static final TextMode PRESERVE = new TextMode("PRESERVE");
        public static final TextMode TRIM = new TextMode("TRIM");
        public static final TextMode NORMALIZE = new TextMode("NORMALIZE");
        public static final TextMode TRIM_FULL_WHITE = new TextMode("TRIM_FULL_WHITE");
        private final String name;

        private TextMode(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }

    public class DefaultEscapeStrategy
    implements EscapeStrategy {
        private int bits;
        public Object b;
        public Method a;
        private final Format this$0;

        public DefaultEscapeStrategy(Format format, String string) {
            this.this$0 = format;
            if (Format.STANDARD_ENCODING.equalsIgnoreCase(string) || "UTF-16".equalsIgnoreCase(string)) {
                this.bits = 16;
            } else if ("ISO-8859-1".equalsIgnoreCase(string) || "Latin1".equalsIgnoreCase(string)) {
                this.bits = 8;
            } else if ("US-ASCII".equalsIgnoreCase(string) || "ASCII".equalsIgnoreCase(string)) {
                this.bits = 7;
            } else {
                this.bits = 0;
                try {
                    Class<?> clazz = Class.forName("java.nio.charset.Charset");
                    Class<?> clazz2 = Class.forName("java.nio.charset.CharsetEncoder");
                    Method method = clazz.getMethod("forName", g == null ? (g = Format.a("java.lang.String")) : g);
                    Object object = method.invoke(null, string);
                    Method method2 = clazz.getMethod("newEncoder", null);
                    this.b = method2.invoke(object, null);
                    this.a = clazz2.getMethod("canEncode", Character.TYPE);
                }
                catch (Exception exception) {}
            }
        }

        public boolean shouldEscape(char c2) {
            if (this.bits == 16) {
                return false;
            }
            if (this.bits == 8) {
                return c2 > '\u00ff';
            }
            if (this.bits == 7) {
                return c2 > '\u007f';
            }
            if (this.a != null && this.b != null) {
                try {
                    Boolean bl2 = (Boolean)this.a.invoke(this.b, new Character(c2));
                    return bl2 == false;
                }
                catch (Exception exception) {
                }
            }
            return false;
        }
    }
}

