/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import org.jdom.Content;
import org.jdom.IllegalDataException;
import org.jdom.Verifier;

public class Text
extends Content {
    private static final String CVS_ID = "@(#) $RCSfile: Text.java,v $ $Revision: 1.23 $ $Date: 2004/02/11 21:12:43 $ $Name: jdom_1_0_b10 $";
    public String value;

    public Text() {
    }

    public Text(String string) {
        this.setText(string);
    }

    public String getText() {
        return this.value;
    }

    public String getTextTrim() {
        return this.getText().trim();
    }

    public String getTextNormalize() {
        return Text.normalizeString(this.getText());
    }

    public static String normalizeString(String string) {
        if (string == null) {
            return "";
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length];
        boolean bl2 = true;
        int n2 = 0;
        int n3 = 0;
        while (n3 < cArray.length) {
            if (" \t\n\r".indexOf(cArray[n3]) != -1) {
                if (!bl2) {
                    cArray2[n2++] = 32;
                    bl2 = true;
                }
            } else {
                cArray2[n2++] = cArray[n3];
                bl2 = false;
            }
            ++n3;
        }
        if (bl2 && n2 > 0) {
            --n2;
        }
        return new String(cArray2, 0, n2);
    }

    public Text setText(String string) {
        if (string == null) {
            this.value = "";
            return this;
        }
        String string2 = Verifier.checkCharacterData(string);
        if (string2 != null) {
            throw new IllegalDataException(string, "character content", string2);
        }
        this.value = string;
        return this;
    }

    public void append(String string) {
        if (string == null) {
            return;
        }
        String string2 = Verifier.checkCharacterData(string);
        if (string2 != null) {
            throw new IllegalDataException(string, "character content", string2);
        }
        this.value = string == "" ? string : this.value + string;
    }

    public void append(Text text) {
        if (text == null) {
            return;
        }
        this.value = this.value + text.getText();
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return new StringBuffer(64).append("[Text: ").append(this.getText()).append("]").toString();
    }

    public Object clone() {
        Text text = (Text)super.clone();
        text.value = this.value;
        return text;
    }
}

