/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.IllegalAddException;
import org.jdom.Parent;
import org.jdom.filter.Filter;

public final class ContentList
extends AbstractList
implements Serializable {
    private static final String CVS_ID = "@(#) $RCSfile: ContentList.java,v $ $Revision: 1.36 $ $Date: 2004/02/11 20:53:26 $ $Name: jdom_1_0_b10 $";
    private static final int INITIAL_ARRAY_SIZE = 5;
    private static final int CREATE = 0;
    private static final int HASPREV = 1;
    private static final int HASNEXT = 2;
    private static final int PREV = 3;
    private static final int NEXT = 4;
    private static final int ADD = 5;
    private static final int REMOVE = 6;
    private Content[] elementData;
    private int size;
    private Parent parent;

    public ContentList(Parent parent) {
        this.parent = parent;
    }

    public void add(int n2, Object object) {
        if (object == null) {
            throw new IllegalAddException("Cannot add null object");
        }
        if (!(object instanceof Content)) {
            throw new IllegalAddException("Class " + object.getClass().getName() + " is of unrecognized type and cannot be added");
        }
        this.a(n2, (Content)object);
    }

    public void a(int n2, Content content) {
        if (content == null) {
            throw new IllegalAddException("Cannot add null object");
        }
        this.parent.canContain(content, n2);
        if (content.getParent() != null) {
            Parent parent = content.getParent();
            if (parent instanceof Document) {
                throw new IllegalAddException((Element)content, "The Content already has an existing parent document");
            }
            throw new IllegalAddException("The Content already has an existing parent \"" + ((Element)parent).getQualifiedName() + "\"");
        }
        if (content == this.parent) {
            throw new IllegalAddException("The Element cannot be added to itself");
        }
        if (this.parent instanceof Element && content instanceof Element && ((Element)content).isAncestor((Element)this.parent)) {
            throw new IllegalAddException("The Element cannot be added as a descendent of itself");
        }
        if (n2 < 0 || n2 > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n2 + " Size: " + this.size());
        }
        content.setParent(this.parent);
        this.a(this.size + 1);
        if (n2 == this.size) {
            this.elementData[this.size++] = content;
        } else {
            System.arraycopy(this.elementData, n2, this.elementData, n2 + 1, this.size - n2);
            this.elementData[n2] = content;
            ++this.size;
        }
        ++this.modCount;
    }

    public boolean addAll(Collection collection) {
        return this.addAll(this.size(), collection);
    }

    /*
     * Unable to fully structure code
     */
    public boolean addAll(int var1_1, Collection var2_2) {
        block6: {
            if (var1_1 < 0 || var1_1 > this.size) {
                throw new IndexOutOfBoundsException("Index: " + var1_1 + " Size: " + this.size());
            }
            if (var2_2 == null || var2_2.size() == 0) {
                return false;
            }
            this.a(this.size() + var2_2.size());
            var3_3 = 0;
            try {
                var4_4 = var2_2.iterator();
                while (var4_4.hasNext()) {
                    var5_6 = var4_4.next();
                    this.add(var1_1 + var3_3, (Object)var5_6);
                    ++var3_3;
                }
                break block6;
            }
            catch (RuntimeException var4_5) {
                var5_7 = 0;
                ** while (var5_7 < var3_3)
            }
lbl-1000:
            // 1 sources

            {
                this.remove(var1_1);
                ++var5_7;
                continue;
            }
lbl22:
            // 1 sources

            throw var4_5;
        }
        return true;
    }

    public void clear() {
        if (this.elementData != null) {
            int n2 = 0;
            while (n2 < this.size) {
                Content content = this.elementData[n2];
                this.removeParent(content);
                ++n2;
            }
            this.elementData = null;
            this.size = 0;
        }
        ++this.modCount;
    }

    public void a(Collection collection) {
        Content[] contentArray = this.elementData;
        int n2 = this.size;
        this.elementData = null;
        this.size = 0;
        if (collection != null && collection.size() != 0) {
            this.a(collection.size());
            try {
                this.addAll(0, collection);
            }
            catch (RuntimeException runtimeException) {
                this.elementData = contentArray;
                this.size = n2;
                throw runtimeException;
            }
        }
        if (contentArray != null) {
            int n3 = 0;
            while (n3 < n2) {
                this.removeParent(contentArray[n3]);
                ++n3;
            }
        }
        ++this.modCount;
    }

    public void a(int n2) {
        if (this.elementData == null) {
            this.elementData = new Content[Math.max(n2, 5)];
        } else {
            int n3 = this.elementData.length;
            if (n2 > n3) {
                Content[] contentArray = this.elementData;
                int n4 = n3 * 3 / 2 + 1;
                if (n4 < n2) {
                    n4 = n2;
                }
                this.elementData = new Content[n4];
                System.arraycopy(contentArray, 0, this.elementData, 0, this.size);
            }
        }
    }

    public Object get(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n2 + " Size: " + this.size());
        }
        return this.elementData[n2];
    }

    public List a(Filter filter) {
        return new FilterList(this, filter);
    }

    public int a() {
        if (this.elementData != null) {
            int n2 = 0;
            while (n2 < this.size) {
                if (this.elementData[n2] instanceof Element) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    public int b() {
        if (this.elementData != null) {
            int n2 = 0;
            while (n2 < this.size) {
                if (this.elementData[n2] instanceof DocType) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    public Object remove(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n2 + " Size: " + this.size());
        }
        Content content = this.elementData[n2];
        this.removeParent(content);
        int n3 = this.size - n2 - 1;
        if (n3 > 0) {
            System.arraycopy(this.elementData, n2 + 1, this.elementData, n2, n3);
        }
        this.elementData[--this.size] = null;
        ++this.modCount;
        return content;
    }

    private void removeParent(Content content) {
        content.setParent(null);
    }

    public Object set(int n2, Object object) {
        int n3;
        if (n2 < 0 || n2 >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n2 + " Size: " + this.size());
        }
        if (object instanceof Element && this.parent instanceof Document && (n3 = this.a()) >= 0 && n3 != n2) {
            throw new IllegalAddException("Cannot add a second root element, only one is allowed");
        }
        if (object instanceof DocType && this.parent instanceof Document && (n3 = this.b()) >= 0 && n3 != n2) {
            throw new IllegalAddException("Cannot add a second doctype, only one is allowed");
        }
        Object object2 = this.remove(n2);
        try {
            this.add(n2, object);
        }
        catch (RuntimeException runtimeException) {
            this.add(n2, object2);
            throw runtimeException;
        }
        return object2;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        return super.toString();
    }

    private int getModCount() {
        return this.modCount;
    }

    public static int b(ContentList contentList) {
        return contentList.getModCount();
    }

    public static Content[] c(ContentList contentList) {
        return contentList.elementData;
    }

    public static int a(ContentList contentList) {
        return contentList.size;
    }

    public class FilterListIterator
    implements ListIterator {
        public Filter b;
        public int e;
        public int a;
        public int c;
        public int d;
        public int f;
        private final ContentList this$0;

        public FilterListIterator(ContentList contentList, Filter filter, int n2) {
            this.this$0 = contentList;
            this.b = filter;
            this.a = this.initializeCursor(n2);
            this.d = -1;
            this.f = ContentList.b(contentList);
            this.e = 0;
        }

        public boolean hasNext() {
            this.checkConcurrentModification();
            switch (this.e) {
                case 0: {
                    this.c = this.a;
                    break;
                }
                case 3: {
                    this.c = this.d;
                    break;
                }
                case 4: 
                case 5: {
                    this.c = this.moveForward(this.d + 1);
                    break;
                }
                case 6: {
                    this.c = this.moveForward(this.d);
                    break;
                }
                case 1: {
                    this.c = this.moveForward(this.c + 1);
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown operation");
                }
            }
            if (this.e != 0) {
                this.e = 2;
            }
            return this.c < this.this$0.size();
        }

        public Object next() {
            this.checkConcurrentModification();
            if (!this.hasNext()) {
                this.d = this.this$0.size();
                throw new NoSuchElementException();
            }
            this.d = this.c;
            this.e = 4;
            return this.this$0.get(this.d);
        }

        public boolean hasPrevious() {
            this.checkConcurrentModification();
            switch (this.e) {
                case 0: {
                    this.c = this.a;
                    int n2 = this.this$0.size();
                    if (this.c < n2) break;
                    this.c = this.moveBackward(n2 - 1);
                    break;
                }
                case 3: 
                case 6: {
                    this.c = this.moveBackward(this.d - 1);
                    break;
                }
                case 2: {
                    this.c = this.moveBackward(this.c - 1);
                    break;
                }
                case 4: 
                case 5: {
                    this.c = this.d;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown operation");
                }
            }
            if (this.e != 0) {
                this.e = 1;
            }
            return this.c >= 0;
        }

        public Object previous() {
            this.checkConcurrentModification();
            if (!this.hasPrevious()) {
                this.d = -1;
                throw new NoSuchElementException();
            }
            this.d = this.c;
            this.e = 3;
            return this.this$0.get(this.d);
        }

        public int nextIndex() {
            this.checkConcurrentModification();
            this.hasNext();
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.this$0.size()) {
                if (this.b.matches(this.this$0.get(n3))) {
                    if (n3 == this.c) {
                        return n2;
                    }
                    ++n2;
                }
                ++n3;
            }
            this.f = ContentList.b(this.this$0);
            return n2;
        }

        public int previousIndex() {
            this.checkConcurrentModification();
            if (this.hasPrevious()) {
                int n2 = 0;
                int n3 = 0;
                while (n3 < this.this$0.size()) {
                    if (this.b.matches(this.this$0.get(n3))) {
                        if (n3 == this.c) {
                            return n2;
                        }
                        ++n2;
                    }
                    ++n3;
                }
            }
            return -1;
        }

        public void add(Object object) {
            this.checkConcurrentModification();
            if (!this.b.matches(object)) {
                throw new IllegalAddException("Filter won't allow add of " + object.getClass().getName());
            }
            this.d = this.c + 1;
            this.this$0.add(this.d, object);
            this.f = ContentList.b(this.this$0);
            this.e = 5;
        }

        public void remove() {
            this.checkConcurrentModification();
            if (this.d < 0 || this.e == 6) {
                throw new IllegalStateException("no preceeding call to prev() or next()");
            }
            if (this.e == 5) {
                throw new IllegalStateException("cannot call remove() after add()");
            }
            Object object = this.this$0.get(this.d);
            if (!this.b.matches(object)) {
                throw new IllegalAddException("Filter won't allow " + object.getClass().getName() + " (index " + this.d + ") to be removed");
            }
            this.this$0.remove(this.d);
            this.f = ContentList.b(this.this$0);
            this.e = 6;
        }

        public void set(Object object) {
            this.checkConcurrentModification();
            if (this.e == 5 || this.e == 6) {
                throw new IllegalStateException("cannot call set() after add() or remove()");
            }
            if (this.d < 0) {
                throw new IllegalStateException("no preceeding call to prev() or next()");
            }
            if (this.b.matches(object)) {
                Object object2 = this.this$0.get(this.d);
                if (!this.b.matches(object2)) {
                    throw new IllegalAddException("Filter won't allow " + object2.getClass().getName() + " (index " + this.d + ") to be removed");
                }
            } else {
                throw new IllegalAddException("Filter won't allow index " + this.d + " to be set to " + object.getClass().getName());
            }
            this.this$0.set(this.d, object);
            this.f = ContentList.b(this.this$0);
        }

        private int initializeCursor(int n2) {
            if (n2 < 0) {
                throw new IndexOutOfBoundsException("Index: " + n2);
            }
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.this$0.size()) {
                Object object = this.this$0.get(n4);
                if (this.b.matches(object)) {
                    if (n2 == n3) {
                        return n4;
                    }
                    ++n3;
                }
                ++n4;
            }
            if (n2 > n3) {
                throw new IndexOutOfBoundsException("Index: " + n2 + " Size: " + n3);
            }
            return this.this$0.size();
        }

        private int moveForward(int n2) {
            if (n2 < 0) {
                n2 = 0;
            }
            int n3 = n2;
            while (n3 < this.this$0.size()) {
                Object object = this.this$0.get(n3);
                if (this.b.matches(object)) {
                    return n3;
                }
                ++n3;
            }
            return this.this$0.size();
        }

        private int moveBackward(int n2) {
            if (n2 >= this.this$0.size()) {
                n2 = this.this$0.size() - 1;
            }
            int n3 = n2;
            while (n3 >= 0) {
                Object object = this.this$0.get(n3);
                if (this.b.matches(object)) {
                    return n3;
                }
                --n3;
            }
            return -1;
        }

        private void checkConcurrentModification() {
            if (this.f != ContentList.b(this.this$0)) {
                throw new ConcurrentModificationException();
            }
        }
    }

    public class FilterList
    extends AbstractList
    implements Serializable {
        public Filter a;
        public int c;
        public int b;
        private final ContentList this$0;

        public FilterList(ContentList contentList, Filter filter) {
            this.this$0 = contentList;
            this.c = 0;
            this.b = -1;
            this.a = filter;
        }

        public void add(int n2, Object object) {
            if (this.a.matches(object)) {
                int n3 = this.getAdjustedIndex(n2);
                this.this$0.add(n3, object);
                ++this.b;
                ++this.c;
            } else {
                throw new IllegalAddException("Filter won't allow the " + object.getClass().getName() + " '" + object + "' to be added to the list");
            }
        }

        public Object get(int n2) {
            int n3 = this.getAdjustedIndex(n2);
            return this.this$0.get(n3);
        }

        public Iterator iterator() {
            return new FilterListIterator(this.this$0, this.a, 0);
        }

        public ListIterator listIterator() {
            return new FilterListIterator(this.this$0, this.a, 0);
        }

        public ListIterator listIterator(int n2) {
            return new FilterListIterator(this.this$0, this.a, n2);
        }

        public Object remove(int n2) {
            int n3 = this.getAdjustedIndex(n2);
            Object object = this.this$0.get(n3);
            if (this.a.matches(object)) {
                object = this.this$0.remove(n3);
                ++this.b;
                --this.c;
            } else {
                throw new IllegalAddException("Filter won't allow the " + object.getClass().getName() + " '" + object + "' (index " + n2 + ") to be removed");
            }
            return object;
        }

        public Object set(int n2, Object object) {
            Object object2 = null;
            if (this.a.matches(object)) {
                int n3 = this.getAdjustedIndex(n2);
                object2 = this.this$0.get(n3);
                if (!this.a.matches(object2)) {
                    throw new IllegalAddException("Filter won't allow the " + object2.getClass().getName() + " '" + object2 + "' (index " + n2 + ") to be removed");
                }
                object2 = this.this$0.set(n3, object);
                this.b += 2;
            } else {
                throw new IllegalAddException("Filter won't allow index " + n2 + " to be set to " + object.getClass().getName());
            }
            return object2;
        }

        public int size() {
            if (this.b == ContentList.b(this.this$0)) {
                return this.c;
            }
            this.c = 0;
            int n2 = 0;
            while (n2 < this.this$0.size()) {
                Content content = ContentList.c(this.this$0)[n2];
                if (this.a.matches(content)) {
                    ++this.c;
                }
                ++n2;
            }
            this.b = ContentList.b(this.this$0);
            return this.c;
        }

        private final int getAdjustedIndex(int n2) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < ContentList.a(this.this$0)) {
                Content content = ContentList.c(this.this$0)[n4];
                if (this.a.matches(content)) {
                    if (n2 == n3) {
                        return n4;
                    }
                    ++n3;
                }
                ++n4;
            }
            if (n2 == n3) {
                return ContentList.a(this.this$0);
            }
            return ContentList.a(this.this$0) + 1;
        }
    }
}

