/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.IllegalDataException;
import org.jdom.IllegalNameException;
import org.jdom.Namespace;
import org.jdom.Verifier;

public class Attribute
implements Serializable,
Cloneable {
    private static final String CVS_ID = "@(#) $RCSfile: Attribute.java,v $ $Revision: 1.49 $ $Date: 2004/02/06 09:28:30 $ $Name: jdom_1_0_b10 $";
    public static final int UNDECLARED_TYPE = 0;
    public static final int CDATA_TYPE = 1;
    public static final int ID_TYPE = 2;
    public static final int IDREF_TYPE = 3;
    public static final int IDREFS_TYPE = 4;
    public static final int ENTITY_TYPE = 5;
    public static final int ENTITIES_TYPE = 6;
    public static final int NMTOKEN_TYPE = 7;
    public static final int NMTOKENS_TYPE = 8;
    public static final int NOTATION_TYPE = 9;
    public static final int ENUMERATED_TYPE = 10;
    public static final int UNDECLARED_ATTRIBUTE = 0;
    public static final int CDATA_ATTRIBUTE = 1;
    public static final int ID_ATTRIBUTE = 2;
    public static final int IDREF_ATTRIBUTE = 3;
    public static final int IDREFS_ATTRIBUTE = 4;
    public static final int ENTITY_ATTRIBUTE = 5;
    public static final int ENTITIES_ATTRIBUTE = 6;
    public static final int NMTOKEN_ATTRIBUTE = 7;
    public static final int NMTOKENS_ATTRIBUTE = 8;
    public static final int NOTATION_ATTRIBUTE = 9;
    public static final int ENUMERATED_ATTRIBUTE = 10;
    public String name;
    public transient Namespace namespace;
    public String value;
    public int type = 0;
    public Object parent;

    public Attribute() {
    }

    public Attribute(String string, String string2, Namespace namespace) {
        this.setName(string);
        this.setValue(string2);
        this.setNamespace(namespace);
    }

    public Attribute(String string, String string2, int n2, Namespace namespace) {
        this.setName(string);
        this.setValue(string2);
        this.setAttributeType(n2);
        this.setNamespace(namespace);
    }

    public Attribute(String string, String string2) {
        this(string, string2, 0, Namespace.NO_NAMESPACE);
    }

    public Attribute(String string, String string2, int n2) {
        this(string, string2, n2, Namespace.NO_NAMESPACE);
    }

    public Element getParent() {
        return (Element)this.parent;
    }

    public Document getDocument() {
        if (this.parent != null) {
            return ((Element)this.parent).getDocument();
        }
        return null;
    }

    public Attribute setParent(Element element) {
        this.parent = element;
        return this;
    }

    public Attribute detach() {
        Element element = this.getParent();
        if (element != null) {
            element.removeAttribute(this.getName(), this.getNamespace());
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Attribute setName(String string) {
        String string2 = Verifier.checkAttributeName(string);
        if (string2 != null) {
            throw new IllegalNameException(string, "attribute", string2);
        }
        this.name = string;
        return this;
    }

    public String getQualifiedName() {
        String string = this.namespace.getPrefix();
        if (string != null && !string.equals("")) {
            return string + ':' + this.getName();
        }
        return this.getName();
    }

    public String getNamespacePrefix() {
        return this.namespace.getPrefix();
    }

    public String getNamespaceURI() {
        return this.namespace.getURI();
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public Attribute setNamespace(Namespace namespace) {
        if (namespace == null) {
            namespace = Namespace.NO_NAMESPACE;
        }
        if (namespace != Namespace.NO_NAMESPACE && namespace.getPrefix().equals("")) {
            throw new IllegalNameException("", "attribute namespace", "An attribute namespace without a prefix can only be the NO_NAMESPACE namespace");
        }
        this.namespace = namespace;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public Attribute setValue(String string) {
        String string2 = null;
        string2 = Verifier.checkCharacterData(string);
        if (string2 != null) {
            throw new IllegalDataException(string, "attribute", string2);
        }
        this.value = string;
        return this;
    }

    public int getAttributeType() {
        return this.type;
    }

    public Attribute setAttributeType(int n2) {
        if (n2 < 0 || n2 > 10) {
            throw new IllegalDataException(String.valueOf(n2), "attribute", "Illegal attribute type");
        }
        this.type = n2;
        return this;
    }

    public String toString() {
        return "[Attribute: " + this.getQualifiedName() + "=\"" + this.value + "\"" + "]";
    }

    public final boolean equals(Object object) {
        return object == this;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public Object clone() {
        Attribute attribute = null;
        try {
            attribute = (Attribute)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        attribute.parent = null;
        return attribute;
    }

    public int getIntValue() throws DataConversionException {
        try {
            return Integer.parseInt(this.value.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataConversionException(this.name, "int");
        }
    }

    public long getLongValue() throws DataConversionException {
        try {
            return Long.parseLong(this.value.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataConversionException(this.name, "long");
        }
    }

    public float getFloatValue() throws DataConversionException {
        try {
            return Float.valueOf(this.value.trim()).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataConversionException(this.name, "float");
        }
    }

    public double getDoubleValue() throws DataConversionException {
        try {
            return Double.valueOf(this.value.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataConversionException(this.name, "double");
        }
    }

    public boolean getBooleanValue() throws DataConversionException {
        String string = this.value.trim();
        if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("on") || string.equalsIgnoreCase("1") || string.equalsIgnoreCase("yes")) {
            return true;
        }
        if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("off") || string.equalsIgnoreCase("0") || string.equalsIgnoreCase("no")) {
            return false;
        }
        throw new DataConversionException(this.name, "boolean");
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.namespace.getPrefix());
        objectOutputStream.writeObject(this.namespace.getURI());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.namespace = Namespace.getNamespace((String)objectInputStream.readObject(), (String)objectInputStream.readObject());
    }
}

