/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jdesktop.layout.Baseline;
import org.jdesktop.layout.LayoutStyle;

public class GroupLayout
implements LayoutManager2 {
    private static final int MIN_SIZE = 0;
    private static final int PREF_SIZE = 1;
    private static final int MAX_SIZE = 2;
    private static final int UNSET = Integer.MIN_VALUE;
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    private static final int NO_ALIGNMENT = 0;
    public static final int LEADING = 1;
    public static final int TRAILING = 2;
    public static final int CENTER = 3;
    public static final int BASELINE = 3;
    public static final int DEFAULT_SIZE = -1;
    public static final int PREFERRED_SIZE = -2;
    private boolean autocreatePadding;
    private boolean autocreateContainerPadding;
    private Group horizontalGroup;
    private Group verticalGroup;
    private Map componentInfos;
    private Container host;
    private List parallelList;
    private boolean springsAdded;
    private boolean hasPreferredPaddingSprings;
    public static Class a;

    private static void checkSize(int n2, int n3, int n4, boolean bl2) {
        GroupLayout.checkResizeType(n2, bl2);
        if (!bl2 && n3 < 0) {
            throw new IllegalArgumentException("Pref must be >= 0");
        }
        GroupLayout.checkResizeType(n4, bl2);
        GroupLayout.checkLessThan(n2, n3);
        GroupLayout.checkLessThan(n2, n4);
        GroupLayout.checkLessThan(n3, n4);
    }

    private static void checkResizeType(int n2, boolean bl2) {
        if (n2 < 0 && (bl2 && n2 != -1 && n2 != -2 || !bl2 && n2 != -2)) {
            throw new IllegalArgumentException("Invalid size");
        }
    }

    private static void checkLessThan(int n2, int n3) {
        if (n2 >= 0 && n3 >= 0 && n2 > n3) {
            throw new IllegalArgumentException("Following is not met: min<=pref<=max");
        }
    }

    private static void checkAlignment(int n2, boolean bl2) {
        if (n2 == 1 || n2 == 2 || n2 == 3) {
            return;
        }
        if (bl2 && n2 != 3) {
            throw new IllegalArgumentException("Alignment must be one of:LEADING, TRAILING, CENTER or BASELINE");
        }
        throw new IllegalArgumentException("Alignment must be one of:LEADING, TRAILING or CENTER");
    }

    public void dump() {
        System.err.println("HORIZONTAL");
        this.dump(this.horizontalGroup, "  ", 1);
        System.err.println("VERTICAL");
        this.dump(this.verticalGroup, "  ", 2);
    }

    public void dump(Spring spring, String string, int n2) {
        Object object;
        String string2 = "";
        String string3 = "";
        if (spring instanceof ComponentSpring) {
            object = (ComponentSpring)spring;
            string2 = Integer.toString(((ComponentSpring)object).e()) + " ";
            String string4 = ((ComponentSpring)object).g().getName();
            if (string4 != null) {
                string2 = "name=" + string4 + ", ";
            }
        }
        if (spring instanceof AutopaddingSpring) {
            object = (AutopaddingSpring)spring;
            string3 = ", userCreated=" + ((AutopaddingSpring)object).getUserCreated() + ", matches=" + ((AutopaddingSpring)object).e();
        }
        System.err.println(string + spring.getClass().getName() + " " + Integer.toHexString(spring.hashCode()) + " " + string2 + ", size=" + spring.b() + ", alignment=" + spring.c() + " prefs=[" + spring.h(n2) + " " + spring.b(n2) + " " + spring.e(n2) + string3 + "]");
        if (spring instanceof Group) {
            object = ((Group)spring).a;
            string = string + "  ";
            for (int i2 = 0; i2 < object.size(); ++i2) {
                this.dump((Spring)object.get(i2), string, n2);
            }
        }
    }

    public GroupLayout(Container container) {
        if (container == null) {
            throw new IllegalArgumentException("Container must be non-null");
        }
        this.host = container;
        this.setHorizontalGroup(this.createParallelGroup(1, true));
        this.setVerticalGroup(this.createParallelGroup(1, true));
        this.componentInfos = new HashMap();
        this.autocreatePadding = false;
        this.parallelList = new ArrayList();
    }

    public void setAutocreateGaps(boolean bl2) {
        this.autocreatePadding = bl2;
    }

    public boolean getAutocreateGaps() {
        return this.autocreatePadding;
    }

    public void setAutocreateContainerGaps(boolean bl2) {
        if (bl2 != this.autocreateContainerPadding) {
            this.autocreateContainerPadding = bl2;
            this.horizontalGroup = this.createTopLevelGroup(this.getHorizontalGroup());
            this.verticalGroup = this.createTopLevelGroup(this.getVerticalGroup());
        }
    }

    public boolean getAutocreateContainerGaps() {
        return this.autocreateContainerPadding;
    }

    public void setHorizontalGroup(Group group) {
        if (group == null) {
            throw new IllegalArgumentException("Group must be non-null");
        }
        this.horizontalGroup = this.createTopLevelGroup(group);
    }

    public Group getHorizontalGroup() {
        int n2 = 0;
        if (this.horizontalGroup.a.size() > 1) {
            n2 = 1;
        }
        return (Group)this.horizontalGroup.a.get(n2);
    }

    public void setVerticalGroup(Group group) {
        if (group == null) {
            throw new IllegalArgumentException("Group must be non-null");
        }
        this.verticalGroup = this.createTopLevelGroup(group);
    }

    public Group getVerticalGroup() {
        int n2 = 0;
        if (this.verticalGroup.a.size() > 1) {
            n2 = 1;
        }
        return (Group)this.verticalGroup.a.get(n2);
    }

    private Group createTopLevelGroup(Group group) {
        SequentialGroup sequentialGroup = this.createSequentialGroup();
        if (this.getAutocreateContainerGaps()) {
            sequentialGroup.b(new ContainerAutopaddingSpring(this));
            sequentialGroup.add(group);
            sequentialGroup.b(new ContainerAutopaddingSpring(this));
        } else {
            sequentialGroup.add(group);
        }
        return sequentialGroup;
    }

    public SequentialGroup createSequentialGroup() {
        return new SequentialGroup(this);
    }

    public ParallelGroup createParallelGroup() {
        return this.createParallelGroup(1);
    }

    public ParallelGroup createParallelGroup(int n2) {
        return this.createParallelGroup(n2, true);
    }

    public ParallelGroup createParallelGroup(int n2, boolean bl2) {
        if (n2 == 3) {
            return new BaselineGroup(this, bl2);
        }
        return new ParallelGroup(this, n2, bl2);
    }

    public void linkSize(Component[] componentArray) {
        this.linkSize(componentArray, 3);
    }

    public void linkSize(Component[] componentArray, int n2) {
        boolean bl2;
        if (componentArray == null) {
            throw new IllegalArgumentException("Components must be non-null");
        }
        boolean bl3 = (n2 & 1) == 1;
        boolean bl4 = bl2 = (n2 & 2) == 2;
        if (!bl2 && !bl3) {
            throw new IllegalArgumentException("Axis must contain HORIZONTAL or VERTICAL");
        }
        for (int i2 = componentArray.length - 1; i2 >= 0; --i2) {
            Component component = componentArray[i2];
            if (componentArray[i2] == null) {
                throw new IllegalArgumentException("Components must be non-null");
            }
            this.getComponentInfo(component);
        }
        if (bl3) {
            this.linkSize0(componentArray, 1);
        }
        if (bl2) {
            this.linkSize0(componentArray, 2);
        }
    }

    private void linkSize0(Component[] componentArray, int n2) {
        ComponentInfo componentInfo = this.getComponentInfo(componentArray[componentArray.length - 1]).getMasterComponentInfo(n2);
        for (int i2 = componentArray.length - 2; i2 >= 0; --i2) {
            componentInfo.addChild(this.getComponentInfo(componentArray[i2]), n2);
        }
    }

    public void replace(Component component, Component component2) {
        if (component == null || component2 == null) {
            throw new IllegalArgumentException("Components must be non-null");
        }
        ComponentInfo componentInfo = (ComponentInfo)this.componentInfos.remove(component);
        if (componentInfo == null) {
            throw new IllegalArgumentException("Component must already exist");
        }
        this.host.remove(component);
        this.host.add(component2);
        componentInfo.setComponent(component2);
        this.componentInfos.put(component2, componentInfo);
        this.invalidateLayout(this.host);
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        this.checkParent(container);
        this.prepare(1);
        return this.adjustSize(this.horizontalGroup.b(1), this.verticalGroup.b(2));
    }

    public Dimension minimumLayoutSize(Container container) {
        this.checkParent(container);
        this.prepare(0);
        return this.adjustSize(this.horizontalGroup.h(1), this.verticalGroup.h(2));
    }

    public void layoutContainer(Container container) {
        this.prepare();
        Insets insets = container.getInsets();
        if (this.getAutocreateGaps() || this.getAutocreateContainerGaps() || this.hasPreferredPaddingSprings) {
            this.resetAutopadding(this.horizontalGroup, 1, -1, 0, container.getWidth() - insets.left - insets.right);
            this.resetAutopadding(this.verticalGroup, 2, -1, 0, container.getHeight() - insets.top - insets.bottom);
        }
        this.horizontalGroup.a(1, 0, container.getWidth() - insets.left - insets.right);
        this.verticalGroup.a(2, 0, container.getHeight() - insets.top - insets.bottom);
        Iterator iterator = this.componentInfos.values().iterator();
        while (iterator.hasNext()) {
            ComponentInfo componentInfo = (ComponentInfo)iterator.next();
            Component component = componentInfo.getComponent();
            componentInfo.setBounds(insets);
        }
    }

    public void addLayoutComponent(Component component, Object object) {
    }

    public Dimension maximumLayoutSize(Container container) {
        this.checkParent(container);
        this.prepare(2);
        return this.adjustSize(this.horizontalGroup.e(1), this.verticalGroup.e(2));
    }

    public float getLayoutAlignmentX(Container container) {
        this.checkParent(container);
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        this.checkParent(container);
        return 0.5f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateLayout(Container container) {
        this.checkParent(container);
        Object object = container.getTreeLock();
        synchronized (object) {
            this.horizontalGroup.a(1, Integer.MIN_VALUE, Integer.MIN_VALUE);
            this.verticalGroup.a(2, Integer.MIN_VALUE, Integer.MIN_VALUE);
            Iterator iterator = this.componentInfos.values().iterator();
            while (iterator.hasNext()) {
                ComponentInfo componentInfo = (ComponentInfo)iterator.next();
                componentInfo.clear();
            }
        }
    }

    private void resetAutopadding(Group group, int n2, int n3, int n4, int n5) {
        group.e();
        switch (n3) {
            case 0: {
                n5 = group.h(n2);
                break;
            }
            case 1: {
                n5 = group.b(n2);
                break;
            }
            case 2: {
                n5 = group.e(n2);
            }
        }
        group.a(n2, n4, n5);
        group.i(n2);
    }

    private void prepare(int n2) {
        this.prepare();
        if (this.getAutocreateGaps() || this.getAutocreateContainerGaps() || this.hasPreferredPaddingSprings) {
            this.resetAutopadding(this.horizontalGroup, 1, n2, 0, 0);
            this.resetAutopadding(this.verticalGroup, 2, n2, 0, 0);
        }
    }

    private void prepare() {
        if (this.springsAdded) {
            this.registerComponents(this.horizontalGroup, 1);
            this.registerComponents(this.verticalGroup, 2);
            this.checkComponents();
            this.horizontalGroup.f();
            this.verticalGroup.f();
            if (this.getAutocreateGaps()) {
                this.adjustAutopadding(true);
            } else if (this.hasPreferredPaddingSprings || this.getAutocreateContainerGaps()) {
                this.adjustAutopadding(false);
            }
            this.springsAdded = false;
        }
    }

    private void checkComponents() {
        Iterator iterator = this.componentInfos.values().iterator();
        while (iterator.hasNext()) {
            ComponentInfo componentInfo = (ComponentInfo)iterator.next();
            if (componentInfo.b == null) {
                throw new IllegalStateException(ComponentInfo.a(componentInfo) + " is not attached to a horizontal group");
            }
            if (componentInfo.a != null) continue;
            throw new IllegalStateException(ComponentInfo.a(componentInfo) + " is not attached to a vertical group");
        }
    }

    private void registerComponents(Group group, int n2) {
        List list = group.a;
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            Spring spring = (Spring)list.get(i2);
            if (spring instanceof ComponentSpring) {
                ((ComponentSpring)spring).k(n2);
                continue;
            }
            if (!(spring instanceof Group)) continue;
            this.registerComponents((Group)spring, n2);
        }
    }

    private Dimension adjustSize(int n2, int n3) {
        Insets insets = this.host.getInsets();
        return new Dimension(n2 + insets.left + insets.right, n3 + insets.top + insets.bottom);
    }

    private void checkParent(Container container) {
        if (container != this.host) {
            throw new IllegalArgumentException("GroupLayout can only be used with one Container at a time");
        }
    }

    private ComponentInfo getComponentInfo(Component component) {
        ComponentInfo componentInfo = (ComponentInfo)this.componentInfos.get(component);
        if (componentInfo == null) {
            this.componentInfos.put(component, new ComponentInfo(component));
            this.host.add(component);
        }
        return componentInfo;
    }

    private void adjustAutopadding(boolean bl2) {
        this.horizontalGroup.a(1, null, new ArrayList(1), new ArrayList(1), bl2);
        this.verticalGroup.a(2, null, new ArrayList(1), new ArrayList(1), bl2);
    }

    private boolean areParallelSiblings(Component component, Component component2, int n2) {
        Spring spring;
        ComponentSpring componentSpring;
        ComponentSpring componentSpring2;
        ComponentInfo componentInfo = this.getComponentInfo(component);
        ComponentInfo componentInfo2 = this.getComponentInfo(component2);
        if (n2 == 1) {
            componentSpring2 = componentInfo.b;
            componentSpring = componentInfo2.b;
        } else {
            componentSpring2 = componentInfo.a;
            componentSpring = componentInfo2.a;
        }
        List list = this.parallelList;
        list.clear();
        for (spring = componentSpring2.a(); spring != null; spring = spring.a()) {
            list.add(spring);
        }
        for (spring = componentSpring.a(); spring != null; spring = spring.a()) {
            if (!list.contains(spring)) continue;
            while (spring != null) {
                if (spring instanceof ParallelGroup) {
                    return true;
                }
                spring = spring.a();
            }
            return false;
        }
        return false;
    }

    public static void a(int n2, boolean bl2) {
        GroupLayout.checkAlignment(n2, bl2);
    }

    public static boolean b(GroupLayout groupLayout, boolean bl2) {
        groupLayout.springsAdded = bl2;
        return groupLayout.springsAdded;
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public static boolean a(GroupLayout groupLayout, boolean bl2) {
        groupLayout.hasPreferredPaddingSprings = bl2;
        return groupLayout.hasPreferredPaddingSprings;
    }

    public static void a(int n2, int n3, int n4, boolean bl2) {
        GroupLayout.checkSize(n2, n3, n4, bl2);
    }

    public static ComponentInfo a(GroupLayout groupLayout, Component component) {
        return groupLayout.getComponentInfo(component);
    }

    public static Container a(GroupLayout groupLayout) {
        return groupLayout.host;
    }

    public static boolean a(GroupLayout groupLayout, Component component, Component component2, int n2) {
        return groupLayout.areParallelSiblings(component, component2, n2);
    }

    public static class 1 {
    }

    private static class ComponentInfo {
        private Component component;
        public ComponentSpring b;
        public ComponentSpring a;
        private ComponentInfo horizontalMaster;
        private ComponentInfo verticalMaster;
        private List horizontalDependants;
        private List verticalDependants;
        private int[] horizontalSizes;
        private int[] verticalSizes;
        public static final boolean c = !(a == null ? (a = GroupLayout.a("org.jdesktop.layout.GroupLayout")) : a).desiredAssertionStatus();

        public ComponentInfo(Component component) {
            this.component = component;
            this.clear();
        }

        public void setBounds(Insets insets) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            if (this.b != null) {
                n2 = this.b.e();
                n4 = this.b.b();
            }
            if (this.a != null) {
                n3 = this.a.e();
                n5 = this.a.b();
            }
            this.component.setBounds(n2 + insets.left, n3 + insets.top, n4, n5);
        }

        public void setComponent(Component component) {
            this.component = component;
            if (this.b != null) {
                this.b.a(component);
            }
            if (this.a != null) {
                this.a.a(component);
            }
        }

        public Component getComponent() {
            return this.component;
        }

        public boolean isLinked(int n2) {
            if (n2 == 1) {
                return this.horizontalMaster != null;
            }
            return this.verticalMaster != null;
        }

        public ComponentInfo getMasterComponentInfo(int n2) {
            if (n2 == 1) {
                if (this.horizontalMaster == null) {
                    this.horizontalMaster = this;
                    this.horizontalDependants = new ArrayList(1);
                    this.horizontalDependants.add(this);
                    this.horizontalSizes = new int[3];
                    this.clear();
                }
                return this.horizontalMaster;
            }
            if (this.verticalMaster == null) {
                this.verticalMaster = this;
                this.verticalDependants = new ArrayList(1);
                this.verticalDependants.add(this);
                this.verticalSizes = new int[3];
                this.clear();
            }
            return this.verticalMaster;
        }

        public void addChild(ComponentInfo componentInfo, int n2) {
            if (n2 == 1) {
                this.addChild0(componentInfo, 1);
            } else {
                if (!c && n2 != 2) {
                    throw new AssertionError();
                }
                this.addChild0(componentInfo, 2);
            }
        }

        private void addChild0(ComponentInfo componentInfo, int n2) {
            if (n2 == 1) {
                if (componentInfo.horizontalMaster == componentInfo) {
                    this.horizontalDependants.addAll(componentInfo.horizontalDependants);
                    componentInfo.horizontalDependants = null;
                    componentInfo.horizontalSizes = null;
                } else {
                    this.horizontalDependants.add(componentInfo);
                }
                componentInfo.horizontalMaster = this;
            } else {
                if (componentInfo.verticalMaster == componentInfo) {
                    this.verticalDependants.addAll(componentInfo.verticalDependants);
                    componentInfo.verticalDependants = null;
                    componentInfo.verticalSizes = null;
                } else {
                    this.verticalDependants.add(componentInfo);
                }
                componentInfo.verticalMaster = this;
            }
        }

        public void clear() {
            this.clear(this.horizontalSizes);
            this.clear(this.verticalSizes);
        }

        private void clear(int[] nArray) {
            if (nArray != null) {
                for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
                    nArray[i2] = Integer.MIN_VALUE;
                }
            }
        }

        public int a(int n2, int n3) {
            int[] nArray = null;
            List list = null;
            if (n2 == 1) {
                if (this.horizontalMaster != this) {
                    return this.horizontalMaster.a(n2, n3);
                }
                nArray = this.horizontalSizes;
                list = this.horizontalDependants;
            } else if (n2 == 2) {
                if (this.verticalMaster != this) {
                    return this.verticalMaster.a(n2, n3);
                }
                nArray = this.verticalSizes;
                list = this.verticalDependants;
            }
            if (nArray[n3] == Integer.MIN_VALUE) {
                nArray[n3] = this.calcSize(list, n2, n3);
            }
            return nArray[n3];
        }

        private int calcSize(List list, int n2, int n3) {
            int n4 = list.size() - 1;
            int n5 = this.getSize(list, n2, n3, n4--);
            while (n4 >= 0) {
                n5 = Math.max(n5, this.getSize(list, n2, n3, n4--));
            }
            return n5;
        }

        private int getSize(List list, int n2, int n3, int n4) {
            ComponentInfo componentInfo = (ComponentInfo)list.get(n4);
            ComponentSpring componentSpring = n2 == 1 ? componentInfo.b : componentInfo.a;
            switch (n3) {
                case 0: {
                    return componentSpring.j(n2);
                }
                case 1: {
                    return componentSpring.i(n2);
                }
            }
            return componentSpring.l(n2);
        }

        public static Component a(ComponentInfo componentInfo) {
            return componentInfo.component;
        }
    }

    private class ContainerAutopaddingSpring
    extends AutopaddingSpring {
        private List targets;
        private final GroupLayout this$0;

        public ContainerAutopaddingSpring(GroupLayout groupLayout) {
            this.this$0 = groupLayout;
            super(groupLayout, null);
            this.setUserCreated(true);
        }

        public ContainerAutopaddingSpring(GroupLayout groupLayout, int n2, int n3) {
            this.this$0 = groupLayout;
            super(groupLayout, n2, n3);
            this.setUserCreated(true);
        }

        public void add(ComponentSpring componentSpring, int n2) {
            if (this.targets == null) {
                this.targets = new ArrayList(1);
            }
            this.targets.add(componentSpring);
        }

        public void calculatePadding(int n2) {
            LayoutStyle layoutStyle = LayoutStyle.getSharedInstance();
            int n3 = 0;
            this.size = 0;
            if (this.targets != null) {
                int n4 = n2 == 1 ? 7 : 1;
                for (int i2 = this.targets.size() - 1; i2 >= 0; --i2) {
                    ComponentSpring componentSpring = (ComponentSpring)this.targets.get(i2);
                    int n5 = 10;
                    if (componentSpring.g() instanceof JComponent) {
                        n5 = layoutStyle.getContainerGap((JComponent)componentSpring.g(), n4, GroupLayout.a(this.this$0));
                        n3 = Math.max(n5, n3);
                        n5 -= componentSpring.e();
                    } else {
                        n3 = Math.max(n5, n3);
                    }
                    this.size = Math.max(this.size, n5);
                }
            } else {
                int n6;
                int n7 = n6 = n2 == 1 ? 3 : 5;
                if (this.a != null) {
                    for (int i3 = this.a.size() - 1; i3 >= 0; --i3) {
                        ComponentSpring componentSpring = (ComponentSpring)this.a.get(i3);
                        n3 = Math.max(n3, this.updateSize(layoutStyle, componentSpring, n6));
                    }
                } else if (this.b != null) {
                    n3 = this.updateSize(layoutStyle, this.b, n6);
                }
            }
            if (this.c != Integer.MIN_VALUE) {
                this.size += Math.min(n3, this.c);
            }
        }

        private int updateSize(LayoutStyle layoutStyle, ComponentSpring componentSpring, int n2) {
            int n3 = 10;
            if (componentSpring.g() instanceof JComponent) {
                n3 = layoutStyle.getContainerGap((JComponent)componentSpring.g(), n2, GroupLayout.a(this.this$0));
            }
            int n4 = Math.max(0, this.a().b() - componentSpring.b() - componentSpring.e());
            this.size = Math.max(this.size, n3 - n4);
            return n3;
        }

        public String e() {
            if (this.a != null) {
                return "trailing: " + this.a.toString();
            }
            if (this.targets == null) {
                return "--";
            }
            return "leading: " + this.targets.toString();
        }
    }

    private static class AutopaddingMatch {
        public ComponentSpring source;
        public ComponentSpring target;

        public AutopaddingMatch(ComponentSpring componentSpring, ComponentSpring componentSpring2) {
            this.source = componentSpring;
            this.target = componentSpring2;
        }

        private String toString(ComponentSpring componentSpring) {
            return componentSpring.g().getName();
        }

        public String toString() {
            return "[" + this.toString(this.source) + "-" + this.toString(this.target) + "]";
        }
    }

    private class AutopaddingSpring
    extends Spring {
        public List a;
        public ComponentSpring b;
        private List matches;
        public int size;
        public int c;
        private int pref;
        private int max;
        private int type;
        private boolean userCreated;
        private final GroupLayout this$0;

        private AutopaddingSpring(GroupLayout groupLayout) {
            this.this$0 = groupLayout;
            super(groupLayout);
            this.pref = -2;
            this.max = -2;
            this.type = 0;
        }

        public AutopaddingSpring(GroupLayout groupLayout, int n2, int n3) {
            this.this$0 = groupLayout;
            super(groupLayout);
            this.pref = n2;
            this.max = n3;
        }

        public AutopaddingSpring(GroupLayout groupLayout, int n2, int n3, int n4) {
            this.this$0 = groupLayout;
            super(groupLayout);
            this.type = n2;
            this.pref = n3;
            this.max = n4;
            this.userCreated = true;
        }

        public void setSource(ComponentSpring componentSpring) {
            this.b = componentSpring;
        }

        public void setSources(List list) {
            this.a = new ArrayList(list.size());
            this.a.addAll(list);
        }

        public void setUserCreated(boolean bl2) {
            this.userCreated = bl2;
        }

        public boolean getUserCreated() {
            return this.userCreated;
        }

        public void d() {
            this.c = this.b();
            super.d();
            this.size = 0;
        }

        public void reset() {
            this.size = 0;
            this.a = null;
            this.b = null;
            this.matches = null;
        }

        public void calculatePadding(int n2) {
            this.size = 0;
            int n3 = 0;
            if (this.matches != null) {
                LayoutStyle layoutStyle = LayoutStyle.getSharedInstance();
                int n4 = n2 == 1 ? 3 : 5;
                for (int i2 = this.matches.size() - 1; i2 >= 0; --i2) {
                    AutopaddingMatch autopaddingMatch = (AutopaddingMatch)this.matches.get(i2);
                    n3 = Math.max(n3, this.calculatePadding(layoutStyle, n4, autopaddingMatch.source, autopaddingMatch.target));
                }
            }
            if (this.c != Integer.MIN_VALUE) {
                this.size += Math.min(n3, this.c);
            }
        }

        private int calculatePadding(LayoutStyle layoutStyle, int n2, ComponentSpring componentSpring, ComponentSpring componentSpring2) {
            int n3 = componentSpring2.e() - (componentSpring.e() + componentSpring.b());
            if (n3 >= 0) {
                int n4 = componentSpring.g() instanceof JComponent && componentSpring2.g() instanceof JComponent ? layoutStyle.getPreferredGap((JComponent)componentSpring.g(), (JComponent)componentSpring2.g(), this.type, n2, GroupLayout.a(this.this$0)) : 10;
                if (n4 > n3) {
                    this.size = Math.max(this.size, n4 - n3);
                }
                return n4;
            }
            return 0;
        }

        public void add(ComponentSpring componentSpring, int n2) {
            int n3;
            int n4 = n3 = n2 == 1 ? 2 : 1;
            if (this.b != null) {
                if (GroupLayout.a(this.this$0, this.b.g(), componentSpring.g(), n3)) {
                    this.addMatch(this.b, componentSpring);
                }
            } else {
                Component component = componentSpring.g();
                for (int i2 = this.a.size() - 1; i2 >= 0; --i2) {
                    ComponentSpring componentSpring2 = (ComponentSpring)this.a.get(i2);
                    if (!GroupLayout.a(this.this$0, componentSpring2.g(), component, n3)) continue;
                    this.addMatch(componentSpring2, componentSpring);
                }
            }
        }

        private void addMatch(ComponentSpring componentSpring, ComponentSpring componentSpring2) {
            if (this.matches == null) {
                this.matches = new ArrayList(1);
            }
            this.matches.add(new AutopaddingMatch(componentSpring, componentSpring2));
        }

        public int d(int n2) {
            return this.size;
        }

        public int g(int n2) {
            if (this.pref == -2 || this.pref == -1) {
                return this.size;
            }
            return Math.max(this.size, this.pref);
        }

        public int f(int n2) {
            if (this.max >= 0) {
                return Math.max(this.b(n2), this.max);
            }
            return this.size;
        }

        public String e() {
            return this.matches == null ? "" : this.matches.toString();
        }

        public String toString() {
            return super.toString() + this.e();
        }

        public AutopaddingSpring(GroupLayout groupLayout, 1 var2_2) {
            this(groupLayout);
        }
    }

    public class GapSpring
    extends Spring {
        private int min;
        private int pref;
        private int max;
        private final GroupLayout this$0;

        public GapSpring(GroupLayout groupLayout, int n2, int n3, int n4) {
            this.this$0 = groupLayout;
            super(groupLayout);
            GroupLayout.a(n2, n3, n4, false);
            this.min = n2;
            this.pref = n3;
            this.max = n4;
        }

        public int d(int n2) {
            if (this.min == -2) {
                return this.b(n2);
            }
            return this.min;
        }

        public int g(int n2) {
            return this.pref;
        }

        public int f(int n2) {
            if (this.max == -2) {
                return this.b(n2);
            }
            return this.max;
        }
    }

    public class PaddingSpring
    extends Spring {
        private JComponent source;
        private JComponent target;
        private int type;
        private boolean canGrow;
        private final GroupLayout this$0;

        public PaddingSpring(GroupLayout groupLayout, JComponent jComponent, JComponent jComponent2, int n2, boolean bl2) {
            this.this$0 = groupLayout;
            super(groupLayout);
            this.source = jComponent;
            this.target = jComponent2;
            this.type = n2;
            this.canGrow = bl2;
        }

        public int d(int n2) {
            return this.getPadding(n2);
        }

        public int g(int n2) {
            return this.getPadding(n2);
        }

        public int f(int n2) {
            if (this.canGrow) {
                return Short.MAX_VALUE;
            }
            return this.getPadding(n2);
        }

        private int getPadding(int n2) {
            int n3 = n2 == 1 ? 3 : 5;
            return LayoutStyle.getSharedInstance().getPreferredGap(this.source, this.target, this.type, n3, GroupLayout.a(this.this$0));
        }
    }

    public class ComponentSpring
    extends Spring {
        private Component component;
        private int origin;
        private int min;
        private int pref;
        private int max;
        private int baseline;
        private boolean installed;
        public static final boolean a = !(a == null ? (a = GroupLayout.a("org.jdesktop.layout.GroupLayout")) : a).desiredAssertionStatus();
        private final GroupLayout this$0;

        private ComponentSpring(GroupLayout groupLayout, Component component, int n2, int n3, int n4) {
            this.this$0 = groupLayout;
            super(groupLayout);
            this.baseline = -1;
            this.component = component;
            GroupLayout.a(n2, n3, n4, true);
            this.min = n2;
            this.max = n4;
            this.pref = n3;
            GroupLayout.a(groupLayout, component);
        }

        public int d(int n2) {
            if (this.isLinked(n2)) {
                return this.getLinkSize(n2, 0);
            }
            return this.j(n2);
        }

        public int j(int n2) {
            if (this.min >= 0) {
                return this.min;
            }
            if (this.min == -2) {
                return this.i(n2);
            }
            if (!a && this.min != -1) {
                throw new AssertionError();
            }
            return this.getSizeAlongAxis(n2, this.component.getMinimumSize());
        }

        public int g(int n2) {
            if (this.isLinked(n2)) {
                return this.getLinkSize(n2, 1);
            }
            return Math.max(this.h(n2), this.i(n2));
        }

        public int i(int n2) {
            if (this.pref >= 0) {
                return this.pref;
            }
            return this.getSizeAlongAxis(n2, this.component.getPreferredSize());
        }

        public int f(int n2) {
            if (this.isLinked(n2)) {
                return this.getLinkSize(n2, 2);
            }
            return Math.max(this.h(n2), this.l(n2));
        }

        public int l(int n2) {
            if (this.max >= 0) {
                return this.max;
            }
            if (this.max == -2) {
                return this.i(n2);
            }
            if (!a && this.max != -1) {
                throw new AssertionError();
            }
            return this.getSizeAlongAxis(n2, this.component.getMaximumSize());
        }

        private int getSizeAlongAxis(int n2, Dimension dimension) {
            return n2 == 1 ? dimension.width : dimension.height;
        }

        private int getLinkSize(int n2, int n3) {
            ComponentInfo componentInfo = GroupLayout.a(this.this$0, this.component);
            return componentInfo.a(n2, n3);
        }

        public void a(int n2, int n3, int n4) {
            super.a(n2, n3, n4);
            this.origin = n3;
            if (n4 == Integer.MIN_VALUE) {
                this.baseline = -1;
            }
        }

        public int e() {
            return this.origin;
        }

        public void a(Component component) {
            this.component = component;
        }

        public Component g() {
            return this.component;
        }

        public int f() {
            if (this.baseline == -1 && this.component instanceof JComponent) {
                ComponentSpring componentSpring = GroupLayout.a((GroupLayout)this.this$0, (Component)this.component).b;
                int n2 = componentSpring != null ? componentSpring.b() : this.component.getPreferredSize().width;
                this.baseline = Baseline.getBaseline((JComponent)this.component, n2, this.b(2));
            }
            return this.baseline;
        }

        private boolean isLinked(int n2) {
            return GroupLayout.a(this.this$0, this.component).isLinked(n2);
        }

        public void k(int n2) {
            if (!this.installed) {
                this.installed = true;
                if (n2 == 1) {
                    GroupLayout.a((GroupLayout)this.this$0, (Component)this.component).b = this;
                } else {
                    GroupLayout.a((GroupLayout)this.this$0, (Component)this.component).a = this;
                }
            }
        }

        public ComponentSpring(GroupLayout groupLayout, Component component, int n2, int n3, int n4, 1 var6_6) {
            this(groupLayout, component, n2, n3, n4);
        }
    }

    private class BaselineGroup
    extends ParallelGroup {
        private boolean allSpringsHaveBaseline;
        private int prefAscent;
        private int prefDescent;
        private final GroupLayout this$0;

        public BaselineGroup(GroupLayout groupLayout, boolean bl2) {
            this.this$0 = groupLayout;
            super(groupLayout, 1, bl2);
            this.prefDescent = -1;
            this.prefAscent = -1;
        }

        public void a(int n2, int n3, int n4) {
            if (n4 == Integer.MIN_VALUE) {
                this.prefDescent = -1;
                this.prefAscent = -1;
            }
            super.a(n2, n3, n4);
        }

        public void b(int n2, int n3, int n4) {
            if (n2 == 1 || this.prefAscent == -1) {
                super.b(n2, n3, n4);
            } else {
                this.baselineLayout(n3, n4);
            }
        }

        public int b(int n2, int n3) {
            if (this.a.size() < 2 || n2 != 2) {
                return super.b(n2, n3);
            }
            if (this.prefAscent == -1) {
                this.calculateBaseline();
            }
            if (this.allSpringsHaveBaseline) {
                return this.prefAscent + this.prefDescent;
            }
            return Math.max(this.prefAscent + this.prefDescent, super.b(n2, n3));
        }

        private void calculateBaseline() {
            this.prefAscent = 0;
            this.prefDescent = 0;
            this.allSpringsHaveBaseline = true;
            for (int i2 = this.a.size() - 1; i2 >= 0; --i2) {
                Spring spring = this.j(i2);
                int n2 = -1;
                if (spring instanceof ComponentSpring && (n2 = ((ComponentSpring)spring).f()) >= 0) {
                    this.prefAscent = Math.max(this.prefAscent, n2);
                    this.prefDescent = Math.max(this.prefDescent, spring.b(2) - n2);
                }
                if (n2 >= 0) continue;
                this.allSpringsHaveBaseline = false;
            }
        }

        private void baselineLayout(int n2, int n3) {
            int n4 = this.a.size();
            for (int i2 = 0; i2 < n4; ++i2) {
                Spring spring = this.j(i2);
                int n5 = -1;
                if (spring instanceof ComponentSpring && (n5 = ((ComponentSpring)spring).f()) >= 0) {
                    spring.a(2, n2 + this.prefAscent - n5, spring.b(2));
                }
                if (n5 >= 0) continue;
                int n6 = Math.min(spring.e(2), n3);
                spring.a(2, n2 + (n3 - n6) / 2, n6);
            }
        }
    }

    public class ParallelGroup
    extends Group {
        private int childAlignment;
        private boolean resizable;
        private final GroupLayout this$0;

        public ParallelGroup(GroupLayout groupLayout, int n2, boolean bl2) {
            this.this$0 = groupLayout;
            super(groupLayout);
            GroupLayout.a(n2, true);
            this.childAlignment = n2;
            this.resizable = bl2;
        }

        public ParallelGroup add(Group group) {
            return (ParallelGroup)this.b(group);
        }

        public ParallelGroup add(Component component) {
            return this.add(component, -1, -1, -1);
        }

        public ParallelGroup add(Component component, int n2, int n3, int n4) {
            return (ParallelGroup)this.b(new ComponentSpring(this.this$0, component, n2, n3, n4, null));
        }

        public ParallelGroup add(int n2) {
            return this.add(n2, n2, n2);
        }

        public ParallelGroup add(int n2, int n3, int n4) {
            return (ParallelGroup)this.b(new GapSpring(this.this$0, n2, n3, n4));
        }

        public ParallelGroup add(int n2, Group group) {
            group.a(n2);
            return (ParallelGroup)this.b(group);
        }

        public ParallelGroup add(int n2, Component component) {
            return this.add(n2, component, -1, -1, -1);
        }

        public ParallelGroup add(int n2, Component component, int n3, int n4, int n5) {
            ComponentSpring componentSpring = new ComponentSpring(this.this$0, component, n3, n4, n5, null);
            componentSpring.a(n2);
            return (ParallelGroup)this.b(componentSpring);
        }

        public boolean g() {
            return this.resizable;
        }

        public int a(int n2, int n3) {
            return Math.max(n2, n3);
        }

        public int d(int n2) {
            if (!this.g()) {
                return this.b(n2);
            }
            return super.d(n2);
        }

        public int f(int n2) {
            if (!this.g()) {
                return this.b(n2);
            }
            return super.f(n2);
        }

        public void b(int n2, int n3, int n4) {
            int n5 = this.childAlignment;
            if (n5 == 3) {
                n5 = 1;
            }
            int n6 = this.a.size();
            block4: for (int i2 = 0; i2 < n6; ++i2) {
                Spring spring = this.j(i2);
                int n7 = spring.c();
                int n8 = Math.min(n4, spring.e(n2));
                if (n7 == 0) {
                    n7 = n5;
                }
                switch (n7) {
                    case 2: {
                        spring.a(n2, n3 + n4 - n8, n8);
                        continue block4;
                    }
                    case 3: {
                        spring.a(n2, n3 + (n4 - n8) / 2, n8);
                        continue block4;
                    }
                    default: {
                        spring.a(n2, n3, n8);
                    }
                }
            }
        }

        public void a(int n2, AutopaddingSpring autopaddingSpring, List list, List list2, boolean bl2) {
            for (int i2 = 0; i2 < this.a.size(); ++i2) {
                Spring spring = this.j(i2);
                if (spring instanceof ComponentSpring) {
                    if (autopaddingSpring != null) {
                        autopaddingSpring.add((ComponentSpring)spring, n2);
                    }
                    list2.add(spring);
                    continue;
                }
                if (!(spring instanceof Group)) continue;
                ((Group)spring).a(n2, autopaddingSpring, list, list2, bl2);
            }
        }
    }

    private static class SpringDelta
    implements Comparable {
        public int index;
        public int delta;

        public SpringDelta(int n2, int n3) {
            this.index = n2;
            this.delta = n3;
        }

        public int compareTo(Object object) {
            return this.delta - ((SpringDelta)object).delta;
        }

        public String toString() {
            return super.toString() + "[index=" + this.index + ", delta=" + this.delta + "]";
        }
    }

    public class SequentialGroup
    extends Group {
        public static final boolean b = !(a == null ? (a = GroupLayout.a("org.jdesktop.layout.GroupLayout")) : a).desiredAssertionStatus();
        private final GroupLayout this$0;

        public SequentialGroup(GroupLayout groupLayout) {
            this.this$0 = groupLayout;
            super(groupLayout);
        }

        public SequentialGroup add(Group group) {
            return (SequentialGroup)this.b(group);
        }

        public SequentialGroup add(Component component) {
            return this.add(component, -1, -1, -1);
        }

        public SequentialGroup add(Component component, int n2, int n3, int n4) {
            return (SequentialGroup)this.b(new ComponentSpring(this.this$0, component, n2, n3, n4, null));
        }

        public SequentialGroup add(int n2) {
            return this.add(n2, n2, n2);
        }

        public SequentialGroup add(int n2, int n3, int n4) {
            return (SequentialGroup)this.b(new GapSpring(this.this$0, n2, n3, n4));
        }

        public SequentialGroup addPreferredGap(JComponent jComponent, JComponent jComponent2, int n2) {
            return this.addPreferredGap(jComponent, jComponent2, n2, false);
        }

        public SequentialGroup addPreferredGap(JComponent jComponent, JComponent jComponent2, int n2, boolean bl2) {
            if (n2 != 0 && n2 != 1 && n2 != 3) {
                throw new IllegalArgumentException("Invalid type argument");
            }
            return (SequentialGroup)this.b(new PaddingSpring(this.this$0, jComponent, jComponent2, n2, bl2));
        }

        public SequentialGroup addPreferredGap(int n2) {
            return this.addPreferredGap(n2, -1, -1);
        }

        public SequentialGroup addPreferredGap(int n2, int n3, int n4) {
            if (n2 != 0 && n2 != 1) {
                throw new IllegalArgumentException("Padding type must be one of Padding.RELATED or Padding.UNRELATED");
            }
            if (n3 < 0 && n3 != -1 || n4 < 0 && n4 != -1 && n4 != -2 || n3 >= 0 && n4 >= 0 && n3 > n4) {
                throw new IllegalArgumentException("Pref and max must be either DEFAULT_VALUE or >= 0 and pref <= max");
            }
            GroupLayout.a(this.this$0, true);
            return (SequentialGroup)this.b(new AutopaddingSpring(this.this$0, n2, n3, n4));
        }

        public SequentialGroup addContainerGap() {
            return this.addContainerGap(-1, -1);
        }

        public SequentialGroup addContainerGap(int n2, int n3) {
            if (n2 < 0 && n2 != -1 || n3 < 0 && n3 != -1 && n3 != -2 || n2 >= 0 && n3 >= 0 && n2 > n3) {
                throw new IllegalArgumentException("Pref and max must be either DEFAULT_VALUE or >= 0 and pref <= max");
            }
            GroupLayout.a(this.this$0, true);
            return (SequentialGroup)this.b(new ContainerAutopaddingSpring(this.this$0, n2, n3));
        }

        public int a(int n2, int n3) {
            return this.c(n2) + this.c(n3);
        }

        public void b(int n2, int n3, int n4) {
            int n5 = this.b(n2);
            if (n4 - n5 == 0) {
                int n6 = this.a.size();
                for (int i2 = 0; i2 < n6; ++i2) {
                    Spring spring = this.j(i2);
                    int n7 = spring.b(n2);
                    spring.a(n2, n3, n7);
                    n3 += n7;
                }
            } else if (this.a.size() == 1) {
                Spring spring = this.j(0);
                spring.a(n2, n3, Math.min(n4, spring.e(n2)));
            } else if (this.a.size() > 1) {
                this.resize(n2, n3, n4);
            }
        }

        private void resize(int n2, int n3, int n4) {
            List list;
            int n5;
            int n6 = n4 - this.b(n2);
            if (!b && n6 == 0) {
                throw new AssertionError();
            }
            boolean bl2 = n6 < 0;
            int n7 = this.a.size();
            if (bl2) {
                n6 *= -1;
            }
            if ((n5 = (list = this.buildResizableList(n2, bl2)).size()) > 0) {
                Object object;
                int n8;
                int n9 = n6 / n5;
                int n10 = n6 - n9 * n5;
                int[] nArray = new int[n7];
                int n11 = bl2 ? -1 : 1;
                for (n8 = 0; n8 < n5; ++n8) {
                    object = (SpringDelta)list.get(n8);
                    if (n8 + 1 == n5) {
                        n9 += n10;
                    }
                    ((SpringDelta)object).delta = Math.min(n9, ((SpringDelta)object).delta);
                    n6 -= ((SpringDelta)object).delta;
                    if (((SpringDelta)object).delta != n9 && n8 + 1 < n5) {
                        n9 = n6 / (n5 - n8 - 1);
                        n10 = n6 - n9 * (n5 - n8 - 1);
                    }
                    Spring spring = this.j(((SpringDelta)object).index);
                    nArray[((SpringDelta)object).index] = n11 * ((SpringDelta)object).delta;
                }
                for (n8 = 0; n8 < n7; ++n8) {
                    object = this.j(n8);
                    int n12 = ((Spring)object).b(n2) + nArray[n8];
                    ((Spring)object).a(n2, n3, n12);
                    n3 += n12;
                }
            } else {
                for (int i2 = 0; i2 < n7; ++i2) {
                    Spring spring = this.j(i2);
                    int n13 = bl2 ? spring.h(n2) : spring.e(n2);
                    spring.a(n2, n3, n13);
                    n3 += n13;
                }
            }
        }

        private List buildResizableList(int n2, boolean bl2) {
            int n3 = this.a.size();
            ArrayList<SpringDelta> arrayList = new ArrayList<SpringDelta>(n3);
            for (int i2 = 0; i2 < n3; ++i2) {
                Spring spring = this.j(i2);
                int n4 = bl2 ? spring.b(n2) - spring.h(n2) : spring.e(n2) - spring.b(n2);
                if (n4 <= 0) continue;
                arrayList.add(new SpringDelta(i2, n4));
            }
            Collections.sort(arrayList);
            return arrayList;
        }

        private AutopaddingSpring getNextAutopadding(int n2, boolean bl2) {
            Spring spring = this.j(n2);
            if (spring instanceof AutopaddingSpring && ((AutopaddingSpring)spring).getUserCreated()) {
                return (AutopaddingSpring)spring;
            }
            if (bl2) {
                AutopaddingSpring autopaddingSpring = new AutopaddingSpring(this.this$0, null);
                this.a.add(n2, autopaddingSpring);
                return autopaddingSpring;
            }
            return null;
        }

        public void a(int n2, AutopaddingSpring autopaddingSpring, List list, List list2, boolean bl2) {
            ArrayList<ComponentSpring> arrayList = new ArrayList<ComponentSpring>(list);
            ArrayList arrayList2 = null;
            for (int i2 = 0; i2 < this.a.size(); ++i2) {
                Spring spring = this.j(i2);
                if (spring instanceof ComponentSpring) {
                    ComponentSpring componentSpring = (ComponentSpring)spring;
                    if (autopaddingSpring != null) {
                        autopaddingSpring.add(componentSpring, n2);
                    }
                    arrayList.clear();
                    if (i2 + 1 < this.a.size()) {
                        autopaddingSpring = this.getNextAutopadding(i2 + 1, bl2);
                        if (autopaddingSpring != null) {
                            ++i2;
                            autopaddingSpring.setSource(componentSpring);
                            continue;
                        }
                        arrayList.add(componentSpring);
                        continue;
                    }
                    list2.add(componentSpring);
                    continue;
                }
                if (spring instanceof Group) {
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList(1);
                    } else {
                        arrayList2.clear();
                    }
                    ((Group)spring).a(n2, autopaddingSpring, arrayList, arrayList2, bl2);
                    arrayList.clear();
                    if (i2 + 1 < this.a.size()) {
                        if (arrayList2.size() > 0) {
                            autopaddingSpring = this.getNextAutopadding(i2 + 1, bl2);
                            if (autopaddingSpring != null) {
                                autopaddingSpring.setSources(arrayList2);
                                ++i2;
                                continue;
                            }
                            arrayList.addAll(arrayList2);
                            continue;
                        }
                        autopaddingSpring = null;
                        continue;
                    }
                    list2.addAll(arrayList2);
                    continue;
                }
                if (spring instanceof ContainerAutopaddingSpring) {
                    autopaddingSpring = (AutopaddingSpring)spring;
                } else if (spring instanceof AutopaddingSpring) {
                    autopaddingSpring = (AutopaddingSpring)spring;
                    if (autopaddingSpring.getUserCreated()) {
                        autopaddingSpring.setSources(arrayList);
                    } else {
                        autopaddingSpring = null;
                    }
                }
                arrayList.clear();
            }
        }
    }

    public abstract class Group
    extends Spring {
        public List a;
        public static final boolean b = !(a == null ? (a = GroupLayout.a("org.jdesktop.layout.GroupLayout")) : a).desiredAssertionStatus();
        private final GroupLayout this$0;

        public Group(GroupLayout groupLayout) {
            this.this$0 = groupLayout;
            super(groupLayout);
            this.a = new ArrayList();
        }

        public Group a(Spring spring, int n2) {
            this.a.add(spring);
            spring.a(this);
            if (!(spring instanceof AutopaddingSpring)) {
                GroupLayout.b(this.this$0, true);
            }
            return this;
        }

        public Group b(Spring spring) {
            this.a(spring, this.a.size());
            return this;
        }

        public void a(Spring spring) {
            super.a(spring);
            for (int i2 = this.a.size() - 1; i2 >= 0; --i2) {
                ((Spring)this.a.get(i2)).a(this);
            }
        }

        public void a(int n2, int n3, int n4) {
            super.a(n2, n3, n4);
            if (n4 == Integer.MIN_VALUE) {
                for (int i2 = this.a.size() - 1; i2 >= 0; --i2) {
                    this.j(i2).a(n2, n3, n4);
                }
            } else {
                this.b(n2, n3, n4);
            }
        }

        public abstract void b(int var1, int var2, int var3);

        public int d(int n2) {
            return this.b(n2, 0);
        }

        public int g(int n2) {
            return this.b(n2, 1);
        }

        public int f(int n2) {
            return this.b(n2, 2);
        }

        public abstract int a(int var1, int var2);

        public int b(int n2, int n3) {
            int n4 = this.a.size();
            if (n4 == 0) {
                return 0;
            }
            if (n4 == 1) {
                return this.a(this.j(0), n2, n3);
            }
            int n5 = this.c(this.a(this.a(this.j(0), n2, n3), this.a(this.j(1), n2, n3)));
            for (int i2 = 2; i2 < n4; ++i2) {
                n5 = this.c(this.a(n5, this.a(this.j(i2), n2, n3)));
            }
            return n5;
        }

        public Spring j(int n2) {
            return (Spring)this.a.get(n2);
        }

        public int a(Spring spring, int n2, int n3) {
            switch (n3) {
                case 0: {
                    return spring.h(n2);
                }
                case 1: {
                    return spring.b(n2);
                }
                case 2: {
                    return spring.e(n2);
                }
            }
            if (!b) {
                throw new AssertionError();
            }
            return 0;
        }

        public abstract void a(int var1, AutopaddingSpring var2, List var3, List var4, boolean var5);

        public void f() {
            for (int i2 = this.a.size() - 1; i2 >= 0; --i2) {
                Spring spring = (Spring)this.a.get(i2);
                if (spring instanceof AutopaddingSpring) {
                    if (((AutopaddingSpring)spring).getUserCreated()) {
                        ((AutopaddingSpring)spring).reset();
                        continue;
                    }
                    this.a.remove(i2);
                    continue;
                }
                if (!(spring instanceof Group)) continue;
                ((Group)spring).f();
            }
        }

        public void e() {
            this.d();
            for (int i2 = this.a.size() - 1; i2 >= 0; --i2) {
                Spring spring = (Spring)this.a.get(i2);
                if (spring instanceof AutopaddingSpring) {
                    ((AutopaddingSpring)spring).d();
                    continue;
                }
                if (!(spring instanceof Group)) continue;
                ((Group)spring).e();
            }
        }

        public void i(int n2) {
            for (int i2 = this.a.size() - 1; i2 >= 0; --i2) {
                Spring spring = (Spring)this.a.get(i2);
                if (spring instanceof AutopaddingSpring) {
                    spring.d();
                    ((AutopaddingSpring)spring).calculatePadding(n2);
                    continue;
                }
                if (!(spring instanceof Group)) continue;
                ((Group)spring).i(n2);
            }
            this.d();
        }
    }

    public abstract class Spring {
        private int size;
        private int min;
        private int max;
        private int pref;
        private Spring parent;
        private int alignment;
        private final GroupLayout this$0;

        public Spring(GroupLayout groupLayout) {
            this.this$0 = groupLayout;
            this.max = Integer.MIN_VALUE;
            this.pref = Integer.MIN_VALUE;
            this.min = Integer.MIN_VALUE;
        }

        public abstract int d(int var1);

        public abstract int g(int var1);

        public abstract int f(int var1);

        public void a(Spring spring) {
            this.parent = spring;
        }

        public Spring a() {
            return this.parent;
        }

        public void a(int n2) {
            GroupLayout.a(n2, false);
            this.alignment = n2;
        }

        public int c() {
            return this.alignment;
        }

        public final int h(int n2) {
            if (this.min == Integer.MIN_VALUE) {
                this.min = this.c(this.d(n2));
            }
            return this.min;
        }

        public final int b(int n2) {
            if (this.pref == Integer.MIN_VALUE) {
                this.pref = this.c(this.g(n2));
            }
            return this.pref;
        }

        public final int e(int n2) {
            if (this.max == Integer.MIN_VALUE) {
                this.max = this.c(this.f(n2));
            }
            return this.max;
        }

        public void d() {
            this.max = Integer.MIN_VALUE;
            this.pref = Integer.MIN_VALUE;
            this.min = Integer.MIN_VALUE;
            this.size = Integer.MIN_VALUE;
        }

        public void a(int n2, int n3, int n4) {
            this.size = n4;
            if (n4 == Integer.MIN_VALUE) {
                this.d();
            }
        }

        public int b() {
            return this.size;
        }

        public int c(int n2) {
            return Math.min(n2, Short.MAX_VALUE);
        }
    }
}

