/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.hsqldb.Database;
import org.hsqldb.HsqlProperties;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.StringConverter;
import org.hsqldb.Trace;
import org.hsqldb.jdbcDatabaseMetaData;
import org.hsqldb.jdbcPreparedStatement;
import org.hsqldb.jdbcResultSet;
import org.hsqldb.jdbcStatement;

public class jdbcConnection
implements Connection {
    private boolean bClosed;
    private String sDatabaseName;
    private HsqlProperties connProperties;
    private int iType;
    public Database f;
    public Session c;
    private static Hashtable tDatabase = new Hashtable();
    private static Hashtable iUsageCount = new Hashtable();
    public Socket d;
    public DataOutputStream b;
    public DataInputStream e;
    public static final int DEFAULT_HSQLDB_PORT = 9001;
    private String sConnect;
    private String sUser;
    private String sPassword;
    public static Class a;

    public Statement createStatement() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.a();
        return new jdbcStatement(this);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (Trace.TRACE) {
            Trace.b(string);
        }
        this.a();
        return new jdbcPreparedStatement(this, string);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        if (Trace.TRACE) {
            Trace.b(string);
        }
        this.a();
        return new jdbcPreparedStatement(this, string);
    }

    public String nativeSQL(String string) throws SQLException {
        this.a();
        if (string.indexOf(123) == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        boolean bl2 = false;
        int n2 = 0;
        int n3 = cArray.length;
        int n4 = 0;
        while (n4 < n3) {
            char c2 = cArray[n4];
            switch (n2) {
                case 0: {
                    if (c2 == '\'') {
                        n2 = 1;
                        break;
                    }
                    if (c2 == '\"') {
                        n2 = 2;
                        break;
                    }
                    if (c2 != '{') break;
                    cArray[n4] = 32;
                    bl2 = true;
                    String string2 = string.substring(n4 + 1).toUpperCase();
                    if (string2.startsWith("?=")) {
                        n4 += 2;
                    } else if (string2.startsWith("CALL")) {
                        n4 += 4;
                    } else if (string2.startsWith("ESCAPE")) {
                        n4 += 6;
                    }
                    n2 = 3;
                    break;
                }
                case 1: 
                case 5: {
                    if (c2 != '\'') break;
                    --n2;
                    break;
                }
                case 2: 
                case 6: {
                    if (c2 != '\"') break;
                    n2 -= 2;
                    break;
                }
                case 3: {
                    if (c2 == ' ') {
                        n2 = 4;
                        break;
                    }
                    cArray[n4] = 32;
                    bl2 = true;
                    break;
                }
                case 4: {
                    if (c2 == '\'') {
                        n2 = 5;
                        break;
                    }
                    if (c2 == '\"') {
                        n2 = 6;
                        break;
                    }
                    if (c2 != '}') break;
                    cArray[n4] = 32;
                    bl2 = true;
                    n2 = 0;
                }
            }
            ++n4;
        }
        if (bl2) {
            string = new String(cArray);
            if (Trace.TRACE) {
                Trace.b(cArray + " > " + string);
            }
        }
        return string;
    }

    public void setAutoCommit(boolean bl2) throws SQLException {
        this.b("SET AUTOCOMMIT " + (bl2 ? "TRUE" : "FALSE"));
    }

    public boolean getAutoCommit() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (this.iType == 2 || this.iType == 1) {
            return this.c.f();
        }
        try {
            jdbcResultSet jdbcResultSet2 = this.b("call \"org.hsqldb.Library.getAutoCommit\"()");
            jdbcResultSet2.next();
            return jdbcResultSet2.getBoolean(1);
        }
        catch (SQLException sQLException) {
            this.close();
            throw Trace.error(3);
        }
    }

    public void commit() throws SQLException {
        this.b("COMMIT");
    }

    public void rollback() throws SQLException {
        this.b("ROLLBACK");
    }

    public void close() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (this.iType == 2) {
            return;
        }
        if (this.bClosed) {
            return;
        }
        if (this.iType == 1) {
            this.closeStandalone();
        } else {
            this.b("DISCONNECT");
        }
        this.bClosed = true;
    }

    public boolean isClosed() {
        if (Trace.TRACE) {
            Trace.b();
        }
        return this.bClosed;
    }

    public DatabaseMetaData getMetaData() {
        if (Trace.TRACE) {
            Trace.b();
        }
        return new jdbcDatabaseMetaData(this);
    }

    public void setReadOnly(boolean bl2) throws SQLException {
        this.b("SET READONLY " + (bl2 ? "TRUE" : "FALSE"));
    }

    public boolean isReadOnly() throws SQLException {
        String string = "SELECT * FROM SYSTEM_CONNECTIONINFO WHERE KEY='READONLY'";
        jdbcResultSet jdbcResultSet2 = this.b(string);
        jdbcResultSet2.next();
        return jdbcResultSet2.getString(2).equals("TRUE");
    }

    public void setCatalog(String string) throws SQLException {
        if (Trace.TRACE) {
            Trace.b(string);
        }
    }

    public String getCatalog() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.a();
        return null;
    }

    public void setTransactionIsolation(int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.a(n2);
        }
        if (n2 != 1) {
            throw Trace.error(20);
        }
        this.a();
    }

    public int getTransactionIsolation() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.a();
        return 1;
    }

    public SQLWarning getWarnings() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.a();
        return null;
    }

    public static void a(int n2, int n3) throws SQLException {
        if (n2 != 1003 && n2 != 1004 || n3 != 1007) {
            throw Trace.error(20);
        }
    }

    public void a() throws SQLException {
        if (this.bClosed) {
            throw Trace.error(2);
        }
    }

    public static void a(Database database) {
        if (database == null) {
            return;
        }
        tDatabase.remove(database.g());
        iUsageCount.remove(database);
    }

    public void clearWarnings() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.a();
    }

    public Statement createStatement(int n2, int n3) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.a();
        jdbcConnection.a(n2, n3);
        return new jdbcStatement(this, n2);
    }

    public PreparedStatement prepareStatement(String string, int n2, int n3) throws SQLException {
        if (Trace.TRACE) {
            Trace.b(string);
        }
        jdbcConnection.a(n2, n3);
        this.a();
        return new jdbcPreparedStatement(this, string, n2);
    }

    public CallableStatement prepareCall(String string, int n2, int n3) throws SQLException {
        jdbcConnection.a(n2, n3);
        this.a();
        return this.prepareCall(string);
    }

    public Map getTypeMap() throws SQLException {
        throw Trace.error(20);
    }

    public void setTypeMap(Map map) throws SQLException {
        throw Trace.error(20);
    }

    public jdbcConnection(String string, Properties properties) throws SQLException {
        if (Trace.TRACE) {
            Trace.b(string);
        }
        String string2 = (String)((Hashtable)properties).get("user");
        String string3 = (String)((Hashtable)properties).get("password");
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        this.sDatabaseName = string;
        if ((string = string.toUpperCase()).startsWith("HTTP://")) {
            this.iType = 0;
            this.openHTTP(string2, string3);
        } else if (string.startsWith("HSQL://")) {
            this.iType = 3;
            this.openHSQL(string2, string3);
        } else {
            this.iType = 1;
            this.openStandalone(string2, string3);
        }
        this.connProperties = new HsqlProperties(properties);
    }

    public jdbcConnection(Session session) throws SQLException {
        Trace.a(session != null, "The specified Session is null");
        this.iType = 2;
        this.c = session;
        this.f = session.k();
        this.sDatabaseName = this.f.g();
    }

    public jdbcResultSet b(String string) throws SQLException {
        if (Trace.TRACE) {
            Trace.b(string);
        }
        this.a();
        if (this.iType == 0) {
            return this.executeHTTP(string);
        }
        if (this.iType == 3) {
            return this.executeHSQL(string);
        }
        return this.executeStandalone(string);
    }

    public boolean b() {
        return this.iType != 0;
    }

    public String c() {
        return this.sDatabaseName;
    }

    private void openHTTP(String string, String string2) throws SQLException {
        this.sConnect = this.sDatabaseName;
        this.sUser = string;
        this.sPassword = string2;
        this.executeHTTP(" ");
    }

    private synchronized jdbcResultSet executeHTTP(String string) throws SQLException {
        byte[] byArray;
        try {
            URL uRL = new URL(this.sConnect);
            String string2 = StringConverter.a(this.sUser);
            string2 = string2 + "+" + StringConverter.a(this.sPassword);
            string2 = string2 + "+" + StringConverter.a(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoOutput(true);
            OutputStream outputStream = uRLConnection.getOutputStream();
            outputStream.write(string2.getBytes("8859_1"));
            outputStream.close();
            uRLConnection.connect();
            InputStream inputStream = (InputStream)uRLConnection.getContent();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            int n2 = uRLConnection.getContentLength();
            byArray = new byte[n2];
            int n3 = 0;
            while (n3 < n2) {
                int n4 = bufferedInputStream.read();
                byArray[n3] = (byte)n4;
                ++n3;
            }
        }
        catch (Exception exception) {
            throw Trace.error(3, exception.getMessage());
        }
        return new jdbcResultSet(new Result(byArray), this.connProperties);
    }

    private void openHSQL(String string, String string2) throws SQLException {
        this.sConnect = this.sDatabaseName.substring(7);
        this.sUser = string;
        this.sPassword = string2;
        this.reconnectHSQL();
    }

    private void reconnectHSQL() throws SQLException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(this.sConnect, ":");
            String string = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
            int n2 = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : 9001;
            this.d = new Socket(string, n2);
            this.d.setTcpNoDelay(true);
            this.b = new DataOutputStream(new BufferedOutputStream(this.d.getOutputStream()));
            this.e = new DataInputStream(new BufferedInputStream(this.d.getInputStream()));
            this.b.writeUTF(this.sUser);
            this.b.writeUTF(this.sPassword);
            this.b.flush();
        }
        catch (Exception exception) {
            throw Trace.error(3, exception.getMessage());
        }
    }

    private synchronized jdbcResultSet executeHSQL(String string) throws SQLException {
        byte[] byArray;
        try {
            int n2;
            byte[] byArray2 = string.getBytes("utf-8");
            this.b.writeInt(byArray2.length);
            this.b.write(byArray2);
            this.b.flush();
            int n3 = this.e.readInt();
            byArray = new byte[n3];
            int n4 = 0;
            while ((n2 = this.e.read(byArray, n4, n3)) != n3) {
                n3 -= n2;
                n4 += n2;
            }
        }
        catch (Exception exception) {
            throw Trace.error(3, exception.getMessage());
        }
        return new jdbcResultSet(new Result(byArray), this.connProperties);
    }

    private void openStandalone(String string, String string2) throws SQLException {
        Class clazz = a == null ? (a = jdbcConnection.a("org.hsqldb.jdbcConnection")) : a;
        synchronized (clazz) {
            int n2;
            this.f = (Database)tDatabase.get(this.sDatabaseName);
            if (this.f == null) {
                this.f = new Database(this.sDatabaseName);
                tDatabase.put(this.sDatabaseName, this.f);
                n2 = 1;
            } else {
                n2 = 1 + (Integer)iUsageCount.get(this.sDatabaseName);
            }
            iUsageCount.put(this.sDatabaseName, new Integer(n2));
            this.c = this.f.a(string, string2);
        }
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void closeStandalone() throws SQLException {
        Class clazz = a == null ? (a = jdbcConnection.a("org.hsqldb.jdbcConnection")) : a;
        synchronized (clazz) {
            Integer n2 = (Integer)iUsageCount.get(this.sDatabaseName);
            if (n2 == null) {
                return;
            }
            int n3 = n2 - 1;
            if (n3 == 0) {
                iUsageCount.remove(this.sDatabaseName);
                tDatabase.remove(this.sDatabaseName);
                if (!this.f.f()) {
                    this.b("SHUTDOWN");
                }
                this.f = null;
                this.c = null;
            } else {
                iUsageCount.put(this.sDatabaseName, new Integer(n3));
                this.b("DISCONNECT");
            }
        }
    }

    private jdbcResultSet executeStandalone(String string) throws SQLException {
        return new jdbcResultSet(this.f.d(string, this.c), this.connProperties);
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

