/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.ByteArray;
import org.hsqldb.DatabaseRowOutput;
import org.hsqldb.TextCache;

public class TextDatabaseRowOutput
extends DatabaseRowOutput {
    public String fieldSep;
    public String varSep;
    public String longvarSep;
    private boolean fieldSepEnd;
    private boolean varSepEnd;
    private boolean longvarSepEnd;
    private String nextSep = "";
    private boolean nextSepEnd;
    private ByteArrayOutputStream byteOut = (ByteArrayOutputStream)this.out;

    public TextDatabaseRowOutput(String string, String string2, String string3) throws IOException {
        super(new ByteArrayOutputStream());
        this.skipSystemId = true;
        if (string.endsWith("\n")) {
            this.fieldSepEnd = true;
            string = string.substring(0, string.length() - 1);
        }
        if (string2.endsWith("\n")) {
            this.varSepEnd = true;
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string3.endsWith("\n")) {
            this.longvarSepEnd = true;
            string3 = string3.substring(0, string3.length() - 1);
        }
        this.fieldSep = string;
        this.varSep = string2;
        this.longvarSep = string3;
    }

    public void writePos(int n2) throws IOException {
    }

    public void writeSize(int n2) throws IOException {
    }

    public void writeType(int n2) throws IOException {
    }

    private void writeNull() throws IOException {
        this.writeBytes(this.nextSep);
        this.nextSep = this.fieldSep;
        this.nextSepEnd = this.fieldSepEnd;
    }

    private void writeVarNull() throws IOException {
        this.writeBytes(this.nextSep);
        this.nextSep = this.varSep;
        this.nextSepEnd = this.varSepEnd;
    }

    private void writeLongVarNull() throws IOException {
        this.writeBytes(this.nextSep);
        this.nextSep = this.longvarSep;
        this.nextSepEnd = this.longvarSepEnd;
    }

    public void writeString(String string) throws IOException {
        this.writeBytes(this.nextSep);
        this.writeBytes(string);
        this.nextSep = this.fieldSep;
        this.nextSepEnd = this.fieldSepEnd;
    }

    public void writeVarString(String string) throws IOException {
        this.writeBytes(this.nextSep);
        this.writeBytes(string);
        this.nextSep = this.varSep;
        this.nextSepEnd = this.varSepEnd;
    }

    public void writeLongVarString(String string) throws IOException {
        this.writeBytes(this.nextSep);
        this.writeBytes(string);
        this.nextSep = this.longvarSep;
        this.nextSepEnd = this.longvarSepEnd;
    }

    public void writeByteArray(byte[] byArray) throws IOException {
        this.writeBytes(this.nextSep);
        this.write(byArray, 0, byArray.length);
        this.nextSep = this.fieldSep;
        this.nextSepEnd = this.fieldSepEnd;
    }

    public void writeVarByteArray(byte[] byArray) throws IOException {
        this.writeBytes(this.nextSep);
        this.write(byArray, 0, byArray.length);
        this.nextSep = this.varSep;
        this.nextSepEnd = this.varSepEnd;
    }

    public void writeLongVarByteArray(byte[] byArray) throws IOException {
        this.writeBytes(this.nextSep);
        this.write(byArray, 0, byArray.length);
        this.nextSep = this.longvarSep;
        this.nextSepEnd = this.longvarSepEnd;
    }

    public void writeIntData(int n2) throws IOException {
        this.writeBytes(this.nextSep + n2);
        this.nextSep = this.fieldSep;
        this.nextSepEnd = this.fieldSepEnd;
    }

    public void writeFieldType(int n2) throws IOException {
    }

    public void writeNull(int n2) throws IOException {
        switch (n2) {
            case -3: 
            case 12: 
            case 100: {
                this.writeVarNull();
                break;
            }
            case -4: 
            case -1: {
                this.writeLongVarNull();
                break;
            }
            default: {
                this.writeNull();
            }
        }
    }

    public void writeChar(String string, int n2) throws IOException {
        switch (n2) {
            case 1: {
                this.writeString(string);
                return;
            }
            case 12: 
            case 100: {
                this.writeVarString(string);
                return;
            }
        }
        this.writeLongVarString(string);
    }

    public void writeSmallint(Number number) throws IOException, SQLException {
        this.writeString(number.toString());
    }

    public void writeInteger(Number number) throws IOException, SQLException {
        this.writeString(number.toString());
    }

    public void writeBigint(Number number) throws IOException, SQLException {
        this.writeString(number.toString());
    }

    public void writeReal(Double d2, int n2) throws IOException, SQLException {
        this.writeString(d2.toString());
    }

    public void writeDecimal(BigDecimal bigDecimal) throws IOException, SQLException {
        this.writeString(bigDecimal.toString());
    }

    public void writeBit(Boolean bl2) throws IOException, SQLException {
        this.writeString(bl2.toString());
    }

    public void writeDate(Date date) throws IOException, SQLException {
        this.writeString(date.toString());
    }

    public void writeTime(Time time) throws IOException, SQLException {
        this.writeString(time.toString());
    }

    public void writeTimestamp(Timestamp timestamp) throws IOException, SQLException {
        this.writeString(timestamp.toString());
    }

    public void writeOther(Object object) throws IOException, SQLException {
        byte[] byArray = ByteArray.a(object);
        this.writeByteArray(byArray);
    }

    public void writeBinary(byte[] byArray, int n2) throws IOException, SQLException {
        switch (n2) {
            default: 
        }
        this.writeByteArray(byArray);
    }

    public byte[] toByteArray() throws IOException {
        if (this.nextSepEnd) {
            this.writeBytes(this.nextSep);
        }
        this.nextSep = "";
        this.nextSepEnd = false;
        this.writeBytes(TextCache.NL);
        byte[] byArray = this.byteOut.toByteArray();
        this.byteOut.reset();
        return byArray;
    }
}

