/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.ByteArray;
import org.hsqldb.DatabaseRowInput;
import org.hsqldb.DatabaseRowInputInterface;
import org.hsqldb.lib.HsqlDateTime;

public class BinaryServerRowInput
extends DatabaseRowInput
implements DatabaseRowInputInterface {
    public BinaryServerRowInput(byte[] byArray) throws IOException {
        super(byArray, -1);
    }

    public BinaryServerRowInput(byte[] byArray, int n2) throws IOException {
        super(byArray, n2);
    }

    public byte[] a() throws IOException {
        byte[] byArray = new byte[this.readInt()];
        this.readFully(byArray);
        return byArray;
    }

    public int readType() throws IOException {
        return this.readShort();
    }

    public int readIntData() throws IOException {
        return this.readInt();
    }

    public String readString() throws IOException {
        byte[] byArray = new byte[this.readInt()];
        this.readFully(byArray);
        return new String(byArray, "utf-8");
    }

    public boolean checkNull() throws IOException {
        byte by2 = this.readByte();
        return by2 == 0;
    }

    public String readChar(int n2) throws IOException {
        return this.readString();
    }

    public Integer readSmallint() throws IOException, SQLException {
        return new Integer(this.readShort());
    }

    public Integer readInteger() throws IOException, SQLException {
        return new Integer(this.readInt());
    }

    public Long readBigint() throws IOException, SQLException {
        return new Long(this.readLong());
    }

    public Double readReal(int n2) throws IOException, SQLException {
        return new Double(Double.longBitsToDouble(this.readLong()));
    }

    public BigDecimal readDecimal() throws IOException, SQLException {
        byte[] byArray = this.a();
        int n2 = this.readInt();
        BigInteger bigInteger = new BigInteger(byArray);
        return new BigDecimal(bigInteger, n2);
    }

    public Boolean readBit() throws IOException, SQLException {
        return new Boolean(this.readBoolean());
    }

    public Time readTime() throws IOException, SQLException {
        return new Time(this.readLong());
    }

    public Date readDate() throws IOException, SQLException {
        return new Date(this.readLong());
    }

    public Timestamp readTimestamp() throws IOException, SQLException {
        return HsqlDateTime.timestampValue(this.readLong(), this.readInt());
    }

    public Object readOther() throws IOException, SQLException {
        byte[] byArray = this.a();
        return ByteArray.a(byArray);
    }

    public byte[] readBinary(int n2) throws IOException, SQLException {
        return this.a();
    }
}

