/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.problem;

import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.compiler.util.Util;

public class DefaultProblem
implements ProblemSeverities,
IProblem {
    private char[] fileName;
    private int id;
    private int startPosition;
    private int endPosition;
    private int line;
    private int severity;
    private String[] arguments;
    private String message;

    public DefaultProblem(char[] cArray, String string, int n2, String[] stringArray, int n3, int n4, int n5, int n6) {
        this.fileName = cArray;
        this.message = string;
        this.id = n2;
        this.arguments = stringArray;
        this.severity = n3;
        this.startPosition = n4;
        this.endPosition = n5;
        this.line = n6;
    }

    public String errorReportSource(char[] cArray) {
        char c2;
        if (this.startPosition > this.endPosition || this.startPosition < 0 && this.endPosition < 0) {
            return Messages.problem_noSourceInformation;
        }
        StringBuffer stringBuffer = new StringBuffer(" ");
        stringBuffer.append(Messages.bind(Messages.problem_atLine, String.valueOf(this.line)));
        stringBuffer.append(Util.LINE_SEPARATOR).append("\t");
        int n2 = cArray.length;
        int n3 = this.startPosition >= n2 ? n2 - 1 : this.startPosition;
        while (n3 > 0) {
            c2 = cArray[n3 - 1];
            if (c2 == '\n' || c2 == '\r') break;
            --n3;
        }
        int n4 = this.endPosition >= n2 ? n2 - 1 : this.endPosition;
        while (n4 + 1 < n2) {
            c2 = cArray[n4 + 1];
            if (c2 == '\r' || c2 == '\n') break;
            ++n4;
        }
        while ((c2 = cArray[n3]) == ' ' || c2 == '\t') {
            ++n3;
        }
        stringBuffer.append(cArray, n3, n4 - n3 + 1);
        stringBuffer.append(Util.LINE_SEPARATOR).append("\t");
        int n5 = n3;
        while (n5 < this.startPosition) {
            stringBuffer.append(cArray[n5] == '\t' ? (char)'\t' : ' ');
            ++n5;
        }
        n5 = this.startPosition;
        while (n5 <= (this.endPosition >= n2 ? n2 - 1 : this.endPosition)) {
            stringBuffer.append('^');
            ++n5;
        }
        return stringBuffer.toString();
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public int getID() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    public char[] getOriginatingFileName() {
        return this.fileName;
    }

    public int getSourceEnd() {
        return this.endPosition;
    }

    public int getSourceLineNumber() {
        return this.line;
    }

    public int getSourceStart() {
        return this.startPosition;
    }

    public boolean isError() {
        return (this.severity & 1) != 0;
    }

    public boolean isWarning() {
        return (this.severity & 1) == 0;
    }

    public void setOriginatingFileName(char[] cArray) {
        this.fileName = cArray;
    }

    public void setSourceEnd(int n2) {
        this.endPosition = n2;
    }

    public void setSourceLineNumber(int n2) {
        this.line = n2;
    }

    public void setSourceStart(int n2) {
        this.startPosition = n2;
    }

    public String toString() {
        String string = "Pb(" + (this.id & 0xFFFFFF) + ") ";
        if (this.message != null) {
            string = String.valueOf(string) + this.message;
        } else if (this.arguments != null) {
            int n2 = 0;
            while (n2 < this.arguments.length) {
                string = String.valueOf(string) + " " + this.arguments[n2];
                ++n2;
            }
        }
        return string;
    }
}

