/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.problem;

import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.problem.ProblemHandler;

public class AbortCompilation
extends RuntimeException {
    public CompilationResult compilationResult;
    public Throwable exception;
    public IProblem problem;
    public boolean isSilent;
    public RuntimeException silentException;
    private static final long serialVersionUID = -2047226595083244852L;

    public AbortCompilation() {
    }

    public AbortCompilation(CompilationResult compilationResult, IProblem iProblem) {
        this();
        this.compilationResult = compilationResult;
        this.problem = iProblem;
    }

    public AbortCompilation(CompilationResult compilationResult, Throwable throwable) {
        this();
        this.compilationResult = compilationResult;
        this.exception = throwable;
    }

    public AbortCompilation(boolean bl2, RuntimeException runtimeException) {
        this();
        this.isSilent = bl2;
        this.silentException = runtimeException;
    }

    public void updateContext(InvocationSite invocationSite, CompilationResult compilationResult) {
        if (this.problem == null) {
            return;
        }
        if (this.problem.getSourceStart() != 0 || this.problem.getSourceEnd() != 0) {
            return;
        }
        this.problem.setSourceStart(invocationSite.sourceStart());
        this.problem.setSourceEnd(invocationSite.sourceEnd());
        this.problem.setSourceLineNumber(ProblemHandler.searchLineNumber(compilationResult.lineSeparatorPositions, invocationSite.sourceStart()));
        this.compilationResult = compilationResult;
    }

    public void updateContext(ASTNode aSTNode, CompilationResult compilationResult) {
        if (this.problem == null) {
            return;
        }
        if (this.problem.getSourceStart() != 0 || this.problem.getSourceEnd() != 0) {
            return;
        }
        this.problem.setSourceStart(aSTNode.sourceStart());
        this.problem.setSourceEnd(aSTNode.sourceEnd());
        this.problem.setSourceLineNumber(ProblemHandler.searchLineNumber(compilationResult.lineSeparatorPositions, aSTNode.sourceStart()));
        this.compilationResult = compilationResult;
    }
}

