/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class RawTypeBinding
extends ParameterizedTypeBinding {
    public RawTypeBinding(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2, LookupEnvironment lookupEnvironment) {
        super(referenceBinding, null, referenceBinding2, lookupEnvironment);
        if (referenceBinding2 == null || (referenceBinding2.modifiers & 0x40000000) == 0) {
            this.modifiers &= 0xBFFFFFFF;
        }
    }

    public char[] computeUniqueKey(boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.isMemberType() && this.enclosingType().isParameterizedType()) {
            char[] cArray = this.enclosingType().computeUniqueKey(false);
            int n2 = 0;
            while (n2 < cArray.length - 1) {
                stringBuffer.append(cArray[n2]);
                ++n2;
            }
            stringBuffer.append('.').append(this.sourceName()).append('<').append('>').append(';');
        } else {
            stringBuffer.append(this.type.computeUniqueKey(false));
            stringBuffer.insert(stringBuffer.length() - 1, "<>");
        }
        int n3 = stringBuffer.length();
        char[] cArray = new char[n3];
        stringBuffer.getChars(0, n3, cArray, 0);
        return cArray;
    }

    public ParameterizedMethodBinding createParameterizedMethod(MethodBinding methodBinding) {
        if (methodBinding.typeVariables == NoTypeVariables || methodBinding.isStatic()) {
            return super.createParameterizedMethod(methodBinding);
        }
        return new ParameterizedGenericMethodBinding(methodBinding, this, this.environment);
    }

    public int kind() {
        return 1028;
    }

    public String debugName() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(this.type.sourceName()).append("#RAW");
        return stringBuffer.toString();
    }

    public char[] genericTypeSignature() {
        if (this.genericTypeSignature == null) {
            StringBuffer stringBuffer = new StringBuffer(10);
            if (this.isMemberType() && this.enclosingType().isParameterizedType()) {
                char[] cArray = this.enclosingType().genericTypeSignature();
                int n2 = 0;
                while (n2 < cArray.length - 1) {
                    stringBuffer.append(cArray[n2]);
                    ++n2;
                }
                stringBuffer.append('.').append(this.sourceName()).append(';');
                n2 = stringBuffer.length();
                this.genericTypeSignature = new char[n2];
                stringBuffer.getChars(0, n2, this.genericTypeSignature, 0);
            } else {
                this.genericTypeSignature = this.type.signature();
            }
        }
        return this.genericTypeSignature;
    }

    public boolean isEquivalentTo(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return true;
        }
        if (typeBinding == null) {
            return false;
        }
        switch (typeBinding.kind()) {
            case 516: {
                return ((WildcardBinding)typeBinding).boundCheck(this);
            }
            case 260: 
            case 1028: 
            case 2052: {
                return this.erasure() == typeBinding.erasure();
            }
        }
        return false;
    }

    public boolean isIntersectingWith(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return true;
        }
        if (typeBinding == null) {
            return false;
        }
        switch (typeBinding.kind()) {
            case 260: 
            case 1028: 
            case 2052: {
                return this.erasure() == typeBinding.erasure();
            }
        }
        return false;
    }

    public boolean isParameterizedType() {
        return false;
    }

    public boolean isRawType() {
        return true;
    }

    public void initializeArguments() {
        TypeVariableBinding[] typeVariableBindingArray = this.type.typeVariables();
        int n2 = typeVariableBindingArray.length;
        TypeBinding[] typeBindingArray = new TypeBinding[n2];
        int n3 = 0;
        while (n3 < n2) {
            typeBindingArray[n3] = this.environment.convertToRawType(typeVariableBindingArray[n3].erasure());
            ++n3;
        }
        this.arguments = typeBindingArray;
    }

    public char[] readableName() {
        char[] cArray = this.isMemberType() ? CharOperation.concat(this.enclosingType().readableName(), this.sourceName, '.') : CharOperation.concatWith(this.type.compoundName, '.');
        return cArray;
    }

    public char[] shortReadableName() {
        char[] cArray = this.isMemberType() ? CharOperation.concat(this.enclosingType().shortReadableName(), this.sourceName, '.') : this.type.sourceName;
        return cArray;
    }
}

