/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class ParameterizedMethodBinding
extends MethodBinding {
    public MethodBinding originalMethod;

    public ParameterizedMethodBinding(ParameterizedTypeBinding parameterizedTypeBinding, MethodBinding methodBinding) {
        super(methodBinding.modifiers, methodBinding.selector, methodBinding.returnType, methodBinding.parameters, methodBinding.thrownExceptions, parameterizedTypeBinding);
        this.originalMethod = methodBinding;
        TypeVariableBinding[] typeVariableBindingArray = methodBinding.typeVariables;
        Substitution substitution = null;
        int n2 = typeVariableBindingArray.length;
        boolean bl2 = methodBinding.isStatic();
        if (n2 == 0) {
            this.typeVariables = NoTypeVariables;
            if (!bl2) {
                substitution = parameterizedTypeBinding;
            }
        } else {
            TypeVariableBinding typeVariableBinding;
            TypeVariableBinding[] typeVariableBindingArray2 = new TypeVariableBinding[n2];
            int n3 = 0;
            while (n3 < n2) {
                typeVariableBinding = typeVariableBindingArray[n3];
                typeVariableBindingArray2[n3] = new TypeVariableBinding(typeVariableBinding.sourceName, this, typeVariableBinding.rank);
                ++n3;
            }
            this.typeVariables = typeVariableBindingArray2;
            substitution = new Substitution(this, parameterizedTypeBinding, bl2, n2, typeVariableBindingArray, typeVariableBindingArray2){
                public final ParameterizedMethodBinding a;
                private final ParameterizedTypeBinding val$parameterizedDeclaringClass;
                private final boolean val$isStatic;
                private final int val$length;
                private final TypeVariableBinding[] val$originalVariables;
                private final TypeVariableBinding[] val$substitutedVariables;
                {
                    this.a = parameterizedMethodBinding;
                    this.val$parameterizedDeclaringClass = parameterizedTypeBinding;
                    this.val$isStatic = bl2;
                    this.val$length = n2;
                    this.val$originalVariables = typeVariableBindingArray;
                    this.val$substitutedVariables = typeVariableBindingArray2;
                }

                public LookupEnvironment environment() {
                    return this.val$parameterizedDeclaringClass.environment;
                }

                public boolean isRawSubstitution() {
                    return !this.val$isStatic && this.val$parameterizedDeclaringClass.isRawSubstitution();
                }

                public TypeBinding substitute(TypeVariableBinding typeVariableBinding) {
                    if (typeVariableBinding.rank < this.val$length && this.val$originalVariables[typeVariableBinding.rank] == typeVariableBinding) {
                        return this.val$substitutedVariables[typeVariableBinding.rank];
                    }
                    if (!this.val$isStatic) {
                        return this.val$parameterizedDeclaringClass.substitute(typeVariableBinding);
                    }
                    return typeVariableBinding;
                }
            };
            n3 = 0;
            while (n3 < n2) {
                typeVariableBinding = typeVariableBindingArray[n3];
                TypeVariableBinding typeVariableBinding2 = typeVariableBindingArray2[n3];
                TypeBinding typeBinding = Scope.substitute(substitution, typeVariableBinding.superclass);
                typeVariableBinding2.superclass = (ReferenceBinding)(typeBinding.isArrayType() ? parameterizedTypeBinding.environment.getType(JAVA_LANG_OBJECT) : typeBinding);
                typeVariableBinding2.superInterfaces = Scope.substitute(substitution, typeVariableBinding.superInterfaces);
                if (typeVariableBinding.firstBound != null) {
                    typeVariableBinding2.firstBound = typeVariableBinding.firstBound == typeVariableBinding.superclass ? typeBinding : typeVariableBinding2.superInterfaces[0];
                }
                ++n3;
            }
        }
        if (substitution != null) {
            this.returnType = Scope.substitute(substitution, this.returnType);
            this.parameters = Scope.substitute(substitution, this.parameters);
            this.thrownExceptions = Scope.substitute(substitution, this.thrownExceptions);
        }
    }

    public ParameterizedMethodBinding() {
    }

    public static ParameterizedMethodBinding instantiateGetClass(TypeBinding typeBinding, MethodBinding methodBinding, Scope scope) {
        ParameterizedMethodBinding parameterizedMethodBinding = new ParameterizedMethodBinding();
        parameterizedMethodBinding.modifiers = methodBinding.modifiers;
        parameterizedMethodBinding.selector = methodBinding.selector;
        parameterizedMethodBinding.declaringClass = methodBinding.declaringClass;
        parameterizedMethodBinding.typeVariables = NoTypeVariables;
        parameterizedMethodBinding.originalMethod = methodBinding;
        parameterizedMethodBinding.parameters = methodBinding.parameters;
        parameterizedMethodBinding.thrownExceptions = methodBinding.thrownExceptions;
        ReferenceBinding referenceBinding = scope.getJavaLangClass();
        parameterizedMethodBinding.returnType = scope.environment().createParameterizedType(referenceBinding, new TypeBinding[]{scope.environment().createWildcard(referenceBinding, 0, typeBinding.erasure(), null, 1)}, null);
        return parameterizedMethodBinding;
    }

    public boolean hasSubstitutedParameters() {
        return this.parameters != this.originalMethod.parameters;
    }

    public boolean hasSubstitutedReturnType() {
        return this.returnType != this.originalMethod.returnType;
    }

    public MethodBinding original() {
        return this.originalMethod.original();
    }
}

