/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;

public class NestedTypeBinding
extends SourceTypeBinding {
    public SourceTypeBinding enclosingType;
    public SyntheticArgumentBinding[] enclosingInstances;
    public SyntheticArgumentBinding[] outerLocalVariables;
    public int enclosingInstancesSlotSize;
    public int outerLocalVariablesSlotSize;

    public NestedTypeBinding(char[][] cArray, ClassScope classScope, SourceTypeBinding sourceTypeBinding) {
        super(cArray, sourceTypeBinding.fPackage, classScope);
        this.tagBits |= 4L;
        this.enclosingType = sourceTypeBinding;
    }

    public SyntheticArgumentBinding addSyntheticArgument(LocalVariableBinding localVariableBinding) {
        SyntheticArgumentBinding syntheticArgumentBinding = null;
        if (this.outerLocalVariables == null) {
            syntheticArgumentBinding = new SyntheticArgumentBinding(localVariableBinding);
            this.outerLocalVariables = new SyntheticArgumentBinding[]{syntheticArgumentBinding};
        } else {
            int n2;
            int n3 = n2 = this.outerLocalVariables.length;
            int n4 = n2;
            while (--n4 >= 0) {
                if (this.outerLocalVariables[n4].actualOuterLocalVariable == localVariableBinding) {
                    return this.outerLocalVariables[n4];
                }
                if (this.outerLocalVariables[n4].id <= localVariableBinding.id) continue;
                n3 = n4;
            }
            SyntheticArgumentBinding[] syntheticArgumentBindingArray = new SyntheticArgumentBinding[n2 + 1];
            System.arraycopy(this.outerLocalVariables, 0, syntheticArgumentBindingArray, 0, n3);
            syntheticArgumentBindingArray[n3] = syntheticArgumentBinding = new SyntheticArgumentBinding(localVariableBinding);
            System.arraycopy(this.outerLocalVariables, n3, syntheticArgumentBindingArray, n3 + 1, n2 - n3);
            this.outerLocalVariables = syntheticArgumentBindingArray;
        }
        if (this.scope.referenceCompilationUnit().isPropagatingInnerClassEmulation) {
            this.updateInnerEmulationDependents();
        }
        return syntheticArgumentBinding;
    }

    public SyntheticArgumentBinding addSyntheticArgument(ReferenceBinding referenceBinding) {
        SyntheticArgumentBinding syntheticArgumentBinding = null;
        if (this.enclosingInstances == null) {
            syntheticArgumentBinding = new SyntheticArgumentBinding(referenceBinding);
            this.enclosingInstances = new SyntheticArgumentBinding[]{syntheticArgumentBinding};
        } else {
            int n2;
            int n3 = n2 = this.enclosingInstances.length;
            int n4 = n2;
            while (--n4 >= 0) {
                if (this.enclosingInstances[n4].type == referenceBinding) {
                    return this.enclosingInstances[n4];
                }
                if (this.enclosingType() != referenceBinding) continue;
                n3 = 0;
            }
            SyntheticArgumentBinding[] syntheticArgumentBindingArray = new SyntheticArgumentBinding[n2 + 1];
            System.arraycopy(this.enclosingInstances, 0, syntheticArgumentBindingArray, n3 == 0 ? 1 : 0, n2);
            syntheticArgumentBindingArray[n3] = syntheticArgumentBinding = new SyntheticArgumentBinding(referenceBinding);
            this.enclosingInstances = syntheticArgumentBindingArray;
        }
        if (this.scope.referenceCompilationUnit().isPropagatingInnerClassEmulation) {
            this.updateInnerEmulationDependents();
        }
        return syntheticArgumentBinding;
    }

    public SyntheticArgumentBinding addSyntheticArgumentAndField(LocalVariableBinding localVariableBinding) {
        SyntheticArgumentBinding syntheticArgumentBinding = this.addSyntheticArgument(localVariableBinding);
        if (syntheticArgumentBinding == null) {
            return null;
        }
        if (syntheticArgumentBinding.matchingField == null) {
            syntheticArgumentBinding.matchingField = this.addSyntheticFieldForInnerclass(localVariableBinding);
        }
        return syntheticArgumentBinding;
    }

    public SyntheticArgumentBinding addSyntheticArgumentAndField(ReferenceBinding referenceBinding) {
        SyntheticArgumentBinding syntheticArgumentBinding = this.addSyntheticArgument(referenceBinding);
        if (syntheticArgumentBinding == null) {
            return null;
        }
        if (syntheticArgumentBinding.matchingField == null) {
            syntheticArgumentBinding.matchingField = this.addSyntheticFieldForInnerclass(referenceBinding);
        }
        return syntheticArgumentBinding;
    }

    public final void computeSyntheticArgumentSlotSizes() {
        int n2 = 0;
        int n3 = this.enclosingInstances == null ? 0 : this.enclosingInstances.length;
        int n4 = 0;
        while (n4 < n3) {
            SyntheticArgumentBinding syntheticArgumentBinding = this.enclosingInstances[n4];
            syntheticArgumentBinding.resolvedPosition = n2 + 1;
            if (n2 + 1 > 255) {
                this.scope.problemReporter().noMoreAvailableSpaceForArgument(syntheticArgumentBinding, this.scope.referenceType());
            }
            n2 = syntheticArgumentBinding.type == LongBinding || syntheticArgumentBinding.type == DoubleBinding ? (n2 += 2) : ++n2;
            ++n4;
        }
        this.enclosingInstancesSlotSize = n2;
        n2 = 0;
        n4 = this.outerLocalVariables == null ? 0 : this.outerLocalVariables.length;
        int n5 = 0;
        while (n5 < n4) {
            SyntheticArgumentBinding syntheticArgumentBinding = this.outerLocalVariables[n5];
            n2 = syntheticArgumentBinding.type == LongBinding || syntheticArgumentBinding.type == DoubleBinding ? (n2 += 2) : ++n2;
            ++n5;
        }
        this.outerLocalVariablesSlotSize = n2;
    }

    public ReferenceBinding enclosingType() {
        return this.enclosingType;
    }

    public SyntheticArgumentBinding getSyntheticArgument(LocalVariableBinding localVariableBinding) {
        if (this.outerLocalVariables == null) {
            return null;
        }
        int n2 = this.outerLocalVariables.length;
        while (--n2 >= 0) {
            if (this.outerLocalVariables[n2].actualOuterLocalVariable != localVariableBinding) continue;
            return this.outerLocalVariables[n2];
        }
        return null;
    }

    public SyntheticArgumentBinding[] syntheticEnclosingInstances() {
        return this.enclosingInstances;
    }

    public ReferenceBinding[] syntheticEnclosingInstanceTypes() {
        if (this.enclosingInstances == null) {
            return null;
        }
        int n2 = this.enclosingInstances.length;
        ReferenceBinding[] referenceBindingArray = new ReferenceBinding[n2];
        int n3 = 0;
        while (n3 < n2) {
            referenceBindingArray[n3] = (ReferenceBinding)this.enclosingInstances[n3].type;
            ++n3;
        }
        return referenceBindingArray;
    }

    public SyntheticArgumentBinding[] syntheticOuterLocalVariables() {
        return this.outerLocalVariables;
    }

    public void updateInnerEmulationDependents() {
    }

    public SyntheticArgumentBinding getSyntheticArgument(ReferenceBinding referenceBinding, boolean bl2) {
        if (this.enclosingInstances == null) {
            return null;
        }
        int n2 = this.enclosingInstances.length;
        while (--n2 >= 0) {
            if (this.enclosingInstances[n2].type != referenceBinding || this.enclosingInstances[n2].actualOuterLocalVariable != null) continue;
            return this.enclosingInstances[n2];
        }
        if (!bl2) {
            n2 = this.enclosingInstances.length;
            while (--n2 >= 0) {
                if (this.enclosingInstances[n2].actualOuterLocalVariable != null || ((ReferenceBinding)this.enclosingInstances[n2].type).findSuperTypeWithSameErasure(referenceBinding) == null) continue;
                return this.enclosingInstances[n2];
            }
        }
        return null;
    }
}

