/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class MethodScope
extends BlockScope {
    public ReferenceContext referenceContext;
    public boolean isStatic;
    public boolean isConstructorCall = false;
    public FieldBinding initializedField;
    public int lastVisibleFieldID = -1;
    public int analysisIndex;
    public boolean isPropagatingInnerClassEmulation;
    public int lastIndex = 0;
    public long[] definiteInits = new long[4];
    public long[][] extraDefiniteInits = new long[4][];
    public boolean insideTypeAnnotation = false;
    public SyntheticArgumentBinding[] extraSyntheticArguments;

    public MethodScope(ClassScope classScope, ReferenceContext referenceContext, boolean bl2) {
        super(2, classScope);
        this.locals = new LocalVariableBinding[5];
        this.referenceContext = referenceContext;
        this.isStatic = bl2;
        this.startIndex = 0;
    }

    private void checkAndSetModifiersForConstructor(MethodBinding methodBinding) {
        int n2 = methodBinding.modifiers;
        ReferenceBinding referenceBinding = methodBinding.declaringClass;
        if ((n2 & 0x400000) != 0) {
            this.problemReporter().duplicateModifierForMethod(referenceBinding, (AbstractMethodDeclaration)this.referenceContext);
        }
        if (((ConstructorDeclaration)this.referenceContext).isDefaultConstructor) {
            if (referenceBinding.isEnum()) {
                n2 = 2;
            } else if (referenceBinding.isPublic()) {
                n2 |= 1;
            } else if (referenceBinding.isProtected()) {
                n2 |= 4;
            }
        }
        int n3 = n2 & 0xFFFF;
        int n4 = -2056;
        if (referenceBinding.isEnum() && !((ConstructorDeclaration)this.referenceContext).isDefaultConstructor) {
            n4 = -2051;
            if ((n3 & n4) != 0) {
                this.problemReporter().illegalModifierForEnumConstructor((AbstractMethodDeclaration)this.referenceContext);
                n2 &= 0xFFFF0000 | ~n4;
            } else if ((((AbstractMethodDeclaration)this.referenceContext).modifiers & 0x800) != 0) {
                this.problemReporter().illegalModifierForMethod((AbstractMethodDeclaration)this.referenceContext);
            }
            n2 |= 2;
        } else if ((n3 & n4) != 0) {
            this.problemReporter().illegalModifierForMethod((AbstractMethodDeclaration)this.referenceContext);
            n2 &= 0xFFFF0000 | ~n4;
        } else if ((((AbstractMethodDeclaration)this.referenceContext).modifiers & 0x800) != 0) {
            this.problemReporter().illegalModifierForMethod((AbstractMethodDeclaration)this.referenceContext);
        }
        int n5 = n3 & 7;
        if ((n5 & n5 - 1) != 0) {
            this.problemReporter().illegalVisibilityModifierCombinationForMethod(referenceBinding, (AbstractMethodDeclaration)this.referenceContext);
            if ((n5 & 1) != 0) {
                if ((n5 & 4) != 0) {
                    n2 &= 0xFFFFFFFB;
                }
                if ((n5 & 2) != 0) {
                    n2 &= 0xFFFFFFFD;
                }
            } else if ((n5 & 4) != 0 && (n5 & 2) != 0) {
                n2 &= 0xFFFFFFFD;
            }
        }
        if (referenceBinding.isPrivate() && (n2 & 2) != 0) {
            n2 &= 0xFFFFFFFD;
        }
        methodBinding.modifiers = n2;
    }

    private void checkAndSetModifiersForMethod(MethodBinding methodBinding) {
        int n2;
        int n3 = methodBinding.modifiers;
        ReferenceBinding referenceBinding = methodBinding.declaringClass;
        if ((n3 & 0x400000) != 0) {
            this.problemReporter().duplicateModifierForMethod(referenceBinding, (AbstractMethodDeclaration)this.referenceContext);
        }
        int n4 = n3 & 0xFFFF;
        if (referenceBinding.isInterface()) {
            if ((n4 & 0xFFFFFBFE) != 0) {
                if ((referenceBinding.modifiers & 0x2000) != 0) {
                    this.problemReporter().illegalModifierForAnnotationMember((AbstractMethodDeclaration)this.referenceContext);
                } else {
                    this.problemReporter().illegalModifierForInterfaceMethod((AbstractMethodDeclaration)this.referenceContext);
                }
            }
            return;
        }
        int n5 = -3392;
        if ((n4 & n5) != 0) {
            this.problemReporter().illegalModifierForMethod((AbstractMethodDeclaration)this.referenceContext);
            n3 &= 0xFFFF0000 | ~n5;
        }
        if (((n2 = n4 & 7) & n2 - 1) != 0) {
            this.problemReporter().illegalVisibilityModifierCombinationForMethod(referenceBinding, (AbstractMethodDeclaration)this.referenceContext);
            if ((n2 & 1) != 0) {
                if ((n2 & 4) != 0) {
                    n3 &= 0xFFFFFFFB;
                }
                if ((n2 & 2) != 0) {
                    n3 &= 0xFFFFFFFD;
                }
            } else if ((n2 & 4) != 0 && (n2 & 2) != 0) {
                n3 &= 0xFFFFFFFD;
            }
        }
        if ((n3 & 0x400) != 0) {
            int n6 = 2362;
            if ((n3 & n6) != 0) {
                this.problemReporter().illegalAbstractModifierCombinationForMethod(referenceBinding, (AbstractMethodDeclaration)this.referenceContext);
            }
            if (!methodBinding.declaringClass.isAbstract()) {
                this.problemReporter().abstractMethodInAbstractClass((SourceTypeBinding)referenceBinding, (AbstractMethodDeclaration)this.referenceContext);
            }
        }
        if ((n3 & 0x100) != 0 && (n3 & 0x800) != 0) {
            this.problemReporter().nativeMethodsCannotBeStrictfp(referenceBinding, (AbstractMethodDeclaration)this.referenceContext);
        }
        if ((n4 & 8) != 0 && referenceBinding.isNestedType() && !referenceBinding.isStatic()) {
            this.problemReporter().unexpectedStaticModifierForMethod(referenceBinding, (AbstractMethodDeclaration)this.referenceContext);
        }
        methodBinding.modifiers = n3;
    }

    public void computeLocalVariablePositions(int n2, CodeStream codeStream) {
        boolean bl2 = false;
        if (this.referenceContext instanceof AbstractMethodDeclaration) {
            AbstractMethodDeclaration abstractMethodDeclaration = (AbstractMethodDeclaration)this.referenceContext;
            MethodBinding methodBinding = abstractMethodDeclaration.binding;
            if (!(methodBinding.isAbstract() || methodBinding.isImplementing() && !this.compilerOptions().reportUnusedParameterWhenImplementingAbstract || methodBinding.isOverriding() && !methodBinding.isImplementing() && !this.compilerOptions().reportUnusedParameterWhenOverridingConcrete || methodBinding.isMain())) {
                bl2 = true;
            }
        }
        this.offset = n2;
        this.maxOffset = n2;
        int n3 = 0;
        int n4 = this.localIndex;
        while (n3 < n4) {
            LocalVariableBinding localVariableBinding = this.locals[n3];
            if (localVariableBinding == null || !localVariableBinding.isArgument) break;
            if (bl2 && localVariableBinding.useFlag == 0 && (localVariableBinding.declaration.bits & 0x40000000) != 0) {
                this.problemReporter().unusedArgument(localVariableBinding.declaration);
            }
            codeStream.record(localVariableBinding);
            localVariableBinding.resolvedPosition = this.offset++;
            if (localVariableBinding.type == LongBinding || localVariableBinding.type == DoubleBinding) {
                this.offset += 2;
            }
            if (this.offset > 255) {
                this.problemReporter().noMoreAvailableSpaceForArgument(localVariableBinding, localVariableBinding.declaration);
            }
            ++n3;
        }
        if (this.extraSyntheticArguments != null) {
            int n5 = 0;
            int n6 = this.extraSyntheticArguments.length;
            while (n5 < n6) {
                SyntheticArgumentBinding syntheticArgumentBinding = this.extraSyntheticArguments[n5];
                syntheticArgumentBinding.resolvedPosition = this.offset++;
                if (syntheticArgumentBinding.type == LongBinding || syntheticArgumentBinding.type == DoubleBinding) {
                    this.offset += 2;
                }
                if (this.offset > 255) {
                    this.problemReporter().noMoreAvailableSpaceForArgument(syntheticArgumentBinding, (ASTNode)((Object)this.referenceContext));
                }
                ++n5;
            }
        }
        this.a(n3, this.offset, codeStream);
    }

    public MethodBinding a(AbstractMethodDeclaration abstractMethodDeclaration) {
        TypeParameter[] typeParameterArray;
        int n2;
        this.referenceContext = abstractMethodDeclaration;
        abstractMethodDeclaration.scope = this;
        SourceTypeBinding sourceTypeBinding = this.referenceType().binding;
        int n3 = abstractMethodDeclaration.modifiers | 0x2000000;
        if (abstractMethodDeclaration.isConstructor()) {
            if (abstractMethodDeclaration.isDefaultConstructor()) {
                n3 |= 0x4000000;
            }
            abstractMethodDeclaration.binding = new MethodBinding(n3, null, null, sourceTypeBinding);
            this.checkAndSetModifiersForConstructor(abstractMethodDeclaration.binding);
        } else {
            if (sourceTypeBinding.isInterface()) {
                n3 |= 0x401;
            }
            abstractMethodDeclaration.binding = new MethodBinding(n3, abstractMethodDeclaration.selector, null, null, null, sourceTypeBinding);
            this.checkAndSetModifiersForMethod(abstractMethodDeclaration.binding);
        }
        this.isStatic = abstractMethodDeclaration.binding.isStatic();
        Argument[] argumentArray = abstractMethodDeclaration.arguments;
        int n4 = n2 = argumentArray == null ? 0 : argumentArray.length;
        if (n2 > 0 && this.compilerOptions().sourceLevel >= 0x310000L) {
            if (argumentArray[--n2].isVarArgs()) {
                abstractMethodDeclaration.binding.modifiers |= 0x80;
            }
            while (--n2 >= 0) {
                if (!argumentArray[n2].isVarArgs()) continue;
                this.problemReporter().illegalVararg(argumentArray[n2], abstractMethodDeclaration);
            }
        }
        if ((typeParameterArray = abstractMethodDeclaration.typeParameters()) == null || this.compilerOptions().sourceLevel < 0x310000L) {
            abstractMethodDeclaration.binding.typeVariables = NoTypeVariables;
        } else {
            abstractMethodDeclaration.binding.typeVariables = this.createTypeVariables(typeParameterArray, abstractMethodDeclaration.binding);
            abstractMethodDeclaration.binding.modifiers |= 0x40000000;
        }
        return abstractMethodDeclaration.binding;
    }

    public FieldBinding findField(TypeBinding typeBinding, char[] cArray, InvocationSite invocationSite, boolean bl2) {
        FieldBinding fieldBinding = super.findField(typeBinding, cArray, invocationSite, bl2);
        if (fieldBinding == null) {
            return null;
        }
        if (!fieldBinding.isValidBinding()) {
            return fieldBinding;
        }
        if (fieldBinding.isStatic()) {
            return fieldBinding;
        }
        if (!this.isConstructorCall || typeBinding != this.enclosingSourceType()) {
            return fieldBinding;
        }
        if (invocationSite instanceof SingleNameReference) {
            return new ProblemFieldBinding(fieldBinding, fieldBinding.declaringClass, cArray, 6);
        }
        if (invocationSite instanceof QualifiedNameReference) {
            QualifiedNameReference qualifiedNameReference = (QualifiedNameReference)invocationSite;
            if (qualifiedNameReference.binding == null) {
                return new ProblemFieldBinding(fieldBinding, fieldBinding.declaringClass, cArray, 6);
            }
        }
        return fieldBinding;
    }

    public boolean isInsideConstructor() {
        return this.referenceContext instanceof ConstructorDeclaration;
    }

    public boolean isInsideInitializer() {
        return this.referenceContext instanceof TypeDeclaration;
    }

    public boolean isInsideInitializerOrConstructor() {
        return this.referenceContext instanceof TypeDeclaration || this.referenceContext instanceof ConstructorDeclaration;
    }

    public ProblemReporter problemReporter() {
        MethodScope methodScope = this.outerMostMethodScope();
        if (methodScope == this) {
            ProblemReporter problemReporter = this.referenceCompilationUnit().problemReporter;
            problemReporter.referenceContext = this.referenceContext;
            return problemReporter;
        }
        return methodScope.problemReporter();
    }

    public final int recordInitializationStates(FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return -1;
        }
        UnconditionalFlowInfo unconditionalFlowInfo = flowInfo.unconditionalInits();
        long[] lArray = unconditionalFlowInfo.extraDefiniteInits;
        long l2 = unconditionalFlowInfo.definiteInits;
        int n2 = this.lastIndex;
        block0: while (--n2 >= 0) {
            if (this.definiteInits[n2] != l2) continue;
            long[] lArray2 = this.extraDefiniteInits[n2];
            if (lArray != null && lArray2 != null) {
                if (lArray.length != lArray2.length) continue;
                int n3 = 0;
                int n4 = lArray.length;
                while (n3 < n4) {
                    if (lArray[n3] != lArray2[n3]) continue block0;
                    ++n3;
                }
                return n2;
            }
            if (lArray != null || lArray2 != null) continue;
            return n2;
        }
        if (this.definiteInits.length == this.lastIndex) {
            this.definiteInits = new long[this.lastIndex + 20];
            System.arraycopy(this.definiteInits, 0, this.definiteInits, 0, this.lastIndex);
            this.extraDefiniteInits = new long[this.lastIndex + 20][];
            System.arraycopy(this.extraDefiniteInits, 0, this.extraDefiniteInits, 0, this.lastIndex);
        }
        this.definiteInits[this.lastIndex] = l2;
        if (lArray != null) {
            this.extraDefiniteInits[this.lastIndex] = new long[lArray.length];
            System.arraycopy(lArray, 0, this.extraDefiniteInits[this.lastIndex], 0, lArray.length);
        }
        return this.lastIndex++;
    }

    public AbstractMethodDeclaration referenceMethod() {
        if (this.referenceContext instanceof AbstractMethodDeclaration) {
            return (AbstractMethodDeclaration)this.referenceContext;
        }
        return null;
    }

    public TypeDeclaration referenceType() {
        return ((ClassScope)this.parent).referenceContext;
    }

    public String a(int n2) {
        String string = "\n";
        int n3 = n2;
        while (--n3 >= 0) {
            string = String.valueOf(string) + "\t";
        }
        String string2 = String.valueOf(string) + "--- Method Scope ---";
        string = String.valueOf(string) + "\t";
        string2 = String.valueOf(string2) + string + "locals:";
        int n4 = 0;
        while (n4 < this.localIndex) {
            string2 = String.valueOf(string2) + string + "\t" + this.locals[n4].toString();
            ++n4;
        }
        string2 = String.valueOf(string2) + string + "startIndex = " + this.startIndex;
        string2 = String.valueOf(string2) + string + "isConstructorCall = " + this.isConstructorCall;
        string2 = String.valueOf(string2) + string + "initializedField = " + this.initializedField;
        string2 = String.valueOf(string2) + string + "lastVisibleFieldID = " + this.lastVisibleFieldID;
        string2 = String.valueOf(string2) + string + "referenceContext = " + this.referenceContext;
        return string2;
    }
}

