/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class MethodBinding
extends Binding
implements BaseTypes,
TypeConstants {
    public int modifiers;
    public char[] selector;
    public TypeBinding returnType;
    public TypeBinding[] parameters;
    public ReferenceBinding[] thrownExceptions;
    public ReferenceBinding declaringClass;
    public TypeVariableBinding[] typeVariables = NoTypeVariables;
    public char[] a;
    public long tagBits;

    public MethodBinding() {
    }

    public MethodBinding(int n2, char[] cArray, TypeBinding typeBinding, TypeBinding[] typeBindingArray, ReferenceBinding[] referenceBindingArray, ReferenceBinding referenceBinding) {
        this.modifiers = n2;
        this.selector = cArray;
        this.returnType = typeBinding;
        this.parameters = typeBindingArray == null || typeBindingArray.length == 0 ? NoParameters : typeBindingArray;
        this.thrownExceptions = referenceBindingArray == null || referenceBindingArray.length == 0 ? NoExceptions : referenceBindingArray;
        this.declaringClass = referenceBinding;
        if (this.declaringClass != null && this.declaringClass.isStrictfp() && !this.isNative() && !this.isAbstract()) {
            this.modifiers |= 0x800;
        }
    }

    public MethodBinding(int n2, TypeBinding[] typeBindingArray, ReferenceBinding[] referenceBindingArray, ReferenceBinding referenceBinding) {
        this(n2, TypeConstants.INIT, VoidBinding, typeBindingArray, referenceBindingArray, referenceBinding);
    }

    public MethodBinding(MethodBinding methodBinding, ReferenceBinding referenceBinding) {
        this.modifiers = methodBinding.modifiers;
        this.selector = methodBinding.selector;
        this.returnType = methodBinding.returnType;
        this.parameters = methodBinding.parameters;
        this.thrownExceptions = methodBinding.thrownExceptions;
        this.declaringClass = referenceBinding;
    }

    public final boolean areParameterErasuresEqual(MethodBinding methodBinding) {
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        if (this.parameters == typeBindingArray) {
            return true;
        }
        int n2 = this.parameters.length;
        if (n2 != typeBindingArray.length) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (this.parameters[n3] != typeBindingArray[n3] && this.parameters[n3].erasure() != typeBindingArray[n3].erasure()) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public final boolean areParametersEqual(MethodBinding methodBinding) {
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        if (this.parameters == typeBindingArray) {
            return true;
        }
        int n2 = this.parameters.length;
        if (n2 != typeBindingArray.length) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (this.parameters[n3] != typeBindingArray[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public final boolean areParametersCompatibleWith(TypeBinding[] typeBindingArray) {
        int n2;
        int n3 = this.parameters.length;
        int n4 = n2 = typeBindingArray.length;
        if (this.isVarargs()) {
            TypeBinding typeBinding;
            n4 = n3 - 1;
            if (n3 == n2) {
                typeBinding = this.parameters[n4];
                TypeBinding typeBinding2 = typeBindingArray[n4];
                if (typeBinding != typeBinding2 && !typeBinding2.isCompatibleWith(typeBinding)) {
                    return false;
                }
            } else if (n3 < n2) {
                typeBinding = ((ArrayBinding)this.parameters[n4]).elementsType();
                int n5 = n4;
                while (n5 < n2) {
                    if (typeBinding != typeBindingArray[n5] && !typeBindingArray[n5].isCompatibleWith(typeBinding)) {
                        return false;
                    }
                    ++n5;
                }
            } else if (n4 != n2) {
                return false;
            }
        }
        int n6 = 0;
        while (n6 < n4) {
            if (this.parameters[n6] != typeBindingArray[n6] && !typeBindingArray[n6].isCompatibleWith(this.parameters[n6])) {
                return false;
            }
            ++n6;
        }
        return true;
    }

    public final int kind() {
        return 8;
    }

    public final boolean canBeSeenBy(PackageBinding packageBinding) {
        if (this.isPublic()) {
            return true;
        }
        if (this.isPrivate()) {
            return false;
        }
        return packageBinding == this.declaringClass.getPackage();
    }

    public final boolean areTypeVariableErasuresEqual(MethodBinding methodBinding) {
        TypeVariableBinding[] typeVariableBindingArray = methodBinding.typeVariables;
        if (this.typeVariables == typeVariableBindingArray) {
            return true;
        }
        int n2 = this.typeVariables.length;
        if (n2 != typeVariableBindingArray.length) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (this.typeVariables[n3] != typeVariableBindingArray[n3] && this.typeVariables[n3].erasure() != typeVariableBindingArray[n3].erasure()) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public final boolean canBeSeenBy(InvocationSite invocationSite, Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding sourceTypeBinding = scope.enclosingSourceType();
        if (sourceTypeBinding == this.declaringClass) {
            return true;
        }
        if (this.isProtected()) {
            if (sourceTypeBinding.fPackage == this.declaringClass.fPackage) {
                return true;
            }
            return invocationSite.isSuperAccess();
        }
        if (this.isPrivate()) {
            ReferenceBinding referenceBinding = sourceTypeBinding;
            ReferenceBinding referenceBinding2 = referenceBinding.enclosingType();
            while (referenceBinding2 != null) {
                referenceBinding = referenceBinding2;
                referenceBinding2 = referenceBinding2.enclosingType();
            }
            ReferenceBinding referenceBinding3 = (ReferenceBinding)this.declaringClass.erasure();
            referenceBinding2 = referenceBinding3.enclosingType();
            while (referenceBinding2 != null) {
                referenceBinding3 = referenceBinding2;
                referenceBinding2 = referenceBinding2.enclosingType();
            }
            return referenceBinding == referenceBinding3;
        }
        return sourceTypeBinding.fPackage == this.declaringClass.fPackage;
    }

    public final boolean canBeSeenBy(TypeBinding typeBinding, InvocationSite invocationSite, Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding sourceTypeBinding = scope.enclosingSourceType();
        if (sourceTypeBinding == this.declaringClass && sourceTypeBinding == typeBinding) {
            return true;
        }
        if (this.isProtected()) {
            if (sourceTypeBinding == this.declaringClass) {
                return true;
            }
            if (sourceTypeBinding.fPackage == this.declaringClass.fPackage) {
                return true;
            }
            ReferenceBinding referenceBinding = sourceTypeBinding;
            TypeBinding typeBinding2 = typeBinding.erasure();
            ReferenceBinding referenceBinding2 = (ReferenceBinding)this.declaringClass.erasure();
            int n2 = 0;
            do {
                if (referenceBinding.findSuperTypeWithSameErasure(referenceBinding2) != null) {
                    if (invocationSite.isSuperAccess()) {
                        return true;
                    }
                    if (typeBinding instanceof ArrayBinding) {
                        return false;
                    }
                    if (this.isStatic()) {
                        if (n2 > 0) {
                            invocationSite.setDepth(n2);
                        }
                        return true;
                    }
                    if (referenceBinding == typeBinding2 || ((ReferenceBinding)typeBinding2).findSuperTypeWithSameErasure(referenceBinding) != null) {
                        if (n2 > 0) {
                            invocationSite.setDepth(n2);
                        }
                        return true;
                    }
                }
                ++n2;
            } while ((referenceBinding = referenceBinding.enclosingType()) != null);
            return false;
        }
        if (this.isPrivate()) {
            if (!(typeBinding == this.declaringClass || typeBinding.isTypeVariable() && ((TypeVariableBinding)typeBinding).isErasureBoundTo(this.declaringClass.erasure()))) {
                return false;
            }
            if (sourceTypeBinding != this.declaringClass) {
                ReferenceBinding referenceBinding = sourceTypeBinding;
                ReferenceBinding referenceBinding3 = referenceBinding.enclosingType();
                while (referenceBinding3 != null) {
                    referenceBinding = referenceBinding3;
                    referenceBinding3 = referenceBinding3.enclosingType();
                }
                ReferenceBinding referenceBinding4 = (ReferenceBinding)this.declaringClass.erasure();
                referenceBinding3 = referenceBinding4.enclosingType();
                while (referenceBinding3 != null) {
                    referenceBinding4 = referenceBinding3;
                    referenceBinding3 = referenceBinding3.enclosingType();
                }
                if (referenceBinding != referenceBinding4) {
                    return false;
                }
            }
            return true;
        }
        if (sourceTypeBinding.fPackage != this.declaringClass.fPackage) {
            return false;
        }
        if (typeBinding instanceof ArrayBinding) {
            return false;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
        PackageBinding packageBinding = this.declaringClass.fPackage;
        do {
            if (this.declaringClass == referenceBinding) {
                return true;
            }
            if (packageBinding == referenceBinding.fPackage) continue;
            return false;
        } while ((referenceBinding = referenceBinding.superclass()) != null);
        return false;
    }

    public MethodBinding a(MethodBinding methodBinding, LookupEnvironment lookupEnvironment) {
        TypeBinding[] typeBindingArray = this.typeVariables;
        TypeVariableBinding[] typeVariableBindingArray = methodBinding.typeVariables;
        if (typeBindingArray.length != typeVariableBindingArray.length) {
            return null;
        }
        int n2 = typeBindingArray.length;
        while (--n2 >= 0) {
            if (typeBindingArray[n2].isInterchangeableWith(lookupEnvironment, typeVariableBindingArray[n2])) continue;
            return null;
        }
        return new ParameterizedGenericMethodBinding(methodBinding, typeBindingArray, lookupEnvironment);
    }

    public char[] computeUniqueKey(boolean bl2) {
        return this.computeUniqueKey(this, bl2);
    }

    public char[] computeUniqueKey(MethodBinding methodBinding, boolean bl2) {
        char[] cArray = this.declaringClass.computeUniqueKey(false);
        int n2 = cArray.length;
        int n3 = this.selector == TypeConstants.INIT ? 0 : this.selector.length;
        char[] cArray2 = methodBinding.genericSignature();
        if (cArray2 == null) {
            cArray2 = methodBinding.signature();
        }
        int n4 = cArray2.length;
        char[] cArray3 = new char[n2 + 1 + n3 + n4];
        int n5 = 0;
        System.arraycopy(cArray, 0, cArray3, n5, n2);
        n5 = n2;
        cArray3[n5++] = 46;
        System.arraycopy(this.selector, 0, cArray3, n5, n3);
        System.arraycopy(cArray2, 0, cArray3, n5 += n3, n4);
        return cArray3;
    }

    public TypeBinding constantPoolDeclaringClass() {
        return this.declaringClass;
    }

    public final char[] constantPoolName() {
        return this.selector;
    }

    public char[] genericSignature() {
        int n2;
        int n3;
        if ((this.modifiers & 0x40000000) == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.typeVariables != NoTypeVariables) {
            stringBuffer.append('<');
            n3 = 0;
            n2 = this.typeVariables.length;
            while (n3 < n2) {
                stringBuffer.append(this.typeVariables[n3].genericSignature());
                ++n3;
            }
            stringBuffer.append('>');
        }
        stringBuffer.append('(');
        n3 = 0;
        n2 = this.parameters.length;
        while (n3 < n2) {
            stringBuffer.append(this.parameters[n3].genericTypeSignature());
            ++n3;
        }
        stringBuffer.append(')');
        if (this.returnType != null) {
            stringBuffer.append(this.returnType.genericTypeSignature());
        }
        n3 = 0;
        n2 = this.thrownExceptions.length;
        int n4 = 0;
        while (n4 < n2) {
            if ((this.thrownExceptions[n4].modifiers & 0x40000000) != 0) {
                n3 = 1;
                break;
            }
            ++n4;
        }
        if (n3 != 0) {
            n4 = 0;
            while (n4 < n2) {
                stringBuffer.append('^');
                stringBuffer.append(this.thrownExceptions[n4].genericTypeSignature());
                ++n4;
            }
        }
        n4 = stringBuffer.length();
        char[] cArray = new char[n4];
        stringBuffer.getChars(0, n4, cArray, 0);
        return cArray;
    }

    public final int getAccessFlags() {
        return this.modifiers & 0xFFFF;
    }

    public long getAnnotationTagBits() {
        TypeDeclaration typeDeclaration;
        AbstractMethodDeclaration abstractMethodDeclaration;
        MethodBinding methodBinding = this.original();
        if ((methodBinding.tagBits & 0x200000000L) == 0L && methodBinding.declaringClass instanceof SourceTypeBinding && (abstractMethodDeclaration = (typeDeclaration = ((SourceTypeBinding)methodBinding.declaringClass).scope.referenceContext).declarationOf(methodBinding)) != null) {
            ASTNode.resolveAnnotations(abstractMethodDeclaration.scope, abstractMethodDeclaration.annotations, methodBinding);
        }
        return methodBinding.tagBits;
    }

    public TypeVariableBinding getTypeVariable(char[] cArray) {
        int n2 = this.typeVariables.length;
        while (--n2 >= 0) {
            if (!CharOperation.equals(this.typeVariables[n2].sourceName, cArray)) continue;
            return this.typeVariables[n2];
        }
        return null;
    }

    public boolean hasSubstitutedParameters() {
        return false;
    }

    public boolean hasSubstitutedReturnType() {
        return false;
    }

    public final boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public final boolean isBridge() {
        return (this.modifiers & 0x40) != 0;
    }

    public final boolean isConstructor() {
        return this.selector == TypeConstants.INIT;
    }

    public final boolean isDefault() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public final boolean isDefaultAbstract() {
        return (this.modifiers & 0x80000) != 0;
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x100000) != 0;
    }

    public final boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public final boolean isImplementing() {
        return (this.modifiers & 0x20000000) != 0;
    }

    public final boolean isNative() {
        return (this.modifiers & 0x100) != 0;
    }

    public final boolean isOverriding() {
        return (this.modifiers & 0x10000000) != 0;
    }

    public final boolean isMain() {
        TypeBinding typeBinding;
        return this.selector.length == 4 && CharOperation.equals(this.selector, MAIN) && (this.modifiers & 9) != 0 && VoidBinding == this.returnType && this.parameters.length == 1 && (typeBinding = this.parameters[0]).dimensions() == 1 && typeBinding.leafComponentType().id == 11;
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isUsed() {
        return (this.modifiers & 0x8000000) != 0;
    }

    public final boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isRequiredToClearPrivateModifier() {
        return (this.modifiers & 0x4000000) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public final boolean isStrictfp() {
        return (this.modifiers & 0x800) != 0;
    }

    public final boolean isSynchronized() {
        return (this.modifiers & 0x20) != 0;
    }

    public final boolean isSynthetic() {
        return (this.modifiers & 0x1000) != 0;
    }

    public final boolean isVarargs() {
        return (this.modifiers & 0x80) != 0;
    }

    public final boolean isViewedAsDeprecated() {
        return (this.modifiers & 0x300000) != 0;
    }

    public MethodBinding original() {
        return this;
    }

    public char[] readableName() {
        StringBuffer stringBuffer = new StringBuffer(this.parameters.length + 20);
        if (this.isConstructor()) {
            stringBuffer.append(this.declaringClass.sourceName());
        } else {
            stringBuffer.append(this.selector);
        }
        stringBuffer.append('(');
        if (this.parameters != NoParameters) {
            int n2 = 0;
            int n3 = this.parameters.length;
            while (n2 < n3) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.parameters[n2].sourceName());
                ++n2;
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString().toCharArray();
    }

    public char[] shortReadableName() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(this.parameters.length + 20);
        if (this.isConstructor()) {
            stringBuffer.append(this.declaringClass.shortReadableName());
        } else {
            stringBuffer.append(this.selector);
        }
        stringBuffer.append('(');
        if (this.parameters != NoParameters) {
            n2 = 0;
            int n3 = this.parameters.length;
            while (n2 < n3) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.parameters[n2].shortReadableName());
                ++n2;
            }
        }
        stringBuffer.append(')');
        n2 = stringBuffer.length();
        char[] cArray = new char[n2];
        stringBuffer.getChars(0, n2, cArray, 0);
        return cArray;
    }

    public final void setSelector(char[] cArray) {
        this.selector = cArray;
        this.a = null;
    }

    public final char[] signature() {
        int n2;
        int n3;
        Binding[] bindingArray;
        boolean bl2;
        if (this.a != null) {
            return this.a;
        }
        StringBuffer stringBuffer = new StringBuffer(this.parameters.length + 20);
        stringBuffer.append('(');
        TypeBinding[] typeBindingArray = this.parameters;
        boolean bl3 = this.isConstructor();
        if (bl3 && this.declaringClass.isEnum()) {
            stringBuffer.append(ConstantPool.JavaLangStringSignature);
            stringBuffer.append(BaseTypes.IntBinding.signature());
        }
        boolean bl4 = bl2 = bl3 && this.declaringClass.isNestedType();
        if (bl2) {
            bindingArray = this.declaringClass.syntheticEnclosingInstanceTypes();
            n3 = bindingArray == null ? 0 : bindingArray.length;
            n2 = 0;
            while (n2 < n3) {
                stringBuffer.append(((ReferenceBinding)bindingArray[n2]).signature());
                ++n2;
            }
            if (this instanceof SyntheticMethodBinding) {
                typeBindingArray = ((SyntheticMethodBinding)this).targetMethod.parameters;
            }
        }
        if (typeBindingArray != NoParameters) {
            int n4 = 0;
            while (n4 < typeBindingArray.length) {
                stringBuffer.append(typeBindingArray[n4].signature());
                ++n4;
            }
        }
        if (bl2) {
            bindingArray = this.declaringClass.syntheticOuterLocalVariables();
            n3 = bindingArray == null ? 0 : bindingArray.length;
            n2 = 0;
            while (n2 < n3) {
                stringBuffer.append(((SyntheticArgumentBinding)bindingArray[n2]).type.signature());
                ++n2;
            }
            n2 = typeBindingArray.length;
            int n5 = this.parameters.length;
            while (n2 < n5) {
                stringBuffer.append(this.parameters[n2].signature());
                ++n2;
            }
        }
        stringBuffer.append(')');
        if (this.returnType != null) {
            stringBuffer.append(this.returnType.signature());
        }
        int n6 = stringBuffer.length();
        this.a = new char[n6];
        stringBuffer.getChars(0, n6, this.a, 0);
        return this.a;
    }

    public final int sourceEnd() {
        AbstractMethodDeclaration abstractMethodDeclaration = this.sourceMethod();
        if (abstractMethodDeclaration == null) {
            return 0;
        }
        return abstractMethodDeclaration.sourceEnd;
    }

    public AbstractMethodDeclaration sourceMethod() {
        SourceTypeBinding sourceTypeBinding;
        try {
            sourceTypeBinding = (SourceTypeBinding)this.declaringClass;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        AbstractMethodDeclaration[] abstractMethodDeclarationArray = sourceTypeBinding.scope.referenceContext.methods;
        int n2 = abstractMethodDeclarationArray.length;
        while (--n2 >= 0) {
            if (this != abstractMethodDeclarationArray[n2].binding) continue;
            return abstractMethodDeclarationArray[n2];
        }
        return null;
    }

    public final int sourceStart() {
        AbstractMethodDeclaration abstractMethodDeclaration = this.sourceMethod();
        if (abstractMethodDeclaration == null) {
            return 0;
        }
        return abstractMethodDeclaration.sourceStart;
    }

    public final void tagForClearingPrivateModifier() {
        this.modifiers |= 0x4000000;
    }

    public String toString() {
        int n2;
        int n3;
        String string = this.returnType != null ? this.returnType.debugName() : "NULL TYPE";
        string = String.valueOf(string) + " ";
        string = String.valueOf(string) + (this.selector != null ? new String(this.selector) : "UNNAMED METHOD");
        string = String.valueOf(string) + "(";
        if (this.parameters != null) {
            if (this.parameters != NoParameters) {
                n3 = 0;
                n2 = this.parameters.length;
                while (n3 < n2) {
                    if (n3 > 0) {
                        string = String.valueOf(string) + ", ";
                    }
                    string = String.valueOf(string) + (this.parameters[n3] != null ? this.parameters[n3].debugName() : "NULL TYPE");
                    ++n3;
                }
            }
        } else {
            string = String.valueOf(string) + "NULL PARAMETERS";
        }
        string = String.valueOf(string) + ") ";
        if (this.thrownExceptions != null) {
            if (this.thrownExceptions != NoExceptions) {
                string = String.valueOf(string) + "throws ";
                n3 = 0;
                n2 = this.thrownExceptions.length;
                while (n3 < n2) {
                    if (n3 > 0) {
                        string = String.valueOf(string) + ", ";
                    }
                    string = String.valueOf(string) + (this.thrownExceptions[n3] != null ? this.thrownExceptions[n3].debugName() : "NULL TYPE");
                    ++n3;
                }
            }
        } else {
            string = String.valueOf(string) + "NULL THROWN EXCEPTIONS";
        }
        return string;
    }

    public MethodBinding tiebreakMethod() {
        return this;
    }

    public TypeVariableBinding[] typeVariables() {
        return this.typeVariables;
    }
}

