/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class LocalVariableBinding
extends VariableBinding {
    public boolean isArgument;
    public int resolvedPosition;
    public static final int UNUSED = 0;
    public static final int USED = 1;
    public static final int FAKE_USED = 2;
    public int useFlag;
    public BlockScope declaringScope;
    public LocalDeclaration declaration;
    public int[] initializationPCs;
    public int initializationCount = 0;

    public LocalVariableBinding(char[] cArray, TypeBinding typeBinding, int n2, boolean bl2) {
        super(cArray, typeBinding, n2, bl2 ? Constant.NotAConstant : null);
        this.isArgument = bl2;
    }

    public LocalVariableBinding(LocalDeclaration localDeclaration, TypeBinding typeBinding, int n2, boolean bl2) {
        this(localDeclaration.name, typeBinding, n2, bl2);
        this.declaration = localDeclaration;
    }

    public final int kind() {
        return 2;
    }

    public char[] computeUniqueKey(boolean bl2) {
        Binding binding;
        StringBuffer stringBuffer = new StringBuffer();
        BlockScope blockScope = this.declaringScope;
        MethodScope methodScope = blockScope instanceof MethodScope ? (MethodScope)blockScope : blockScope.enclosingMethodScope();
        ReferenceContext referenceContext = methodScope.referenceContext;
        if (referenceContext instanceof AbstractMethodDeclaration) {
            binding = ((AbstractMethodDeclaration)referenceContext).binding;
            if (binding != null) {
                stringBuffer.append(((MethodBinding)binding).computeUniqueKey(false));
            }
        } else if (referenceContext instanceof TypeDeclaration && (binding = ((TypeDeclaration)referenceContext).binding) != null) {
            stringBuffer.append(binding.computeUniqueKey(false));
        }
        this.getScopeKey(blockScope, stringBuffer);
        stringBuffer.append('#');
        stringBuffer.append(this.name);
        int n2 = stringBuffer.length();
        char[] cArray = new char[n2];
        stringBuffer.getChars(0, n2, cArray, 0);
        return cArray;
    }

    private void getScopeKey(BlockScope blockScope, StringBuffer stringBuffer) {
        int n2 = blockScope.scopeIndex();
        if (n2 != -1) {
            this.getScopeKey((BlockScope)blockScope.parent, stringBuffer);
            stringBuffer.append('#');
            stringBuffer.append(n2);
        }
    }

    public boolean isSecret() {
        return this.declaration == null && !this.isArgument;
    }

    public void recordInitializationEndPC(int n2) {
        if (this.initializationPCs[(this.initializationCount - 1 << 1) + 1] == -1) {
            this.initializationPCs[(this.initializationCount - 1 << 1) + 1] = n2;
        }
    }

    public void recordInitializationStartPC(int n2) {
        if (this.initializationPCs == null) {
            return;
        }
        if (this.initializationCount > 0 && this.initializationPCs[(this.initializationCount - 1 << 1) + 1] == n2) {
            this.initializationPCs[(this.initializationCount - 1 << 1) + 1] = -1;
        } else {
            int n3 = this.initializationCount << 1;
            if (n3 == this.initializationPCs.length) {
                this.initializationPCs = new int[this.initializationCount << 2];
                System.arraycopy(this.initializationPCs, 0, this.initializationPCs, 0, n3);
            }
            this.initializationPCs[n3] = n2;
            this.initializationPCs[n3 + 1] = -1;
            ++this.initializationCount;
        }
    }

    public String toString() {
        String string = super.toString();
        switch (this.useFlag) {
            case 1: {
                string = String.valueOf(string) + "[pos: " + String.valueOf(this.resolvedPosition) + "]";
                break;
            }
            case 0: {
                string = String.valueOf(string) + "[pos: unused]";
                break;
            }
            case 2: {
                string = String.valueOf(string) + "[pos: fake_used]";
            }
        }
        string = String.valueOf(string) + "[id:" + String.valueOf(this.id) + "]";
        if (this.initializationCount > 0) {
            string = String.valueOf(string) + "[pc: ";
            int n2 = 0;
            while (n2 < this.initializationCount) {
                if (n2 > 0) {
                    string = String.valueOf(string) + ", ";
                }
                string = String.valueOf(string) + String.valueOf(this.initializationPCs[n2 << 1]) + "-" + (this.initializationPCs[(n2 << 1) + 1] == -1 ? "?" : String.valueOf(this.initializationPCs[(n2 << 1) + 1]));
                ++n2;
            }
            string = String.valueOf(string) + "]";
        }
        return string;
    }
}

