/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;

public class ClassScope
extends Scope {
    public TypeDeclaration referenceContext;
    public TypeReference superTypeReference;
    private static final char[] IncompleteHierarchy = new char[]{'h', 'a', 's', ' ', 'i', 'n', 'c', 'o', 'n', 's', 'i', 's', 't', 'e', 'n', 't', ' ', 'h', 'i', 'e', 'r', 'a', 'r', 'c', 'h', 'y'};

    public ClassScope(Scope scope, TypeDeclaration typeDeclaration) {
        super(3, scope);
        this.referenceContext = typeDeclaration;
    }

    public void a(SourceTypeBinding sourceTypeBinding, ReferenceBinding referenceBinding) {
        LocalTypeBinding localTypeBinding = this.buildLocalType(sourceTypeBinding, sourceTypeBinding.fPackage);
        SourceTypeBinding sourceTypeBinding2 = this.referenceContext.binding;
        if (referenceBinding.isInterface()) {
            sourceTypeBinding2.superclass = this.getJavaLangObject();
            sourceTypeBinding2.superInterfaces = new ReferenceBinding[]{referenceBinding};
        } else {
            sourceTypeBinding2.superclass = referenceBinding;
            sourceTypeBinding2.superInterfaces = TypeConstants.NoSuperInterfaces;
        }
        this.connectMemberTypes();
        this.c();
        localTypeBinding.b();
        sourceTypeBinding2.a(this.environment().methodVerifier());
    }

    private void buildFields() {
        FieldBinding fieldBinding;
        boolean bl2 = this.referenceContext.binding.isHierarchyInconsistent();
        if (this.referenceContext.fields == null) {
            if (bl2) {
                this.referenceContext.binding.fields = new FieldBinding[1];
                this.referenceContext.binding.fields[0] = new FieldBinding(IncompleteHierarchy, IntBinding, 2, this.referenceContext.binding, null);
            } else {
                this.referenceContext.binding.fields = NoFields;
            }
            return;
        }
        FieldDeclaration[] fieldDeclarationArray = this.referenceContext.fields;
        int n2 = fieldDeclarationArray.length;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            switch (fieldDeclarationArray[n4].getKind()) {
                case 1: 
                case 3: {
                    ++n3;
                }
            }
            ++n4;
        }
        if (bl2) {
            ++n3;
        }
        FieldBinding[] fieldBindingArray = new FieldBinding[n3];
        HashtableOfObject hashtableOfObject = new HashtableOfObject(n3);
        boolean bl3 = false;
        n3 = 0;
        int n5 = 0;
        while (n5 < n2) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n5];
            if (fieldDeclaration.getKind() == 2) {
                if (this.referenceContext.binding.isInterface()) {
                    this.problemReporter().interfaceCannotHaveInitializers(this.referenceContext.binding, fieldDeclaration);
                }
            } else {
                fieldBinding = new FieldBinding(fieldDeclaration, null, fieldDeclaration.modifiers | 0x2000000, this.referenceContext.binding);
                this.checkAndSetModifiersForField(fieldBinding, fieldDeclaration);
                if (hashtableOfObject.containsKey(fieldDeclaration.name)) {
                    bl3 = true;
                    FieldBinding fieldBinding2 = (FieldBinding)hashtableOfObject.get(fieldDeclaration.name);
                    if (fieldBinding2 != null) {
                        int n6 = 0;
                        while (n6 < n5) {
                            FieldDeclaration fieldDeclaration2 = fieldDeclarationArray[n6];
                            if (fieldDeclaration2.binding == fieldBinding2) {
                                this.problemReporter().duplicateFieldInType(this.referenceContext.binding, fieldDeclaration2);
                                fieldDeclaration2.binding = null;
                                break;
                            }
                            ++n6;
                        }
                    }
                    hashtableOfObject.put(fieldDeclaration.name, null);
                    this.problemReporter().duplicateFieldInType(this.referenceContext.binding, fieldDeclaration);
                    fieldDeclaration.binding = null;
                } else {
                    hashtableOfObject.put(fieldDeclaration.name, fieldBinding);
                    if (fieldBinding != null) {
                        fieldBindingArray[n3++] = fieldBinding;
                    }
                }
            }
            ++n5;
        }
        if (bl3) {
            FieldBinding[] fieldBindingArray2 = new FieldBinding[fieldBindingArray.length];
            n2 = n3;
            n3 = 0;
            int n7 = 0;
            while (n7 < n2) {
                fieldBinding = fieldBindingArray[n7];
                if (hashtableOfObject.get(fieldBinding.name) != null) {
                    fieldBindingArray2[n3++] = fieldBinding;
                }
                ++n7;
            }
            fieldBindingArray = fieldBindingArray2;
        }
        if (bl2) {
            fieldBindingArray[n3++] = new FieldBinding(IncompleteHierarchy, IntBinding, 2, this.referenceContext.binding, null);
        }
        if (n3 != fieldBindingArray.length) {
            FieldBinding[] fieldBindingArray3 = fieldBindingArray;
            fieldBindingArray = new FieldBinding[n3];
            System.arraycopy(fieldBindingArray3, 0, fieldBindingArray, 0, n3);
        }
        int n8 = 0;
        while (n8 < n3) {
            fieldBindingArray[n8].id = n8;
            ++n8;
        }
        this.referenceContext.binding.fields = fieldBindingArray;
    }

    public void c() {
        this.buildFields();
        this.buildMethods();
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        if (sourceTypeBinding.isMemberType() && !sourceTypeBinding.isLocalType()) {
            ((MemberTypeBinding)sourceTypeBinding).c();
        }
        ReferenceBinding[] referenceBindingArray = sourceTypeBinding.memberTypes;
        int n2 = 0;
        int n3 = referenceBindingArray.length;
        while (n2 < n3) {
            ((SourceTypeBinding)referenceBindingArray[n2]).scope.c();
            ++n2;
        }
    }

    private LocalTypeBinding buildLocalType(SourceTypeBinding sourceTypeBinding, PackageBinding packageBinding) {
        this.referenceContext.scope = this;
        this.referenceContext.staticInitializerScope = new MethodScope(this, this.referenceContext, true);
        this.referenceContext.initializerScope = new MethodScope(this, this.referenceContext, false);
        LocalTypeBinding localTypeBinding = new LocalTypeBinding(this, sourceTypeBinding, this.innermostSwitchCase());
        this.referenceContext.binding = localTypeBinding;
        this.checkAndSetModifiers();
        this.buildTypeVariables();
        ReferenceBinding[] referenceBindingArray = NoMemberTypes;
        if (this.referenceContext.memberTypes != null) {
            int n2 = this.referenceContext.memberTypes.length;
            referenceBindingArray = new ReferenceBinding[n2];
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                TypeDeclaration typeDeclaration = this.referenceContext.memberTypes[n4];
                block0 : switch (typeDeclaration.kind()) {
                    case 2: 
                    case 4: {
                        this.problemReporter().illegalLocalTypeDeclaration(typeDeclaration);
                        break;
                    }
                    default: {
                        ReferenceBinding referenceBinding = localTypeBinding;
                        do {
                            if (!CharOperation.equals(referenceBinding.sourceName, typeDeclaration.name)) continue;
                            this.problemReporter().hidingEnclosingType(typeDeclaration);
                            break block0;
                        } while ((referenceBinding = ((TypeBinding)referenceBinding).enclosingType()) != null);
                        int n5 = 0;
                        while (n5 < n4) {
                            if (CharOperation.equals(this.referenceContext.memberTypes[n5].name, typeDeclaration.name)) {
                                this.problemReporter().duplicateNestedType(typeDeclaration);
                                break block0;
                            }
                            ++n5;
                        }
                        ClassScope classScope = new ClassScope(this, this.referenceContext.memberTypes[n4]);
                        LocalTypeBinding localTypeBinding2 = classScope.buildLocalType(localTypeBinding, packageBinding);
                        localTypeBinding2.setAsMemberType();
                        referenceBindingArray[n3++] = localTypeBinding2;
                    }
                }
                ++n4;
            }
            if (n3 != n2) {
                ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n3];
                System.arraycopy(referenceBindingArray2, 0, referenceBindingArray, 0, n3);
            }
        }
        localTypeBinding.memberTypes = referenceBindingArray;
        return localTypeBinding;
    }

    public void a(SourceTypeBinding sourceTypeBinding) {
        LocalTypeBinding localTypeBinding = this.buildLocalType(sourceTypeBinding, sourceTypeBinding.fPackage);
        this.b();
        this.c();
        localTypeBinding.b();
        this.referenceContext.binding.a(this.environment().methodVerifier());
    }

    private void buildMemberTypes(AccessRestriction accessRestriction) {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        ReferenceBinding[] referenceBindingArray = NoMemberTypes;
        if (this.referenceContext.memberTypes != null) {
            int n2 = this.referenceContext.memberTypes.length;
            referenceBindingArray = new ReferenceBinding[n2];
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                TypeDeclaration typeDeclaration = this.referenceContext.memberTypes[n4];
                block0 : switch (typeDeclaration.kind()) {
                    case 2: 
                    case 4: {
                        if (sourceTypeBinding.isNestedType() && sourceTypeBinding.isClass() && !sourceTypeBinding.isStatic()) {
                            this.problemReporter().illegalLocalTypeDeclaration(typeDeclaration);
                            break;
                        }
                    }
                    default: {
                        ReferenceBinding referenceBinding = sourceTypeBinding;
                        do {
                            if (!CharOperation.equals(referenceBinding.sourceName, typeDeclaration.name)) continue;
                            this.problemReporter().hidingEnclosingType(typeDeclaration);
                            break block0;
                        } while ((referenceBinding = referenceBinding.enclosingType()) != null);
                        int n5 = 0;
                        while (n5 < n4) {
                            if (CharOperation.equals(this.referenceContext.memberTypes[n5].name, typeDeclaration.name)) {
                                this.problemReporter().duplicateNestedType(typeDeclaration);
                                break block0;
                            }
                            ++n5;
                        }
                        ClassScope classScope = new ClassScope(this, typeDeclaration);
                        referenceBindingArray[n3++] = classScope.a(sourceTypeBinding, sourceTypeBinding.fPackage, accessRestriction);
                    }
                }
                ++n4;
            }
            if (n3 != n2) {
                ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n3];
                System.arraycopy(referenceBindingArray2, 0, referenceBindingArray, 0, n3);
            }
        }
        sourceTypeBinding.memberTypes = referenceBindingArray;
    }

    private void buildMethods() {
        boolean bl2;
        boolean bl3 = bl2 = this.referenceContext.kind() == 3;
        if (this.referenceContext.methods == null && !bl2) {
            this.referenceContext.binding.methods = NoMethods;
            return;
        }
        AbstractMethodDeclaration[] abstractMethodDeclarationArray = this.referenceContext.methods;
        int n2 = abstractMethodDeclarationArray == null ? 0 : abstractMethodDeclarationArray.length;
        int n3 = -1;
        int n4 = 0;
        while (n4 < n2) {
            if (abstractMethodDeclarationArray[n4].isClinit()) {
                n3 = n4;
                break;
            }
            ++n4;
        }
        n4 = bl2 ? 2 : 0;
        MethodBinding[] methodBindingArray = new MethodBinding[(n3 == -1 ? n2 : n2 - 1) + n4];
        if (bl2) {
            SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
            methodBindingArray[0] = sourceTypeBinding.addSyntheticEnumMethod(TypeConstants.VALUES);
            methodBindingArray[1] = sourceTypeBinding.addSyntheticEnumMethod(TypeConstants.VALUEOF);
        }
        int n5 = 0;
        while (n5 < n2) {
            MethodScope methodScope;
            MethodBinding methodBinding;
            if (n5 != n3 && (methodBinding = (methodScope = new MethodScope(this, abstractMethodDeclarationArray[n5], false)).a(abstractMethodDeclarationArray[n5])) != null) {
                methodBindingArray[n4++] = methodBinding;
            }
            ++n5;
        }
        if (n4 != methodBindingArray.length) {
            MethodBinding[] methodBindingArray2 = methodBindingArray;
            methodBindingArray = new MethodBinding[n4];
            System.arraycopy(methodBindingArray2, 0, methodBindingArray, 0, n4);
        }
        this.referenceContext.binding.methods = methodBindingArray;
    }

    public SourceTypeBinding a(SourceTypeBinding sourceTypeBinding, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        Object object;
        this.referenceContext.scope = this;
        this.referenceContext.staticInitializerScope = new MethodScope(this, this.referenceContext, true);
        this.referenceContext.initializerScope = new MethodScope(this, this.referenceContext, false);
        if (sourceTypeBinding == null) {
            object = CharOperation.arrayConcat(packageBinding.compoundName, this.referenceContext.name);
            this.referenceContext.binding = new SourceTypeBinding((char[][])object, packageBinding, this);
        } else {
            object = CharOperation.deepCopy(sourceTypeBinding.compoundName);
            object[((char[][])object).length - 1] = CharOperation.concat(object[((char[][])object).length - 1], this.referenceContext.name, '$');
            this.referenceContext.binding = new MemberTypeBinding((char[][])object, this, sourceTypeBinding);
        }
        object = this.referenceContext.binding;
        this.environment().setAccessRestriction((ReferenceBinding)object, accessRestriction);
        object.fPackage.a((ReferenceBinding)object);
        this.checkAndSetModifiers();
        this.buildTypeVariables();
        this.buildMemberTypes(accessRestriction);
        return object;
    }

    private void buildTypeVariables() {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        TypeParameter[] typeParameterArray = this.referenceContext.typeParameters;
        if (typeParameterArray == null || this.compilerOptions().sourceLevel < 0x310000L) {
            sourceTypeBinding.typeVariables = NoTypeVariables;
            return;
        }
        sourceTypeBinding.typeVariables = NoTypeVariables;
        if (sourceTypeBinding.id == 1) {
            this.problemReporter().objectCannotBeGeneric(this.referenceContext);
            return;
        }
        sourceTypeBinding.typeVariables = this.createTypeVariables(typeParameterArray, sourceTypeBinding);
        sourceTypeBinding.modifiers |= 0x40000000;
    }

    private void checkAndSetModifiers() {
        int n2;
        Binding binding;
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        int n3 = sourceTypeBinding.modifiers;
        if ((n3 & 0x400000) != 0) {
            this.problemReporter().duplicateModifierForType(sourceTypeBinding);
        }
        ReferenceBinding referenceBinding = sourceTypeBinding.enclosingType();
        boolean bl2 = sourceTypeBinding.isMemberType();
        if (bl2) {
            n3 |= referenceBinding.modifiers & 0x40000800;
            if (referenceBinding.isInterface()) {
                n3 |= 1;
            }
            if (sourceTypeBinding.isEnum()) {
                if (!referenceBinding.isStatic()) {
                    this.problemReporter().nonStaticContextForEnumMemberType(sourceTypeBinding);
                } else {
                    n3 |= 8;
                }
            }
        } else if (sourceTypeBinding.isLocalType()) {
            if (sourceTypeBinding.isEnum()) {
                this.problemReporter().illegalLocalTypeDeclaration(this.referenceContext);
                sourceTypeBinding.modifiers = 0;
                return;
            }
            if (sourceTypeBinding.isAnonymousType()) {
                n3 |= 0x10;
                if (this.referenceContext.allocation.type == null) {
                    n3 |= 0x4000;
                }
            }
            Scope scope = this;
            block4: do {
                switch (scope.kind) {
                    case 2: {
                        MethodScope methodScope = (MethodScope)scope;
                        if (methodScope.isInsideInitializer()) {
                            binding = ((TypeDeclaration)methodScope.referenceContext).binding;
                            if (methodScope.initializedField != null) {
                                if (!methodScope.initializedField.isViewedAsDeprecated() || sourceTypeBinding.isDeprecated()) continue block4;
                                n3 |= 0x200000;
                                break;
                            }
                            if (((ReferenceBinding)binding).isStrictfp()) {
                                n3 |= 0x800;
                            }
                            if (!((ReferenceBinding)binding).isViewedAsDeprecated() || sourceTypeBinding.isDeprecated()) continue block4;
                            n3 |= 0x200000;
                            break;
                        }
                        binding = ((AbstractMethodDeclaration)methodScope.referenceContext).binding;
                        if (binding == null) break;
                        if (((MethodBinding)binding).isStrictfp()) {
                            n3 |= 0x800;
                        }
                        if (!((MethodBinding)binding).isViewedAsDeprecated() || sourceTypeBinding.isDeprecated()) continue block4;
                        n3 |= 0x200000;
                        break;
                    }
                    case 3: {
                        if (referenceBinding.isStrictfp()) {
                            n3 |= 0x800;
                        }
                        if (!referenceBinding.isViewedAsDeprecated() || sourceTypeBinding.isDeprecated()) continue block4;
                        n3 |= 0x200000;
                    }
                }
            } while ((scope = scope.parent) != null);
        }
        if (((n2 = n3 & 0xFFFF) & 0x200) != 0) {
            int n4;
            if (bl2) {
                n4 = -11792;
                if ((n2 & n4) != 0) {
                    if ((n2 & 0x2000) != 0) {
                        this.problemReporter().illegalModifierForAnnotationMemberType(sourceTypeBinding);
                    } else {
                        this.problemReporter().illegalModifierForMemberInterface(sourceTypeBinding);
                    }
                }
            } else {
                n4 = -11778;
                if ((n2 & n4) != 0) {
                    if ((n2 & 0x2000) != 0) {
                        this.problemReporter().illegalModifierForAnnotationType(sourceTypeBinding);
                    } else {
                        this.problemReporter().illegalModifierForInterface(sourceTypeBinding);
                    }
                }
            }
            n3 |= 0x400;
        } else if ((n2 & 0x4000) != 0) {
            block72: {
                int n5;
                if (bl2) {
                    n5 = -18448;
                    if ((n2 & n5) != 0) {
                        this.problemReporter().illegalModifierForMemberEnum(sourceTypeBinding);
                    }
                } else if (sourceTypeBinding.isLocalType()) {
                    n5 = -18449;
                    if ((n2 & n5) != 0) {
                        this.problemReporter().illegalModifierForLocalEnum(sourceTypeBinding);
                    }
                } else {
                    n5 = -18434;
                    if ((n2 & n5) != 0) {
                        this.problemReporter().illegalModifierForEnum(sourceTypeBinding);
                    }
                }
                if ((this.referenceContext.bits & 0x800) != 0) {
                    n3 |= 0x400;
                } else if (!sourceTypeBinding.isAnonymousType()) {
                    int n6;
                    TypeDeclaration typeDeclaration = this.referenceContext;
                    binding = typeDeclaration.fields;
                    int n7 = n6 = binding == null ? 0 : ((Binding)binding).length;
                    if (n6 != 0) {
                        AbstractMethodDeclaration[] abstractMethodDeclarationArray = typeDeclaration.methods;
                        int n8 = abstractMethodDeclarationArray == null ? 0 : abstractMethodDeclarationArray.length;
                        boolean bl3 = typeDeclaration.superInterfaces != null;
                        int n9 = 0;
                        while (n9 < n8 && !bl3) {
                            bl3 = abstractMethodDeclarationArray[n9].isAbstract();
                            ++n9;
                        }
                        if (bl3) {
                            n9 = 0;
                            while (n9 < n6) {
                                Binding binding2 = binding[n9];
                                if (((FieldDeclaration)((Object)binding2)).getKind() != 3 || ((FieldDeclaration)((Object)binding2)).initialization instanceof QualifiedAllocationExpression) {
                                    ++n9;
                                    continue;
                                }
                                break block72;
                            }
                            n3 |= 0x400;
                        }
                    }
                }
            }
            n3 |= 0x10;
        } else {
            int n10;
            if (bl2) {
                n10 = -3104;
                if ((n2 & n10) != 0) {
                    this.problemReporter().illegalModifierForMemberClass(sourceTypeBinding);
                }
            } else if (sourceTypeBinding.isLocalType()) {
                n10 = -3089;
                if ((n2 & n10) != 0) {
                    this.problemReporter().illegalModifierForLocalClass(sourceTypeBinding);
                }
            } else {
                n10 = -3090;
                if ((n2 & n10) != 0) {
                    this.problemReporter().illegalModifierForClass(sourceTypeBinding);
                }
            }
            if ((n2 & 0x410) == 1040) {
                this.problemReporter().illegalModifierCombinationFinalAbstractForClass(sourceTypeBinding);
            }
        }
        if (bl2) {
            if (referenceBinding.isInterface()) {
                if ((n2 & 6) != 0) {
                    this.problemReporter().illegalVisibilityModifierForInterfaceMemberType(sourceTypeBinding);
                    if ((n2 & 4) != 0) {
                        n3 &= 0xFFFFFFFB;
                    }
                    if ((n2 & 2) != 0) {
                        n3 &= 0xFFFFFFFD;
                    }
                }
            } else {
                int n11 = n2 & 7;
                if ((n11 & n11 - 1) > 1) {
                    this.problemReporter().illegalVisibilityModifierCombinationForMemberType(sourceTypeBinding);
                    if ((n11 & 1) != 0) {
                        if ((n11 & 4) != 0) {
                            n3 &= 0xFFFFFFFB;
                        }
                        if ((n11 & 2) != 0) {
                            n3 &= 0xFFFFFFFD;
                        }
                    } else if ((n11 & 4) != 0 && (n11 & 2) != 0) {
                        n3 &= 0xFFFFFFFD;
                    }
                }
            }
            if ((n2 & 8) == 0) {
                if (referenceBinding.isInterface()) {
                    n3 |= 8;
                }
            } else if (!referenceBinding.isStatic()) {
                this.problemReporter().illegalStaticModifierForMemberType(sourceTypeBinding);
            }
        }
        sourceTypeBinding.modifiers = n3;
    }

    private void checkAndSetModifiersForField(FieldBinding fieldBinding, FieldDeclaration fieldDeclaration) {
        int n2;
        int n3 = fieldBinding.modifiers;
        ReferenceBinding referenceBinding = fieldBinding.declaringClass;
        if ((n3 & 0x400000) != 0) {
            this.problemReporter().duplicateModifierForField(referenceBinding, fieldDeclaration);
        }
        if (referenceBinding.isInterface()) {
            int n4 = 25;
            if (((n3 |= n4) & 0xFFFF) != n4) {
                if ((referenceBinding.modifiers & 0x2000) != 0) {
                    this.problemReporter().illegalModifierForAnnotationField(fieldDeclaration);
                } else {
                    this.problemReporter().illegalModifierForInterfaceField(fieldDeclaration);
                }
            }
            fieldBinding.modifiers = n3;
            return;
        }
        if (fieldDeclaration.getKind() == 3) {
            if ((n3 & 0xFFFF) != 0) {
                this.problemReporter().illegalModifierForEnumConstant(referenceBinding, fieldDeclaration);
            }
            int n5 = 16409;
            if (fieldDeclaration.initialization instanceof QualifiedAllocationExpression) {
                referenceBinding.modifiers &= 0xFFFFFFEF;
            }
            fieldBinding.modifiers |= n5;
            return;
        }
        int n6 = n3 & 0xFFFF;
        int n7 = -224;
        if ((n6 & n7) != 0) {
            this.problemReporter().illegalModifierForField(referenceBinding, fieldDeclaration);
            n3 &= 0xFFFF0000 | ~n7;
        }
        if (((n2 = n6 & 7) & n2 - 1) > 1) {
            this.problemReporter().illegalVisibilityModifierCombinationForField(referenceBinding, fieldDeclaration);
            if ((n2 & 1) != 0) {
                if ((n2 & 4) != 0) {
                    n3 &= 0xFFFFFFFB;
                }
                if ((n2 & 2) != 0) {
                    n3 &= 0xFFFFFFFD;
                }
            } else if ((n2 & 4) != 0 && (n2 & 2) != 0) {
                n3 &= 0xFFFFFFFD;
            }
        }
        if ((n6 & 0x50) == 80) {
            this.problemReporter().illegalModifierCombinationFinalVolatileForField(referenceBinding, fieldDeclaration);
        }
        if (fieldDeclaration.initialization == null && (n3 & 0x10) != 0) {
            n3 |= 0x4000000;
        }
        fieldBinding.modifiers = n3;
    }

    private void checkForInheritedMemberTypes(SourceTypeBinding sourceTypeBinding) {
        ReferenceBinding referenceBinding = sourceTypeBinding;
        ReferenceBinding[][] referenceBindingArray = null;
        int n2 = -1;
        do {
            if (referenceBinding.hasMemberTypes()) {
                return;
            }
            ReferenceBinding[] referenceBindingArray2 = referenceBinding.superInterfaces();
            if (referenceBindingArray2 == NoSuperInterfaces) continue;
            if (referenceBindingArray2 == null) {
                return;
            }
            if (referenceBindingArray == null) {
                referenceBindingArray = new ReferenceBinding[5][];
            }
            if (++n2 == referenceBindingArray.length) {
                ReferenceBinding[][] referenceBindingArray3 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n2 * 2][];
                System.arraycopy(referenceBindingArray3, 0, referenceBindingArray, 0, n2);
            }
            referenceBindingArray[n2] = referenceBindingArray2;
        } while ((referenceBinding = referenceBinding.superclass()) != null && (referenceBinding.tagBits & 0x4000L) == 0L);
        if (referenceBindingArray != null) {
            int n3;
            int n4;
            ReferenceBinding[] referenceBindingArray4;
            boolean bl2 = false;
            int n5 = 0;
            while (n5 <= n2) {
                referenceBindingArray4 = referenceBindingArray[n5];
                n4 = 0;
                n3 = referenceBindingArray4.length;
                while (n4 < n3) {
                    ReferenceBinding referenceBinding2 = referenceBindingArray4[n4];
                    if ((referenceBinding2.tagBits & 0x4000L) == 0L) {
                        if (referenceBinding2.hasMemberTypes()) {
                            return;
                        }
                        bl2 = true;
                        ReferenceBinding[] referenceBindingArray5 = referenceBinding2.superInterfaces();
                        if (referenceBindingArray5 != NoSuperInterfaces) {
                            if (referenceBindingArray5 == null) {
                                return;
                            }
                            if (++n2 == referenceBindingArray.length) {
                                ReferenceBinding[][] referenceBindingArray6 = referenceBindingArray;
                                referenceBindingArray = new ReferenceBinding[n2 * 2][];
                                System.arraycopy(referenceBindingArray6, 0, referenceBindingArray, 0, n2);
                            }
                            referenceBindingArray[n2] = referenceBindingArray5;
                        }
                    }
                    ++n4;
                }
                ++n5;
            }
            if (bl2) {
                n5 = 0;
                while (n5 <= n2) {
                    referenceBindingArray4 = referenceBindingArray[n5];
                    n4 = 0;
                    n3 = referenceBindingArray4.length;
                    while (n4 < n3) {
                        referenceBindingArray4[n4].tagBits |= 0x4000L;
                        ++n4;
                    }
                    ++n5;
                }
            }
        }
        referenceBinding = sourceTypeBinding;
        do {
            referenceBinding.tagBits |= 0x4000L;
        } while ((referenceBinding = referenceBinding.superclass()) != null && (referenceBinding.tagBits & 0x4000L) == 0L);
    }

    public void checkParameterizedTypeBounds() {
        ReferenceBinding[] referenceBindingArray;
        int n2;
        TypeParameter[] typeParameterArray;
        int n3;
        TypeReference[] typeReferenceArray;
        TypeReference typeReference = this.referenceContext.superclass;
        if (typeReference != null) {
            typeReference.checkBounds(this);
        }
        if ((typeReferenceArray = this.referenceContext.superInterfaces) != null) {
            int n4 = 0;
            n3 = typeReferenceArray.length;
            while (n4 < n3) {
                typeReferenceArray[n4].checkBounds(this);
                ++n4;
            }
        }
        if ((typeParameterArray = this.referenceContext.typeParameters) != null) {
            n3 = 0;
            n2 = typeParameterArray.length;
            while (n3 < n2) {
                typeParameterArray[n3].checkBounds(this);
                ++n3;
            }
        }
        if ((referenceBindingArray = this.referenceContext.binding.memberTypes) != null && referenceBindingArray != NoMemberTypes) {
            n2 = 0;
            int n5 = referenceBindingArray.length;
            while (n2 < n5) {
                ((SourceTypeBinding)referenceBindingArray[n2]).scope.checkParameterizedTypeBounds();
                ++n2;
            }
        }
    }

    private void connectMemberTypes() {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        ReferenceBinding[] referenceBindingArray = sourceTypeBinding.memberTypes;
        if (referenceBindingArray != null && referenceBindingArray != NoMemberTypes) {
            int n2 = 0;
            int n3 = referenceBindingArray.length;
            while (n2 < n3) {
                ((SourceTypeBinding)referenceBindingArray[n2]).scope.b();
                ++n2;
            }
        }
    }

    private boolean connectSuperclass() {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        if (sourceTypeBinding.id == 1) {
            sourceTypeBinding.superclass = null;
            sourceTypeBinding.superInterfaces = NoSuperInterfaces;
            if (!sourceTypeBinding.isClass()) {
                this.problemReporter().objectMustBeClass(sourceTypeBinding);
            }
            if (this.referenceContext.superclass != null || this.referenceContext.superInterfaces != null && this.referenceContext.superInterfaces.length > 0) {
                this.problemReporter().objectCannotHaveSuperTypes(sourceTypeBinding);
            }
            return true;
        }
        if (this.referenceContext.superclass == null) {
            if (sourceTypeBinding.isEnum() && this.compilerOptions().sourceLevel >= 0x310000L) {
                return this.connectEnumSuperclass();
            }
            sourceTypeBinding.superclass = this.getJavaLangObject();
            return !this.detectHierarchyCycle(sourceTypeBinding, sourceTypeBinding.superclass, null);
        }
        TypeReference typeReference = this.referenceContext.superclass;
        ReferenceBinding referenceBinding = this.findSupertype(typeReference);
        if (referenceBinding != null) {
            if (!referenceBinding.isClass()) {
                this.problemReporter().superclassMustBeAClass(sourceTypeBinding, typeReference, referenceBinding);
            } else if (referenceBinding.isFinal()) {
                this.problemReporter().classExtendFinalClass(sourceTypeBinding, typeReference, referenceBinding);
            } else if ((referenceBinding.tagBits & 0x40000000L) != 0L) {
                this.problemReporter().superTypeCannotUseWildcard(sourceTypeBinding, typeReference, referenceBinding);
            } else if (referenceBinding.erasure().id == 41) {
                this.problemReporter().cannotExtendEnum(sourceTypeBinding, typeReference, referenceBinding);
            } else {
                sourceTypeBinding.superclass = referenceBinding;
                return true;
            }
        }
        sourceTypeBinding.tagBits |= 0x8000L;
        sourceTypeBinding.superclass = this.getJavaLangObject();
        if ((sourceTypeBinding.superclass.tagBits & 0x100L) == 0L) {
            this.detectHierarchyCycle(sourceTypeBinding, sourceTypeBinding.superclass, null);
        }
        return false;
    }

    private boolean connectEnumSuperclass() {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        ReferenceBinding referenceBinding = this.getJavaLangEnum();
        boolean bl2 = this.detectHierarchyCycle(sourceTypeBinding, referenceBinding, null);
        TypeVariableBinding[] typeVariableBindingArray = referenceBinding.typeVariables();
        if (typeVariableBindingArray == NoTypeVariables) {
            this.problemReporter().nonGenericTypeCannotBeParameterized(null, referenceBinding, new TypeBinding[]{sourceTypeBinding});
            return false;
        }
        if (1 != typeVariableBindingArray.length) {
            this.problemReporter().incorrectArityForParameterizedType(null, referenceBinding, new TypeBinding[]{sourceTypeBinding});
            return false;
        }
        ParameterizedTypeBinding parameterizedTypeBinding = this.environment().createParameterizedType(referenceBinding, new TypeBinding[]{this.environment().convertToRawType(sourceTypeBinding)}, null);
        sourceTypeBinding.superclass = parameterizedTypeBinding;
        if (typeVariableBindingArray[0].boundCheck(parameterizedTypeBinding, sourceTypeBinding) != 0) {
            this.problemReporter().typeMismatchError(referenceBinding, typeVariableBindingArray[0], sourceTypeBinding, null);
        }
        return !bl2;
    }

    private boolean connectSuperInterfaces() {
        Object object;
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        sourceTypeBinding.superInterfaces = NoSuperInterfaces;
        if (this.referenceContext.superInterfaces == null) {
            if (sourceTypeBinding.isAnnotationType() && this.compilerOptions().sourceLevel >= 0x310000L) {
                ReferenceBinding referenceBinding = this.getJavaLangAnnotationAnnotation();
                boolean bl2 = this.detectHierarchyCycle(sourceTypeBinding, referenceBinding, null);
                sourceTypeBinding.superInterfaces = new ReferenceBinding[]{referenceBinding};
                return !bl2;
            }
            return true;
        }
        if (sourceTypeBinding.id == 1) {
            return true;
        }
        boolean bl3 = true;
        int n2 = this.referenceContext.superInterfaces.length;
        ReferenceBinding[] referenceBindingArray = new ReferenceBinding[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            block26: {
                object = this.referenceContext.superInterfaces[n4];
                ReferenceBinding referenceBinding = this.findSupertype((TypeReference)object);
                if (referenceBinding == null) {
                    sourceTypeBinding.tagBits |= 0x8000L;
                    bl3 = false;
                } else {
                    ((TypeReference)object).resolvedType = referenceBinding;
                    int n5 = 0;
                    while (n5 < n4) {
                        if (referenceBindingArray[n5] == referenceBinding) {
                            this.problemReporter().duplicateSuperinterface(sourceTypeBinding, (TypeReference)object, referenceBinding);
                            break block26;
                        }
                        ++n5;
                    }
                    if (!referenceBinding.isInterface()) {
                        this.problemReporter().superinterfaceMustBeAnInterface(sourceTypeBinding, (TypeReference)object, referenceBinding);
                        sourceTypeBinding.tagBits |= 0x8000L;
                        bl3 = false;
                    } else {
                        if (referenceBinding.isAnnotationType()) {
                            this.problemReporter().annotationTypeUsedAsSuperinterface(sourceTypeBinding, (TypeReference)object, referenceBinding);
                        }
                        if ((referenceBinding.tagBits & 0x40000000L) != 0L) {
                            this.problemReporter().superTypeCannotUseWildcard(sourceTypeBinding, (TypeReference)object, referenceBinding);
                            sourceTypeBinding.tagBits |= 0x8000L;
                            bl3 = false;
                        } else {
                            referenceBindingArray[n3++] = referenceBinding;
                        }
                    }
                }
            }
            ++n4;
        }
        if (this.compilerOptions().sourceLevel >= 0x310000L) {
            TypeBinding[] typeBindingArray = new TypeBinding[2];
            object = new HashMap(2);
            int n6 = 0;
            while (n6 < n3) {
                block27: {
                    Object object2;
                    ReferenceBinding referenceBinding = referenceBindingArray[n6];
                    if (!sourceTypeBinding.isInterface()) {
                        typeBindingArray[0] = sourceTypeBinding.superclass;
                        typeBindingArray[1] = referenceBinding;
                        TypeBinding[] typeBindingArray2 = this.minimalErasedCandidates(typeBindingArray, (Map)object);
                        if (typeBindingArray2 != null) {
                            int n7 = 0;
                            int n8 = typeBindingArray2.length;
                            while (n7 < n8) {
                                Set set;
                                int n9;
                                TypeBinding typeBinding = typeBindingArray2[n7];
                                if (typeBinding != null && (n9 = (set = (Set)object.get(typeBinding)).size()) > 1) {
                                    object2 = new TypeBinding[n9];
                                    set.toArray((T[])object2);
                                    this.problemReporter().superinterfacesCollide(((TypeBinding)object2[0]).erasure(), this.referenceContext, (TypeBinding)object2[0], (TypeBinding)object2[1]);
                                    sourceTypeBinding.tagBits |= 0x8000L;
                                    bl3 = false;
                                    break block27;
                                }
                                ++n7;
                            }
                        }
                    }
                    typeBindingArray[0] = referenceBinding;
                    int n10 = 0;
                    block4: while (n10 < n6) {
                        ReferenceBinding referenceBinding2 = referenceBindingArray[n10];
                        if (referenceBinding2 != null) {
                            typeBindingArray[1] = referenceBinding2;
                            object.clear();
                            TypeBinding[] typeBindingArray3 = this.minimalErasedCandidates(typeBindingArray, (Map)object);
                            if (typeBindingArray3 != null) {
                                int n11 = 0;
                                int n12 = typeBindingArray3.length;
                                while (n11 < n12) {
                                    int n13;
                                    TypeBinding typeBinding = typeBindingArray3[n11];
                                    if (typeBinding != null && (n13 = (object2 = (Set)object.get(typeBinding)).size()) > 1) {
                                        TypeBinding[] typeBindingArray4 = new TypeBinding[n13];
                                        object2.toArray(typeBindingArray4);
                                        this.problemReporter().superinterfacesCollide(typeBindingArray4[0].erasure(), this.referenceContext, typeBindingArray4[0], typeBindingArray4[1]);
                                        sourceTypeBinding.tagBits |= 0x8000L;
                                        bl3 = false;
                                        break block4;
                                    }
                                    ++n11;
                                }
                            }
                        }
                        ++n10;
                    }
                }
                ++n6;
            }
        }
        if (n3 > 0) {
            if (n3 != n2) {
                ReferenceBinding[] referenceBindingArray2 = referenceBindingArray;
                referenceBindingArray = new ReferenceBinding[n3];
                System.arraycopy(referenceBindingArray2, 0, referenceBindingArray, 0, n3);
            }
            sourceTypeBinding.superInterfaces = referenceBindingArray;
        }
        return bl3;
    }

    public void b() {
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        if ((sourceTypeBinding.tagBits & 0x100L) == 0L) {
            sourceTypeBinding.tagBits |= 0x100L;
            boolean bl2 = this.connectSuperclass();
            bl2 &= this.connectSuperInterfaces();
            sourceTypeBinding.tagBits |= 0x200L;
            if ((bl2 &= this.connectTypeVariables(this.referenceContext.typeParameters)) && sourceTypeBinding.isHierarchyInconsistent()) {
                this.problemReporter().hierarchyHasProblems(sourceTypeBinding);
            }
        }
        this.connectMemberTypes();
        try {
            this.checkForInheritedMemberTypes(sourceTypeBinding);
        }
        catch (AbortCompilation abortCompilation) {
            abortCompilation.updateContext(this.referenceContext, this.referenceCompilationUnit().compilationResult);
            throw abortCompilation;
        }
    }

    private void connectTypeHierarchyWithoutMembers() {
        if (this.parent instanceof CompilationUnitScope) {
            if (((CompilationUnitScope)this.parent).imports == null) {
                ((CompilationUnitScope)this.parent).g();
            }
        } else if (this.parent instanceof ClassScope) {
            ((ClassScope)this.parent).connectTypeHierarchyWithoutMembers();
        }
        SourceTypeBinding sourceTypeBinding = this.referenceContext.binding;
        if ((sourceTypeBinding.tagBits & 0x100L) != 0L) {
            return;
        }
        sourceTypeBinding.tagBits |= 0x100L;
        boolean bl2 = this.connectSuperclass();
        bl2 &= this.connectSuperInterfaces();
        sourceTypeBinding.tagBits |= 0x200L;
        if ((bl2 &= this.connectTypeVariables(this.referenceContext.typeParameters)) && sourceTypeBinding.isHierarchyInconsistent()) {
            this.problemReporter().hierarchyHasProblems(sourceTypeBinding);
        }
    }

    public boolean detectHierarchyCycle(TypeBinding typeBinding, TypeReference typeReference, TypeBinding[] typeBindingArray) {
        if (!(typeBinding instanceof ReferenceBinding)) {
            return false;
        }
        if (typeBindingArray != null) {
            int n2 = 0;
            int n3 = typeBindingArray.length;
            while (n2 < n3) {
                TypeBinding typeBinding2 = typeBindingArray[n2].leafComponentType();
                if ((typeBinding2.tagBits & 0x100L) == 0L && typeBinding2 instanceof SourceTypeBinding) {
                    ((SourceTypeBinding)typeBinding2).scope.connectTypeHierarchyWithoutMembers();
                }
                ++n2;
            }
        }
        if (typeReference == this.superTypeReference) {
            if (typeBinding.isTypeVariable()) {
                return false;
            }
            if (typeBinding.isParameterizedType()) {
                typeBinding = ((ParameterizedTypeBinding)typeBinding).type;
            }
            this.compilationUnitScope().a(typeBinding);
            return this.detectHierarchyCycle(this.referenceContext.binding, (ReferenceBinding)typeBinding, typeReference);
        }
        if ((typeBinding.tagBits & 0x100L) == 0L && typeBinding instanceof SourceTypeBinding) {
            ((SourceTypeBinding)typeBinding).scope.connectTypeHierarchyWithoutMembers();
        }
        return false;
    }

    private boolean detectHierarchyCycle(SourceTypeBinding sourceTypeBinding, ReferenceBinding referenceBinding, TypeReference typeReference) {
        TypeReference typeReference2;
        if (referenceBinding.isRawType()) {
            referenceBinding = ((RawTypeBinding)referenceBinding).type;
        }
        if (sourceTypeBinding == referenceBinding) {
            this.problemReporter().hierarchyCircularity(sourceTypeBinding, referenceBinding, typeReference);
            sourceTypeBinding.tagBits |= 0x8000L;
            return true;
        }
        if (referenceBinding.isBinaryBinding()) {
            ReferenceBinding[] referenceBindingArray;
            boolean bl2 = false;
            ReferenceBinding referenceBinding2 = referenceBinding.superclass();
            if (referenceBinding2 != null) {
                if (sourceTypeBinding == referenceBinding2) {
                    this.problemReporter().hierarchyCircularity(sourceTypeBinding, referenceBinding, typeReference);
                    sourceTypeBinding.tagBits |= 0x8000L;
                    referenceBinding.tagBits |= 0x8000L;
                    return true;
                }
                if (referenceBinding2.isParameterizedType()) {
                    referenceBinding2 = ((ParameterizedTypeBinding)referenceBinding2).type;
                }
                bl2 |= this.detectHierarchyCycle(sourceTypeBinding, referenceBinding2, typeReference);
                if ((referenceBinding2.tagBits & 0x8000L) != 0L) {
                    sourceTypeBinding.tagBits |= 0x8000L;
                    referenceBinding2.tagBits |= 0x8000L;
                }
            }
            if ((referenceBindingArray = referenceBinding.superInterfaces()) != NoSuperInterfaces) {
                int n2 = 0;
                int n3 = referenceBindingArray.length;
                while (n2 < n3) {
                    ReferenceBinding referenceBinding3 = referenceBindingArray[n2];
                    if (sourceTypeBinding == referenceBinding3) {
                        this.problemReporter().hierarchyCircularity(sourceTypeBinding, referenceBinding, typeReference);
                        sourceTypeBinding.tagBits |= 0x8000L;
                        referenceBinding.tagBits |= 0x8000L;
                        return true;
                    }
                    if (referenceBinding3.isParameterizedType()) {
                        referenceBinding3 = ((ParameterizedTypeBinding)referenceBinding3).type;
                    }
                    bl2 |= this.detectHierarchyCycle(sourceTypeBinding, referenceBinding3, typeReference);
                    if ((referenceBinding3.tagBits & 0x8000L) != 0L) {
                        sourceTypeBinding.tagBits |= 0x8000L;
                        referenceBinding.tagBits |= 0x8000L;
                    }
                    ++n2;
                }
            }
            return bl2;
        }
        if (referenceBinding.isHierarchyBeingConnected() && (typeReference2 = ((SourceTypeBinding)referenceBinding).scope.superTypeReference) != null && typeReference2.resolvedType != null && ((ReferenceBinding)typeReference2.resolvedType).isHierarchyBeingConnected()) {
            this.problemReporter().hierarchyCircularity(sourceTypeBinding, referenceBinding, typeReference);
            sourceTypeBinding.tagBits |= 0x8000L;
            referenceBinding.tagBits |= 0x8000L;
            return true;
        }
        if ((referenceBinding.tagBits & 0x100L) == 0L) {
            ((SourceTypeBinding)referenceBinding).scope.connectTypeHierarchyWithoutMembers();
        }
        if ((referenceBinding.tagBits & 0x8000L) != 0L) {
            sourceTypeBinding.tagBits |= 0x8000L;
        }
        return false;
    }

    private ReferenceBinding findSupertype(TypeReference typeReference) {
        try {
            typeReference.aboutToResolve(this);
            this.compilationUnitScope().a(typeReference.getTypeName());
            this.superTypeReference = typeReference;
            ReferenceBinding referenceBinding = (ReferenceBinding)typeReference.resolveSuperType(this);
            this.superTypeReference = null;
            return referenceBinding;
        }
        catch (AbortCompilation abortCompilation) {
            abortCompilation.updateContext(typeReference, this.referenceCompilationUnit().compilationResult);
            throw abortCompilation;
        }
    }

    public ProblemReporter problemReporter() {
        MethodScope methodScope = this.outerMostMethodScope();
        if (methodScope == null) {
            ProblemReporter problemReporter = this.referenceCompilationUnit().problemReporter;
            problemReporter.referenceContext = this.referenceContext;
            return problemReporter;
        }
        return methodScope.problemReporter();
    }

    public TypeDeclaration referenceType() {
        return this.referenceContext;
    }

    public String toString() {
        if (this.referenceContext != null) {
            return "--- Class Scope ---\n\n" + this.referenceContext.binding.toString();
        }
        return "--- Class Scope ---\n\n Binding not initialized";
    }
}

