/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.EmptyStatement;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.LoopingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class WhileStatement
extends Statement {
    public Expression condition;
    public Statement action;
    private Label breakLabel;
    private Label continueLabel;
    public int c = -1;
    public int a = -1;
    public int b = -1;

    public WhileStatement(Expression expression, Statement statement, int n2, int n3) {
        this.condition = expression;
        this.action = statement;
        if (statement instanceof EmptyStatement) {
            statement.bits |= 1;
        }
        this.sourceStart = n2;
        this.sourceEnd = n3;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo flowInfo2;
        this.breakLabel = new Label();
        this.continueLabel = new Label();
        Constant constant = this.condition.constant;
        boolean bl2 = constant != NotAConstant && constant.booleanValue();
        boolean bl3 = constant != NotAConstant && !constant.booleanValue();
        constant = this.condition.optimizedBooleanConstant();
        boolean bl4 = constant != NotAConstant && constant.booleanValue();
        boolean bl5 = constant != NotAConstant && !constant.booleanValue();
        this.c = blockScope.methodScope().recordInitializationStates(flowInfo);
        FlowInfo flowInfo3 = flowInfo.copy().unconditionalInits().discardNullRelatedInitializations();
        LoopingFlowContext loopingFlowContext = new LoopingFlowContext(flowContext, this, null, null, blockScope);
        flowInfo3 = this.condition.analyseCode(blockScope, loopingFlowContext, flowInfo3);
        if (this.action == null || this.action.isEmptyBlock() && blockScope.compilerOptions().complianceLevel <= 0x2F0000L) {
            loopingFlowContext.complainOnDeferredChecks(blockScope, flowInfo3);
            if (bl2) {
                return FlowInfo.DEAD_END;
            }
            UnconditionalFlowInfo unconditionalFlowInfo = flowInfo3.initsWhenFalse().unconditionalInits();
            if (bl4) {
                ((FlowInfo)unconditionalFlowInfo).setReachMode(1);
            }
            this.b = blockScope.methodScope().recordInitializationStates(unconditionalFlowInfo);
            return unconditionalFlowInfo;
        }
        LoopingFlowContext loopingFlowContext2 = new LoopingFlowContext(flowContext, this, this.breakLabel, this.continueLabel, blockScope);
        if (bl3) {
            flowInfo2 = FlowInfo.DEAD_END;
        } else {
            flowInfo2 = flowInfo3.initsWhenTrue().copy();
            if (bl5) {
                flowInfo2.setReachMode(1);
            }
        }
        this.a = blockScope.methodScope().recordInitializationStates(flowInfo3.initsWhenTrue());
        if (!this.action.complainIfUnreachable(flowInfo2, blockScope, false)) {
            flowInfo2 = this.action.analyseCode(blockScope, loopingFlowContext2, flowInfo2);
        }
        FlowInfo flowInfo4 = flowInfo3.initsWhenFalse();
        flowInfo4.addInitializationsFrom(flowInfo);
        if (!flowInfo2.isReachable() && !loopingFlowContext2.initsOnContinue.isReachable()) {
            this.continueLabel = null;
        } else {
            loopingFlowContext.complainOnDeferredChecks(blockScope, flowInfo3);
            flowInfo2 = flowInfo2.mergedWith(loopingFlowContext2.initsOnContinue.unconditionalInits());
            loopingFlowContext2.complainOnDeferredChecks(blockScope, flowInfo2);
            flowInfo4.addPotentialInitializationsFrom(flowInfo2.unconditionalInits());
        }
        FlowInfo flowInfo5 = FlowInfo.mergedOptimizedBranches(loopingFlowContext2.initsOnBreak, bl4, flowInfo4, bl5, !bl2);
        this.b = blockScope.methodScope().recordInitializationStates(flowInfo5);
        return flowInfo5;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n2 = codeStream.position;
        this.breakLabel.initialize(codeStream);
        if (this.continueLabel == null) {
            if (this.condition.constant == NotAConstant) {
                this.condition.generateOptimizedBoolean(blockScope, codeStream, null, this.breakLabel, true);
            }
        } else {
            this.continueLabel.initialize(codeStream);
            if (!(this.condition.constant != NotAConstant && this.condition.constant.booleanValue() || this.action == null || this.action.isEmptyBlock())) {
                int n3 = codeStream.position;
                codeStream.goto_(this.continueLabel);
                codeStream.recordPositionsFrom(n3, this.condition.sourceStart);
            }
        }
        Label label = new Label(codeStream);
        label.place();
        if (this.action != null) {
            if (this.a != -1) {
                codeStream.addDefinitelyAssignedVariables(blockScope, this.a);
            }
            this.action.generateCode(blockScope, codeStream);
            if (this.c != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.c);
            }
        }
        if (this.continueLabel != null) {
            this.continueLabel.place();
            this.condition.generateOptimizedBoolean(blockScope, codeStream, label, null, true);
        }
        this.breakLabel.place();
        if (this.b != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.b);
            codeStream.addDefinitelyAssignedVariables(blockScope, this.b);
        }
        codeStream.recordPositionsFrom(n2, this.sourceStart);
    }

    public void resolve(BlockScope blockScope) {
        TypeBinding typeBinding = this.condition.resolveTypeExpecting(blockScope, BooleanBinding);
        this.condition.computeConversion(blockScope, typeBinding, typeBinding);
        if (this.action != null) {
            this.action.resolve(blockScope);
        }
    }

    public StringBuffer printStatement(int n2, StringBuffer stringBuffer) {
        WhileStatement.printIndent(n2, stringBuffer).append("while (");
        this.condition.printExpression(0, stringBuffer).append(')');
        if (this.action == null) {
            stringBuffer.append(';');
        } else {
            this.action.printStatement(n2 + 1, stringBuffer);
        }
        return stringBuffer;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.condition.traverse(aSTVisitor, blockScope);
            if (this.action != null) {
                this.action.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

