/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SubRoutineStatement;
import org.eclipse.jdt.internal.compiler.ast.SynchronizedStatement;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ReturnStatement
extends Statement {
    public Expression expression;
    public boolean isSynchronized;
    public SubRoutineStatement[] subroutines;
    public boolean isAnySubRoutineEscaping = false;
    public LocalVariableBinding saveValueVariable;

    public ReturnStatement(Expression expression, int n2, int n3) {
        this.sourceStart = n2;
        this.sourceEnd = n3;
        this.expression = expression;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        boolean bl2;
        if (this.expression != null) {
            flowInfo = this.expression.analyseCode(blockScope, flowContext, flowInfo);
        }
        FlowContext flowContext2 = flowContext;
        int n2 = 0;
        int n3 = 5;
        boolean bl3 = false;
        boolean bl4 = bl2 = this.expression != null && this.expression.constant == NotAConstant;
        do {
            SubRoutineStatement subRoutineStatement;
            if ((subRoutineStatement = flowContext2.subRoutine()) != null) {
                if (this.subroutines == null) {
                    this.subroutines = new SubRoutineStatement[n3];
                }
                if (n2 == n3) {
                    this.subroutines = new SubRoutineStatement[n3 *= 2];
                    System.arraycopy(this.subroutines, 0, this.subroutines, 0, n2);
                }
                this.subroutines[n2++] = subRoutineStatement;
                if (subRoutineStatement.isSubRoutineEscaping()) {
                    bl3 = false;
                    this.isAnySubRoutineEscaping = true;
                    break;
                }
            }
            flowContext2.recordReturnFrom(flowInfo.unconditionalInits());
            ASTNode aSTNode = flowContext2.associatedNode;
            if (aSTNode instanceof SynchronizedStatement) {
                this.isSynchronized = true;
                continue;
            }
            if (aSTNode instanceof TryStatement) {
                TryStatement tryStatement = (TryStatement)aSTNode;
                flowInfo.addInitializationsFrom(tryStatement.subRoutineInits);
                if (!bl2) continue;
                if (this.saveValueVariable == null) {
                    this.prepareSaveValueLocation(tryStatement);
                }
                bl3 = true;
                continue;
            }
            if (!(flowContext2 instanceof InitializationFlowContext)) continue;
            blockScope.problemReporter().cannotReturnInInitializer(this);
            return FlowInfo.DEAD_END;
        } while ((flowContext2 = flowContext2.parent) != null);
        if (this.subroutines != null && n2 != n3) {
            this.subroutines = new SubRoutineStatement[n2];
            System.arraycopy(this.subroutines, 0, this.subroutines, 0, n2);
        }
        if (bl3) {
            if (this.saveValueVariable != null) {
                this.saveValueVariable.useFlag = 1;
            }
        } else {
            this.saveValueVariable = null;
            if (!this.isSynchronized && this.expression != null && this.expression.resolvedType == BooleanBinding) {
                this.expression.bits |= 0x10;
            }
        }
        return FlowInfo.DEAD_END;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n2 = codeStream.position;
        if (this.expression != null && this.expression.constant == NotAConstant) {
            this.expression.generateCode(blockScope, codeStream, this.needValue());
            this.generateStoreSaveValueIfNecessary(codeStream);
        }
        if (this.subroutines != null) {
            int n3 = 0;
            int n4 = this.subroutines.length;
            while (n3 < n4) {
                SubRoutineStatement subRoutineStatement = this.subroutines[n3];
                subRoutineStatement.generateSubRoutineInvocation(blockScope, codeStream);
                if (subRoutineStatement.isSubRoutineEscaping()) {
                    codeStream.recordPositionsFrom(n2, this.sourceStart);
                    SubRoutineStatement.reenterExceptionHandlers(this.subroutines, n3, codeStream);
                    return;
                }
                subRoutineStatement.exitAnyExceptionHandler();
                ++n3;
            }
        }
        if (this.saveValueVariable != null) {
            codeStream.load(this.saveValueVariable);
        }
        if (this.expression != null && this.expression.constant != NotAConstant) {
            codeStream.generateConstant(this.expression.constant, this.expression.implicitConversion);
            this.generateStoreSaveValueIfNecessary(codeStream);
        }
        this.generateReturnBytecode(codeStream);
        codeStream.recordPositionsFrom(n2, this.sourceStart);
        SubRoutineStatement.reenterExceptionHandlers(this.subroutines, -1, codeStream);
    }

    public void generateReturnBytecode(CodeStream codeStream) {
        codeStream.generateReturnBytecode(this.expression);
    }

    public void generateStoreSaveValueIfNecessary(CodeStream codeStream) {
        if (this.saveValueVariable != null) {
            codeStream.store(this.saveValueVariable, false);
        }
    }

    public boolean needValue() {
        return this.subroutines == null || this.saveValueVariable != null || this.isSynchronized;
    }

    public void prepareSaveValueLocation(TryStatement tryStatement) {
        this.saveValueVariable = tryStatement.secretReturnValue;
    }

    public StringBuffer printStatement(int n2, StringBuffer stringBuffer) {
        ReturnStatement.printIndent(n2, stringBuffer).append("return ");
        if (this.expression != null) {
            this.expression.printExpression(0, stringBuffer);
        }
        return stringBuffer.append(';');
    }

    public void resolve(BlockScope blockScope) {
        BaseTypeBinding baseTypeBinding;
        MethodBinding methodBinding;
        MethodScope methodScope = blockScope.methodScope();
        Object object = methodScope.referenceContext instanceof AbstractMethodDeclaration ? ((methodBinding = ((AbstractMethodDeclaration)methodScope.referenceContext).binding) == null ? null : methodBinding.returnType) : (baseTypeBinding = VoidBinding);
        if (baseTypeBinding == VoidBinding) {
            if (this.expression == null) {
                return;
            }
            TypeBinding typeBinding = this.expression.resolveType(blockScope);
            if (typeBinding != null) {
                blockScope.problemReporter().attemptToReturnNonVoidExpression(this, typeBinding);
            }
            return;
        }
        if (this.expression == null) {
            if (baseTypeBinding != null) {
                blockScope.problemReporter().shouldReturn(baseTypeBinding, this);
            }
            return;
        }
        this.expression.setExpectedType(baseTypeBinding);
        TypeBinding typeBinding = this.expression.resolveType(blockScope);
        if (typeBinding == null) {
            return;
        }
        if (typeBinding == VoidBinding) {
            blockScope.problemReporter().attemptToReturnVoidValue(this);
            return;
        }
        if (baseTypeBinding == null) {
            return;
        }
        if (baseTypeBinding != typeBinding) {
            blockScope.compilationUnitScope().recordTypeConversion(baseTypeBinding, typeBinding);
        }
        if (this.expression.isConstantValueOfTypeAssignableToType(typeBinding, baseTypeBinding) || typeBinding.isCompatibleWith(baseTypeBinding)) {
            this.expression.computeConversion(blockScope, baseTypeBinding, typeBinding);
            if (typeBinding.needsUncheckedConversion(baseTypeBinding)) {
                blockScope.problemReporter().unsafeTypeConversion(this.expression, typeBinding, baseTypeBinding);
            }
            return;
        }
        if (blockScope.isBoxingCompatibleWith(typeBinding, baseTypeBinding)) {
            this.expression.computeConversion(blockScope, baseTypeBinding, typeBinding);
            return;
        }
        blockScope.problemReporter().typeMismatchError(typeBinding, baseTypeBinding, this.expression);
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.expression != null) {
            this.expression.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

