/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class ParameterizedSingleTypeReference
extends ArrayTypeReference {
    public TypeReference[] typeArguments;
    private boolean didResolve = false;

    public ParameterizedSingleTypeReference(char[] cArray, TypeReference[] typeReferenceArray, int n2, long l2) {
        super(cArray, n2, l2);
        this.originalSourceEnd = this.sourceEnd;
        this.typeArguments = typeReferenceArray;
    }

    public void checkBounds(Scope scope) {
        if (this.resolvedType == null) {
            return;
        }
        if (this.resolvedType.leafComponentType() instanceof ParameterizedTypeBinding) {
            ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this.resolvedType.leafComponentType();
            ReferenceBinding referenceBinding = parameterizedTypeBinding.type;
            TypeVariableBinding[] typeVariableBindingArray = referenceBinding.typeVariables();
            TypeBinding[] typeBindingArray = parameterizedTypeBinding.arguments;
            if (typeBindingArray != null && typeVariableBindingArray != null) {
                parameterizedTypeBinding.boundCheck(scope, this.typeArguments);
            }
        }
    }

    public TypeReference copyDims(int n2) {
        return new ParameterizedSingleTypeReference(this.token, this.typeArguments, n2, ((long)this.sourceStart << 32) + (long)this.sourceEnd);
    }

    public char[][] getParameterizedTypeName() {
        StringBuffer stringBuffer = new StringBuffer(5);
        stringBuffer.append(this.token).append('<');
        int n2 = 0;
        int n3 = this.typeArguments.length;
        while (n2 < n3) {
            if (n2 > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(CharOperation.concatWith(this.typeArguments[n2].getParameterizedTypeName(), '.'));
            ++n2;
        }
        stringBuffer.append('>');
        n2 = stringBuffer.length();
        char[] cArray = new char[n2];
        stringBuffer.getChars(0, n2, cArray, 0);
        int n4 = this.dimensions;
        if (n4 > 0) {
            char[] cArray2 = new char[n4 * 2];
            int n5 = 0;
            while (n5 < n4) {
                int n6 = n5 * 2;
                cArray2[n6] = 91;
                cArray2[n6 + 1] = 93;
                ++n5;
            }
            cArray = CharOperation.concat(cArray, cArray2);
        }
        return new char[][]{cArray};
    }

    public TypeBinding getTypeBinding(Scope scope) {
        return null;
    }

    private TypeBinding internalResolveType(Scope scope, ReferenceBinding referenceBinding, boolean bl2) {
        TypeVariableBinding[] typeVariableBindingArray;
        TypeBinding typeBinding;
        this.constant = NotAConstant;
        if (this.didResolve) {
            if (this.resolvedType != null && !this.resolvedType.isValidBinding()) {
                return null;
            }
            return this.resolvedType;
        }
        this.didResolve = true;
        if (referenceBinding == null) {
            ReferenceBinding referenceBinding2;
            this.resolvedType = scope.getType(this.token);
            if (!this.resolvedType.isValidBinding()) {
                this.reportInvalidType(scope);
                return null;
            }
            referenceBinding = this.resolvedType.enclosingType();
            if (referenceBinding != null && ((referenceBinding2 = (ReferenceBinding)this.resolvedType).isStatic() || referenceBinding.isGenericType() && referenceBinding.outermostEnclosingType() != scope.outerMostClassScope().referenceContext.binding)) {
                referenceBinding = (ReferenceBinding)scope.environment().convertToRawType(referenceBinding);
            }
        } else {
            this.resolvedType = scope.getMemberType(this.token, (ReferenceBinding)referenceBinding.erasure());
            if (!this.resolvedType.isValidBinding()) {
                scope.problemReporter().invalidEnclosingType(this, this.resolvedType, referenceBinding);
                return null;
            }
            if (this.isTypeUseDeprecated(this.resolvedType, scope)) {
                scope.problemReporter().deprecatedType(this.resolvedType, this);
            }
        }
        boolean bl3 = scope.kind == 3;
        TypeReference typeReference = null;
        if (bl3) {
            typeReference = ((ClassScope)scope).superTypeReference;
            ((ClassScope)scope).superTypeReference = null;
        }
        ReferenceBinding referenceBinding3 = (ReferenceBinding)this.resolvedType;
        int n2 = this.typeArguments.length;
        TypeBinding[] typeBindingArray = new TypeBinding[n2];
        boolean bl4 = false;
        int n3 = 0;
        while (n3 < n2) {
            TypeReference typeReference2 = this.typeArguments[n3];
            TypeBinding typeBinding2 = typeBinding = bl3 ? typeReference2.resolveTypeArgument((ClassScope)scope, referenceBinding3, n3) : typeReference2.resolveTypeArgument((BlockScope)scope, referenceBinding3, n3);
            if (typeBinding == null) {
                bl4 = true;
            } else {
                typeBindingArray[n3] = typeBinding;
            }
            ++n3;
        }
        if (bl4) {
            return null;
        }
        if (bl3) {
            ((ClassScope)scope).superTypeReference = typeReference;
            if (((ClassScope)scope).detectHierarchyCycle(referenceBinding3, this, typeBindingArray)) {
                return null;
            }
        }
        if ((typeVariableBindingArray = referenceBinding3.typeVariables()) == NoTypeVariables) {
            scope.problemReporter().nonGenericTypeCannotBeParameterized(this, referenceBinding3, typeBindingArray);
            return null;
        }
        if (n2 != typeVariableBindingArray.length) {
            scope.problemReporter().incorrectArityForParameterizedType(this, referenceBinding3, typeBindingArray);
            return null;
        }
        if (!referenceBinding3.isStatic() && referenceBinding != null && referenceBinding.isRawType()) {
            scope.problemReporter().rawMemberTypeCannotBeParameterized(this, scope.environment().createRawType((ReferenceBinding)referenceBinding3.erasure(), referenceBinding), typeBindingArray);
            return null;
        }
        boolean bl5 = true;
        if (bl5) {
            int n4 = 0;
            while (n4 < n2) {
                if (typeVariableBindingArray[n4] != typeBindingArray[n4]) {
                    bl5 = false;
                    break;
                }
                ++n4;
            }
        }
        if (!bl5) {
            typeBinding = scope.environment().createParameterizedType((ReferenceBinding)referenceBinding3.erasure(), typeBindingArray, referenceBinding);
            if (bl2) {
                ((ParameterizedTypeBinding)typeBinding).boundCheck(scope, this.typeArguments);
            }
            this.resolvedType = typeBinding;
            if (this.isTypeUseDeprecated(this.resolvedType, scope)) {
                this.reportDeprecatedType(scope);
            }
        } else {
            this.resolvedType = this.resolvedType.erasure();
        }
        if (this.dimensions > 0) {
            if (this.dimensions > 255) {
                scope.problemReporter().tooManyDimensions(this);
            }
            this.resolvedType = scope.createArrayType(this.resolvedType, this.dimensions);
        }
        return this.resolvedType;
    }

    public StringBuffer printExpression(int n2, StringBuffer stringBuffer) {
        stringBuffer.append(this.token);
        stringBuffer.append("<");
        int n3 = this.typeArguments.length - 1;
        int n4 = 0;
        while (n4 < n3) {
            this.typeArguments[n4].print(0, stringBuffer);
            stringBuffer.append(", ");
            ++n4;
        }
        this.typeArguments[n3].print(0, stringBuffer);
        stringBuffer.append(">");
        if ((this.bits & 0x4000) != 0) {
            n4 = 0;
            while (n4 < this.dimensions - 1) {
                stringBuffer.append("[]");
                ++n4;
            }
            stringBuffer.append("...");
        } else {
            n4 = 0;
            while (n4 < this.dimensions) {
                stringBuffer.append("[]");
                ++n4;
            }
        }
        return stringBuffer;
    }

    public TypeBinding resolveType(BlockScope blockScope, boolean bl2) {
        return this.internalResolveType(blockScope, null, bl2);
    }

    public TypeBinding resolveType(ClassScope classScope) {
        return this.internalResolveType(classScope, null, false);
    }

    public TypeBinding resolveTypeEnclosing(BlockScope blockScope, ReferenceBinding referenceBinding) {
        return this.internalResolveType(blockScope, referenceBinding, true);
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n2 = 0;
            int n3 = this.typeArguments.length;
            while (n2 < n3) {
                this.typeArguments[n2].traverse(aSTVisitor, blockScope);
                ++n2;
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            int n2 = 0;
            int n3 = this.typeArguments.length;
            while (n2 < n3) {
                this.typeArguments[n2].traverse(aSTVisitor, classScope);
                ++n2;
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

